/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.parts.gui;

import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.types.PaperSize;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.parts.gui.ReportSectionFigure;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ReportFigure
extends FreeformLayer {
    private final Color marginBkg = IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(255, 77, 77));
    private ReportModel model;

    public ReportFigure(ReportModel reportModel) {
        this.model = reportModel;
        this.setOpaque(true);
        this.setBackgroundColor(IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(128, 128, 128)));
        this.setLayoutManager((LayoutManager)new FreeformLayout());
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        Rectangle rectangle = this.getClientArea();
        Report report = (Report)this.model.getTarget();
        PaperSize paperSize = report.getPaperSize();
        graphics.setBackgroundColor(this.marginBkg);
        int n = UnitConverter.inchToPixel((float)(paperSize.getWidth() - paperSize.getMarginLeft() - paperSize.getMarginRight()));
        graphics.fillRectangle(n, 2, 2, rectangle.height);
        int n2 = UnitConverter.inchToPixel((float)(paperSize.getHeight() - paperSize.getMarginTop() - paperSize.getMarginBottom()));
        List list = this.getChildren();
        for (IFigure iFigure : list) {
            if (!(iFigure instanceof ReportSectionFigure)) continue;
            Insets insets = iFigure.getBorder().getInsets(iFigure);
            n2 += insets.top + insets.bottom;
        }
        graphics.fillRectangle(2, n2, rectangle.width, 2);
    }
}

