/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.wizards.AbstractImportPage;
import com.iscobol.reportdesigner.CodeGenerator;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.wizards.ReportWizard;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.BeanReader;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ReportAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class IscobolReportImportPage
extends AbstractImportPage<Report> {
    private int generationMode = IscobolEditorPlugin.getIntFromStore((String)"iscobol.cobolgen.mode");

    public IscobolReportImportPage(String string, String string2) {
        super(string, string2);
    }

    protected String getLastImportDirectory() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.reportImportDirectory");
    }

    protected void setLastImportDirectory(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.reportImportDirectory", string);
    }

    protected boolean allowRenaming() {
        return false;
    }

    protected void loadDestinationTree(Tree tree) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray != null) {
            for (IProject iProject : iProjectArray) {
                this.loadProject(iProject, tree);
            }
        }
    }

    private void loadProject(IProject iProject, Tree tree) {
        if (iProject.isOpen() && this.isIscobolProject(iProject)) {
            this.setExistsProjects(true);
            TreeItem treeItem = new TreeItem(tree, 0);
            treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/project.gif"));
            treeItem.setText(iProject.getName());
            treeItem.setData((Object)iProject);
            try {
                IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
                if (iContainer != null) {
                    IResource[] iResourceArray;
                    for (IResource iResource : iResourceArray = iContainer.members()) {
                        IFile iFile;
                        if (!(iResource instanceof IFile) || !(iFile = (IFile)iResource).getName().endsWith(".isp")) continue;
                        this.loadScreenProgram(iFile, treeItem);
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private void loadScreenProgram(IFile iFile, TreeItem treeItem) {
        TreeItem treeItem2 = new TreeItem(treeItem, 0);
        treeItem2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png"));
        treeItem2.setText(iFile.getLocation().removeFileExtension().lastSegment());
        treeItem2.setData((Object)iFile);
    }

    protected boolean validateSelection() {
        if (this.progNames == null) {
            this.setPageInvalid("No report selected");
            return false;
        }
        return true;
    }

    protected final void createFiles() {
        if (this.progNames == null) {
            return;
        }
        this.createFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFiles(IProgressMonitor iProgressMonitor) {
        try {
            IFile iFile = (IFile)this.getParentResource();
            ScreenProgram screenProgram = PluginUtilities.getScreenProgram((IFile)iFile);
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("Import reports", this.progNames.length);
            }
            for (int i = 0; i < this.progNames.length; ++i) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                BeanReader beanReader = new BeanReader((InputStream)new FileInputStream(this.progFiles[i]));
                Report report = (Report)beanReader.readObject();
                String string = null;
                try {
                    string = (String)beanReader.readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                beanReader.close();
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Import report '" + report.getName() + "'...");
                }
                this.importProgramInfo(screenProgram, report, string);
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            screenProgram.save();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    public boolean validateFileName(String string) {
        return string.endsWith(".irl");
    }

    protected Image getFileTreeItemImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/report.png");
    }

    protected IFile getFile(Object object) {
        return null;
    }

    protected IResource getContainer(Object object) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IContainer iContainer = null;
            try {
                iContainer = PluginUtilities.getScreenFolder((IProject)iFile.getProject());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (iContainer != null && iContainer.equals(iFile.getParent()) && iFile.getName().endsWith(".isp")) {
                return iFile;
            }
        } else {
            if (object instanceof ScreenProgramAdapter) {
                return ((ScreenProgramAdapter)object).getProgramFile();
            }
            if (object instanceof ReportAdapter) {
                return ((ReportAdapter)object).getProgramFile();
            }
        }
        return null;
    }

    protected boolean importProgramInfo0(Report report, File file) throws Exception {
        return false;
    }

    protected boolean importProgramInfo0(ScreenProgram screenProgram, Report report, Report report2) {
        Object[] objectArray;
        Set set;
        IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new FileEditorInput(screenProgram.getFile()));
        if (report2 != null) {
            screenProgram.removeReport(report2);
            screenProgram.pruneReportResources((ReportElement)report2);
            set = new CodeGenerator(screenProgram, this.generationMode);
            objectArray = set.getReportParNames(report2, new HashMap());
            for (int i = 0; i < objectArray.length; ++i) {
                screenProgram.getResourceRegistry().removeParagraph((String)objectArray[i]);
            }
            if (iEditorPart instanceof ScreenProgramEditor) {
                ScreenProgramEditor screenProgramEditor = (ScreenProgramEditor)iEditorPart;
                screenProgramEditor.removeReport(report2.getName());
                screenProgramEditor.setDirty(true);
            }
        }
        screenProgram.addReport(report);
        set = PropertyDescriptorRegistry.getProbableParagraphList((ScreenProgram)screenProgram);
        PropertyDescriptorRegistry.findAndCreateMissingResources((Object)report, null, (ScreenProgram)screenProgram, (Set)set);
        objectArray = new Report[]{report};
        screenProgram.getResourceRegistry().registerParagraphs(objectArray);
        if (iEditorPart instanceof ScreenProgramEditor) {
            ScreenProgramEditor screenProgramEditor = (ScreenProgramEditor)iEditorPart;
            screenProgramEditor.addReport(report);
            screenProgramEditor.setDirty(true);
        }
        return false;
    }

    protected boolean validateParent() {
        if (!(this.getParentResource() instanceof IFile)) {
            this.setPageInvalid("Select parent program");
            return false;
        }
        if (!this.isIscobolProject(this.getParentResource().getProject())) {
            this.setPageInvalid("'" + this.getParentResource().getProject().getName() + "': " + IsresourceBundle.getString((String)"not_iscobol_prj_msg"));
            return false;
        }
        return true;
    }

    protected boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean importProgramInfo(ScreenProgram screenProgram, Report report, String string) {
        Report report2 = null;
        Report[] reportArray = screenProgram.getReports();
        for (int i = 0; i < reportArray.length && report2 == null; ++i) {
            if (!reportArray[i].getName().equals(report.getName())) continue;
            report2 = reportArray[i];
        }
        if (report2 != null) {
            block0 : switch (this.overwriteCode) {
                case 1: {
                    break;
                }
                case 0: 
                case 2: {
                    this.overwriteCode = this.openMessageDialog("Overwrite report '" + report.getName() + "'");
                    if (this.overwriteCode < 0) {
                        this.overwriteCode = 2;
                    }
                    switch (this.overwriteCode) {
                        case 0: 
                        case 1: {
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            String string2 = ReportWizard.getSuggestedName((ScreenProgram)screenProgram, (String)report.getName());
                            report.setName(string2);
                            report.setPrefix(string2);
                            report2 = null;
                            break block0;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.checkRelease(string, report.getName())) {
            return this.importProgramInfo0(screenProgram, report, report2);
        }
        return false;
    }

    protected int openMessageDialog(String string) {
        int[] nArray = new int[]{2};
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return nArray[0];
    }
}

