/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.plugins.editor.util.InternalErrorException;
import com.iscobol.screenpainter.TaggedArea;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractTaggedAreaManager {
    protected final String eol = PluginUtilities.getLineDelimiter();
    protected Vector<TaggedArea> taggedAreas = new Vector();
    protected boolean regenerateAll;
    private Map<String, Integer> tagTable = new HashMap();
    private int reportTaggedAreaProg = 100;
    private IFile programIFile;
    private File programFile;

    public AbstractTaggedAreaManager(IFile iFile) {
        this.programIFile = iFile;
        this.tagTable.putAll(this.getFixedTagTable());
        if (!iFile.exists()) {
            this.regenerateAll = true;
            return;
        }
        Reader reader = null;
        try {
            reader = this.getReader(iFile);
            this.readStream(reader);
        }
        catch (CoreException coreException) {
            throw new InternalErrorException(coreException.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTaggedAreaManager(File file) {
        this.programFile = file;
        this.tagTable.putAll(this.getFixedTagTable());
        if (!file.exists()) {
            this.regenerateAll = true;
            return;
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(new FileInputStream(file));
            this.readStream((Reader)inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getProgramFile() {
        return this.programFile;
    }

    public IFile getProgramIFile() {
        return this.programIFile;
    }

    protected abstract String getEndTag();

    protected abstract String getBeginTag();

    protected abstract String[] getStdTags();

    protected abstract Map<String, Integer> getFixedTagTable();

    protected abstract String getReportMasterParaTag();

    protected abstract String getReportMasterParaSuffix();

    protected void addTaggedArea(TaggedArea taggedArea) {
        this.taggedAreas.addElement(taggedArea);
    }

    Reader getReader(IFile iFile) throws CoreException {
        return new InputStreamReader(iFile.getContents());
    }

    void readStream(Reader reader) {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            int n = 0;
            TaggedArea taggedArea = new TaggedArea("initial", 0);
            this.addTaggedArea(taggedArea);
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 1;
            String string = bufferedReader.readLine();
            while (string != null) {
                TaggedArea taggedArea2;
                String string2 = string.toLowerCase();
                if (bl) {
                    if (AbstractTaggedAreaManager.findTagIndex((String)string2, (String)this.getEndTag()) >= 0) {
                        taggedArea.setEndLine(n2);
                        ++n;
                        bl = false;
                    } else {
                        taggedArea2 = this.findTaggedArea(string2, taggedArea.getId() != 0 ? n + 1 : n);
                        if (taggedArea2 != null) {
                            taggedArea.setUntaggedData("");
                            stringBuilder = new StringBuilder();
                            ++n;
                            taggedArea = taggedArea2;
                            taggedArea.setStartLine(n2);
                            this.addTaggedArea(taggedArea);
                        }
                    }
                } else {
                    taggedArea2 = this.findTaggedArea(string2, n);
                    if (taggedArea2 != null) {
                        taggedArea.setUntaggedData(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        taggedArea = taggedArea2;
                        taggedArea.setStartLine(n2);
                        this.addTaggedArea(taggedArea);
                        ++n;
                        bl = true;
                    } else {
                        stringBuilder.append(string);
                        stringBuilder.append(this.eol);
                    }
                }
                string = bufferedReader.readLine();
                ++n2;
            }
            if (!bl) {
                taggedArea.setUntaggedData(stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int findTagIndex(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 1) {
            return -1;
        }
        switch (n) {
            case 1: 
            case 7: {
                if (string.charAt(n - 1) != '*') {
                    return -1;
                }
                return n;
            }
            case 2: {
                if (!string.substring(0, 2).equals("*>")) {
                    return -1;
                }
                return n;
            }
        }
        return -1;
    }

    private TaggedArea findTaggedArea(String string, int n) {
        int n2 = AbstractTaggedAreaManager.findTagIndex((String)string, (String)this.getBeginTag());
        if (n2 < 1) {
            return null;
        }
        int n3 = string.indexOf(32, n2 + this.getBeginTag().length());
        if (n3 < 0) {
            n3 = string.length();
        }
        String[] stringArray = this.getStdTags();
        String string2 = string.substring(n2 + this.getBeginTag().length(), n3);
        int n4 = n %= stringArray.length;
        do {
            if (string2.matches(stringArray[n4])) {
                return new TaggedArea(string2, this.getTagId(string2));
            }
            ++n4;
        } while ((n4 %= stringArray.length) != n);
        return null;
    }

    public boolean isRegenerateAll() {
        return this.regenerateAll;
    }

    public TaggedArea[] getTaggedAreas() {
        return this.taggedAreas.toArray(new TaggedArea[this.taggedAreas.size()]);
    }

    protected int getTagId(String string) {
        Integer n = (Integer)this.tagTable.get(string);
        if (n == null && this.getReportMasterParaTag() != null && string.matches(this.getReportMasterParaTag())) {
            n = ++this.reportTaggedAreaProg;
            this.tagTable.put(string, n);
        }
        return n != null ? n : 0;
    }
}

