/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.types.Key;
import com.iscobol.filedesigner.types.KeyList;
import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IError;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportGroup;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.screenpainter.ConsistencyCheckResult;
import com.iscobol.screenpainter.ConsistencyChecker;
import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.FDAttributes;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.FileSection;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.VariableUsage;
import com.iscobol.screenpainter.beans.types.XFDAttributes;
import com.iscobol.screenpainter.findinobject.FindInObjectMatch;
import com.iscobol.screenpainter.findinobject.FindInObjectUtilities;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.VariableSettingsContentPane;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.DataSetAdapter;
import com.iscobol.screenpainter.util.adapters.EventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FDAdapter;
import com.iscobol.screenpainter.util.adapters.FDEventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FDListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.FileSectionAdapter;
import com.iscobol.screenpainter.util.adapters.IFDAdapter;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import com.iscobol.screenpainter.util.adapters.LinkageSectionAdapter;
import com.iscobol.screenpainter.util.adapters.ProgramListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ReportAdapter;
import com.iscobol.screenpainter.util.adapters.ReportListAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionListAdapter;
import com.iscobol.screenpainter.util.adapters.WorkingStorageAdapter;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class ConsistencyChecker
extends Job {
    private static final HashMap FIGURATIVE_CONSTANTS = new HashMap();
    private Object target;
    private Vector matches = new Vector();
    private ConsistencyCheckResult result;
    private ScreenFD_SL[] dataLayouts;
    private IProject project;
    private ScreenRootData cachedData = new ScreenRootData(null);

    public ConsistencyChecker(Object object) {
        super("Consistency Check of '" + FindInObjectUtilities.getLabelFor((Object)object) + "'");
        this.target = object;
        this.result = new ConsistencyCheckResult(object);
    }

    public String getLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parse ");
        stringBuilder.append(FindInObjectUtilities.getLabelFor((Object)this.target));
        return stringBuilder.toString();
    }

    private VariableType findVariable(String string, ScreenProgram screenProgram) {
        if (this.cachedData.sr == screenProgram && this.cachedData.variables != null) {
            return (VariableType)this.cachedData.variables.get(string);
        }
        this.cachedData.sr = screenProgram;
        this.cachedData.variables = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        VariableType[] variableTypeArray = screenProgram.getProgramVariables();
        for (int i = 0; i < variableTypeArray.length; ++i) {
            this.cachedData.variables.put(variableTypeArray[i].getQName(), variableTypeArray[i]);
        }
        return (VariableType)this.cachedData.variables.get(string);
    }

    private Set<String> getProbableParagraphList(ScreenProgram screenProgram) {
        if (this.cachedData.sr == screenProgram && this.cachedData.paragraphs != null) {
            return this.cachedData.paragraphs;
        }
        this.cachedData.sr = screenProgram;
        this.cachedData.paragraphs = PropertyDescriptorRegistry.getProbableParagraphList((ScreenProgram)screenProgram);
        return this.cachedData.paragraphs;
    }

    private Set<String> getProbableParagraphList(ScreenFD_SL screenFD_SL) {
        if (this.cachedData.sr == screenFD_SL) {
            return this.cachedData.paragraphs;
        }
        this.cachedData.sr = screenFD_SL;
        this.cachedData.paragraphs = PropertyDescriptorRegistry.getProbableParagraphList((ScreenFD_SL)screenFD_SL);
        return this.cachedData.paragraphs;
    }

    public ConsistencyCheckResult getConsistencyCheckResult() {
        return this.result;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        this.matches.removeAllElements();
        boolean bl = false;
        try {
            this.consistencyCheck(iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            bl = true;
        }
        this.result.setMatches(this.matches);
        return bl ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private void consistencyCheck(IProgressMonitor iProgressMonitor) {
        this.beginTask(iProgressMonitor, "", 100);
        if (this.target instanceof IProject) {
            this.project = (IProject)this.target;
            this.target = new ProjectWorkbenchAdapter(this.project);
        }
        if (this.target instanceof IscobolProjectAdapter) {
            this.project = ((IscobolProjectAdapter)this.target).getProject();
        }
        if (this.target instanceof ProgramListWorkbenchAdapter) {
            ProgramListWorkbenchAdapter programListWorkbenchAdapter = (ProgramListWorkbenchAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)programListWorkbenchAdapter));
            this.consistencyCheckOfProgramList(programListWorkbenchAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ScreenProgramAdapter) {
            ScreenProgramAdapter screenProgramAdapter = (ScreenProgramAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter));
            this.consistencyCheckOfScreenProgram(screenProgramAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof FDListWorkbenchAdapter) {
            FDListWorkbenchAdapter fDListWorkbenchAdapter = (FDListWorkbenchAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)fDListWorkbenchAdapter));
            this.consistencyCheckOfFDList(fDListWorkbenchAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ProjectWorkbenchAdapter) {
            ProjectWorkbenchAdapter projectWorkbenchAdapter = (ProjectWorkbenchAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)projectWorkbenchAdapter));
            this.consistencyCheckOfProject(projectWorkbenchAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof FDAdapter) {
            FDAdapter fDAdapter = (FDAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)fDAdapter));
            this.consistencyCheckOfFD(fDAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof DataSetAdapter) {
            DataSetAdapter dataSetAdapter = (DataSetAdapter)this.target;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, dataSetAdapter.getScreenProgram().getFileSection().findDataSet(dataSetAdapter.getDataSet().getName()), "");
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{findInObjectMatchReference};
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)dataSetAdapter));
            this.consistencyCheckOfDataSet(dataSetAdapter, findInObjectMatchReferenceArray, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ScreenSectionAdapter) {
            ScreenSectionAdapter screenSectionAdapter = (ScreenSectionAdapter)this.target;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SCREEN, screenSectionAdapter.getScreenProgram().findScreenSection(screenSectionAdapter.getWindow().getName()), "");
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{findInObjectMatchReference};
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenSectionAdapter));
            this.consistencyCheckOfScreenSection(screenSectionAdapter, findInObjectMatchReferenceArray, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ScreenSectionListAdapter) {
            ScreenSectionListAdapter screenSectionListAdapter = (ScreenSectionListAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenSectionListAdapter));
            this.consistencyCheckOfScreenSectionList(screenSectionListAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ReportAdapter) {
            ReportAdapter reportAdapter = (ReportAdapter)this.target;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT, reportAdapter.getScreenProgram().findReport(reportAdapter.getReport().getName()), "");
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{findInObjectMatchReference};
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)reportAdapter));
            this.consistencyCheckOfReport(reportAdapter, findInObjectMatchReferenceArray, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof ReportListAdapter) {
            ReportListAdapter reportListAdapter = (ReportListAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)reportListAdapter));
            this.consistencyCheckOfReportList(reportListAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof LinkageSectionAdapter) {
            LinkageSectionAdapter linkageSectionAdapter = (LinkageSectionAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)linkageSectionAdapter));
            this.consistencyCheckOfLinkageSection(linkageSectionAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof WorkingStorageAdapter) {
            WorkingStorageAdapter workingStorageAdapter = (WorkingStorageAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)workingStorageAdapter));
            this.consistencyCheckOfWorkingStorage(workingStorageAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof FileSectionAdapter) {
            FileSectionAdapter fileSectionAdapter = (FileSectionAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)fileSectionAdapter));
            this.consistencyCheckOfFileSection(fileSectionAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof EventParagraphsAdapter) {
            EventParagraphsAdapter eventParagraphsAdapter = (EventParagraphsAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)eventParagraphsAdapter));
            this.consistencyCheckOfEventParagraphs(eventParagraphsAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        } else if (this.target instanceof FDEventParagraphsAdapter) {
            FDEventParagraphsAdapter fDEventParagraphsAdapter = (FDEventParagraphsAdapter)this.target;
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)fDEventParagraphsAdapter));
            this.consistencyCheckOfFDEventParagraphs(fDEventParagraphsAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 100));
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void consistencyCheckOfProgramList(ProgramListWorkbenchAdapter programListWorkbenchAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = programListWorkbenchAdapter.getChildren();
        this.beginTask(iProgressMonitor, "", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkMonitor(iProgressMonitor);
            ScreenProgramAdapter screenProgramAdapter = (ScreenProgramAdapter)objectArray[i];
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter));
            this.consistencyCheckOfScreenProgram(screenProgramAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfProject(ProjectWorkbenchAdapter projectWorkbenchAdapter, IProgressMonitor iProgressMonitor) {
        this.checkMonitor(iProgressMonitor);
        this.beginTask(iProgressMonitor, "", 2);
        this.subTask(iProgressMonitor, "Parse " + projectWorkbenchAdapter.getProgramList().getLabel());
        this.consistencyCheckOfProgramList(projectWorkbenchAdapter.getProgramList(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.checkMonitor(iProgressMonitor);
        this.subTask(iProgressMonitor, "Parse " + projectWorkbenchAdapter.getFdList().getLabel());
        this.consistencyCheckOfFDList(projectWorkbenchAdapter.getFdList(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.done(iProgressMonitor);
    }

    private void checkMonitor(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private SubProgressMonitor getSubMonitor(IProgressMonitor iProgressMonitor, int n) {
        return iProgressMonitor != null ? new SubProgressMonitor(iProgressMonitor, n) : null;
    }

    private void beginTask(IProgressMonitor iProgressMonitor, String string, int n) {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(string, n);
        }
    }

    private void worked(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(n);
        }
    }

    private void done(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void subTask(IProgressMonitor iProgressMonitor, String string) {
        if (iProgressMonitor != null) {
            iProgressMonitor.subTask(string);
        }
    }

    private void consistencyCheckOfScreenProgram(ScreenProgramAdapter screenProgramAdapter, IProgressMonitor iProgressMonitor) {
        this.checkMonitor(iProgressMonitor);
        this.beginTask(iProgressMonitor, "", 5);
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getScreenList()));
        this.consistencyCheckOfScreenSectionList(screenProgramAdapter.getScreenList(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.checkMonitor(iProgressMonitor);
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getReportList()));
        this.consistencyCheckOfReportList(screenProgramAdapter.getReportList(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.checkMonitor(iProgressMonitor);
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getWorking()));
        this.consistencyCheckOfWorkingStorage(screenProgramAdapter.getWorking(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getLinkage()));
        this.consistencyCheckOfLinkageSection(screenProgramAdapter.getLinkage(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getFileSection()));
        this.consistencyCheckOfFileSection(screenProgramAdapter.getFileSection(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenProgramAdapter.getEventPar()));
        this.consistencyCheckOfEventParagraphs(screenProgramAdapter.getEventPar(), (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        this.done(iProgressMonitor);
    }

    private FindInObjectMatchReference[] addRef(FindInObjectMatchReference[] findInObjectMatchReferenceArray, FindInObjectMatchReference findInObjectMatchReference) {
        FindInObjectMatchReference[] findInObjectMatchReferenceArray2 = new FindInObjectMatchReference[findInObjectMatchReferenceArray.length + 1];
        System.arraycopy(findInObjectMatchReferenceArray, 0, findInObjectMatchReferenceArray2, 0, findInObjectMatchReferenceArray.length);
        findInObjectMatchReferenceArray2[findInObjectMatchReferenceArray.length] = findInObjectMatchReference;
        return findInObjectMatchReferenceArray2;
    }

    private void consistencyCheckOfScreenSection(ScreenSectionAdapter screenSectionAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        Object object;
        FindInObjectMatchReference findInObjectMatchReference;
        this.beginTask(iProgressMonitor, "", 1);
        AbstractBeanWindow abstractBeanWindow = screenSectionAdapter.getWindow();
        this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanWindow, findInObjectMatchReferenceArray, null, iProgressMonitor);
        boolean bl = false;
        bl = abstractBeanWindow.getWindowType().getValue() == 4;
        if (!(!bl && abstractBeanWindow.getWindowType().getValue() != 6 || abstractBeanWindow.getWindowHandle() != null && abstractBeanWindow.getWindowHandle().length() != 0)) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "window-handle");
            object = "missing window-handle in " + (bl ? "docking" : "mdi-parent") + " window";
            this.matches.addElement(new FindInObjectMatch(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), (String)object));
        }
        findInObjectMatchReference = abstractBeanWindow.getComponents();
        for (int i = 0; i < ((FindInObjectMatchReference)findInObjectMatchReference).length; ++i) {
            object = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.consistencyCheckOfComponent(screenSectionAdapter, (AbstractBeanControl)findInObjectMatchReference[i], this.addRef(findInObjectMatchReferenceArray, object), iProgressMonitor);
        }
        IToolbar[] iToolbarArray = abstractBeanWindow.getToolbars();
        for (int i = 0; i < iToolbarArray.length; ++i) {
            object = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_TOOLBAR, i, "");
            if (iToolbarArray[i] instanceof AbstractBeanToolbar) {
                this.consistencyCheckOfToolbar(screenSectionAdapter, (AbstractBeanToolbar)iToolbarArray[i], this.addRef(findInObjectMatchReferenceArray, object), iProgressMonitor);
                continue;
            }
            this.consistencyCheckOfRibbon(screenSectionAdapter, (AbstractRibbon)iToolbarArray[i], this.addRef(findInObjectMatchReferenceArray, object), iProgressMonitor);
        }
        Menu[] menuArray = abstractBeanWindow.getMenus();
        for (int i = 0; i < menuArray.length; ++i) {
            object = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_MENU, i, "");
            this.consistencyCheckOfMenu(screenSectionAdapter, menuArray[i], this.addRef(findInObjectMatchReferenceArray, object), iProgressMonitor);
        }
        AbstractBeanStatusbar abstractBeanStatusbar = abstractBeanWindow.getStatusbar();
        if (abstractBeanStatusbar != null) {
            object = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_STATUSBAR, 0, "");
            this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanStatusbar, this.addRef(findInObjectMatchReferenceArray, object), null, iProgressMonitor);
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfReport(ReportAdapter reportAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.beginTask(iProgressMonitor, "", 1);
        Report report = reportAdapter.getReport();
        this.consistencyCheckOfJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)report, findInObjectMatchReferenceArray, null, iProgressMonitor);
        ReportSection[] reportSectionArray = report.getAllSections();
        for (int i = 0; i < reportSectionArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT_SECTION, i, "");
            this.consistencyCheckOfReportSection(reportAdapter, reportSectionArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfToolbar(ScreenSectionAdapter screenSectionAdapter, AbstractBeanToolbar abstractBeanToolbar, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanToolbar, findInObjectMatchReferenceArray, null, iProgressMonitor);
        AbstractBeanControl[] abstractBeanControlArray = abstractBeanToolbar.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.consistencyCheckOfComponent(screenSectionAdapter, abstractBeanControlArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void consistencyCheckOfRibbon(ScreenSectionAdapter screenSectionAdapter, AbstractRibbon abstractRibbon, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractRibbon, findInObjectMatchReferenceArray, null, iProgressMonitor);
        TabPage[] tabPageArray = abstractRibbon.getPages();
        for (int i = 0; i < tabPageArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PAGE, i, "");
            this.consistencyCheckOfTabPage(screenSectionAdapter, tabPageArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void consistencyCheckOfReportSection(ReportAdapter reportAdapter, ReportSection reportSection, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        String string;
        ReportControl[] reportControlArray;
        if (reportSection instanceof ReportGroup) {
            FindInObjectMatchReference findInObjectMatchReference;
            reportControlArray = (ReportControl[])reportSection;
            string = reportControlArray.getGroupedBy();
            if (string == null || string.length() == 0) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "Grouped By");
                this.matches.addElement(new FindInObjectMatch(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), "'Grouped By' property is not set"));
            } else if (this.findVariable(string, reportAdapter.getScreenProgram()) == null) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "Grouped By");
                this.matches.addElement(new FindInObjectMatch(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), "'Grouped By' variable '" + string + "' does not exist"));
            }
        }
        this.consistencyCheckOfJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)reportSection, findInObjectMatchReferenceArray, null, iProgressMonitor);
        reportControlArray = reportSection.getComponents();
        for (int i = 0; i < reportControlArray.length; ++i) {
            string = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT_COMPONENT, i, "");
            this.consistencyCheckOfReportComponent(reportAdapter, reportControlArray[i], this.addRef(findInObjectMatchReferenceArray, (FindInObjectMatchReference)string), iProgressMonitor);
        }
    }

    private void consistencyCheckOfMenu(ScreenSectionAdapter screenSectionAdapter, Menu menu, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)menu, findInObjectMatchReferenceArray, null, iProgressMonitor);
    }

    private void consistencyCheckOfTabPage(ScreenSectionAdapter screenSectionAdapter, TabPage tabPage, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)tabPage, findInObjectMatchReferenceArray, null, iProgressMonitor);
        AbstractBeanControl[] abstractBeanControlArray = tabPage.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.consistencyCheckOfComponent(screenSectionAdapter, abstractBeanControlArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void consistencyCheckOfComponent(ScreenSectionAdapter screenSectionAdapter, AbstractBeanControl abstractBeanControl, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                this.consistencyCheckOfJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanControl, findInObjectMatchReferenceArray, null, iProgressMonitor);
                if (!(abstractBeanControl instanceof AbstractTabbedPane)) break block2;
                TabPage[] tabPageArray = ((AbstractTabbedPane)abstractBeanControl).getPages();
                for (int i = 0; i < tabPageArray.length; ++i) {
                    FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PAGE, i, "");
                    this.consistencyCheckOfTabPage(screenSectionAdapter, tabPageArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
                }
                break block3;
            }
            if (!(abstractBeanControl instanceof ComponentsContainer)) break block3;
            AbstractBeanControl[] abstractBeanControlArray = ((ComponentsContainer)abstractBeanControl).getComponents();
            for (int i = 0; i < abstractBeanControlArray.length; ++i) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
                this.consistencyCheckOfComponent(screenSectionAdapter, abstractBeanControlArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), iProgressMonitor);
            }
        }
    }

    private void consistencyCheckOfReportComponent(ReportAdapter reportAdapter, ReportControl reportControl, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)reportControl, findInObjectMatchReferenceArray, null, iProgressMonitor);
    }

    private void consistencyCheckOfSettingList(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, SettingItemList settingItemList, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        SettingItem[] settingItemArray = new SettingItem[settingItemList.getSettingCount()];
        settingItemList.toArray(settingItemArray);
        for (int i = 0; i < settingItemArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            String string2 = string == null ? settingItemArray[i].toString() : string + ":" + settingItemArray[i].toString();
            this.consistencyCheckOfSettingItem(iFile, iscobolWorkbenchAdapter, settingItemArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string2, iProgressMonitor);
        }
    }

    private void consistencyCheckOfArray(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, Object[] objectArray, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        for (int i = 0; i < objectArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            String string2 = string == null ? objectArray[i].toString() : string + ":" + objectArray[i].toString();
            this.consistencyCheckOfJavaBean(iFile, iscobolWorkbenchAdapter, objectArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string2, iProgressMonitor);
        }
    }

    private void consistencyCheckOfVariable(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, VariableType variableType, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        Object object;
        FindInObjectMatchReference findInObjectMatchReference;
        FindInObjectMatchReference findInObjectMatchReference2;
        VariableUsage variableUsage;
        this.consistencyCheckOfVariableValue(iFile, iscobolWorkbenchAdapter, variableType, findInObjectMatchReferenceArray, string);
        this.consistencyCheckOfVariableLevel(iFile, iscobolWorkbenchAdapter, variableType, findInObjectMatchReferenceArray, string);
        if (variableType.isAlphanumericG()) {
            variableUsage = variableType.getUsage();
            if (variableUsage.getValue() != 0) {
                findInObjectMatchReference2 = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "usage");
                findInObjectMatchReference = "invalid usage of '" + variableType.getName() + "' variable: '" + variableUsage + "'";
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference2), (String)findInObjectMatchReference));
            }
        } else if (variableType.isAlphanumeric() && (variableUsage = variableType.getUsage()).getValue() != 0 && variableUsage.getValue() != 9 && variableUsage.getValue() != 13) {
            findInObjectMatchReference2 = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "usage");
            findInObjectMatchReference = "invalid usage of '" + variableType.getName() + "' variable: '" + variableUsage + "'";
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference2), (String)findInObjectMatchReference));
        }
        this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "redefines", variableType.getRedefines());
        this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "same as", variableType.getSameAs());
        this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "renames", variableType.getRenames());
        this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "renames thru", variableType.getRenamesThru());
        findInObjectMatchReference2 = this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "usage typedef", variableType.getUsageTypedef());
        if (findInObjectMatchReference2 != null && !findInObjectMatchReference2.isTypedef()) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "usage typedef");
            object = "invalid usage typedef name: '" + variableType.getUsageTypedef() + "'";
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), (String)object));
        }
        if (variableType.getOccurs().isOccurs()) {
            this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "occurs", variableType.getOccurs().getDepOn());
        }
        findInObjectMatchReference = variableType.getChildren();
        for (int i = 0; i < ((FindInObjectMatchReference)findInObjectMatchReference).length; ++i) {
            object = (VariableType)findInObjectMatchReference[i];
            if (!VariableSettingsContentPane.canAdd((VariableType)object, (int)1)) continue;
            FindInObjectMatchReference findInObjectMatchReference3 = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            this.consistencyCheckOfVariable(iFile, iscobolWorkbenchAdapter, object, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference3), object.toString(), iProgressMonitor);
        }
    }

    private void consistencyCheckOfSettingItem(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, SettingItem settingItem, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        this.consistencyCheckOfJavaBean(iFile, iscobolWorkbenchAdapter, (Object)settingItem, findInObjectMatchReferenceArray, string, iProgressMonitor);
        if (settingItem instanceof SettingTreeItem) {
            SettingTreeItem settingTreeItem = (SettingTreeItem)settingItem;
            SettingTreeItem[] settingTreeItemArray = settingTreeItem.getChildren();
            for (int i = 0; i < settingTreeItemArray.length; ++i) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
                this.consistencyCheckOfSettingItem(iFile, iscobolWorkbenchAdapter, (SettingItem)settingTreeItemArray[i], this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), settingTreeItemArray[i].toString(), iProgressMonitor);
            }
        }
    }

    private void consistencyCheckOfFDAttribute(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, FDAttributes fDAttributes, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findParagraph(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "beforeOpen", fDAttributes.getBeforeOpen());
        this.findParagraph(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, "afterOpen", fDAttributes.getAfterOpen());
    }

    private void consistencyCheckOfVariableLevel(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, VariableType variableType, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string) {
        boolean bl;
        int n = variableType.getLevelAsInt();
        VariableType variableType2 = (VariableType)variableType.getParent();
        if (variableType2 != null) {
            int n2;
            bl = n > variableType2.getLevelAsInt();
            if ((bl &= n == 88 || variableType.getNo88ChildCount() > 0 || variableType.getPicture() != null && variableType.getPicture().length() > 0 || variableType.getUsage().getValue() > 13) && (n2 = variableType2.indexOf((SettingTreeItem)variableType)) > 0) {
                bl &= n == ((VariableType)variableType2.getChildAt(n2 - 1)).getLevelAsInt();
            }
        } else {
            boolean bl2 = bl = n == 1 || n == 77 || n == 78;
        }
        if (!bl) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "level");
            String string2 = "Invalid level number " + n;
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string2));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void consistencyCheckOfVariableValue(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, VariableType variableType, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string) {
        String string2 = variableType.getValue();
        int n = variableType.getLevelAsInt();
        if (n == 78 || n == 88 || string2 == null || string2.length() <= 0) return;
        if (variableType.isNumeric() || variableType.isHandle()) {
            if (string2.startsWith("\"")) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "value");
                String string3 = "invalid value of '" + variableType.getName() + "' variable: '" + string2 + "'";
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string3));
                return;
            } else {
                try {
                    Double.parseDouble(string2.replace(',', '.'));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    VariableType variableType2;
                    if (FIGURATIVE_CONSTANTS.containsKey(string2.toUpperCase()) || (variableType2 = this.findVariable(iscobolWorkbenchAdapter, string2)) != null && variableType2.getLevelAsInt() == 78 && variableType2.getValue() != null && !variableType2.getValue().startsWith("\"")) return;
                    FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "value");
                    String string4 = "invalid value of '" + variableType.getName() + "' variable: '" + string2 + "'";
                    this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string4));
                }
            }
            return;
        }
        try {
            Double.parseDouble(string2.replace(',', '.'));
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, "value");
            String string5 = "invalid value of '" + variableType.getName() + "' variable: '" + string2 + "'";
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string5));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private VariableType findVariable(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, String string2) {
        VariableType variableType;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (iscobolWorkbenchAdapter instanceof IScreenProgramAdapter) {
            ScreenProgram screenProgram = ((IScreenProgramAdapter)iscobolWorkbenchAdapter).getScreenProgram();
            variableType = this.findVariable(string2, screenProgram);
            if (variableType == null) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, string);
                String string3 = "variable '" + string2 + "' does not exist";
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string3));
            }
        } else if (iscobolWorkbenchAdapter instanceof IFDAdapter) {
            ScreenFD_SL screenFD_SL = ((IFDAdapter)iscobolWorkbenchAdapter).getDataLayout();
            variableType = screenFD_SL.getFdItems().findVariable(string2, screenFD_SL.getFdName());
            if (variableType == null) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, string);
                String string4 = "variable '" + string2 + "' does not exist";
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string4));
            }
        } else {
            variableType = null;
        }
        return variableType;
    }

    private VariableType findVariable(IscobolWorkbenchAdapter iscobolWorkbenchAdapter, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (iscobolWorkbenchAdapter instanceof IScreenProgramAdapter) {
            ScreenProgram screenProgram = ((IScreenProgramAdapter)iscobolWorkbenchAdapter).getScreenProgram();
            return this.findVariable(string, screenProgram);
        }
        if (iscobolWorkbenchAdapter instanceof IFDAdapter) {
            ScreenFD_SL screenFD_SL = ((IFDAdapter)iscobolWorkbenchAdapter).getDataLayout();
            return screenFD_SL.getFdItems().findVariable(string, screenFD_SL.getFdName());
        }
        return null;
    }

    private void findParagraph(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, String string2) {
        ScreenFD_SL screenFD_SL;
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (iscobolWorkbenchAdapter instanceof IScreenProgramAdapter) {
            ScreenProgram screenProgram = ((IScreenProgramAdapter)iscobolWorkbenchAdapter).getScreenProgram();
            if (!this.getProbableParagraphList(screenProgram).contains(string2)) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, string);
                String string3 = "paragraph '" + string2 + "' does not exist";
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string3));
            }
        } else if (iscobolWorkbenchAdapter instanceof IFDAdapter && !this.getProbableParagraphList(screenFD_SL = ((IFDAdapter)iscobolWorkbenchAdapter).getDataLayout()).contains(string2)) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, string);
            String string4 = "paragraph '" + string2 + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string4));
        }
    }

    private void consistencyCheckOfJavaBean(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, Object object, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        PropertyDescriptor[] propertyDescriptorArray = PropertyDescriptorRegistry.getJPropertyDescriptors(object.getClass());
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            String string2;
            FindInObjectMatchReference findInObjectMatchReference;
            if (IscobolBeanConstants.isHiddenProperty((String)propertyDescriptorArray[i].getName())) continue;
            Object object2 = this.getPropValue(propertyDescriptorArray[i], object);
            if (object2 instanceof SettingItemList) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptorArray[i].getName());
                this.consistencyCheckOfSettingList(iFile, iscobolWorkbenchAdapter, (SettingItemList)object2, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), "[" + FindInObjectUtilities.getLabelFor((Object)object) + "]", iProgressMonitor);
            } else if (object2 instanceof Object[]) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptorArray[i].getName());
                this.consistencyCheckOfArray(iFile, iscobolWorkbenchAdapter, (Object[])object2, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), "[" + FindInObjectUtilities.getLabelFor((Object)object) + "]", iProgressMonitor);
            } else if (object2 instanceof XFDAttributes) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_EFD_ATTR, 0, propertyDescriptorArray[i].getName());
            }
            object2 = this.getPropValue(propertyDescriptorArray[i], object);
            if (IscobolBeanConstants.isVariableProperty((String)propertyDescriptorArray[i].getName())) {
                string2 = (String)object2;
                this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, propertyDescriptorArray[i].getDisplayName(), string2);
                continue;
            }
            if (IscobolBeanConstants.isParagraphProperty((String)propertyDescriptorArray[i].getName())) {
                string2 = (String)object2;
                this.findParagraph(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, propertyDescriptorArray[i].getDisplayName(), string2);
                continue;
            }
            if ("Event procedure".equals(propertyDescriptorArray[i].getName()) || "Exception procedure".equals(propertyDescriptorArray[i].getName())) {
                string2 = (String)object2;
                this.findProcedure(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, propertyDescriptorArray[i].getDisplayName(), string2);
                continue;
            }
            if (IscobolBeanConstants.isFontProperty((String)propertyDescriptorArray[i].getName())) {
                string2 = (FontType)object2;
                if (string2 == null) continue;
                this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, propertyDescriptorArray[i].getDisplayName(), string2.getHandleName());
                continue;
            }
            if (!IscobolBeanConstants.isBitmapProperty((String)propertyDescriptorArray[i].getName()) || (string2 = (ImageType)object2) == null) continue;
            this.findVariable(iFile, iscobolWorkbenchAdapter, findInObjectMatchReferenceArray, propertyDescriptorArray[i].getDisplayName(), string2.getHandleName());
        }
    }

    private Object getPropValue(PropertyDescriptor propertyDescriptor, Object object) {
        try {
            return propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void consistencyCheckOfScreenSectionList(ScreenSectionListAdapter screenSectionListAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = screenSectionListAdapter.getChildren();
        this.beginTask(iProgressMonitor, "", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkMonitor(iProgressMonitor);
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SCREEN, i, "");
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{findInObjectMatchReference};
            ScreenSectionAdapter screenSectionAdapter = (ScreenSectionAdapter)objectArray[i];
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)screenSectionAdapter));
            this.consistencyCheckOfScreenSection((ScreenSectionAdapter)objectArray[i], findInObjectMatchReferenceArray, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfReportList(ReportListAdapter reportListAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = reportListAdapter.getChildren();
        this.beginTask(iProgressMonitor, "", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkMonitor(iProgressMonitor);
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT, i, "");
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{findInObjectMatchReference};
            ReportAdapter reportAdapter = (ReportAdapter)objectArray[i];
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)reportAdapter));
            this.consistencyCheckOfReport(reportAdapter, findInObjectMatchReferenceArray, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfLinkageSection(LinkageSectionAdapter linkageSectionAdapter, IProgressMonitor iProgressMonitor) {
        this.checkMonitor(iProgressMonitor);
        VariableTypeList variableTypeList = linkageSectionAdapter.getScreenProgram().getResourceRegistry().getVariableTypeList();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        this.beginTask(iProgressMonitor, "", variableTypeArray.length);
        for (int i = 0; i < variableTypeArray.length; ++i) {
            if (!VariableSettingsContentPane.canAdd((VariableType)variableTypeArray[i], (int)2)) continue;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            this.consistencyCheckOfVariable(linkageSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)linkageSectionAdapter, variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
            this.worked(iProgressMonitor, 1);
        }
        iProgressMonitor.done();
    }

    private void consistencyCheckOfWorkingStorage(WorkingStorageAdapter workingStorageAdapter, IProgressMonitor iProgressMonitor) {
        this.checkMonitor(iProgressMonitor);
        VariableTypeList variableTypeList = workingStorageAdapter.getScreenProgram().getResourceRegistry().getVariableTypeList();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        this.beginTask(iProgressMonitor, "", variableTypeArray.length);
        for (int i = 0; i < variableTypeArray.length; ++i) {
            if (!VariableSettingsContentPane.canAdd((VariableType)variableTypeArray[i], (int)1)) continue;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            this.consistencyCheckOfVariable(workingStorageAdapter.getProgramFile(), (IscobolWorkbenchAdapter)workingStorageAdapter, variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
            this.worked(iProgressMonitor, 1);
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfFileSection(FileSectionAdapter fileSectionAdapter, IProgressMonitor iProgressMonitor) {
        FindInObjectMatchReference[] findInObjectMatchReferenceArray;
        this.beginTask(iProgressMonitor, "", 1);
        Object[] objectArray = fileSectionAdapter.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, i, "")};
            this.consistencyCheckOfDataSet((DataSetAdapter)objectArray[i], findInObjectMatchReferenceArray, iProgressMonitor);
        }
        FileSection fileSection = fileSectionAdapter.getScreenProgram().getFileSection();
        FDAttributes[] fDAttributesArray = fileSection.getFDAttributes();
        for (int i = 0; i < fDAttributesArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_FD_ATTR, i, "")};
            this.consistencyCheckOfFDAttribute(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, fDAttributesArray[i], findInObjectMatchReferenceArray, iProgressMonitor);
        }
        FileEntry[] fileEntryArray = fileSectionAdapter.getScreenProgram().getFileSection().getFDEntries();
        for (int i = 0; i < fileEntryArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_FD_ENTRY, i, "")};
            if (this.checkFileEntry(fileEntryArray[i])) continue;
            String string = "file '" + fileEntryArray[i].getFilename() + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, findInObjectMatchReferenceArray, string));
        }
        FileEntry[] fileEntryArray2 = fileSectionAdapter.getScreenProgram().getFileSection().getSLEntries();
        for (int i = 0; i < fileEntryArray2.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SL_ENTRY, i, "")};
            if (this.checkFileEntry(fileEntryArray2[i])) continue;
            String string = "file '" + fileEntryArray2[i].getFilename() + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, findInObjectMatchReferenceArray, string));
        }
        FileEntry[] fileEntryArray3 = fileSectionAdapter.getScreenProgram().getFileSection().getDeclarativeEntries();
        for (int i = 0; i < fileEntryArray3.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DC_ENTRY, i, "")};
            if (this.checkFileEntry(fileEntryArray3[i])) continue;
            String string = "file '" + fileEntryArray3[i].getFilename() + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, findInObjectMatchReferenceArray, string));
        }
        this.done(iProgressMonitor);
    }

    private boolean checkFileEntry(FileEntry fileEntry) {
        String string = fileEntry.getFilename();
        File file = new File(string);
        if (file.isAbsolute()) {
            if (file.exists()) {
                return true;
            }
        } else {
            String string2 = PluginUtilities.getCurrentSettingMode((IResource)this.project);
            try {
                IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)this.project, (String)string2);
                for (int i = 0; i < iContainerArray.length; ++i) {
                    IResource iResource = PluginUtilities.findMember((IContainer)iContainerArray[i], (IPath)new Path(string));
                    if (!(iResource instanceof IFile)) continue;
                    return true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private void consistencyCheckOfFDList(FDListWorkbenchAdapter fDListWorkbenchAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = fDListWorkbenchAdapter.getChildren();
        this.beginTask(iProgressMonitor, "", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkMonitor(iProgressMonitor);
            FDAdapter fDAdapter = (FDAdapter)objectArray[i];
            this.subTask(iProgressMonitor, "Parse " + FindInObjectUtilities.getLabelFor((Object)fDAdapter));
            this.consistencyCheckOfFD(fDAdapter, (IProgressMonitor)this.getSubMonitor(iProgressMonitor, 1));
        }
        this.done(iProgressMonitor);
    }

    private void consistencyCheckOfFD(FDAdapter fDAdapter, IProgressMonitor iProgressMonitor) {
        VariableTypeList variableTypeList = fDAdapter.getDataLayout().getFdItems();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        if (variableTypeArray.length > 0) {
            for (int i = 0; i < variableTypeArray.length; ++i) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
                this.consistencyCheckOfVariable(fDAdapter.getDataLayoutFile(), (IscobolWorkbenchAdapter)fDAdapter, variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
            }
        } else {
            this.matches.addElement(FindInObjectMatch.getFDKeyDefinitionMatch((IscobolWorkbenchAdapter)fDAdapter, (String)"no record description entities exist"));
        }
        this.consistencyCheckOfFDEventParagraphs(fDAdapter.getEventPar(), iProgressMonitor);
        this.done(iProgressMonitor);
    }

    private void analyzeEventParagraphs(StringBuilder stringBuilder, boolean bl, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, IProject iProject, IProgressMonitor iProgressMonitor) {
        Vector vector;
        ICompiler iCompiler = Factory.getCompiler((IProject)iProject);
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(stringBuilder.toString()));
        String string = bl ? "-sa" : "-st";
        String string2 = "";
        String string3 = PluginUtilities.getCurrentSettingMode((IResource)iProject);
        if (string3 != null) {
            string2 = PluginUtilities.getSourcePath((IProject)iProject, (String)string3);
        }
        IOptionList iOptionList = iCompiler.newOptionList(new String[]{"-jj", string, "-sp=" + string2, "xxx"});
        IPcc iPcc = PluginUtilities.pccAnalyze((String)"xxx", (IOptionList)iOptionList, (String)("-sp=" + string2), (IErrors)iCompiler.newErrorsForCodeAnalyzer(), (Reader)lineNumberReader, (IProject)iProject, null, null, null);
        try {
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (iPcc != null && (vector = iPcc.getErrors().getAllMessages()).size() > 0) {
            lineNumberReader = new LineNumberReader(new StringReader(stringBuilder.toString()));
            int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
            try {
                nArray = this.getEventParagraphStartEnd(lineNumberReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                lineNumberReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IError iError = (IError)vector.elementAt(i);
                if (iError.getErrorType() != 4 || iError.getLineNumber() <= nArray[0] || iError.getLineNumber() >= nArray[1]) continue;
                if (iscobolWorkbenchAdapter instanceof EventParagraphsAdapter) {
                    this.matches.addElement(FindInObjectMatch.getSPEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)(iError.getLineNumber() - nArray[0]), (int)iError.getOffset(), (int)0, (String)iError.getMessage()));
                    continue;
                }
                this.matches.addElement(FindInObjectMatch.getFDEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)(iError.getLineNumber() - nArray[0]), (int)iError.getOffset(), (int)0, (String)iError.getMessage()));
            }
        }
    }

    private void consistencyCheckOfEventParagraphs(EventParagraphsAdapter eventParagraphsAdapter, IProgressMonitor iProgressMonitor) {
        this.beginTask(iProgressMonitor, "", 1);
        ScreenProgram screenProgram = eventParagraphsAdapter.getScreenProgram();
        StringBuilder stringBuilder = EventParagraphsEditor.getContents((ScreenProgram)screenProgram);
        this.analyzeEventParagraphs(stringBuilder, screenProgram.getAnsiFormat(), (IscobolWorkbenchAdapter)eventParagraphsAdapter, screenProgram.getProject(), iProgressMonitor);
        this.done(iProgressMonitor);
    }

    private int[] getEventParagraphStartEnd(LineNumberReader lineNumberReader) throws IOException {
        int[] nArray = new int[]{0, 0};
        String string = lineNumberReader.readLine();
        while (string != null) {
            if (nArray[0] == 0) {
                if (string.equals("      *> ##### EVENT PARAGRAPH START #####")) {
                    nArray[0] = lineNumberReader.getLineNumber();
                }
            } else {
                if (nArray[1] != 0) break;
                if (string.equals("      *> ##### EVENT PARAGRAPH END #####")) {
                    nArray[1] = lineNumberReader.getLineNumber();
                }
            }
            string = lineNumberReader.readLine();
        }
        if (nArray[0] == 0) {
            nArray[0] = lineNumberReader.getLineNumber();
        }
        if (nArray[1] == 0) {
            nArray[1] = lineNumberReader.getLineNumber();
        }
        return nArray;
    }

    private void consistencyCheckOfFDEventParagraphs(FDEventParagraphsAdapter fDEventParagraphsAdapter, IProgressMonitor iProgressMonitor) {
        this.beginTask(iProgressMonitor, "", 1);
        ScreenFD_SL screenFD_SL = fDEventParagraphsAdapter.getDataLayout();
        StringBuilder stringBuilder = EventParagraphsEditor.getContents((ScreenFD_SL)screenFD_SL);
        this.analyzeEventParagraphs(stringBuilder, IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.progfile.ansi"), (IscobolWorkbenchAdapter)fDEventParagraphsAdapter, screenFD_SL.getProject(), iProgressMonitor);
        this.done(iProgressMonitor);
    }

    private void findProcedure(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, String string2) {
        ScreenProgram screenProgram;
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (iscobolWorkbenchAdapter instanceof IScreenProgramAdapter && !(screenProgram = ((IScreenProgramAdapter)iscobolWorkbenchAdapter).getScreenProgram()).containsProcedure(string2)) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, string);
            String string3 = "procedure '" + string2 + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string3));
        }
    }

    private ScreenFD_SL findDataLayout(String string) {
        if (this.dataLayouts == null) {
            IFile[] iFileArray = PluginUtilities.getDataLayoutFiles((IProject)this.project);
            this.dataLayouts = new ScreenFD_SL[iFileArray.length];
            for (int i = 0; i < iFileArray.length; ++i) {
                this.dataLayouts[i] = IscobolScreenPainterPlugin.getDefault().getCachedScreenFD_SL(iFileArray[i]);
            }
        }
        for (int i = 0; i < this.dataLayouts.length; ++i) {
            if (!this.dataLayouts[i].getFdName().equalsIgnoreCase(string)) continue;
            return this.dataLayouts[i];
        }
        return null;
    }

    private void consistencyCheckOfDataSet(DataSetAdapter dataSetAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.beginTask(iProgressMonitor, "", 1);
        DataSet dataSet = dataSetAdapter.getDataSet();
        String string = dataSet.getFDName();
        ScreenFD_SL screenFD_SL = this.findDataLayout(string);
        if (screenFD_SL == null) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, 0, "Data Layout");
            String string2 = "data-layout '" + string + "' does not exist";
            this.matches.addElement(new FindInObjectMatch(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string2));
        } else {
            String string3 = dataSet.getKeyName();
            if (string3 != null && string3.length() > 0) {
                String string4;
                KeyList keyList = screenFD_SL.getFileDescriptor().getKeys();
                int n = keyList.getSettingCount();
                boolean bl = false;
                for (int i = 0; i < n && !bl; bl |= (string4 = ((Key)keyList.getSettingAt(i)).getName()) != null && string4.equalsIgnoreCase(string3), ++i) {
                }
                if (!bl) {
                    FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, 0, "Key");
                    string4 = "key '" + string3 + "' does not exist";
                    this.matches.addElement(new FindInObjectMatch(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, this.addRef(findInObjectMatchReferenceArray, findInObjectMatchReference), string4));
                }
            }
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "After Delete", dataSet.getAfterDelete());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "After Read", dataSet.getAfterRead());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "After Rewrite", dataSet.getAfterRewrite());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "After Write", dataSet.getAfterWrite());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Before Delete", dataSet.getBeforeDelete());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Before Read", dataSet.getBeforeRead());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Before Rewrite", dataSet.getBeforeRewrite());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Before Write", dataSet.getBeforeWrite());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Input Procedure", dataSet.getInputProcedure());
            this.findParagraph(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, findInObjectMatchReferenceArray, "Output Procedure", dataSet.getOutputProcedure());
        }
        this.done(iProgressMonitor);
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    static {
        FIGURATIVE_CONSTANTS.put("NULL", "NULL");
        FIGURATIVE_CONSTANTS.put("NULLS", "NULLS");
        FIGURATIVE_CONSTANTS.put("ZERO", "ZERO");
        FIGURATIVE_CONSTANTS.put("ZEROS", "ZEROS");
        FIGURATIVE_CONSTANTS.put("ZEROES", "ZEROES");
        FIGURATIVE_CONSTANTS.put("SPACE", "SPACE");
        FIGURATIVE_CONSTANTS.put("SPACES", "SPACES");
        FIGURATIVE_CONSTANTS.put("QUOTE", "QUOTE");
        FIGURATIVE_CONSTANTS.put("QUOTES", "QUOTES");
        FIGURATIVE_CONSTANTS.put("LOW-VALUE", "LOW-VALUE");
        FIGURATIVE_CONSTANTS.put("LOW-VALUES", "LOW-VALUES");
        FIGURATIVE_CONSTANTS.put("HIGH-VALUE", "HIGH-VALUE");
        FIGURATIVE_CONSTANTS.put("HIGH-VALUES", "HIGH-VALUES");
    }
}

