/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IError;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.annotations.CopyAnnotation;
import com.iscobol.plugins.editor.annotations.ProblemAnnotation;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.ProgramFragment;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.propertysheet.EventParagraphs;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventParagraphsEditor
extends IscobolEditor {
    private static final String eol = System.getProperty("line.separator", "\n");
    private ScreenRoot screenRoot;
    private int eventParagraphStartLine;
    private boolean allowCopyProblemAnnotations;
    private FormEditor parentEditor;
    private IBreakpointListener bpListener;
    private IResourceChangeListener resourceChangeListener;
    private ICompiler compiler;

    public EventParagraphsEditor(FormEditor formEditor) {
        this.parentEditor = formEditor;
        if (this.parentEditor instanceof ScreenProgramEditor) {
            this.screenRoot = ((ScreenProgramEditor)this.parentEditor).getScreenProgram();
        } else if (this.parentEditor instanceof DataLayoutEditor) {
            this.screenRoot = ((DataLayoutEditor)this.parentEditor).getDataLayout();
        }
        this.compiler = Factory.getCompiler((IProject)this.screenRoot.getProject());
        if (this.screenRoot.getFile() != null) {
            this.resourceChangeListener = new /* Unavailable Anonymous Inner Class!! */;
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
        this.setDocumentProvider((IDocumentProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    public FormEditor getParentEditor() {
        return this.parentEditor;
    }

    private void update(IAnnotationModel iAnnotationModel, IMarkerDelta[] iMarkerDeltaArray) {
        if (iMarkerDeltaArray.length == 0) {
            return;
        }
        block4: for (int i = 0; i < iMarkerDeltaArray.length; ++i) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[i];
            switch (iMarkerDelta.getKind()) {
                case 1: {
                    this.putMarkerAnnotation(iAnnotationModel, iMarkerDelta.getMarker());
                    continue block4;
                }
                case 2: {
                    this.removeMarkerAnnotation(iAnnotationModel, iMarkerDelta.getMarker());
                }
            }
        }
    }

    private void putMarkerAnnotation(IAnnotationModel iAnnotationModel, IMarker iMarker) {
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private final void removeMarkerAnnotation(IAnnotationModel iAnnotationModel, IMarker iMarker) {
        MarkerAnnotation markerAnnotation = this.getMarkerAnnotation(iAnnotationModel, iMarker);
        if (markerAnnotation != null) {
            iAnnotationModel.removeAnnotation((Annotation)markerAnnotation);
        }
    }

    private final MarkerAnnotation getMarkerAnnotation(IAnnotationModel iAnnotationModel, IMarker iMarker) {
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            MarkerAnnotation markerAnnotation;
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation) || !iMarker.equals((Object)(markerAnnotation = (MarkerAnnotation)e).getMarker())) continue;
            return markerAnnotation;
        }
        return null;
    }

    public static StringBuilder getContents(ScreenFD_SL screenFD_SL) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.progfile.ansi");
        String string = bl ? "       " : "";
        stringBuilder.append(string);
        stringBuilder.append("program-id. xxx.");
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("environment division.");
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("input-output section.");
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("file-control.");
        stringBuilder.append(eol);
        com.iscobol.filedesigner.CodeGenerator codeGenerator = new com.iscobol.filedesigner.CodeGenerator(screenFD_SL, 0);
        codeGenerator.generateSL(stringBuilder);
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("data division.");
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("file section.");
        stringBuilder.append(eol);
        codeGenerator.generateFD(stringBuilder);
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("working-storage section.");
        stringBuilder.append(eol);
        stringBuilder.append(string);
        stringBuilder.append("procedure division.");
        stringBuilder.append(eol);
        if (IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.fileproc.checked")) {
            stringBuilder.append("      *> ##### FD EVENT PARAGRAPH START #####");
            stringBuilder.append(eol);
            codeGenerator.generatePRC(stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder getContents(ScreenProgram screenProgram) {
        CodeGenerator codeGenerator = new CodeGenerator(screenProgram, true);
        StringBuilder stringBuilder = new StringBuilder();
        codeGenerator.generate(!screenProgram.getRegenerateTaggedAreaOnly(), stringBuilder);
        return stringBuilder;
    }

    public ContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new EventParagraphsOutlinePage(this);
        }
        return this.outlinePage;
    }

    protected void initializeConfiguration() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new EventParagraphsConfiguration((IscobolEditor)this));
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void updateFoldingStructure(List<Position> list, ProgramFragment programFragment, boolean bl) {
        try {
            super.updateFoldingStructure(list, programFragment, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFormat() {
        return this.screenRoot.getAnsiFormat() ? 1 : 2;
    }

    protected boolean isFragmentAtLine(int n, String string, IsFragment isFragment) {
        return isFragment.getPosition() != null && n >= isFragment.getStartLine() && (isFragment.getType() == 5 ? n < isFragment.getEndLine() : n <= isFragment.getEndLine());
    }

    public void addAndSelectParagraph(EventParagraphs eventParagraphs, String string, boolean bl) {
        if (!bl) {
            return;
        }
        IDocument iDocument = this.getViewer().getDocument();
        String string2 = iDocument.get();
        int n = PluginUtilities.rawSearchParagraph((String)string, (String)string2, (ICompiler)this.compiler);
        this.initEditor(eventParagraphs, n, string, iDocument, string2);
    }

    private void initEditor(EventParagraphs eventParagraphs, int n, String string, IDocument iDocument, String string2) {
        if (n >= 0) {
            try {
                IRegion iRegion = iDocument.getLineInformation(n);
                this.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
                IRegion iRegion2 = iDocument.getLineInformation(n + 1);
                int n2 = iRegion2.getLength();
                if (n2 == 0) {
                    n2 = 1;
                }
                this.getViewer().getTextWidget().setCaretOffset(iRegion2.getOffset() + n2 - 1);
            }
            catch (Exception exception) {}
        } else {
            ScreenProgram screenProgram;
            if (this.screenRoot instanceof ScreenFD_SL) {
                eventParagraphs.addParagraphToBody(string, string2);
                iDocument.set(eventParagraphs.getBody());
            } else {
                screenProgram = (ScreenProgram)this.screenRoot;
                if (screenProgram.isAGenericCobolProgram()) {
                    eventParagraphs.addParagraphToProcedure(string, string2);
                    iDocument.set(eventParagraphs.getProcedure());
                } else {
                    eventParagraphs.addParagraphToBody(string, string2);
                    iDocument.set(eventParagraphs.getBody());
                }
            }
            try {
                screenProgram = iDocument.getLineInformation(iDocument.getNumberOfLines() - 1);
                this.setHighlightRange(screenProgram.getOffset(), screenProgram.getLength(), true);
                this.getViewer().getTextWidget().setCaretOffset(iDocument.getLength() - 15);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener(this.bpListener);
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        super.dispose();
    }

    int getEventParagraphStartLine() {
        return this.eventParagraphStartLine;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IEditorPart.class) {
            if (this.screenRoot.getFile() != null) {
                return this.parentEditor != null ? this.parentEditor : this;
            }
            return null;
        }
        return super.getAdapter(clazz);
    }

    private void putMarkerAnnotations(IFile iFile, String string) {
        if (iFile == null) {
            return;
        }
        try {
            IMarker[] iMarkerArray;
            for (IMarker iMarker : iMarkerArray = iFile.findMarkers(string, false, 1)) {
                this.putMarkerAnnotation(this.getVerticalRuler().getModel(), iMarker);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        IFile iFile = this.screenRoot.getFile();
        this.putMarkerAnnotations(iFile, "org.eclipse.core.resources.bookmark");
        this.putMarkerAnnotations(iFile, "org.eclipse.core.resources.taskmarker");
        for (IBreakpoint iBreakpoint : DebugPlugin.getDefault().getBreakpointManager().getBreakpoints()) {
            int n;
            if (!(iBreakpoint instanceof IscobolBreakpoint) || !iBreakpoint.getMarker().getResource().getName().equals(this.parentEditor.getEditorInput().getName()) || (n = iBreakpoint.getMarker().getAttribute("lineNumber", 0)) < 0) continue;
            try {
                iBreakpoint.getMarker().delete();
                IscobolDebugTarget.toggleLineBreakpoints((IEditorPart)this.parentEditor, (int)(n - 1));
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        this.bpListener = new /* Unavailable Anonymous Inner Class!! */;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(this.bpListener);
        Control control = this.getVerticalRuler().getControl();
        control.addMouseTrackListener((MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void putCopyAnnotation(int n, CopyAnnotation copyAnnotation) {
        if ((n -= this.eventParagraphStartLine) >= 0 && this.allowCopyProblemAnnotations) {
            super.putCopyAnnotation(n, copyAnnotation);
            this.putCopyAnnotation(n, copyAnnotation, this.getVerticalRuler().getModel());
        }
    }

    public void clearCopyAnnotations() {
        super.clearCopyAnnotations();
        if (this.getVerticalRuler() != null) {
            this.clearCopyAnnotations(this.getVerticalRuler().getModel());
        }
    }

    public void putProblemAnnotation(IError iError, int n, int n2, ProblemAnnotation problemAnnotation) {
        if (!this.allowCopyProblemAnnotations) {
            return;
        }
        super.putProblemAnnotation(iError, n, n2, problemAnnotation);
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void clearProblemAnnotations() {
        super.clearProblemAnnotations();
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private StringBuilder getContents(IDocument iDocument) {
        String string;
        StringBuilder stringBuilder;
        String string2;
        Object object;
        if (this.screenRoot instanceof ScreenProgram) {
            object = (ScreenProgram)this.screenRoot;
            string2 = this.getViewer().getDocument().get();
            if (object.isAGenericCobolProgram()) {
                object.getEventParagraphs().setProcedure(string2);
            } else {
                object.getEventParagraphs().setBody(string2);
            }
            stringBuilder = EventParagraphsEditor.getContents((ScreenProgram)object);
            string = "      *> ##### EVENT PARAGRAPH START #####";
        } else {
            object = (ScreenFD_SL)this.screenRoot;
            object.getEventParagraphs().setBody(this.getViewer().getDocument().get());
            stringBuilder = EventParagraphsEditor.getContents((ScreenFD_SL)object);
            string = "      *> ##### FD EVENT PARAGRAPH START #####";
        }
        object = new LineNumberReader(new StringReader(stringBuilder.toString()));
        this.eventParagraphStartLine = 0;
        this.allowCopyProblemAnnotations = false;
        try {
            string2 = ((LineNumberReader)object).readLine();
            while (string2 != null) {
                if (string2.equals(string)) {
                    this.eventParagraphStartLine = ((LineNumberReader)object).getLineNumber();
                    break;
                }
                string2 = ((LineNumberReader)object).readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.eventParagraphStartLine == 0) {
            boolean bl;
            stringBuilder = new StringBuilder();
            boolean bl2 = bl = this.screenRoot instanceof ScreenProgram ? ((ScreenProgram)this.screenRoot).getDecimalPointComma() : false;
            if (this.getViewer() != null && this.getViewer().getDocument() != null) {
                this.eventParagraphStartLine = PluginUtilities.preProcessSource((StringBuilder)stringBuilder, null, (String)this.getViewer().getDocument().get(), null, (boolean)bl, (boolean)false, (int)18);
            }
        } else {
            this.allowCopyProblemAnnotations = true;
        }
        return stringBuilder;
    }

    public int getContentsForPcc(StringBuilder stringBuilder) {
        if (this.getViewer() != null) {
            stringBuilder.append((CharSequence)this.getContents(this.getViewer().getDocument()));
            return this.eventParagraphStartLine;
        }
        return 0;
    }

    static /* synthetic */ IVerticalRuler access$000(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ ScreenRoot access$100(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.screenRoot;
    }

    static /* synthetic */ IVerticalRuler access$200(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ void access$300(EventParagraphsEditor eventParagraphsEditor, IAnnotationModel iAnnotationModel, IMarkerDelta[] iMarkerDeltaArray) {
        eventParagraphsEditor.update(iAnnotationModel, iMarkerDeltaArray);
    }

    static /* synthetic */ IVerticalRuler access$400(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ StringBuilder access$500(EventParagraphsEditor eventParagraphsEditor, IDocument iDocument) {
        return eventParagraphsEditor.getContents(iDocument);
    }

    static /* synthetic */ int access$600(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.eventParagraphStartLine;
    }

    static /* synthetic */ FormEditor access$700(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.parentEditor;
    }

    static /* synthetic */ IVerticalRuler access$900(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ void access$1000(EventParagraphsEditor eventParagraphsEditor, IError iError, Position position, ProblemAnnotation problemAnnotation, IAnnotationModel iAnnotationModel) {
        eventParagraphsEditor.putProblemAnnotation(iError, position, problemAnnotation, iAnnotationModel);
    }

    static /* synthetic */ IVerticalRuler access$1100(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ IVerticalRuler access$1200(EventParagraphsEditor eventParagraphsEditor) {
        return eventParagraphsEditor.getVerticalRuler();
    }

    static /* synthetic */ void access$1300(EventParagraphsEditor eventParagraphsEditor, IAnnotationModel iAnnotationModel) {
        eventParagraphsEditor.clearProblemAnnotations(iAnnotationModel);
    }
}

