/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.filedesigner.IOAllowedOperations;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.types.FileFormat;
import com.iscobol.filedesigner.types.Key;
import com.iscobol.filedesigner.types.KeyList;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.screenpainter.FileSectionPage;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenProgramPage;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.FDAttributes;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.FileSection;
import com.iscobol.screenpainter.beans.types.OpenLockMode;
import com.iscobol.screenpainter.beans.types.OpenMode;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.beans.types.RefDataSetInfo;
import com.iscobol.screenpainter.dialogs.ReferencedDataSetsDialog;
import com.iscobol.screenpainter.findinobject.FindInObjectMatch;
import com.iscobol.screenpainter.propertysheet.ParagraphEditor;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FileSectionPage
extends ScreenProgramPage {
    private Section fdSec;
    private Section slSec;
    private Section declSec;
    private Section dsSec;
    private Section referencedSec;
    private Section openOptSec;
    private Section ioOptSec;
    private Table slTable;
    private Table fdTable;
    private Table declTable;
    private Table dsEvtTable;
    private Table referencedProcTable;
    private TableEditor dsEvtTableEditor;
    private TableEditor referencedProcTableEditor;
    private Tree dsTree;
    private Tree fdAttrTree;
    private Button fdImportBtn;
    private Button fdLinkBtn;
    private Button fdRemoveBtn;
    private Button slImportBtn;
    private Button slLinkBtn;
    private Button slRemoveBtn;
    private Button declImportBtn;
    private Button declLinkBtn;
    private Button declRemoveBtn;
    private Button wrOpenBtn;
    private Button openExclusiveBtn;
    private Button wrDeclarativesBtn;
    private Button wrReadBtn;
    private Button wrReadNextBtn;
    private Button wrReadPrevBtn;
    private Button wrWriteBtn;
    private Button wrRewriteBtn;
    private Button wrDeleteRecBtn;
    private Button wrDeleteBtn;
    private Button wrCloseBtn;
    private Button wrCommitBtn;
    private Button wrRollbackBtn;
    private Button refDataSetsBtn;
    private Combo dsDataLayoutCmb;
    private Combo dsKeyCmb;
    private Combo openModeCmb;
    private Combo openLockModeCmb;
    private Text dsNameTxt;
    private Text refDataSetsTxt;
    private Label openModeLbl;
    private Label openLockModeLbl;
    private ModifyListener dsNameTxtModifyL;
    private boolean programSelection;
    private int lastDsDataLayoutSelection = -1;
    private CommandStack commandStack;

    FileSectionPage(ScreenProgramEditor screenProgramEditor) {
        super(screenProgramEditor, "iscobolscreenpainter.MultipageScreenSectionEditor.Page2", "File Section");
    }

    void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        try {
            iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)var2_2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof ScreenFD_SL) {
            if (propertyChangeEvent.getProperty().equals("iscobol.fd.name") && propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() != null) {
                FileSection fileSection = this.getScreenProgram().getFileSection();
                FDAttributes fDAttributes = fileSection.getFDAttributes(propertyChangeEvent.getOldValue().toString());
                if (fDAttributes != null) {
                    fileSection.removeFDAttributes(fDAttributes);
                    fDAttributes.setFDName(propertyChangeEvent.getNewValue().toString());
                    fileSection.addFDAttributes(fDAttributes);
                    this.renameFDAttrItem(fDAttributes);
                    this.makeDirty();
                }
            } else if (propertyChangeEvent.getProperty().equals("iscobol.fd.file.format")) {
                ScreenFD_SL screenFD_SL = (ScreenFD_SL)propertyChangeEvent.getSource();
                FileFormat fileFormat = screenFD_SL.getFileDescriptor().getFileFormat();
                int n = this.openModeCmb.getSelectionIndex();
                this.fillOpenModeCmb(fileFormat);
                if (n < 0 || n >= this.openModeCmb.getItemCount()) {
                    n = fileFormat.isOpenIOAllowed() ? 3 : (screenFD_SL.getFileDescriptor().getAssignDevice().isOpenInputAllowed() ? 0 : 1);
                }
                this.openModeCmb.select(n);
                int n2 = fileFormat.getValue();
                if (n2 != 5) {
                    this.setReferencedSectionEnabledState(true);
                    this.setIOOperationEnabledStates(this.wrOpenBtn.getSelection(), ((Integer)this.openModeCmb.getData(this.openModeCmb.getItem(n))).intValue(), fileFormat.getValue());
                } else {
                    this.setReferencedSectionEnabledState(false);
                }
            }
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText("File Section");
        scrolledForm.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/filesection.gif"));
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = scrolledForm.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        composite.setLayout((Layout)tableWrapLayout);
        this.fdSec = formToolkit.createSection(composite, 260);
        this.fdSec.setText("FD Files");
        TableWrapData tableWrapData = new TableWrapData(256);
        this.fdSec.setLayoutData((Object)tableWrapData);
        Composite composite2 = formToolkit.createComposite((Composite)this.fdSec);
        this.fdSec.setClient((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = formToolkit.createComposite(composite2, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 50;
        composite3.setLayoutData((Object)gridData);
        ColumnLayout columnLayout = new ColumnLayout();
        columnLayout.maxNumColumns = 3;
        composite3.setLayout((Layout)columnLayout);
        this.fdTable = formToolkit.createTable(composite2, 2052);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.fdTable.setLayoutData((Object)gridData);
        this.fdTable.setLinesVisible(true);
        this.fdTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.fdTable, 0);
        tableColumn.setWidth(400);
        tableColumn.setText("Path");
        tableColumn = new TableColumn(this.fdTable, 0);
        tableColumn.setWidth(70);
        tableColumn.setText("Linked");
        this.fdImportBtn = formToolkit.createButton(composite3, "Import Copy File", 8);
        this.fdLinkBtn = formToolkit.createButton(composite3, "Link Copy File", 8);
        this.fdRemoveBtn = formToolkit.createButton(composite3, "Remove Copy File", 8);
        this.slSec = formToolkit.createSection(composite, 260);
        this.slSec.setText("SL Files");
        tableWrapData = new TableWrapData(256);
        this.slSec.setLayoutData((Object)tableWrapData);
        Composite composite4 = formToolkit.createComposite((Composite)this.slSec);
        this.slSec.setClient((Control)composite4);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite4.setLayout((Layout)gridLayout);
        Composite composite5 = formToolkit.createComposite(composite4, 0);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        composite5.setLayoutData((Object)gridData);
        columnLayout = new ColumnLayout();
        columnLayout.maxNumColumns = 3;
        composite5.setLayout((Layout)columnLayout);
        this.slTable = formToolkit.createTable(composite4, 2052);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.slTable.setLayoutData((Object)gridData);
        this.slTable.setLinesVisible(true);
        this.slTable.setHeaderVisible(true);
        tableColumn = new TableColumn(this.slTable, 0);
        tableColumn.setWidth(400);
        tableColumn.setText("Path");
        tableColumn = new TableColumn(this.slTable, 0);
        tableColumn.setWidth(70);
        tableColumn.setText("Linked");
        this.slImportBtn = formToolkit.createButton(composite5, "Import Copy File", 8);
        this.slLinkBtn = formToolkit.createButton(composite5, "Link Copy File", 8);
        this.slRemoveBtn = formToolkit.createButton(composite5, "Remove Copy File", 8);
        this.declSec = formToolkit.createSection(composite, 260);
        this.declSec.setText("Declarative Files");
        tableWrapData = new TableWrapData(256);
        this.declSec.setLayoutData((Object)tableWrapData);
        Composite composite6 = formToolkit.createComposite((Composite)this.declSec);
        this.declSec.setClient((Control)composite6);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite6.setLayout((Layout)gridLayout);
        Composite composite7 = formToolkit.createComposite(composite6, 0);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        composite7.setLayoutData((Object)gridData);
        columnLayout = new ColumnLayout();
        columnLayout.maxNumColumns = 3;
        composite7.setLayout((Layout)columnLayout);
        this.declTable = formToolkit.createTable(composite6, 2052);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.declTable.setLayoutData((Object)gridData);
        this.declTable.setLinesVisible(true);
        this.declTable.setHeaderVisible(true);
        tableColumn = new TableColumn(this.declTable, 0);
        tableColumn.setWidth(400);
        tableColumn.setText("Path");
        tableColumn = new TableColumn(this.declTable, 0);
        tableColumn.setWidth(70);
        tableColumn.setText("Linked");
        this.declImportBtn = formToolkit.createButton(composite7, "Import Copy File", 8);
        this.declLinkBtn = formToolkit.createButton(composite7, "Link Copy File", 8);
        this.declRemoveBtn = formToolkit.createButton(composite7, "Remove Copy File", 8);
        this.referencedSec = formToolkit.createSection(composite, 260);
        this.referencedSec.setText("Referenced FD/SL files");
        tableWrapData = new TableWrapData(256);
        this.referencedSec.setLayoutData((Object)tableWrapData);
        Composite composite8 = formToolkit.createComposite((Composite)this.referencedSec);
        this.referencedSec.setClient((Control)composite8);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite8.setLayout((Layout)gridLayout);
        this.fdAttrTree = formToolkit.createTree(composite8, 2048);
        gridData = new GridData(1040);
        gridData.verticalSpan = 3;
        gridData.widthHint = 350;
        this.fdAttrTree.setLayoutData((Object)gridData);
        this.openOptSec = formToolkit.createSection(composite8, 256);
        this.openOptSec.setText("Open Options");
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        this.openOptSec.setLayoutData((Object)gridData);
        Composite composite9 = formToolkit.createComposite((Composite)this.openOptSec);
        this.openOptSec.setClient((Control)composite9);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite9.setLayout((Layout)gridLayout);
        this.wrOpenBtn = formToolkit.createButton(composite9, "Open", 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.wrOpenBtn.setLayoutData((Object)gridData);
        this.openExclusiveBtn = formToolkit.createButton(composite9, "Exclusive", 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.openExclusiveBtn.setLayoutData((Object)gridData);
        this.openModeLbl = formToolkit.createLabel(composite9, "Mode");
        this.openModeCmb = new Combo(composite9, 2056);
        gridData = new GridData(768);
        this.openModeCmb.setLayoutData((Object)gridData);
        this.openLockModeLbl = formToolkit.createLabel(composite9, "Lock");
        this.openLockModeCmb = new Combo(composite9, 2056);
        gridData = new GridData(768);
        this.openLockModeCmb.setLayoutData((Object)gridData);
        this.ioOptSec = formToolkit.createSection(composite8, 256);
        this.ioOptSec.setText("I-O Operations");
        gridData = new GridData(1808);
        this.ioOptSec.setLayoutData((Object)gridData);
        Composite composite10 = formToolkit.createComposite((Composite)this.ioOptSec);
        this.ioOptSec.setClient((Control)composite10);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite10.setLayout((Layout)gridLayout);
        this.wrDeclarativesBtn = formToolkit.createButton(composite10, "Declaratives", 32);
        this.wrDeleteRecBtn = formToolkit.createButton(composite10, "Delete File Record", 32);
        this.wrReadBtn = formToolkit.createButton(composite10, "Read File", 32);
        this.wrDeleteBtn = formToolkit.createButton(composite10, "Delete File", 32);
        this.wrReadNextBtn = formToolkit.createButton(composite10, "Read File Next", 32);
        this.wrCloseBtn = formToolkit.createButton(composite10, "Close File", 32);
        this.wrReadPrevBtn = formToolkit.createButton(composite10, "Read File Previous", 32);
        this.wrCommitBtn = formToolkit.createButton(composite10, "Commit", 32);
        this.wrWriteBtn = formToolkit.createButton(composite10, "Write", 32);
        this.wrRollbackBtn = formToolkit.createButton(composite10, "Rollback", 32);
        this.wrRewriteBtn = formToolkit.createButton(composite10, "Rewrite", 32);
        Label label = formToolkit.createLabel(composite8, "Events:");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.referencedProcTable = formToolkit.createTable(composite8, 2052);
        this.referencedProcTable.setLinesVisible(true);
        this.referencedProcTable.setHeaderVisible(true);
        this.referencedProcTableEditor = new TableEditor(this.referencedProcTable);
        this.referencedProcTableEditor.grabHorizontal = true;
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 120;
        this.referencedProcTable.setLayoutData((Object)gridData);
        TableColumn tableColumn2 = new TableColumn(this.referencedProcTable, 0);
        tableColumn2.setWidth(150);
        tableColumn2.setText("Name");
        tableColumn2 = new TableColumn(this.referencedProcTable, 0);
        tableColumn2.setWidth(300);
        tableColumn2.setText("Value");
        TableItem tableItem = new TableItem(this.referencedProcTable, 0);
        tableItem.setText(0, "After Close");
        tableItem = new TableItem(this.referencedProcTable, 0);
        tableItem.setText(0, "After Open");
        tableItem = new TableItem(this.referencedProcTable, 0);
        tableItem.setText(0, "Before Close");
        tableItem = new TableItem(this.referencedProcTable, 0);
        tableItem.setText(0, "Before Open");
        this.dsSec = formToolkit.createSection(composite, 324);
        this.dsSec.setText("Data Sets");
        tableWrapData = new TableWrapData(256);
        this.dsSec.setLayoutData((Object)tableWrapData);
        Composite composite11 = formToolkit.createComposite((Composite)this.dsSec);
        this.dsSec.setClient((Control)composite11);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite11.setLayout((Layout)gridLayout);
        this.dsTree = formToolkit.createTree(composite11, 2560);
        gridData = new GridData(1040);
        gridData.widthHint = 350;
        gridData.heightHint = 300;
        this.dsTree.setLayoutData((Object)gridData);
        Composite composite12 = formToolkit.createComposite(composite11);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite12.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        composite12.setLayoutData((Object)gridData);
        label = formToolkit.createLabel(composite12, "Name:");
        this.dsNameTxt = formToolkit.createText(composite12, "", 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.dsNameTxt.setLayoutData((Object)gridData);
        label = formToolkit.createLabel(composite12, "Data Layout:");
        this.dsDataLayoutCmb = new Combo(composite12, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.dsDataLayoutCmb.setLayoutData((Object)gridData);
        label = formToolkit.createLabel(composite12, "Key:");
        this.dsKeyCmb = new Combo(composite12, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.dsKeyCmb.setLayoutData((Object)gridData);
        label = formToolkit.createLabel(composite12, "Referenced Data Sets:");
        this.refDataSetsTxt = formToolkit.createText(composite12, "", 2048);
        gridData = new GridData(768);
        this.refDataSetsTxt.setLayoutData((Object)gridData);
        this.refDataSetsTxt.setEditable(false);
        this.refDataSetsBtn = formToolkit.createButton(composite12, "...", 8);
        label = formToolkit.createLabel(composite12, "Events:");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.dsEvtTable = new Table(composite12, 2052);
        this.dsEvtTable.setLinesVisible(true);
        this.dsEvtTable.setHeaderVisible(true);
        this.dsEvtTableEditor = new TableEditor(this.dsEvtTable);
        this.dsEvtTableEditor.grabHorizontal = true;
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 200;
        this.dsEvtTable.setLayoutData((Object)gridData);
        tableColumn2 = new TableColumn(this.dsEvtTable, 0);
        tableColumn2.setWidth(150);
        tableColumn2.setText("Name");
        tableColumn2 = new TableColumn(this.dsEvtTable, 0);
        tableColumn2.setWidth(300);
        tableColumn2.setText("Value");
        this.initData();
        if (this.dsTree.getItemCount() > 0) {
            this.dsTree.setSelection(this.dsTree.getItem(0));
            this.dsTreeSelchange();
        }
        if (this.fdAttrTree.getItemCount() > 0) {
            this.fdAttrTree.setSelection(this.fdAttrTree.getItem(0));
            this.fdAttrTreeSelchange();
        }
        this.addListeners(scrolledForm);
        this.setContentPane(composite);
    }

    private void fillDataLayoutCmb(ScreenFD_SL[] screenFD_SLArray) {
        for (int i = 0; i < screenFD_SLArray.length; ++i) {
            String string = screenFD_SLArray[i].getFdName();
            this.dsDataLayoutCmb.add(string);
            this.putDataLayoutFile(string, screenFD_SLArray[i].getFile());
        }
    }

    private void putDataLayoutFile(String string, IFile iFile) {
        this.dsDataLayoutCmb.setData(string.toLowerCase(), (Object)iFile);
    }

    private IFile getDataLayoutFile(String string) {
        return (IFile)this.dsDataLayoutCmb.getData(string.toLowerCase());
    }

    void select(DataSet dataSet) {
        TreeItem[] treeItemArray = this.dsTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!((DataSet)treeItemArray[i].getData()).getName().equals(dataSet.getName())) continue;
            this.dsTree.setSelection(treeItemArray[i]);
        }
    }

    private void dsEvtTableSelect(int n) {
        this.dsEvtTable.setFocus();
        if (n < this.dsEvtTable.getItemCount()) {
            this.dsEvtTable.select(n);
        }
    }

    public void selectFileSectionProperty(FindInObjectMatchReference[] findInObjectMatchReferenceArray) {
        if (findInObjectMatchReferenceArray.length < 2) {
            return;
        }
        this.programSelection = true;
        Enum enum_ = findInObjectMatchReferenceArray[0].getType();
        if (enum_ instanceof FindInObjectMatch.ReferenceType) {
            switch (36.$SwitchMap$com$iscobol$screenpainter$findinobject$FindInObjectMatch$ReferenceType[((FindInObjectMatch.ReferenceType)enum_).ordinal()]) {
                case 1: {
                    String string;
                    DataSet dataSet = null;
                    this.dsSec.setExpanded(true);
                    if (this.dsTree.getItemCount() > findInObjectMatchReferenceArray[0].getIndex()) {
                        TreeItem treeItem = this.dsTree.getItem(findInObjectMatchReferenceArray[0].getIndex());
                        dataSet = (DataSet)treeItem.getData();
                        this.dsTree.setSelection(treeItem);
                        this.dsTreeSelchange();
                    }
                    if ((string = findInObjectMatchReferenceArray[1].getName()).equals("After Delete")) {
                        this.dsEvtTableSelect(0);
                        break;
                    }
                    if (string.equals("After Read")) {
                        this.dsEvtTableSelect(1);
                        break;
                    }
                    if (string.equals("After Rewrite")) {
                        this.dsEvtTableSelect(2);
                        break;
                    }
                    if (string.equals("After Write")) {
                        this.dsEvtTableSelect(3);
                        break;
                    }
                    if (string.equals("Before Delete")) {
                        this.dsEvtTableSelect(4);
                        break;
                    }
                    if (string.equals("Before Read")) {
                        this.dsEvtTableSelect(5);
                        break;
                    }
                    if (string.equals("Before Rewrite")) {
                        this.dsEvtTableSelect(6);
                        break;
                    }
                    if (string.equals("Before Write")) {
                        this.dsEvtTableSelect(7);
                        break;
                    }
                    if (string.equals("Input Procedure")) {
                        this.dsEvtTableSelect(0);
                        break;
                    }
                    if (string.equals("Output Procedure")) {
                        this.dsEvtTableSelect(1);
                        break;
                    }
                    if (string.equals("Name")) {
                        this.dsNameTxt.setFocus();
                        break;
                    }
                    if (string.equals("Data Layout")) {
                        this.dsDataLayoutCmb.setFocus();
                        break;
                    }
                    if (string.equals("Key")) {
                        this.dsKeyCmb.setFocus();
                        break;
                    }
                    if (!string.equals("Referenced Data Sets")) break;
                    this.refDataSetsTxt.setFocus();
                    if (findInObjectMatchReferenceArray.length <= 2 || dataSet == null) break;
                    this.openReferencedDataSetDialog(dataSet, findInObjectMatchReferenceArray[2].getIndex());
                    break;
                }
                case 2: {
                    String string;
                    this.fdSec.setExpanded(true);
                    if (this.fdAttrTree.getItemCount() > findInObjectMatchReferenceArray[0].getIndex()) {
                        this.fdAttrTree.setSelection(this.fdAttrTree.getItem(findInObjectMatchReferenceArray[0].getIndex()));
                    }
                    if ((string = findInObjectMatchReferenceArray[1].getName()).equals("exclusive")) {
                        if (!this.openExclusiveBtn.isEnabled()) break;
                        this.openExclusiveBtn.setFocus();
                        break;
                    }
                    if (string.equals("openLockMode")) {
                        if (!this.openLockModeCmb.isEnabled()) break;
                        this.openLockModeCmb.setFocus();
                        break;
                    }
                    if (string.equals("openMode")) {
                        if (!this.openModeCmb.isEnabled()) break;
                        this.openModeCmb.setFocus();
                        break;
                    }
                    if (string.equals("writeClose")) {
                        if (!this.wrCloseBtn.isEnabled()) break;
                        this.wrCloseBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeCommint")) {
                        if (!this.wrCommitBtn.isEnabled()) break;
                        this.wrCommitBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeDeclaratives")) {
                        if (!this.wrDeclarativesBtn.isEnabled()) break;
                        this.wrDeclarativesBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeDelete")) {
                        if (!this.wrDeleteBtn.isEnabled()) break;
                        this.wrDeleteBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeDeleteRecord")) {
                        if (!this.wrDeleteRecBtn.isEnabled()) break;
                        this.wrDeleteRecBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeOpen")) {
                        if (!this.wrOpenBtn.isEnabled()) break;
                        this.wrOpenBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeReadNext")) {
                        if (!this.wrReadNextBtn.isEnabled()) break;
                        this.wrReadNextBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeReadPrevious")) {
                        if (!this.wrReadPrevBtn.isEnabled()) break;
                        this.wrReadPrevBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeRead")) {
                        if (!this.wrReadBtn.isEnabled()) break;
                        this.wrReadBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeRewrite")) {
                        if (!this.wrRewriteBtn.isEnabled()) break;
                        this.wrRewriteBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeRollback")) {
                        if (!this.wrRollbackBtn.isEnabled()) break;
                        this.wrRollbackBtn.setFocus();
                        break;
                    }
                    if (string.equals("writeWrite")) {
                        if (!this.wrWriteBtn.isEnabled()) break;
                        this.wrWriteBtn.setFocus();
                        break;
                    }
                    if (string.equals("afterClose")) {
                        this.referencedSec.setExpanded(true);
                        this.referencedProcTable.setFocus();
                        this.referencedProcTable.setSelection(0);
                        break;
                    }
                    if (string.equals("afterOpen")) {
                        this.referencedSec.setExpanded(true);
                        this.referencedProcTable.setFocus();
                        this.referencedProcTable.setSelection(1);
                        break;
                    }
                    if (string.equals("beforeClose")) {
                        this.referencedSec.setExpanded(true);
                        this.referencedProcTable.setFocus();
                        this.referencedProcTable.setSelection(2);
                        break;
                    }
                    if (!string.equals("beforeOpen")) break;
                    this.referencedSec.setExpanded(true);
                    this.referencedProcTable.setFocus();
                    this.referencedProcTable.setSelection(3);
                    break;
                }
                case 3: {
                    this.fdSec.setExpanded(true);
                    if (this.fdTable.getItemCount() <= findInObjectMatchReferenceArray[0].getIndex()) break;
                    this.fdTable.select(findInObjectMatchReferenceArray[0].getIndex());
                    break;
                }
                case 4: {
                    this.slSec.setExpanded(true);
                    if (this.slTable.getItemCount() <= findInObjectMatchReferenceArray[0].getIndex()) break;
                    this.slTable.select(findInObjectMatchReferenceArray[0].getIndex());
                    break;
                }
                case 5: {
                    this.declSec.setExpanded(true);
                    if (this.declTable.getItemCount() <= findInObjectMatchReferenceArray[0].getIndex()) break;
                    this.declTable.select(findInObjectMatchReferenceArray[0].getIndex());
                }
            }
        }
        this.programSelection = false;
    }

    void addDataSet(int n, DataSet dataSet) {
        if (n < 0 || n > this.dsTree.getItemCount()) {
            n = this.dsTree.getItemCount();
        }
        TreeItem treeItem = this.addDataSetItem(dataSet, n);
        this.dsTree.setSelection(treeItem);
        this.dsTreeSelchange();
    }

    void removeDataSet(DataSet dataSet) {
        TreeItem[] treeItemArray = this.dsTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!((DataSet)treeItemArray[i].getData()).getName().equals(dataSet.getName())) continue;
            treeItemArray[i].dispose();
            if (i != this.lastDsDataLayoutSelection) continue;
            this.lastDsDataLayoutSelection = -1;
        }
        if (this.dsTree.getItemCount() == 0) {
            this.setDataSetSectionEnabledState(false);
        }
    }

    void removeFDAttrItem(FDAttributes fDAttributes) {
        TreeItem[] treeItemArray = this.fdAttrTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (treeItemArray[i].getData() != fDAttributes) continue;
            treeItemArray[i].dispose();
        }
        if (this.fdAttrTree.getItemCount() == 0) {
            this.setReferencedSectionEnabledState(false);
        }
    }

    void renameFDAttrItem(FDAttributes fDAttributes) {
        TreeItem[] treeItemArray = this.fdAttrTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (treeItemArray[i].getData() != fDAttributes) continue;
            treeItemArray[i].setText(fDAttributes.getFDName());
        }
    }

    private void fillDsTable(DataSet dataSet, boolean bl) {
        this.dsEvtTable.removeAll();
        if (bl) {
            this.addDsTableItem("Input Procedure", dataSet.getInputProcedure());
            this.addDsTableItem("Output Procedure", dataSet.getOutputProcedure());
        } else {
            this.addDsTableItem("After Delete", dataSet.getAfterDelete());
            this.addDsTableItem("After Read", dataSet.getAfterRead());
            this.addDsTableItem("After Rewrite", dataSet.getAfterRewrite());
            this.addDsTableItem("After Write", dataSet.getAfterWrite());
            this.addDsTableItem("Before Delete", dataSet.getBeforeDelete());
            this.addDsTableItem("Before Read", dataSet.getBeforeRead());
            this.addDsTableItem("Before Rewrite", dataSet.getBeforeRewrite());
            this.addDsTableItem("Before Write", dataSet.getBeforeWrite());
        }
    }

    private void addDsTableItem(String string, String string2) {
        TableItem tableItem = new TableItem(this.dsEvtTable, 0);
        tableItem.setText(0, string);
        if (string2 != null) {
            tableItem.setText(1, string2);
        }
    }

    private int findFileEntryItem(Table table, FileEntry fileEntry) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            FileEntry fileEntry2 = (FileEntry)tableItemArray[i].getData();
            if (!fileEntry.getFilename().equals(fileEntry2.getFilename()) || !PluginUtilities.equals((Object)fileEntry.getReplacingPhrase(), (Object)fileEntry2.getReplacingPhrase())) continue;
            return i;
        }
        return -1;
    }

    private void addFileEntryItem(Table table, FileEntry fileEntry) {
        TableItem tableItem;
        int n = this.findFileEntryItem(table, fileEntry);
        if (n >= 0) {
            table.remove(n);
            tableItem = new TableItem(table, 0, n);
        } else {
            tableItem = new TableItem(table, 0);
        }
        tableItem.setText(0, fileEntry.getFilename());
        tableItem.setText(1, fileEntry.isLinked() ? "yes" : "no");
        tableItem.setForeground(fileEntry.isLinked() ? ColorConstants.red : ColorConstants.black);
        tableItem.setData((Object)fileEntry);
    }

    public CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = new CommandStack();
        }
        return this.commandStack;
    }

    void initData() {
        int n;
        FileSection fileSection = this.getScreenProgram().getFileSection();
        FileEntry[] fileEntryArray = fileSection.getFDEntries();
        this.fdTable.removeAll();
        for (int i = 0; i < fileEntryArray.length; ++i) {
            this.addFileEntryItem(this.fdTable, fileEntryArray[i]);
        }
        FileEntry[] fileEntryArray2 = fileSection.getSLEntries();
        this.slTable.removeAll();
        for (int i = 0; i < fileEntryArray2.length; ++i) {
            this.addFileEntryItem(this.slTable, fileEntryArray2[i]);
        }
        FileEntry[] fileEntryArray3 = fileSection.getDeclarativeEntries();
        this.declTable.removeAll();
        for (int i = 0; i < fileEntryArray3.length; ++i) {
            this.addFileEntryItem(this.declTable, fileEntryArray3[i]);
        }
        DataSet[] dataSetArray = this.getScreenProgram().getFileSection().getDataSets();
        for (int i = 0; i < dataSetArray.length; ++i) {
            this.addDataSetItem(dataSetArray[i], i);
        }
        IProject iProject = this.editor.getScreenProgram().getProject();
        IFile[] iFileArray = iProject != null ? PluginUtilities.getDataLayoutFiles((IProject)iProject) : new IFile[]{};
        ScreenFD_SL[] screenFD_SLArray = new ScreenFD_SL[iFileArray.length];
        for (int i = 0; i < iFileArray.length; ++i) {
            screenFD_SLArray[i] = PluginUtilities.getDataLayout((IFile)iFileArray[i]);
        }
        this.fillDataLayoutCmb(screenFD_SLArray);
        this.setDataSetSectionEnabledState(false);
        OpenMode openMode = new OpenMode();
        String[] stringArray = openMode.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.openModeCmb.setData(stringArray[i], (Object)new Integer(i));
        }
        OpenLockMode openLockMode = new OpenLockMode();
        stringArray = openLockMode.getNames();
        for (n = 0; n < stringArray.length; ++n) {
            this.openLockModeCmb.add(stringArray[n]);
        }
        this.fdAttrTree.removeAll();
        for (n = 0; n < dataSetArray.length; ++n) {
            int n2;
            String string = dataSetArray[n].getFDName();
            if (string == null || string.length() <= 0 || (n2 = this.checkExist(string, screenFD_SLArray)) < 0) continue;
            FDAttributes fDAttributes = fileSection.getFDAttributes(string);
            if (fDAttributes == null) {
                fDAttributes = new FDAttributes(string);
                fileSection.addFDAttributes(fDAttributes);
            }
            this.addFDAttrItem(fDAttributes, -1);
            if (screenFD_SLArray[n2].getFileDescriptor().getAccessMode().getValue() != 2) continue;
            fDAttributes.setWriteReadNext(false);
            fDAttributes.setWriteReadPrevious(false);
        }
        this.setReferencedSectionEnabledState(false);
    }

    private int checkExist(String string, ScreenFD_SL[] screenFD_SLArray) {
        for (int i = 0; i < screenFD_SLArray.length; ++i) {
            if (!screenFD_SLArray[i].getFdName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private TreeItem addFDAttrItem(FDAttributes fDAttributes, int n) {
        TreeItem treeItem = n >= 0 && n < this.fdAttrTree.getItemCount() ? new TreeItem(this.fdAttrTree, 0, n) : new TreeItem(this.fdAttrTree, 0);
        treeItem.setText(fDAttributes.getFDName());
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdsl.png"));
        treeItem.setData((Object)fDAttributes);
        return treeItem;
    }

    private TreeItem addDataSetItem(DataSet dataSet, int n) {
        TreeItem treeItem = new TreeItem(this.dsTree, 0, n);
        treeItem.setText(dataSet.getName());
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/dataset.png"));
        treeItem.setData((Object)dataSet);
        return treeItem;
    }

    private void setDataSetSectionEnabledState(boolean bl) {
        this.dsNameTxt.setEnabled(bl);
        this.dsKeyCmb.setEnabled(bl);
        this.dsDataLayoutCmb.setEnabled(bl);
        this.dsEvtTable.setEnabled(bl);
    }

    private void setReferencedSectionEnabledState(boolean bl) {
        this.openModeLbl.setEnabled(bl);
        this.openModeCmb.setEnabled(bl);
        this.openLockModeLbl.setEnabled(bl);
        this.openLockModeCmb.setEnabled(bl);
        this.openExclusiveBtn.setEnabled(bl);
        this.wrOpenBtn.setEnabled(bl);
        this.wrDeclarativesBtn.setEnabled(bl);
        this.wrReadBtn.setEnabled(bl);
        this.wrReadNextBtn.setEnabled(bl);
        this.wrReadPrevBtn.setEnabled(bl);
        this.wrDeleteBtn.setEnabled(bl);
        this.wrCloseBtn.setEnabled(bl);
        this.wrCommitBtn.setEnabled(bl);
        this.wrRollbackBtn.setEnabled(bl);
        this.wrDeleteRecBtn.setEnabled(bl);
        this.wrWriteBtn.setEnabled(bl);
        this.wrRewriteBtn.setEnabled(bl);
    }

    private void fdImportBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)true);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addFDEntry(fileEntry);
            this.addFileEntryItem(this.fdTable, fileEntry);
            this.makeDirty();
        }
    }

    private void fdLinkBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)false);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addFDEntry(fileEntry);
            this.addFileEntryItem(this.fdTable, fileEntry);
            this.makeDirty();
        }
    }

    private void fdRemoveBtnClicked() {
        int n = this.fdTable.getSelectionIndex();
        if (n >= 0) {
            this.getScreenProgram().getFileSection().removeFDEntry((FileEntry)this.fdTable.getItem(n).getData());
            this.fdTable.remove(n);
            this.makeDirty();
        }
    }

    private void slImportBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)true);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addSLEntry(fileEntry);
            this.addFileEntryItem(this.slTable, fileEntry);
            this.makeDirty();
        }
    }

    private void slLinkBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)false);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addSLEntry(fileEntry);
            this.addFileEntryItem(this.slTable, fileEntry);
            this.makeDirty();
        }
    }

    private void slRemoveBtnClicked() {
        int n = this.slTable.getSelectionIndex();
        if (n >= 0) {
            this.getScreenProgram().getFileSection().removeSLEntry((FileEntry)this.slTable.getItem(n).getData());
            this.slTable.remove(n);
            this.makeDirty();
        }
    }

    private void declImportBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)true);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addDeclarativeEntry(fileEntry);
            this.addFileEntryItem(this.declTable, fileEntry);
            this.makeDirty();
        }
    }

    private void declLinkBtnClicked() {
        IProject iProject = this.editor.getScreenProgram().getProject();
        if (iProject == null) {
            return;
        }
        FileEntry fileEntry = PluginUtilities.getFileEntry((Shell)this.getEditor().getSite().getShell(), (IProject)iProject, null, (boolean)false);
        if (fileEntry != null) {
            this.getScreenProgram().getFileSection().addDeclarativeEntry(fileEntry);
            this.addFileEntryItem(this.declTable, fileEntry);
            this.makeDirty();
        }
    }

    private void declRemoveBtnClicked() {
        int n = this.declTable.getSelectionIndex();
        if (n >= 0) {
            this.getScreenProgram().getFileSection().removeDeclarativeEntry((FileEntry)this.declTable.getItem(n).getData());
            this.declTable.remove(n);
            this.makeDirty();
        }
    }

    private void dsTreeSelchange() {
        if (this.dsTree.getSelectionCount() == 0) {
            return;
        }
        TreeItem treeItem = this.dsTree.getSelection()[0];
        DataSet dataSet = (DataSet)treeItem.getData();
        if (this.dsNameTxtModifyL != null) {
            this.dsNameTxt.removeModifyListener(this.dsNameTxtModifyL);
        }
        this.dsNameTxt.setText(dataSet.getName());
        if (this.dsNameTxtModifyL != null) {
            this.dsNameTxt.addModifyListener(this.dsNameTxtModifyL);
        }
        boolean bl = false;
        if (dataSet.getFDName() != null) {
            int n = -1;
            for (int i = 0; i < this.dsDataLayoutCmb.getItemCount(); ++i) {
                if (!this.dsDataLayoutCmb.getItem(i).equalsIgnoreCase(dataSet.getFDName())) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                this.dsDataLayoutCmb.select(n);
                ScreenFD_SL screenFD_SL = PluginUtilities.getDataLayout((IFile)this.getDataLayoutFile(dataSet.getFDName()));
                this.fillDsKeyCmb(screenFD_SL);
                boolean bl2 = bl = screenFD_SL.getFileDescriptor().getFileFormat().getValue() == 5;
                if (dataSet.getKeyName() != null && (n = this.dsKeyCmb.indexOf(dataSet.getKeyName())) >= 0) {
                    this.dsKeyCmb.select(n);
                }
            } else {
                this.dsDataLayoutCmb.deselectAll();
                this.dsKeyCmb.removeAll();
            }
        } else {
            this.dsDataLayoutCmb.deselectAll();
            this.dsKeyCmb.removeAll();
        }
        this.fillRefDataSetsTxt(dataSet);
        this.fillDsTable(dataSet, bl);
        this.setDataSetSectionEnabledState(true);
    }

    private void fillRefDataSetsTxt(DataSet dataSet) {
        RefDataSetInfo[] refDataSetInfoArray = dataSet.getReferencedDataSets();
        if (refDataSetInfoArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < refDataSetInfoArray.length; ++i) {
                stringBuilder.append("<");
                stringBuilder.append(refDataSetInfoArray[i].getDataSetName());
                stringBuilder.append(",");
                if (refDataSetInfoArray[i].getKeyName() != null) {
                    stringBuilder.append(refDataSetInfoArray[i].getKeyName());
                } else {
                    stringBuilder.append(refDataSetInfoArray[i].getFieldName());
                }
                stringBuilder.append(">");
                if (i >= refDataSetInfoArray.length - 1) continue;
                stringBuilder.append(",");
            }
            this.refDataSetsTxt.setText(stringBuilder.toString());
        }
    }

    private void fdAttrTreeSelchange() {
        boolean bl;
        FileFormat fileFormat;
        if (this.fdAttrTree.getSelectionCount() == 0) {
            return;
        }
        TreeItem treeItem = this.fdAttrTree.getSelection()[0];
        FDAttributes fDAttributes = (FDAttributes)treeItem.getData();
        this.wrOpenBtn.setSelection(fDAttributes.isWriteOpen());
        ScreenFD_SL screenFD_SL = null;
        IFile iFile = this.getDataLayoutFile(fDAttributes.getFDName());
        if (iFile != null) {
            screenFD_SL = PluginUtilities.getDataLayout((IFile)iFile);
            fileFormat = screenFD_SL.getFileDescriptor().getFileFormat();
        } else {
            fileFormat = new FileFormat();
        }
        this.fillOpenModeCmb(fileFormat);
        int n = fDAttributes.getOpenMode().getValue();
        boolean bl2 = bl = screenFD_SL == null || screenFD_SL.getFileDescriptor().getAssignDevice().isOpenInputAllowed();
        if (n < this.openModeCmb.getItemCount()) {
            if (!(n != 3 && n != 0 || bl)) {
                n = 1;
            }
        } else {
            n = fileFormat.isOpenIOAllowed() ? 3 : (bl ? 0 : 1);
        }
        this.openModeCmb.select(n);
        this.openExclusiveBtn.setSelection(fDAttributes.isExclusive());
        this.openLockModeCmb.select(fDAttributes.getOpenLockMode().getValue());
        this.wrDeclarativesBtn.setSelection(fDAttributes.isWriteDeclaratives());
        this.wrReadBtn.setSelection(fDAttributes.isWriteRead());
        this.wrReadNextBtn.setSelection(fDAttributes.isWriteReadNext());
        this.wrReadPrevBtn.setSelection(fDAttributes.isWriteReadPrevious());
        this.wrWriteBtn.setSelection(fDAttributes.isWriteWrite());
        this.wrRewriteBtn.setSelection(fDAttributes.isWriteRewrite());
        this.wrDeleteRecBtn.setSelection(fDAttributes.isWriteDeleteRecord());
        this.wrDeleteBtn.setSelection(fDAttributes.isWriteDelete());
        this.wrCloseBtn.setSelection(fDAttributes.isWriteClose());
        this.wrCommitBtn.setSelection(fDAttributes.isWriteCommit());
        this.wrRollbackBtn.setSelection(fDAttributes.isWriteRollback());
        int n2 = fileFormat.getValue();
        if (n2 != 5) {
            this.setReferencedSectionEnabledState(true);
            this.setIOOperationEnabledStates(fDAttributes.isWriteOpen(), n, fileFormat.getValue());
        } else {
            this.setReferencedSectionEnabledState(false);
        }
        if (fDAttributes.getAfterClose() != null) {
            this.referencedProcTable.getItem(0).setText(1, fDAttributes.getAfterClose());
        } else {
            this.referencedProcTable.getItem(0).setText(1, "");
        }
        if (fDAttributes.getAfterOpen() != null) {
            this.referencedProcTable.getItem(1).setText(1, fDAttributes.getAfterOpen());
        } else {
            this.referencedProcTable.getItem(1).setText(1, "");
        }
        if (fDAttributes.getBeforeClose() != null) {
            this.referencedProcTable.getItem(2).setText(1, fDAttributes.getBeforeClose());
        } else {
            this.referencedProcTable.getItem(2).setText(1, "");
        }
        if (fDAttributes.getBeforeOpen() != null) {
            this.referencedProcTable.getItem(3).setText(1, fDAttributes.getBeforeOpen());
        } else {
            this.referencedProcTable.getItem(3).setText(1, "");
        }
    }

    private void setIOOperationEnabledStates(boolean bl, int n, int n2) {
        IOAllowedOperations iOAllowedOperations = IOAllowedOperations.get((boolean)bl, (int)n, (int)n2);
        this.wrDeclarativesBtn.setEnabled(iOAllowedOperations.isAllowDeclaratives());
        this.wrReadBtn.setEnabled(iOAllowedOperations.isAllowRead());
        this.wrReadNextBtn.setEnabled(iOAllowedOperations.isAllowReadNext());
        this.wrReadPrevBtn.setEnabled(iOAllowedOperations.isAllowReadPrevious());
        this.wrWriteBtn.setEnabled(iOAllowedOperations.isAllowWrite());
        this.wrRewriteBtn.setEnabled(iOAllowedOperations.isAllowRewrite());
        this.wrDeleteRecBtn.setEnabled(iOAllowedOperations.isAllowDeleteRecord());
        this.wrDeleteBtn.setEnabled(iOAllowedOperations.isAllowDelete());
        this.wrCloseBtn.setEnabled(iOAllowedOperations.isAllowClose());
        this.wrCommitBtn.setEnabled(iOAllowedOperations.isAllowCommit());
        this.wrRollbackBtn.setEnabled(iOAllowedOperations.isAllowRollback());
    }

    private void fillOpenModeCmb(FileFormat fileFormat) {
        this.openModeCmb.removeAll();
        OpenMode openMode = new OpenMode();
        this.openModeCmb.add(openMode.getName(0));
        this.openModeCmb.add(openMode.getName(1));
        this.openModeCmb.add(openMode.getName(2));
        if (fileFormat.isOpenIOAllowed()) {
            this.openModeCmb.add(openMode.getName(3));
            this.openModeCmb.select(3);
        }
    }

    private void fillDsKeyCmb(ScreenFD_SL screenFD_SL) {
        KeyList keyList = screenFD_SL.getFileDescriptor().getKeys();
        int n = keyList.getSettingCount();
        this.dsKeyCmb.removeAll();
        for (int i = 0; i < n; ++i) {
            Key key = (Key)keyList.getSettingAt(i);
            String string = key.getName() != null && key.getName().length() > 0 ? key.getName() : key.getFieldNameList();
            this.dsKeyCmb.add(string);
        }
    }

    private void dsNameTxtModify() {
        if (this.dsTree.getSelectionCount() > 0) {
            DataSet dataSet = (DataSet)this.dsTree.getSelection()[0].getData();
            dataSet.setName(this.dsNameTxt.getText());
            this.makeDirty();
        }
    }

    protected void makeDirty() {
        if (!this.programSelection) {
            super.makeDirty();
        }
    }

    private void dsDataLayoutCmbSelchange() {
        int n = this.dsDataLayoutCmb.getSelectionIndex();
        if (n >= 0) {
            FDAttributes fDAttributes;
            String string = this.dsDataLayoutCmb.getItem(n);
            ScreenFD_SL screenFD_SL = PluginUtilities.getDataLayout((IFile)this.getDataLayoutFile(string));
            this.fillDsKeyCmb(screenFD_SL);
            DataSet dataSet = (DataSet)this.dsTree.getSelection()[0].getData();
            dataSet.setFDName(screenFD_SL.getFdName());
            boolean bl = screenFD_SL.getFileDescriptor().getFileFormat().getValue() == 5;
            this.fillDsTable(dataSet, bl);
            FileSection fileSection = this.getScreenProgram().getFileSection();
            if (this.lastDsDataLayoutSelection >= 0) {
                string = this.dsDataLayoutCmb.getItem(this.lastDsDataLayoutSelection);
                String string2 = PluginUtilities.getFDName((IFile)this.getDataLayoutFile(string));
                DataSet[] dataSetArray = fileSection.getDataSets();
                boolean bl2 = false;
                for (int i = 0; i < dataSetArray.length && !bl2; bl2 |= dataSetArray[i].getFDName() != null && dataSetArray[i].getFDName().equalsIgnoreCase(string2), ++i) {
                }
                if (!bl2 && (fDAttributes = fileSection.getFDAttributes(string2)) != null) {
                    fileSection.removeFDAttributes(fDAttributes);
                    this.removeFDAttrItem(fDAttributes);
                }
            }
            if ((fDAttributes = fileSection.getFDAttributes(screenFD_SL.getFdName())) == null) {
                fDAttributes = new FDAttributes(screenFD_SL.getFdName());
                if (screenFD_SL.getFileDescriptor().getFileFormat().isOpenIOAllowed()) {
                    if (screenFD_SL.getFileDescriptor().getAssignDevice().isOpenInputAllowed()) {
                        fDAttributes.setOpenMode(new OpenMode(3));
                    } else {
                        fDAttributes.setOpenMode(new OpenMode(1));
                    }
                } else if (screenFD_SL.getFileDescriptor().getAssignDevice().isOpenInputAllowed()) {
                    fDAttributes.setOpenMode(new OpenMode(0));
                } else {
                    fDAttributes.setOpenMode(new OpenMode(1));
                }
                if (screenFD_SL.getFileDescriptor().getAccessMode().getValue() == 2) {
                    fDAttributes.setWriteReadNext(false);
                    fDAttributes.setWriteReadPrevious(false);
                    this.setIOOperationEnabledStates(fDAttributes.isWriteOpen(), fDAttributes.getOpenMode().getValue(), screenFD_SL.getFileDescriptor().getFileFormat().getValue());
                }
                fileSection.addFDAttributes(fDAttributes);
                this.addFDAttrItem(fDAttributes, this.fdAttrTree.getItemCount());
            }
        } else {
            this.dsKeyCmb.removeAll();
            DataSet dataSet = (DataSet)this.dsTree.getSelection()[0].getData();
            dataSet.setFDName(null);
        }
        this.lastDsDataLayoutSelection = this.dsDataLayoutCmb.getSelectionIndex();
        this.makeDirty();
    }

    private void dsKeyCmbSelchange() {
        DataSet dataSet = (DataSet)this.dsTree.getSelection()[0].getData();
        dataSet.setKeyName(this.dsKeyCmb.getItem(this.dsKeyCmb.getSelectionIndex()));
        this.makeDirty();
    }

    void addListeners(ScrolledForm scrolledForm) {
        2 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.fdSec.addExpansionListener((IExpansionListener)var2_2);
        this.slSec.addExpansionListener((IExpansionListener)var2_2);
        this.fdImportBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fdLinkBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fdRemoveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.slImportBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.slLinkBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.slRemoveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.declImportBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.declLinkBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.declRemoveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dsTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dsNameTxtModifyL = new /* Unavailable Anonymous Inner Class!! */;
        this.dsNameTxt.addModifyListener(this.dsNameTxtModifyL);
        this.dsDataLayoutCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dsKeyCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dsEvtTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.referencedProcTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fdAttrTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.openModeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.openLockModeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.openExclusiveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrOpenBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrDeclarativesBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrReadBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrReadNextBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrReadPrevBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrDeleteBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrCloseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrCommitBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrRollbackBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrWriteBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrRewriteBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wrDeleteRecBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refDataSetsBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private FDAttributes getSelectedFDAttrs() {
        return this.fdAttrTree.getSelectionCount() > 0 ? (FDAttributes)this.fdAttrTree.getSelection()[0].getData() : null;
    }

    private void wrRollbackBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteRollback(this.wrRollbackBtn.getSelection());
            this.makeDirty();
        }
    }

    private void wrWriteBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteWrite(this.wrWriteBtn.getSelection());
            this.makeDirty();
        }
    }

    private void wrRewriteBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteRewrite(this.wrRewriteBtn.getSelection());
            this.makeDirty();
        }
    }

    private void wrDeleteRecBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteDeleteRecord(this.wrDeleteRecBtn.getSelection());
            this.makeDirty();
        }
    }

    private void refDataSetsBtnPushed() {
        if (this.dsTree.getSelectionCount() > 0) {
            DataSet dataSet = (DataSet)this.dsTree.getSelection()[0].getData();
            this.openReferencedDataSetDialog(dataSet, -1);
        }
    }

    private void openReferencedDataSetDialog(DataSet dataSet, int n) {
        if (dataSet.getFDName() == null) {
            return;
        }
        DataSet[] dataSetArray = new DataSet[this.dsTree.getItemCount()];
        ScreenFD_SL screenFD_SL = PluginUtilities.getDataLayout((IFile)this.getDataLayoutFile(dataSet.getFDName()));
        TreeItem[] treeItemArray = this.dsTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            dataSetArray[i] = (DataSet)treeItemArray[i].getData();
        }
        ReferencedDataSetsDialog referencedDataSetsDialog = new ReferencedDataSetsDialog(this.editor.getEditorSite().getShell(), dataSetArray, screenFD_SL, dataSet, n);
        RefDataSetInfo[] refDataSetInfoArray = referencedDataSetsDialog.openDialog();
        if (refDataSetInfoArray != null) {
            dataSet.setReferencedDataSets(refDataSetInfoArray);
            this.fillRefDataSetsTxt(dataSet);
            this.makeDirty();
        }
    }

    protected void wrCommitBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteCommit(this.wrCommitBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrCloseBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteClose(this.wrCloseBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrDeleteBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteDelete(this.wrDeleteBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrReadPrevBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteReadPrevious(this.wrReadPrevBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrReadNextBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteReadNext(this.wrReadNextBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrReadBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteRead(this.wrReadBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrDeclarativesBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteDeclaratives(this.wrDeclarativesBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void wrOpenBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setWriteOpen(this.wrOpenBtn.getSelection());
            int n = -1;
            IFile iFile = this.getDataLayoutFile(fDAttributes.getFDName());
            if (iFile != null) {
                ScreenFD_SL screenFD_SL = PluginUtilities.getDataLayout((IFile)iFile);
                n = screenFD_SL.getFileDescriptor().getFileFormat().getValue();
            }
            this.setIOOperationEnabledStates(this.wrOpenBtn.getSelection(), ((Integer)this.openModeCmb.getData(this.openModeCmb.getText())).intValue(), n);
            this.makeDirty();
        }
    }

    protected void openExclusiveBtnStatechange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setExclusive(this.openExclusiveBtn.getSelection());
            this.makeDirty();
        }
    }

    protected void openLockModeCmbSelchange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            fDAttributes.setOpenLockMode(new OpenLockMode(this.openLockModeCmb.getSelectionIndex()));
            this.makeDirty();
        }
    }

    protected void openModeCmbSelchange() {
        FDAttributes fDAttributes = this.getSelectedFDAttrs();
        if (fDAttributes != null) {
            String string = this.openModeCmb.getItem(this.openModeCmb.getSelectionIndex());
            OpenMode openMode = new OpenMode(((Integer)this.openModeCmb.getData(string)).intValue());
            fDAttributes.setOpenMode(openMode);
            int n = -1;
            IFile iFile = this.getDataLayoutFile(fDAttributes.getFDName());
            if (iFile != null) {
                ScreenFD_SL screenFD_SL = PluginUtilities.getDataLayout((IFile)iFile);
                n = screenFD_SL.getFileDescriptor().getFileFormat().getValue();
            }
            this.setIOOperationEnabledStates(this.wrOpenBtn.getSelection(), openMode.getValue(), n);
            this.makeDirty();
        }
    }

    private void handleEvtTableSelectionEvent(MouseEvent mouseEvent, Tree tree, Table table, TableEditor tableEditor) {
        Object object = tree.getSelection()[0].getData();
        int[] nArray = this.getItemForLocation(table, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        TableItem tableItem = table.getItem(nArray[0]);
        switch (nArray[1]) {
            case 0: {
                break;
            }
            case 1: {
                String string;
                String string2;
                if (object instanceof DataSet) {
                    string2 = ((DataSet)object).getName();
                    string = tableItem.getText(0);
                } else {
                    string2 = ((FDAttributes)object).getFDName();
                    switch (nArray[0]) {
                        default: {
                            string = "afterClose";
                            break;
                        }
                        case 1: {
                            string = "afterOpen";
                            break;
                        }
                        case 2: {
                            string = "beforeClose";
                            break;
                        }
                        case 3: {
                            string = "beforeOpen";
                        }
                    }
                }
                String string3 = string;
                String string4 = string2 = string2 + "-" + tableItem.getText(0).replace(' ', '-');
                ResourceRegistry resourceRegistry = this.getScreenProgram().getResourceRegistry();
                int n = 0;
                while (resourceRegistry.getParagraph(string4) != null) {
                    string4 = string2 + n;
                    ++n;
                }
                string2 = string4;
                ParagraphEditor paragraphEditor = new ParagraphEditor(null, string2);
                paragraphEditor.createEditor((Composite)table);
                paragraphEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
                tableEditor.setEditor(paragraphEditor.getEditor(), tableItem, 1);
                String string5 = this.getParagraphValue(object, string3);
                if (string5 != null) {
                    paragraphEditor.setValue((Object)new ParagraphType(string5));
                }
                paragraphEditor.selectAll();
                paragraphEditor.setFocus();
            }
        }
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void setParagraphValue(Object object, String string, String string2) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyDescriptorRegistry.getJPropertyDescriptor(object.getClass(), (String)string2);
            String string3 = (String)propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            if (string3 != null) {
                this.getScreenProgram().getResourceRegistry().unregisterParagraph(string3, object, string2);
            }
            PropertyDescriptorRegistry.setProperty((Object)object, (String)string2, (Object)string, null);
            propertyDescriptor.getWriteMethod().invoke(object, string);
            if (string != null) {
                this.getScreenProgram().getResourceRegistry().registerParagraph(string, object, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getParagraphValue(Object object, String string) {
        try {
            PropertyDescriptor propertyDescriptor = PropertyDescriptorRegistry.getJPropertyDescriptor(object.getClass(), (String)string);
            return (String)propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ void access$000(FileSectionPage fileSectionPage) {
        fileSectionPage.fdImportBtnClicked();
    }

    static /* synthetic */ void access$100(FileSectionPage fileSectionPage) {
        fileSectionPage.fdLinkBtnClicked();
    }

    static /* synthetic */ void access$200(FileSectionPage fileSectionPage) {
        fileSectionPage.fdRemoveBtnClicked();
    }

    static /* synthetic */ void access$300(FileSectionPage fileSectionPage) {
        fileSectionPage.slImportBtnClicked();
    }

    static /* synthetic */ void access$400(FileSectionPage fileSectionPage) {
        fileSectionPage.slLinkBtnClicked();
    }

    static /* synthetic */ void access$500(FileSectionPage fileSectionPage) {
        fileSectionPage.slRemoveBtnClicked();
    }

    static /* synthetic */ void access$600(FileSectionPage fileSectionPage) {
        fileSectionPage.declImportBtnClicked();
    }

    static /* synthetic */ void access$700(FileSectionPage fileSectionPage) {
        fileSectionPage.declLinkBtnClicked();
    }

    static /* synthetic */ void access$800(FileSectionPage fileSectionPage) {
        fileSectionPage.declRemoveBtnClicked();
    }

    static /* synthetic */ void access$900(FileSectionPage fileSectionPage) {
        fileSectionPage.dsTreeSelchange();
    }

    static /* synthetic */ void access$1000(FileSectionPage fileSectionPage) {
        fileSectionPage.dsNameTxtModify();
    }

    static /* synthetic */ void access$1100(FileSectionPage fileSectionPage) {
        fileSectionPage.dsDataLayoutCmbSelchange();
    }

    static /* synthetic */ void access$1200(FileSectionPage fileSectionPage) {
        fileSectionPage.dsKeyCmbSelchange();
    }

    static /* synthetic */ Tree access$1300(FileSectionPage fileSectionPage) {
        return fileSectionPage.dsTree;
    }

    static /* synthetic */ Table access$1400(FileSectionPage fileSectionPage) {
        return fileSectionPage.dsEvtTable;
    }

    static /* synthetic */ TableEditor access$1500(FileSectionPage fileSectionPage) {
        return fileSectionPage.dsEvtTableEditor;
    }

    static /* synthetic */ void access$1600(FileSectionPage fileSectionPage, MouseEvent mouseEvent, Tree tree, Table table, TableEditor tableEditor) {
        fileSectionPage.handleEvtTableSelectionEvent(mouseEvent, tree, table, tableEditor);
    }

    static /* synthetic */ Tree access$1700(FileSectionPage fileSectionPage) {
        return fileSectionPage.fdAttrTree;
    }

    static /* synthetic */ Table access$1800(FileSectionPage fileSectionPage) {
        return fileSectionPage.referencedProcTable;
    }

    static /* synthetic */ TableEditor access$1900(FileSectionPage fileSectionPage) {
        return fileSectionPage.referencedProcTableEditor;
    }

    static /* synthetic */ void access$2000(FileSectionPage fileSectionPage) {
        fileSectionPage.fdAttrTreeSelchange();
    }

    static /* synthetic */ void access$2100(FileSectionPage fileSectionPage) {
        fileSectionPage.wrRollbackBtnStatechange();
    }

    static /* synthetic */ void access$2200(FileSectionPage fileSectionPage) {
        fileSectionPage.wrWriteBtnStatechange();
    }

    static /* synthetic */ void access$2300(FileSectionPage fileSectionPage) {
        fileSectionPage.wrRewriteBtnStatechange();
    }

    static /* synthetic */ void access$2400(FileSectionPage fileSectionPage) {
        fileSectionPage.wrDeleteRecBtnStatechange();
    }

    static /* synthetic */ void access$2500(FileSectionPage fileSectionPage) {
        fileSectionPage.refDataSetsBtnPushed();
    }

    static /* synthetic */ void access$2600(FileSectionPage fileSectionPage, Object object, String string, String string2) {
        fileSectionPage.setParagraphValue(object, string, string2);
    }
}

