/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.plugins.editor.util.PreferenceConverter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.propertysheet.UIFontManager;
import com.iscobol.screenpainter.util.ColorProvider;
import com.iscobol.screenpainter.util.FontProvider;
import com.iscobol.screenpainter.util.ImageProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class IscobolScreenPainterPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.iscobol.plugins.screenpainter.IscobolScreenPainter";
    public static final String SCREEN_PROGRAM_EXT = "isp";
    public static final String FD_SL_EXT = "idl";
    public static final String SCREEN_SECTION_EXT = "isl";
    public static final String REPORT_EXT = "irl";
    public static final String[] DEF_FILES = new String[]{"isgui.def", "iscobol.def", "iscrt.def", "isfonts.def", "ismsg.def", "isresize.def"};
    private static final Map<String, String> is2AcuDef = new HashMap();
    private static final int SP_CACHE_MAX_SIZE = 10;
    private static final int DL_CACHE_MAX_SIZE = 100;
    private static IscobolScreenPainterPlugin singleton;
    private ColorProvider cProvider;
    private FontProvider fProvider;
    private ImageProvider iProvider;
    private Vector<IPropertyChangeListener> pcListeners = new Vector();
    private List<ScreenProgram> cachedScreenPrograms = new ArrayList();
    private List<ScreenFD_SL> cachedDataLayouts = new ArrayList();
    private MyResourceChangeListener reschangelist;

    private int indexOfCachedScreenProgram(IFile iFile) {
        int n = 0;
        for (ScreenProgram screenProgram : this.cachedScreenPrograms) {
            IFile iFile2 = screenProgram.getFile();
            if (iFile2 != null && iFile2.equals(iFile)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int indexOfCachedDataLayout(IFile iFile) {
        int n = 0;
        for (ScreenFD_SL screenFD_SL : this.cachedDataLayouts) {
            IFile iFile2 = screenFD_SL.getFile();
            if (iFile2 != null && iFile2.equals(iFile)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ScreenProgram getCachedScreenProgram(IFile iFile) {
        ScreenRoot screenRoot = this.getCachedScreenRoot(iFile, this.cachedScreenPrograms);
        if (screenRoot != null) {
            return (ScreenProgram)screenRoot;
        }
        ScreenProgram screenProgram = new ScreenProgram(iFile);
        if (this.cachedScreenPrograms.size() == 10) {
            this.cachedScreenPrograms.remove(0);
        }
        this.cachedScreenPrograms.add(screenProgram);
        return screenProgram;
    }

    public void removeCachedScreenFD_SL(IFile iFile) {
        int n = this.indexOfCachedDataLayout(iFile);
        if (n >= 0) {
            this.cachedDataLayouts.remove(n);
        }
    }

    public void removeCachedScreenProgram(IFile iFile) {
        int n = this.indexOfCachedScreenProgram(iFile);
        if (n >= 0) {
            this.cachedScreenPrograms.remove(n);
        }
    }

    public ScreenFD_SL getCachedScreenFD_SL(IFile iFile) {
        ScreenRoot screenRoot = this.getCachedScreenRoot(iFile, this.cachedDataLayouts);
        if (screenRoot != null) {
            return (ScreenFD_SL)screenRoot;
        }
        ScreenFD_SL screenFD_SL = new ScreenFD_SL(iFile);
        if (this.cachedDataLayouts.size() == 100) {
            this.cachedDataLayouts.remove(0);
        }
        this.cachedDataLayouts.add(screenFD_SL);
        return screenFD_SL;
    }

    private ScreenRoot getCachedScreenRoot(IFile iFile, List<? extends ScreenRoot> list) {
        ScreenRoot screenRoot = null;
        for (ScreenRoot screenRoot2 : list) {
            IFile iFile2 = screenRoot2.getFile();
            if (iFile2 == null || !iFile2.equals(iFile)) continue;
            screenRoot = screenRoot2;
        }
        return screenRoot;
    }

    public static IscobolScreenPainterPlugin getDefault() {
        return singleton;
    }

    public IscobolScreenPainterPlugin() {
        this.cProvider = new ColorProvider();
        this.fProvider = new FontProvider();
        this.iProvider = new ImageProvider();
        singleton = this;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.pcListeners.addElement(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.pcListeners.removeElement(iPropertyChangeListener);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        int n = this.pcListeners.size();
        for (int i = 0; i < n; ++i) {
            ((IPropertyChangeListener)this.pcListeners.elementAt(i)).propertyChange(propertyChangeEvent);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.cProvider != null) {
            this.cProvider.dispose();
        }
        if (this.fProvider != null) {
            this.fProvider.dispose();
        }
        if (this.iProvider != null) {
            this.iProvider.dispose();
        }
        try {
            if (UIFontManager.getInstance() != null) {
                UIFontManager.getInstance().save();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stop(bundleContext);
    }

    public ColorProvider getColorProvider() {
        return this.cProvider;
    }

    public FontProvider getFontProvider() {
        return this.fProvider;
    }

    public ImageProvider getImageProvider() {
        return this.iProvider;
    }

    public static Color getColorFromStore(String string) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), (String)string);
        return IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(rGB);
    }

    public static boolean getBooleanFromStore(String string) {
        IPreferenceStore iPreferenceStore = IscobolScreenPainterPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getBoolean(string);
        }
        return iPreferenceStore.getDefaultBoolean(string);
    }

    public static int getIntFromStore(String string) {
        IPreferenceStore iPreferenceStore = IscobolScreenPainterPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getInt(string);
        }
        return iPreferenceStore.getDefaultInt(string);
    }

    public static String getStringFromStore(String string) {
        IPreferenceStore iPreferenceStore = IscobolScreenPainterPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getString(string);
        }
        return iPreferenceStore.getDefaultString(string);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.reschangelist = new MyResourceChangeListener(this, null);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.reschangelist, 8);
    }

    public static String getAcuCopyName(String string) {
        return (String)is2AcuDef.get(string);
    }

    static /* synthetic */ int access$000(IscobolScreenPainterPlugin iscobolScreenPainterPlugin, IFile iFile) {
        return iscobolScreenPainterPlugin.indexOfCachedScreenProgram(iFile);
    }

    static /* synthetic */ List access$100(IscobolScreenPainterPlugin iscobolScreenPainterPlugin) {
        return iscobolScreenPainterPlugin.cachedScreenPrograms;
    }

    static /* synthetic */ int access$200(IscobolScreenPainterPlugin iscobolScreenPainterPlugin, IFile iFile) {
        return iscobolScreenPainterPlugin.indexOfCachedDataLayout(iFile);
    }

    static /* synthetic */ List access$300(IscobolScreenPainterPlugin iscobolScreenPainterPlugin) {
        return iscobolScreenPainterPlugin.cachedDataLayouts;
    }

    static {
        is2AcuDef.put("iscobol.def", "acucobol.def");
        is2AcuDef.put("isgui.def", "acugui.def");
        is2AcuDef.put("iscontrols.def", "controls.def");
        is2AcuDef.put("iscrt.def", "crtvars.def");
        is2AcuDef.put("isfonts.def", "fonts.def");
        is2AcuDef.put("isresize.def", "lmresize.def");
        is2AcuDef.put("ispalette.def", "palette.def");
        is2AcuDef.put("ismsg.def", "showmsg.def");
        is2AcuDef.put("ismsg.cpy", "showmsg.cpy");
    }
}

