/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.plugins.editor.IscobolOutlinePage;
import com.iscobol.reportdesigner.ReportEditor;
import com.iscobol.reportdesigner.ReportOutlinePage;
import com.iscobol.screenpainter.ScreenOutlinePage;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenSectionEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ScreenProgramContentOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider {
    private Composite control;
    private StackLayout stackLayout;
    private ScreenProgramEditor mpEditor;
    private Vector<ScreenOutlinePage> screenOutlines = new Vector();
    private Vector<ReportOutlinePage> reportOutlines = new Vector();
    private Vector<ISelectionChangedListener> selchangeListeners = new Vector();
    private Hashtable outlineControls = new Hashtable();
    private IscobolOutlinePage eventOutline;
    private Control genericControl;

    public ScreenProgramContentOutline(ScreenProgramEditor screenProgramEditor) {
        this.mpEditor = screenProgramEditor;
        ScreenSectionEditor[] screenSectionEditorArray = this.mpEditor.getScreenSectionEditors();
        for (int i = 0; i < screenSectionEditorArray.length; ++i) {
            ScreenOutlinePage screenOutlinePage = (ScreenOutlinePage)screenSectionEditorArray[i].getOutlinePage();
            this.screenOutlines.addElement(screenOutlinePage);
        }
        ReportEditor[] reportEditorArray = this.mpEditor.getReportEditors();
        for (int i = 0; i < reportEditorArray.length; ++i) {
            ReportOutlinePage reportOutlinePage = (ReportOutlinePage)reportEditorArray[i].getOutlinePage();
            this.reportOutlines.addElement(reportOutlinePage);
        }
        this.eventOutline = (IscobolOutlinePage)this.mpEditor.getEventParagraphsEditor().getOutlinePage();
    }

    void removeScreenOutline(int n) {
        if (this.control != null) {
            IContentOutlinePage iContentOutlinePage = (IContentOutlinePage)this.screenOutlines.elementAt(n);
            this.screenOutlines.removeElementAt(n);
            iContentOutlinePage.dispose();
            Composite composite = (Composite)this.outlineControls.get(iContentOutlinePage);
            if (composite != null) {
                composite.dispose();
                this.outlineControls.remove(iContentOutlinePage);
                this.control.layout();
            }
        }
    }

    void addScreenOutline(int n, ScreenOutlinePage screenOutlinePage) {
        if (this.control != null) {
            this.screenOutlines.add(n, screenOutlinePage);
            Composite composite = new Composite(this.control, 0);
            composite.setLayout((Layout)new FillLayout());
            this.outlineControls.put(screenOutlinePage, composite);
            screenOutlinePage.init(this.getSite());
            screenOutlinePage.createControl(composite);
            Enumeration enumeration = this.selchangeListeners.elements();
            while (enumeration.hasMoreElements()) {
                screenOutlinePage.addSelectionChangedListener((ISelectionChangedListener)enumeration.nextElement());
            }
        }
    }

    void removeReportOutline(int n) {
        if (this.control != null) {
            IContentOutlinePage iContentOutlinePage = (IContentOutlinePage)this.reportOutlines.elementAt(n);
            this.reportOutlines.removeElementAt(n);
            iContentOutlinePage.dispose();
            Composite composite = (Composite)this.outlineControls.get(iContentOutlinePage);
            if (composite != null) {
                composite.dispose();
                this.outlineControls.remove(iContentOutlinePage);
                this.control.layout();
            }
        }
    }

    void addReportOutline(int n, ReportOutlinePage reportOutlinePage) {
        if (this.control != null) {
            this.reportOutlines.add(n, reportOutlinePage);
            Composite composite = new Composite(this.control, 0);
            composite.setLayout((Layout)new FillLayout());
            this.outlineControls.put(reportOutlinePage, composite);
            reportOutlinePage.init(this.getSite());
            reportOutlinePage.createControl(composite);
            Enumeration enumeration = this.selchangeListeners.elements();
            while (enumeration.hasMoreElements()) {
                reportOutlinePage.addSelectionChangedListener((ISelectionChangedListener)enumeration.nextElement());
            }
        }
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        for (ScreenOutlinePage screenOutlinePage : this.screenOutlines) {
            screenOutlinePage.init(iPageSite);
        }
        for (ScreenOutlinePage screenOutlinePage : this.reportOutlines) {
            screenOutlinePage.init(iPageSite);
        }
        if (this.eventOutline != null) {
            this.eventOutline.init(iPageSite);
        }
        iPageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite composite) {
        Composite composite2;
        this.control = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.control.setLayout((Layout)this.stackLayout);
        Label label = new Label(this.control, 0);
        label.setText("Content Outline not available");
        this.genericControl = label;
        for (ScreenOutlinePage screenOutlinePage : this.screenOutlines) {
            composite2 = this.getControlForOutline((IContentOutlinePage)screenOutlinePage);
            screenOutlinePage.createControl(composite2);
        }
        for (ScreenOutlinePage screenOutlinePage : this.reportOutlines) {
            composite2 = this.getControlForOutline((IContentOutlinePage)screenOutlinePage);
            screenOutlinePage.createControl(composite2);
        }
        if (this.eventOutline != null) {
            Composite composite3 = this.getControlForOutline((IContentOutlinePage)this.eventOutline);
            this.eventOutline.createControl(composite3);
        }
        if (this.screenOutlines.size() > 0) {
            this.stackLayout.topControl = (Composite)this.outlineControls.get(this.screenOutlines.elementAt(0));
        } else if (this.reportOutlines.size() > 0) {
            this.stackLayout.topControl = (Composite)this.outlineControls.get(this.reportOutlines.elementAt(0));
        } else if (this.eventOutline != null) {
            this.stackLayout.topControl = (Composite)this.outlineControls.get(this.eventOutline);
        }
    }

    private Composite getControlForOutline(IContentOutlinePage iContentOutlinePage) {
        Composite composite = (Composite)this.outlineControls.get(iContentOutlinePage);
        if (composite == null) {
            composite = new Composite(this.control, 0);
            composite.setLayout((Layout)new FillLayout());
            this.outlineControls.put(iContentOutlinePage, composite);
        }
        return composite;
    }

    public void dispose() {
        for (ScreenOutlinePage screenOutlinePage : this.screenOutlines) {
            screenOutlinePage.dispose();
        }
        for (ScreenOutlinePage screenOutlinePage : this.reportOutlines) {
            screenOutlinePage.dispose();
        }
        if (this.eventOutline != null) {
            this.eventOutline.dispose();
        }
        super.dispose();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            Composite composite = this.getControlForOutline(iContentOutlinePage);
            this.stackLayout.topControl = composite;
            this.control.layout();
            iContentOutlinePage.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selchangeListeners.addElement(iSelectionChangedListener);
        for (ScreenOutlinePage screenOutlinePage : this.screenOutlines) {
            screenOutlinePage.addSelectionChangedListener(iSelectionChangedListener);
        }
        for (ScreenOutlinePage screenOutlinePage : this.reportOutlines) {
            screenOutlinePage.addSelectionChangedListener(iSelectionChangedListener);
        }
        if (this.eventOutline != null) {
            this.eventOutline.addSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selchangeListeners.removeElement(iSelectionChangedListener);
        for (ScreenOutlinePage screenOutlinePage : this.screenOutlines) {
            screenOutlinePage.removeSelectionChangedListener(iSelectionChangedListener);
        }
        for (ScreenOutlinePage screenOutlinePage : this.reportOutlines) {
            screenOutlinePage.removeSelectionChangedListener(iSelectionChangedListener);
        }
        if (this.eventOutline != null) {
            this.eventOutline.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            return iContentOutlinePage.getSelection();
        }
        return new StructuredSelection();
    }

    public IContentOutlinePage getActiveOutline() {
        int n = this.mpEditor.getActivePageIndex();
        if (n >= 0) {
            if (n == this.mpEditor.getEventParagraphsEditorIndex()) {
                return this.eventOutline;
            }
            if (n == this.mpEditor.getWorkingStoragePageIndex()) {
                return null;
            }
            if (n == this.mpEditor.getLinkageSectionPageIndex()) {
                return null;
            }
            if (n == this.mpEditor.getFileSectionPageIndex()) {
                return null;
            }
            if (n < this.screenOutlines.size()) {
                return (IContentOutlinePage)this.screenOutlines.elementAt(n);
            }
            if (n < this.screenOutlines.size() + this.reportOutlines.size()) {
                return (IContentOutlinePage)this.reportOutlines.elementAt(n - this.screenOutlines.size());
            }
        }
        return null;
    }

    public void setSelection(ISelection iSelection) {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            iContentOutlinePage.setSelection(iSelection);
        }
    }

    public void refresh() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            Composite composite = this.getControlForOutline(iContentOutlinePage);
            this.stackLayout.topControl = composite;
            this.control.layout();
            if (this.getSite() != null) {
                IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
                if (this.mpEditor.getActivePageIndex() == this.mpEditor.getPageCount() - 1) {
                    this.eventOutline.addSortAction(iToolBarManager);
                } else {
                    this.eventOutline.removeSortAction(iToolBarManager);
                }
                iToolBarManager.update(true);
            }
        } else {
            this.stackLayout.topControl = this.genericControl;
            this.control.layout();
        }
    }
}

