/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolProjectionViewer;
import com.iscobol.plugins.editor.IscobolReconcilingStrategy;
import com.iscobol.plugins.editor.annotations.BreakpointAnnotation;
import com.iscobol.plugins.editor.lafs.LookAndFeelManager;
import com.iscobol.plugins.editor.util.UpdateOperation;
import com.iscobol.reportdesigner.ReportEditor;
import com.iscobol.reportdesigner.ReportEditorInput;
import com.iscobol.reportdesigner.ReportOutlinePage;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.screenpainter.BaseGraphicalEditor;
import com.iscobol.screenpainter.DataDefinitionPage;
import com.iscobol.screenpainter.DataPool;
import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.FileSectionPage;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenOutlinePage;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramContentOutline;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.ScreenSectionEditor;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.propertysheet.VariableSettingsContentPane;
import com.iscobol.screenpainter.propertysheet.pages.TabbedPropertySheetPage;
import com.iscobol.screenpainter.util.ImageProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.editorinputs.EventParagraphsEditorInput;
import com.iscobol.screenpainter.util.editorinputs.ScreenSectionEditorInput;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ScreenProgramEditor
extends FormEditor
implements IResourceChangeListener,
IPropertyChangeListener,
IGotoMarker {
    public static final String ID = "iscobolscreenpainter.MultipageScreenSectionEditor";
    private IStorageEditorInput storageInput;
    private ScreenProgram screenProgram;
    DataDefinitionPage workingPage;
    DataDefinitionPage linkagePage;
    FileSectionPage fileSectionPage;
    private Vector<ScreenSectionEditor> ssEditor = new Vector();
    private Vector<ScreenSectionEditorInput> ssInput = new Vector();
    private Vector<ReportEditorInput> rptInput = new Vector();
    private Vector<ReportEditor> rptEditor = new Vector();
    private EventParagraphsEditorInput epInput;
    private EventParagraphsEditor epEditor;
    private BaseGraphicalEditor lastActiveGraphicalEditor;
    private ScreenProgramContentOutline outline;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private boolean dirty;
    private boolean resourceListenerEnabled = true;
    private int linkedCopyReloadedIndex = -1;
    private List<UpdateOperation> updateOperations = new ArrayList();

    public ScreenProgramEditor() {
        this.addListeners();
    }

    int getEventParagraphsEditorIndex() {
        return this.getPageCount() - 1;
    }

    int getWorkingStoragePageIndex() {
        return this.getPageCount() - 4;
    }

    int getLinkageSectionPageIndex() {
        return this.getPageCount() - 3;
    }

    int getFileSectionPageIndex() {
        return this.getPageCount() - 2;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (!this.resourceListenerEnabled) {
            return;
        }
        IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(iFile.getFullPath());
        if (iResourceDelta != null) {
            switch (iResourceDelta.getKind()) {
                case 2: {
                    this.closeEditor();
                    break;
                }
                case 4: {
                    if ((iResourceDelta.getFlags() & 0x100) != 256 && (iResourceDelta.getFlags() & 0x800) != 2048) break;
                    this.closeEditor();
                }
            }
            if (iResourceDelta.getKind() == 2) {
                this.closeEditor();
            }
        } else if (this.fileSectionPage != null && this.fileSectionPage.getContentPane() != null) {
            this.fileSectionPage.resourceChanged(iResourceChangeEvent);
        }
    }

    private void closeEditor() {
        this.closeEditor(false);
    }

    public void closeEditor(boolean bl) {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        Display.getDefault().asyncExec((Runnable)var2_2);
    }

    public void activateEventParagraphsEditor() {
        this.setActivePage(this.getEventParagraphsEditorIndex());
        this.pageChange(this.getEventParagraphsEditorIndex());
    }

    public void activateWorkingStoragePage() {
        this.setActivePage(this.getWorkingStoragePageIndex());
        this.pageChange(this.getWorkingStoragePageIndex());
    }

    public void activateLinkageSectionPage() {
        this.setActivePage(this.getLinkageSectionPageIndex());
        this.pageChange(this.getLinkageSectionPageIndex());
    }

    public void activateFileSectionPage() {
        this.activateFileSectionPage(null);
    }

    public void activateFileSectionPage(DataSet dataSet) {
        this.setActivePage(this.getFileSectionPageIndex());
        this.pageChange(this.getFileSectionPageIndex());
        if (dataSet != null && this.fileSectionPage.getContentPane() != null) {
            this.fileSectionPage.select(dataSet);
        }
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }

    private void addListeners() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        IscobolScreenPainterPlugin.getDefault().addPropertyChangeListener((IPropertyChangeListener)this);
        LookAndFeelManager.getInstance().addPropertyChangeListener((IPropertyChangeListener)this);
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void removeListeners() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        IscobolScreenPainterPlugin.getDefault().removePropertyChangeListener((IPropertyChangeListener)this);
        LookAndFeelManager.getInstance().removePropertyChangeListener((IPropertyChangeListener)this);
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    public void setPageText(int n, String string) {
        super.setPageText(n, string);
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.storageInput instanceof IFileEditorInput && (this.dirty || super.isDirty());
    }

    protected void addPages() {
        try {
            ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
            int n = 0;
            int n2 = 0;
            while (n2 < this.ssInput.size()) {
                this.addPage((IEditorPart)this.ssEditor.elementAt(n2), (IEditorInput)this.ssInput.elementAt(n2));
                this.setPageText(n, ((ScreenSectionEditorInput)this.ssInput.elementAt(n2)).getName());
                this.setPageImage(n, imageProvider.getImage("/screen.png"));
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < this.rptInput.size()) {
                this.addPage((IEditorPart)this.rptEditor.elementAt(n2), (IEditorInput)this.rptInput.elementAt(n2));
                this.setPageText(n, ((ReportEditorInput)this.rptInput.elementAt(n2)).getName());
                this.setPageImage(n, imageProvider.getImage("/report.png"));
                ++n2;
                ++n;
            }
            this.workingPage = new DataDefinitionPage(this, "Working Storage", imageProvider.getImage("/workingstorage.png"), 1);
            this.addPage((IFormPage)this.workingPage);
            this.linkagePage = new DataDefinitionPage(this, "Linkage Section", imageProvider.getImage("/linkagesection.png"), 2);
            this.addPage((IFormPage)this.linkagePage);
            this.fileSectionPage = new FileSectionPage(this);
            this.addPage((IFormPage)this.fileSectionPage);
            this.addPage((IEditorPart)this.epEditor, (IEditorInput)this.epInput);
            this.setPageText(this.getEventParagraphsEditorIndex(), this.getScreenProgram().isAGenericCobolProgram() ? "Procedure" : ISPBundle.getString((String)"event_paragraphs_lbl"));
            this.setPageImage(this.getEventParagraphsEditorIndex(), imageProvider.getImage("/paragrapheditor.png"));
            this.setPageImage(this.getWorkingStoragePageIndex(), imageProvider.getImage("/workingstorage.png"));
            this.setPageImage(this.getLinkageSectionPageIndex(), imageProvider.getImage("/linkagesection.png"));
            this.setPageImage(this.getFileSectionPageIndex(), imageProvider.getImage("/filesection.gif"));
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public void addDataSet(DataSet dataSet) {
        this.addDataSet(-1, dataSet);
    }

    public void addDataSet(int n, DataSet dataSet) {
        if (this.fileSectionPage.getContentPane() != null) {
            this.fileSectionPage.addDataSet(n, dataSet);
        }
    }

    public void removeDataSet(DataSet dataSet) {
        if (this.fileSectionPage.getContentPane() != null) {
            this.fileSectionPage.removeDataSet(dataSet);
        }
    }

    public void addScreenSection(AbstractBeanWindow abstractBeanWindow) {
        this.addScreenSection(-1, abstractBeanWindow);
    }

    public void addScreenSection(int n, AbstractBeanWindow abstractBeanWindow) {
        ScreenSectionEditorInput screenSectionEditorInput = new ScreenSectionEditorInput(abstractBeanWindow, this.screenProgram);
        if (n >= 0 && n < this.ssInput.size()) {
            this.ssInput.add(n, screenSectionEditorInput);
        } else {
            this.ssInput.addElement(screenSectionEditorInput);
        }
        ScreenSectionEditor screenSectionEditor = this.createScreenSectionEditor();
        if (n >= 0 && n < this.ssEditor.size()) {
            this.ssEditor.add(n, screenSectionEditor);
        } else {
            this.ssEditor.addElement(screenSectionEditor);
        }
        screenSectionEditor.setSite(this.getSite());
        screenSectionEditor.setInput((IEditorInput)screenSectionEditorInput);
        try {
            screenSectionEditor.init(this.getEditorSite(), (IEditorInput)screenSectionEditorInput);
            int n2 = this.ssEditor.size() - 1;
            if (n < 0 || n > n2) {
                n = n2;
            }
            this.addPage(n, (IEditorPart)screenSectionEditor, (IEditorInput)screenSectionEditorInput);
            this.getOutlinePage().addScreenOutline(n, (ScreenOutlinePage)screenSectionEditor.getOutlinePage());
            this.setPageText(n, abstractBeanWindow.getName());
            this.setPageImage(n, IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/screen.png"));
            this.setActivePage(n);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public int indexOfScreenSection(String string) {
        for (int i = 0; i < this.ssInput.size(); ++i) {
            AbstractBeanWindow abstractBeanWindow = ((ScreenSectionEditorInput)this.ssInput.elementAt(i)).getWindow();
            if (!abstractBeanWindow.getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public void setCurrentScreenSection(String string) {
        int n = this.indexOfScreenSection(string);
        if (n >= 0) {
            this.setActivePage(n);
        }
    }

    public void removeScreenSection(String string) {
        int n = this.indexOfScreenSection(string);
        if (n >= 0) {
            this.ssEditor.removeElementAt(n);
            this.ssInput.removeElementAt(n);
            this.getOutlinePage().removeScreenOutline(n);
            this.removePage(n);
        }
    }

    private ScreenSectionEditor createScreenSectionEditor() {
        return new ScreenSectionEditor(this);
    }

    public void addReport(Report report) {
        this.addReport(-1, report);
    }

    public void addReport(int n, Report report) {
        ReportEditorInput reportEditorInput = new ReportEditorInput(report, this.screenProgram);
        if (n >= 0 && n < this.rptInput.size()) {
            this.rptInput.add(n, reportEditorInput);
        } else {
            this.rptInput.addElement(reportEditorInput);
        }
        ReportEditor reportEditor = this.createReportEditor();
        if (n >= 0 && n < this.rptEditor.size()) {
            this.rptEditor.add(n, reportEditor);
        } else {
            this.rptEditor.addElement(reportEditor);
        }
        reportEditor.setSite(this.getSite());
        reportEditor.setInput((IEditorInput)reportEditorInput);
        try {
            reportEditor.init(this.getEditorSite(), (IEditorInput)reportEditorInput);
            int n2 = this.rptEditor.size() - 1;
            if (n < 0 || n > n2) {
                n = n2;
            }
            int n3 = n + this.ssEditor.size();
            this.addPage(n3, (IEditorPart)reportEditor, (IEditorInput)reportEditorInput);
            this.getOutlinePage().addReportOutline(n, (ReportOutlinePage)reportEditor.getOutlinePage());
            this.setPageText(n3, report.getName());
            this.setPageImage(n3, IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/report.png"));
            this.setActivePage(n3);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public int indexOfReport(String string) {
        for (int i = 0; i < this.rptInput.size(); ++i) {
            Report report = ((ReportEditorInput)this.rptInput.elementAt(i)).getReport();
            if (!report.getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public void setCurrentReport(String string) {
        int n = this.indexOfReport(string);
        if (n >= 0) {
            this.setActivePage(this.ssInput.size() + n);
        }
    }

    public void removeReport(String string) {
        int n = this.indexOfReport(string);
        if (n >= 0) {
            this.rptEditor.removeElementAt(n);
            this.rptInput.removeElementAt(n);
            this.getOutlinePage().removeReportOutline(n);
            this.removePage(this.ssEditor.size() + n);
        }
    }

    private ReportEditor createReportEditor() {
        return new ReportEditor(this);
    }

    public ScreenProgram getScreenProgram() {
        return this.screenProgram;
    }

    protected void setInput(IEditorInput iEditorInput) {
        ScreenSectionEditor screenSectionEditor;
        InputStream inputStream;
        AbstractBeanWindow[] abstractBeanWindowArray;
        super.setInput(iEditorInput);
        this.storageInput = (IStorageEditorInput)iEditorInput;
        IFile iFile = null;
        if (this.storageInput instanceof IFileEditorInput) {
            iFile = ((IFileEditorInput)this.storageInput).getFile();
            this.screenProgram = new ScreenProgram(iFile);
        } else {
            try {
                abstractBeanWindowArray = System.getProperty("java.io.tmpdir", ".");
                File file = new File((String)abstractBeanWindowArray + File.separator + iEditorInput.getName());
                inputStream = this.storageInput.getStorage().getContents();
                this.screenProgram = new ScreenProgram(file);
                this.screenProgram.load(inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.removeListeners();
        }
        if (!PluginUtilities.checkRelease((ScreenRoot)this.screenProgram, (Shell)this.getSite().getShell())) {
            this.closeEditor();
        }
        this.setPartName(iEditorInput.getName());
        abstractBeanWindowArray = this.screenProgram.getScreenSections();
        this.ssInput = new Vector();
        this.ssEditor = new Vector();
        for (int i = 0; i < abstractBeanWindowArray.length; ++i) {
            inputStream = new ScreenSectionEditorInput(abstractBeanWindowArray[i], this.screenProgram);
            this.ssInput.addElement(inputStream);
            screenSectionEditor = this.createScreenSectionEditor();
            this.ssEditor.addElement(screenSectionEditor);
            screenSectionEditor.setSite(this.getSite());
            screenSectionEditor.setInput((IEditorInput)inputStream);
        }
        Report[] reportArray = this.screenProgram.getReports();
        this.rptInput = new Vector();
        this.rptEditor = new Vector();
        for (int i = 0; i < reportArray.length; ++i) {
            screenSectionEditor = new ReportEditorInput(reportArray[i], this.screenProgram);
            this.rptInput.addElement(screenSectionEditor);
            ReportEditor reportEditor = this.createReportEditor();
            this.rptEditor.addElement(reportEditor);
            reportEditor.setSite(this.getSite());
            reportEditor.setInput((IEditorInput)screenSectionEditor);
        }
        try {
            this.epInput = new EventParagraphsEditorInput(this.screenProgram.getEventParagraphs(), iFile, this.storageInput.getName(), !this.screenProgram.isAGenericCobolProgram());
            this.epEditor = this.createEventParagraphsEditor();
            this.epEditor.setSite(this.getSite());
            this.epEditor.setInput((IEditorInput)this.epInput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = this.screenProgram.getProgramName();
        this.setPartName(string);
        if (IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscoboldd.reloadlinkedcopies") && this.storageInput instanceof IFileEditorInput) {
            this.screenProgram.getResourceRegistry().getVariableTypeList().reloadAllLinkedCopies(this.screenProgram.getProject());
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.screenProgram.save();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public EventParagraphsEditor getEventParagraphsEditor() {
        return this.epEditor;
    }

    public ScreenSectionEditor[] getScreenSectionEditors() {
        return this.ssEditor.toArray(new ScreenSectionEditor[this.ssEditor.size()]);
    }

    public int getScreenSectionEditorCount() {
        return this.ssEditor.size();
    }

    public ReportEditor[] getReportEditors() {
        return this.rptEditor.toArray(new ReportEditor[this.rptEditor.size()]);
    }

    public int getReportEditorCount() {
        return this.rptEditor.size();
    }

    private void intUpdateUI(IProgressMonitor iProgressMonitor) {
        ScreenSectionEditor[] screenSectionEditorArray = this.getScreenSectionEditors();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Updating UI...", screenSectionEditorArray.length);
        }
        for (int i = 0; i < screenSectionEditorArray.length; ++i) {
            WindowModel windowModel = screenSectionEditorArray[i].getWindowModel();
            if (iProgressMonitor != null) {
                iProgressMonitor.subTask("Updating " + windowModel.getName() + "...");
            }
            windowModel.updateUI();
            if (iProgressMonitor == null) continue;
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void intUpdateControlDecorations(String string) {
        WindowModel windowModel;
        for (ScreenSectionEditor screenSectionEditor : this.getScreenSectionEditors()) {
            windowModel = screenSectionEditor.getWindowModel();
            windowModel.updateControlDecorations(string);
        }
        if ("iscobolrd.showlockedicon".equals(string)) {
            for (ScreenSectionEditor screenSectionEditor : this.getReportEditors()) {
                windowModel = screenSectionEditor.getReportModel();
                windowModel.updateControlDecorations(string);
            }
        }
    }

    public void updateUI(boolean bl, IProgressMonitor iProgressMonitor) {
        2 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        UpdateOperation updateOperation = new UpdateOperation((IRunnableWithProgress)var3_3, this.getEditorSite().getShell(), iProgressMonitor);
        this.executeUpdateOperation(bl, updateOperation);
    }

    public void updateControlDecorations(boolean bl, String string) {
        3 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        UpdateOperation updateOperation = new UpdateOperation((IRunnableWithProgress)var3_3, this.getEditorSite().getShell(), null);
        this.executeUpdateOperation(bl, updateOperation);
    }

    public void updateScreenSections(boolean bl, IProgressMonitor iProgressMonitor) {
        4 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        UpdateOperation updateOperation = new UpdateOperation((IRunnableWithProgress)var3_3, this.getEditorSite().getShell(), iProgressMonitor);
        this.executeUpdateOperation(bl, updateOperation);
    }

    private void intUpdateScreenSections(IProgressMonitor iProgressMonitor) {
        ScreenSectionEditor[] screenSectionEditorArray = this.getScreenSectionEditors();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Updating Screen...", screenSectionEditorArray.length);
        }
        for (int i = 0; i < screenSectionEditorArray.length; ++i) {
            WindowModel windowModel = screenSectionEditorArray[i].getWindowModel();
            if (iProgressMonitor != null) {
                iProgressMonitor.subTask("Updating " + windowModel.getName() + "...");
            }
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            if (iProgressMonitor == null) continue;
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void executeUpdateOperation(boolean bl, UpdateOperation updateOperation) {
        if (bl) {
            updateOperation.execute();
        } else {
            updateOperation.setDeferred();
            this.updateOperations.add(updateOperation);
        }
    }

    public void setFocus() {
        super.setFocus();
        while (!this.updateOperations.isEmpty()) {
            ((UpdateOperation)this.updateOperations.remove(0)).execute();
        }
    }

    private EventParagraphsEditor createEventParagraphsEditor() {
        return new EventParagraphsEditor((FormEditor)this);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ScreenSectionEditor screenSectionEditor2;
        IscobolProjectionViewer iscobolProjectionViewer;
        if (!(this.storageInput instanceof IFileEditorInput)) {
            return;
        }
        this.dirty = false;
        if (this.workingPage != null && this.workingPage.getContentPane() != null) {
            this.workingPage.cleanDirtyState();
        }
        if (this.linkagePage != null && this.linkagePage.getContentPane() != null) {
            this.linkagePage.cleanDirtyState();
        }
        if (this.epEditor != null) {
            iscobolProjectionViewer = this.epEditor.getViewer().getDocument().get();
            if (this.screenProgram.isAGenericCobolProgram()) {
                this.screenProgram.getEventParagraphs().setProcedure((String)iscobolProjectionViewer);
            } else {
                this.screenProgram.getEventParagraphs().setBody((String)iscobolProjectionViewer);
            }
        }
        this.resourceListenerEnabled = false;
        this.screenProgram.save();
        this.resourceListenerEnabled = true;
        for (ScreenSectionEditor screenSectionEditor2 : this.ssEditor) {
            screenSectionEditor2.doSave(iProgressMonitor);
        }
        for (ScreenSectionEditor screenSectionEditor2 : this.rptEditor) {
            screenSectionEditor2.doSave(iProgressMonitor);
        }
        if (this.epEditor != null) {
            this.epEditor.doSave(iProgressMonitor);
        }
        iscobolProjectionViewer = this.getEventParagraphsEditor().getViewer();
        screenSectionEditor2 = (AnnotationModel)iscobolProjectionViewer.getAnnotationModel();
        Iterator iterator = screenSectionEditor2.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof BreakpointAnnotation) || (position = screenSectionEditor2.getPosition(annotation)) == null) continue;
            try {
                int n = iscobolProjectionViewer.getDocument().getLineOfOffset(position.getOffset()) + 1;
                BreakpointAnnotation breakpointAnnotation = (BreakpointAnnotation)annotation;
                breakpointAnnotation.getMarker().setAttribute("lineNumber", n);
                breakpointAnnotation.getMarker().getFileMarker().setAttribute("lineNumber", n);
            }
            catch (Exception exception) {}
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public DataDefinitionPage getWorkingPage() {
        return this.workingPage;
    }

    public DataDefinitionPage getLinkagePage() {
        return this.linkagePage;
    }

    public FileSectionPage getFileSectionPage() {
        return this.fileSectionPage;
    }

    public void pageChange(int n) {
        int n2 = this.getActivePageIndex();
        super.pageChange(n);
        if (n2 < this.ssEditor.size()) {
            ((ScreenSectionEditor)this.ssEditor.elementAt(n2)).updateActions();
        } else if (n2 >= this.ssEditor.size() && n2 < this.ssEditor.size() + this.rptEditor.size()) {
            ((ReportEditor)this.rptEditor.elementAt(n2 - this.ssEditor.size())).updateActions();
        }
        if (n < this.ssEditor.size()) {
            this.lastActiveGraphicalEditor = (BaseGraphicalEditor)this.ssEditor.elementAt(n);
        } else if (n < this.ssEditor.size() + this.rptEditor.size()) {
            this.lastActiveGraphicalEditor = (BaseGraphicalEditor)this.rptEditor.elementAt(n - this.ssEditor.size());
        }
        DataPool.closeDialog();
        this.updateOutlineView(n);
        if (n == this.getWorkingStoragePageIndex() || n == this.getLinkageSectionPageIndex()) {
            IEditorActionBarContributor iEditorActionBarContributor;
            DataDefinitionPage dataDefinitionPage;
            if (n == this.getWorkingStoragePageIndex()) {
                dataDefinitionPage = this.workingPage;
                if (this.linkedCopyReloadedIndex == this.getLinkageSectionPageIndex()) {
                    ((VariableSettingsContentPane)this.workingPage.getSettingsContentPane()).refreshData(true);
                    this.linkedCopyReloadedIndex = -1;
                }
            } else {
                dataDefinitionPage = this.linkagePage;
                if (this.linkedCopyReloadedIndex == this.getWorkingStoragePageIndex()) {
                    ((VariableSettingsContentPane)this.linkagePage.getSettingsContentPane()).refreshData(true);
                    this.linkedCopyReloadedIndex = -1;
                }
            }
            if ((iEditorActionBarContributor = this.getEditorSite().getActionBarContributor()) != null && iEditorActionBarContributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)iEditorActionBarContributor).setActivePage((IEditorPart)dataDefinitionPage);
            }
            dataDefinitionPage.refreshData();
            dataDefinitionPage.updateActions();
        } else if (n == this.getEventParagraphsEditorIndex()) {
            EventParagraphsEditor eventParagraphsEditor = this.getEventParagraphsEditor();
            if (eventParagraphsEditor.isReconcilingEnabled()) {
                IscobolReconcilingStrategy iscobolReconcilingStrategy = (IscobolReconcilingStrategy)eventParagraphsEditor.getConfiguration().getReconciler((ISourceViewer)eventParagraphsEditor.getViewer()).getReconcilingStrategy("__dftl_partition_content_type");
                iscobolReconcilingStrategy.reconcile(true);
            }
        } else if (n < this.ssEditor.size()) {
            ScreenSectionEditor screenSectionEditor = this.getActiveScreenEditor();
            screenSectionEditor.getWindowModel().getScreenSection().firePropertyChange("dummy", (Object)"old", (Object)"new");
            this.getTabbedPropertySheetPage().setGraphicalEditor((BaseGraphicalEditor)screenSectionEditor);
        } else if (n < this.ssEditor.size() + this.rptEditor.size()) {
            ReportEditor reportEditor = this.getActiveReportEditor();
            reportEditor.getReportModel().firePropertyChange("dummy", (Object)"old", (Object)"new");
            this.getTabbedPropertySheetPage().setGraphicalEditor((BaseGraphicalEditor)reportEditor);
        }
    }

    public ScreenSectionEditor getActiveScreenEditor() {
        int n = this.getActivePageIndex();
        if (n < this.ssEditor.size()) {
            return (ScreenSectionEditor)this.ssEditor.elementAt(n);
        }
        return null;
    }

    public ReportEditor getActiveReportEditor() {
        int n = this.getActivePageIndex();
        if (n >= this.ssEditor.size() && n < this.ssEditor.size() + this.rptEditor.size()) {
            return (ReportEditor)this.rptEditor.elementAt(n - this.ssEditor.size());
        }
        return null;
    }

    public BaseGraphicalEditor getLastActiveGraphicalEditor() {
        return this.lastActiveGraphicalEditor;
    }

    public int getActivePageIndex() {
        return super.getActivePage();
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    protected ScreenProgramContentOutline getOutlinePage() {
        if (this.outline == null) {
            this.outline = new ScreenProgramContentOutline(this);
        }
        return this.outline;
    }

    protected TabbedPropertySheetPage getTabbedPropertySheetPage() {
        int n = this.getActivePage();
        if (this.tabbedPropertySheetPage == null && n < this.ssEditor.size() + this.rptEditor.size()) {
            this.tabbedPropertySheetPage = new TabbedPropertySheetPage(n < this.ssEditor.size() ? (BaseGraphicalEditor)this.ssEditor.elementAt(n) : (BaseGraphicalEditor)this.rptEditor.elementAt(n - this.ssEditor.size()));
        }
        return this.tabbedPropertySheetPage;
    }

    public Object getAdapter(Class clazz) {
        IFile iFile = this.getScreenProgram().getFile();
        if (clazz == IShowInSource.class) {
            if (iFile != null) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            return null;
        }
        if (clazz == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (clazz == ScreenProgram.class) {
            return this.getScreenProgram();
        }
        if (clazz == ActionRegistry.class) {
            if (this.getActiveEditor() instanceof ScreenSectionEditor) {
                return ((ScreenSectionEditor)this.getActiveEditor()).getActionRegistry();
            }
            if (this.getActivePageInstance() instanceof DataDefinitionPage) {
                return ((DataDefinitionPage)this.getActivePageInstance()).getActionRegistry();
            }
            return null;
        }
        if (clazz == CommandStack.class) {
            if (this.getActiveEditor() instanceof ScreenSectionEditor) {
                return ((ScreenSectionEditor)this.getActiveEditor()).getGraphicalViewer().getEditDomain().getCommandStack();
            }
            if (this.getActiveEditor() instanceof ReportEditor) {
                return ((ReportEditor)this.getActiveEditor()).getGraphicalViewer().getEditDomain().getCommandStack();
            }
            if (this.getActivePageInstance() instanceof DataDefinitionPage) {
                return ((DataDefinitionPage)this.getActivePageInstance()).getSettingsContentPane().getCommandStack();
            }
            if (this.getActivePageInstance() instanceof FileSectionPage) {
                return ((FileSectionPage)this.getActivePageInstance()).getCommandStack();
            }
            return null;
        }
        if (clazz == IscobolEditor.class || clazz == ITextEditor.class) {
            return iFile != null ? this.getEventParagraphsEditor() : null;
        }
        if (clazz == IPropertySheetPage.class) {
            return this.getTabbedPropertySheetPage();
        }
        return super.getAdapter(clazz);
    }

    void updateOutlineView(int n) {
        try {
            this.outline.refresh();
            PropertySheet propertySheet = (PropertySheet)this.getSite().getWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
            if (propertySheet != null) {
                PropertySheetPage propertySheetPage = (PropertySheetPage)propertySheet.getCurrentPage();
                propertySheetPage.refresh();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("CURRENT_LOOK_AND_FEEL")) {
            this.updateUI(this.getSite().getPage().getActiveEditor() == this, null);
        } else if (propertyChangeEvent.getProperty().equals("iscobolsp.showcontrolid") || propertyChangeEvent.getProperty().equals("iscobolsp.showtaborder") || propertyChangeEvent.getProperty().equals("iscobolsp.showcontrolidfg") || propertyChangeEvent.getProperty().equals("iscobolsp.showtaborderfg") || propertyChangeEvent.getProperty().equals("iscobolsp.showcontrolidbg") || propertyChangeEvent.getProperty().equals("iscobolsp.showtaborderbg") || propertyChangeEvent.getProperty().equals("iscobolsp.showlockedicon") || propertyChangeEvent.getProperty().equals("iscobolrd.showlockedicon")) {
            this.updateControlDecorations(this.getSite().getPage().getActiveEditor() == this, propertyChangeEvent.getProperty());
        } else if (this.fileSectionPage != null && this.fileSectionPage.getContentPane() != null) {
            this.fileSectionPage.propertyChange(propertyChangeEvent);
        }
    }

    public void gotoMarker(IMarker iMarker) {
        this.activateEventParagraphsEditor();
        this.getEventParagraphsEditor().gotoMarker(iMarker);
    }

    public DataPool getDataPool() {
        if (this.getActiveScreenEditor() != null) {
            return this.getActiveScreenEditor().getDataPool();
        }
        if (this.getActiveReportEditor() != null) {
            return this.getActiveReportEditor().getDataPool();
        }
        return null;
    }

    public void setLinkedCopyReloaded() {
        this.linkedCopyReloadedIndex = this.getActivePageIndex();
    }

    static /* synthetic */ void access$000(ScreenProgramEditor screenProgramEditor, IProgressMonitor iProgressMonitor) {
        screenProgramEditor.intUpdateUI(iProgressMonitor);
    }

    static /* synthetic */ void access$100(ScreenProgramEditor screenProgramEditor, String string) {
        screenProgramEditor.intUpdateControlDecorations(string);
    }

    static /* synthetic */ void access$200(ScreenProgramEditor screenProgramEditor, IProgressMonitor iProgressMonitor) {
        screenProgramEditor.intUpdateScreenSections(iProgressMonitor);
    }
}

