/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter;

import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.EventParagraphs;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class ScreenRoot {
    protected EventParagraphs eventParagraphs = new EventParagraphs();
    protected IFile file;
    protected File iofile;
    private boolean loaded;
    private boolean imported;
    protected Hashtable properties;

    public ScreenRoot(IFile iFile) {
        this.file = iFile;
    }

    public ScreenRoot(File file) {
        this.iofile = file;
    }

    protected void setIscobolRelease() {
        this.setString("iscobol.release", PluginUtilities.getIscobolRelease());
    }

    public String getIscobolRelease() {
        return this.getIscobolRelease(false);
    }

    public String getIscobolRelease(boolean bl) {
        if (bl || PluginUtilities.getResourcePersistentProperty((IResource)this.getFile(), (String)"releaseCheckDisabled") == null) {
            return this.getString("iscobol.release", "Unknown");
        }
        PluginUtilities.setResourcePersistentProperty((IResource)this.getFile(), (String)"releaseCheckDisabled", null);
        return PluginUtilities.getIscobolRelease();
    }

    public abstract VariableType findVariable(String var1);

    public Hashtable getProperties() {
        this.checkLoaded();
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    protected void checkLoaded() {
        if (!this.loaded && !this.imported) {
            this.load();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public IProject getProject() {
        return this.file != null ? this.file.getProject() : null;
    }

    public void setLoaded() {
        this.loaded = true;
        this.imported = false;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean bl) {
        this.imported = bl;
    }

    public abstract void load();

    public abstract void save();

    public abstract boolean getAnsiFormat();

    public IFile getFile() {
        return this.file;
    }

    public File getIOFile() {
        return this.iofile;
    }

    protected InputStream getContents() {
        try {
            return this.file != null ? this.file.getContents() : new FileInputStream(this.iofile);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public EventParagraphs getEventParagraphs() {
        this.checkLoaded();
        if (this.eventParagraphs == null) {
            this.eventParagraphs = new EventParagraphs();
        }
        return this.eventParagraphs;
    }

    public void setEventParagraphs(EventParagraphs eventParagraphs) {
        this.eventParagraphs = eventParagraphs;
    }

    public String getFileName() {
        String string = this.file != null ? this.file.getName() : this.iofile.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean getBoolean(String string, boolean bl) {
        if (this.file == null) {
            return false;
        }
        String string2 = (String)this.getProperties().get(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public String getString(String string, String string2) {
        if (this.file == null) {
            return "";
        }
        String string3 = (String)this.getProperties().get(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public void setString(String string, String string2) {
        if (this.file != null) {
            if (string2 != null) {
                this.getProperties().put(string, string2);
            } else {
                this.getProperties().remove(string);
            }
        }
    }

    public void setBoolean(String string, boolean bl) {
        this.setString(string, Boolean.toString(bl));
    }

    public void setInt(String string, int n) {
        this.setString(string, Integer.toString(n));
    }

    public int getInt(String string, int n) {
        if (this.file == null) {
            return 0;
        }
        String string2 = (String)this.getProperties().get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        ScreenRoot screenRoot = (ScreenRoot)object;
        if (this.file != null) {
            return screenRoot.file != null ? this.file.equals(screenRoot.file) : false;
        }
        return screenRoot.iofile != null ? this.iofile.equals(screenRoot.iofile) : false;
    }

    protected void loadOldProps() {
    }

    public void disableReleaseCheck() {
        PluginUtilities.setResourcePersistentProperty((IResource)this.getFile(), (String)"releaseCheckDisabled", (String)"true");
    }
}

