/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.actions;

import com.iscobol.filedesigner.DataLayoutPage;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.reportdesigner.parts.ReportComponentEditPart;
import com.iscobol.reportdesigner.parts.ReportComponentTreeEditPart;
import com.iscobol.screenpainter.BaseGraphicalEditor;
import com.iscobol.screenpainter.ISettingItemListPage;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramPage;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.StatusbarModel;
import com.iscobol.screenpainter.model.ToolbarModel;
import com.iscobol.screenpainter.model.commands.CopyBeanCommand;
import com.iscobol.screenpainter.model.commands.PasteData;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.ComponentTreeEditPart;
import com.iscobol.screenpainter.parts.MenuEditPart;
import com.iscobol.screenpainter.parts.MenuTreeEditPart;
import com.iscobol.screenpainter.parts.RibbonEditPart;
import com.iscobol.screenpainter.parts.RibbonTreeEditPart;
import com.iscobol.screenpainter.parts.StatusbarEditPart;
import com.iscobol.screenpainter.parts.StatusbarTreeEditPart;
import com.iscobol.screenpainter.parts.ToolbarEditPart;
import com.iscobol.screenpainter.parts.ToolbarTreeEditPart;
import com.iscobol.screenpainter.propertysheet.pages.TabbedPropertySheetPage;
import com.iscobol.screenpainter.util.EditableControlWrapper;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.views.properties.PropertySheet;

public class CopyBeanAction
extends SelectionAction {
    private FormEditor formEditor;

    public CopyBeanAction(FormEditor formEditor) {
        super((IWorkbenchPart)formEditor);
        this.setLazyEnablementCalculation(true);
        this.formEditor = formEditor;
    }

    protected void init() {
        super.init();
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText("Copy");
        this.setId(ActionFactory.COPY.getId());
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    private CopyBeanCommand createCopyCommand(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[list.size()];
        list.toArray(objectArray);
        ContainerModel containerModel = null;
        ReportSectionModel reportSectionModel = null;
        CopyBeanCommand copyBeanCommand = new CopyBeanCommand();
        PasteData pasteData = new PasteData();
        ScreenProgram screenProgram = null;
        if (objectArray[0] instanceof TreeItem) {
            if (!(this.formEditor.getActivePageInstance() instanceof ISettingItemListPage)) {
                return null;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                TreeItem treeItem = (TreeItem)objectArray[i];
                pasteData.addSettingItem((SettingItem)treeItem.getData());
            }
        } else if (objectArray[0] instanceof EditableControlWrapper) {
            EditableControlWrapper editableControlWrapper = (EditableControlWrapper)objectArray[0];
            if (!editableControlWrapper.canCopy()) {
                return null;
            }
            pasteData.setEditableControlWrapper(editableControlWrapper);
        } else {
            if (!(this.formEditor.getActiveEditor() instanceof BaseGraphicalEditor)) {
                return null;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                ToolbarModel toolbarModel;
                boolean bl = false;
                if (objectArray[i] instanceof ToolbarEditPart || (bl = objectArray[i] instanceof ToolbarTreeEditPart)) {
                    toolbarModel = bl ? (ToolbarModel)((ToolbarTreeEditPart)objectArray[i]).getModel() : (ToolbarModel)((ToolbarEditPart)objectArray[i]).getModel();
                    pasteData.addToolbar((IToolbarModel)toolbarModel);
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getParentWindow().getScreenProgram();
                    continue;
                }
                if (objectArray[i] instanceof RibbonEditPart || (bl = objectArray[i] instanceof RibbonTreeEditPart)) {
                    toolbarModel = bl ? (RibbonModel)((RibbonTreeEditPart)objectArray[i]).getModel() : (RibbonModel)((RibbonEditPart)objectArray[i]).getModel();
                    pasteData.addToolbar((IToolbarModel)toolbarModel);
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getParentWindow().getScreenProgram();
                    continue;
                }
                if (objectArray[i] instanceof StatusbarEditPart || (bl = objectArray[i] instanceof StatusbarTreeEditPart)) {
                    toolbarModel = bl ? (StatusbarModel)((StatusbarTreeEditPart)objectArray[i]).getModel() : (StatusbarModel)((StatusbarEditPart)objectArray[i]).getModel();
                    pasteData.addStatusbar((StatusbarModel)toolbarModel);
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getParentWindow().getScreenProgram();
                    continue;
                }
                if (objectArray[i] instanceof MenuEditPart || (bl = objectArray[i] instanceof MenuTreeEditPart)) {
                    toolbarModel = bl ? (MenuModel)((MenuTreeEditPart)objectArray[i]).getModel() : (MenuModel)((MenuEditPart)objectArray[i]).getModel();
                    pasteData.addMenu((MenuModel)toolbarModel);
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getParentWindow().getScreenProgram();
                    continue;
                }
                if (objectArray[i] instanceof ComponentEditPart || (bl = objectArray[i] instanceof ComponentTreeEditPart)) {
                    ComponentModel componentModel = toolbarModel = bl ? (ComponentModel)((ComponentTreeEditPart)objectArray[i]).getModel() : (ComponentModel)((ComponentEditPart)objectArray[i]).getModel();
                    if (toolbarModel.getOnPageButton() != null) {
                        return null;
                    }
                    if (containerModel == null) {
                        containerModel = (ContainerModel)toolbarModel.getParent();
                        pasteData.addComponent((ComponentModel)toolbarModel);
                    } else if (containerModel == toolbarModel.getParent()) {
                        pasteData.addComponent((ComponentModel)toolbarModel);
                    } else {
                        return null;
                    }
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getParentWindow().getScreenProgram();
                    continue;
                }
                if (objectArray[i] instanceof ReportComponentEditPart || (bl = objectArray[i] instanceof ReportComponentTreeEditPart)) {
                    ReportComponentModel reportComponentModel = toolbarModel = bl ? (ReportComponentModel)((ReportComponentTreeEditPart)objectArray[i]).getModel() : (ReportComponentModel)((ReportComponentEditPart)objectArray[i]).getModel();
                    if (reportSectionModel == null) {
                        reportSectionModel = (ReportSectionModel)toolbarModel.getParent();
                        pasteData.addReportComponent((ReportComponentModel)toolbarModel);
                    } else if (reportSectionModel == toolbarModel.getParent()) {
                        pasteData.addReportComponent((ReportComponentModel)toolbarModel);
                    } else {
                        return null;
                    }
                    if (screenProgram != null) continue;
                    screenProgram = toolbarModel.getScreenProgram();
                    continue;
                }
                return null;
            }
        }
        pasteData.setScreenProgram(screenProgram);
        copyBeanCommand.setPasteData(pasteData);
        return copyBeanCommand;
    }

    protected boolean calculateEnabled() {
        CopyBeanCommand copyBeanCommand = this.createCopyCommand(this.getSelectedObjects());
        return copyBeanCommand != null && copyBeanCommand.canExecute();
    }

    public void run() {
        CopyBeanCommand copyBeanCommand = this.createCopyCommand(this.getSelectedObjects());
        if (copyBeanCommand != null && copyBeanCommand.canExecute()) {
            if (copyBeanCommand.getPasteData() != null && copyBeanCommand.getPasteData().getEditableControlWrapper() != null) {
                copyBeanCommand.getPasteData().getEditableControlWrapper().copy();
            } else {
                this.execute((Command)copyBeanCommand);
            }
        }
    }

    protected ISelection getSelection() {
        TabbedPropertySheetPage tabbedPropertySheetPage;
        Control control;
        IWorkbenchPart iWorkbenchPart = this.formEditor.getSite().getPage().getWorkbenchWindow().getPartService().getActivePart();
        ISelection iSelection = PluginUtilities.getContentOutlineSelection((IWorkbenchPart)iWorkbenchPart);
        if (iSelection != null) {
            return iSelection;
        }
        if (iWorkbenchPart == this.formEditor) {
            Control control2;
            if (this.formEditor.getActiveEditor() instanceof BaseGraphicalEditor) {
                return ((BaseGraphicalEditor)this.formEditor.getActiveEditor()).getGraphicalViewer().getSelection();
            }
            if (this.formEditor.getActivePageInstance() instanceof ISettingItemListPage) {
                return ((ISettingItemListPage)this.formEditor.getActivePageInstance()).getSettingsContentPane().getSelection();
            }
            if (this.formEditor.getActivePageInstance() instanceof ScreenProgramPage) {
                Control control3 = ((ScreenProgramPage)this.formEditor.getActivePageInstance()).getFocusControl();
                if (EditableControlWrapper.isEditableControl((Control)control3)) {
                    return new StructuredSelection((Object)EditableControlWrapper.getInstance((Control)control3));
                }
            } else if (this.formEditor.getActivePageInstance() instanceof DataLayoutPage && EditableControlWrapper.isEditableControl((Control)(control2 = ((DataLayoutPage)this.formEditor.getActivePageInstance()).getFocusControl()))) {
                return new StructuredSelection((Object)EditableControlWrapper.getInstance((Control)control2));
            }
        } else if (iWorkbenchPart instanceof PropertySheet && ((PropertySheet)iWorkbenchPart).getCurrentPage() instanceof TabbedPropertySheetPage && EditableControlWrapper.isEditableControl((Control)(control = (tabbedPropertySheetPage = (TabbedPropertySheetPage)((PropertySheet)iWorkbenchPart).getCurrentPage()).getControl().getDisplay().getFocusControl()))) {
            return new StructuredSelection((Object)EditableControlWrapper.getInstance((Control)control));
        }
        return StructuredSelection.EMPTY;
    }
}

