/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.actions;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.osgi.framework.Bundle;

public class ReloadCopybooksAction
extends Action {
    public static final String ID = "com.iscobol.screenpainter.reloadCopybooksAction";
    private IContainer copyFolder;

    public ReloadCopybooksAction(IContainer iContainer) {
        this.setId(ID);
        this.setText("Reload isCOBOL's copybooks");
        this.copyFolder = iContainer;
    }

    public void run() {
        if (this.copyFolder == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)"com.iscobol.plugins.libraries");
        for (String string : IscobolEditorPlugin.SYSTEM_COPY_BOOKS) {
            this.copyFile(bundle, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(Bundle bundle, String string) {
        InputStream inputStream = null;
        try {
            Serializable serializable;
            String string2 = PluginUtilities.getIscobolInstallationDirectory((IProject)this.copyFolder.getProject());
            if ("Embedded isCOBOL".equals(string2) || IscobolEditorPlugin.EMBEDDED_SYSTEM_COPY_BOOKS.contains(string)) {
                serializable = bundle.getEntry("copy/" + string);
                if (serializable != null) {
                    inputStream = ((URL)serializable).openStream();
                }
            } else {
                serializable = new File(string2 + File.separator + "sample" + File.separator + "isdef" + File.separator + string);
                if (((File)serializable).exists() && ((File)serializable).isFile() && ((File)serializable).canRead()) {
                    inputStream = new FileInputStream((File)serializable);
                }
            }
            if (inputStream != null) {
                serializable = new Path(string);
                IFile iFile = this.copyFolder.getFile((IPath)serializable);
                if (iFile.exists()) {
                    PluginUtilities.modifyFile((IFile)iFile, (InputStream)inputStream, (boolean)true, (boolean)false);
                } else {
                    PluginUtilities.createFile((IFile)iFile, (InputStream)inputStream, (boolean)true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

