/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.actions;

import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.views.AbstractScreenPainterView;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;

public class RemoveAllFiltersAction
extends Action {
    public static final String ID = "com.iscobol.screenpainter.removeAllFiltersAction";
    private AbstractScreenPainterView view;

    public RemoveAllFiltersAction(AbstractScreenPainterView abstractScreenPainterView) {
        this.setId(ID);
        this.setText("Remove All Filters");
        this.view = abstractScreenPainterView;
    }

    public void run() {
        for (IProject iProject : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            try {
                if (!iProject.isOpen() || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) continue;
                this.removeFilters((IContainer)iProject);
                this.view.refresh((Object)iProject);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void removeFilters(IContainer iContainer) throws CoreException {
        PluginUtilities.setResourcePersistentProperty((IResource)iContainer, (String)"iscobol.filter.folder", null);
        if (iContainer instanceof IProject) {
            PluginUtilities.setResourcePersistentProperty((IResource)iContainer, (String)"iscobol.filter.programlist", null);
            PluginUtilities.setResourcePersistentProperty((IResource)iContainer, (String)"iscobol.filter.fdlist", null);
        }
        for (IResource iResource : iContainer.members()) {
            if (!(iResource instanceof IContainer)) continue;
            this.removeFilters((IContainer)iResource);
        }
    }
}

