/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.actions;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.actions.ShowSourceContributionItem;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IFDAdapter;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class ShowSourceContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator iServiceLocator) {
        this.serviceLocator = iServiceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList arrayList = new ArrayList();
        ISelection iSelection = ((ISelectionService)this.serviceLocator.getService(ISelectionService.class)).getSelection();
        IWorkbenchPart iWorkbenchPart = ((IPartService)this.serviceLocator.getService(IPartService.class)).getActivePart();
        if (iWorkbenchPart != null && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            if (iStructuredSelection.getFirstElement() instanceof IScreenProgramAdapter) {
                ScreenProgram screenProgram = ((IScreenProgramAdapter)iStructuredSelection.getFirstElement()).getScreenProgram();
                IContainer iContainer = null;
                try {
                    iContainer = PluginUtilities.getSourceFolder((IProject)screenProgram.getProject());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (iContainer != null) {
                    this.addAction(iContainer, screenProgram.getProgramName() + screenProgram.getProgramFileSuffix(), iWorkbenchPart, arrayList);
                }
            } else if (iStructuredSelection.getFirstElement() instanceof IFDAdapter) {
                ScreenFD_SL screenFD_SL = ((IFDAdapter)iStructuredSelection.getFirstElement()).getDataLayout();
                IFolder iFolder = null;
                try {
                    iFolder = PluginUtilities.getFileLayoutCopyFolder((IProject)screenFD_SL.getProject());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (iFolder == null) {
                    iFolder = PluginUtilities.getFirstLocalCopyFolder((IProject)screenFD_SL.getProject());
                }
                if (iFolder != null) {
                    this.addAction((IContainer)iFolder, screenFD_SL.getFdName() + (screenFD_SL.getFileDescriptor().getFileFormat().getValue() == 5 ? IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.sort.suffix") : IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filesec.suffix")), iWorkbenchPart, arrayList);
                    this.addAction((IContainer)iFolder, screenFD_SL.getFdName() + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filectl.suffix"), iWorkbenchPart, arrayList);
                    this.addAction((IContainer)iFolder, screenFD_SL.getFdName() + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.fileproc.suffix"), iWorkbenchPart, arrayList);
                }
            }
        }
        return arrayList.toArray(new IContributionItem[arrayList.size()]);
    }

    private void addAction(IContainer iContainer, String string, IWorkbenchPart iWorkbenchPart, List<IContributionItem> list) {
        IResource iResource = PluginUtilities.findMember((IContainer)iContainer, (IPath)new Path(string));
        if (iResource instanceof IFile) {
            list.add((IContributionItem)new ActionContributionItem((IAction)new MyAction(this, iWorkbenchPart, (IFile)iResource)));
        }
    }
}

