/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.AccordionPage;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.HAlignment;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractAccordion
extends AbstractTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final TabOrientation TOP_ORIENTATION = new TabOrientation(0);
    public static final int BUTTONS_HEIGHT = 25;
    private String befTabchgDisplay;
    private String aftTabchgDisplay;
    private boolean relativeOffset;

    public AbstractAccordion(Component component) {
        super(component);
    }

    protected void getTabPagesCode(TabPage[] tabPageArray, CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, StringBuilder stringBuilder) {
        super.getTabPagesCode(tabPageArray, cobolFormatter, string, bl, bl2, stringBuilder);
        StringBuilder stringBuilder2 = new StringBuilder(string);
        int n = tabPageArray.length;
        if (n == 1) {
            stringBuilder2.append("tab-alignment ");
            stringBuilder2.append(this.getTabAlignmentString(((AccordionPage)tabPageArray[0]).getAlignment()));
        } else {
            stringBuilder2.append("tab-alignment (");
            for (int i = 0; i < n; ++i) {
                stringBuilder2.append(" ");
                stringBuilder2.append(this.getTabAlignmentString(((AccordionPage)tabPageArray[i]).getAlignment()));
            }
            stringBuilder2.append(")");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
    }

    public float getLinePixelsToAdd() {
        if (this.isRelativeOffset()) {
            return 0.0f;
        }
        return this.getLinePixels() + 25.0f - 15.0f;
    }

    public float getColPixelsToAdd() {
        if (this.isRelativeOffset()) {
            return 0.0f;
        }
        return this.getColumnPixels() - (float)this.cellWidth * 0.8f;
    }

    public float getLineToAdd() {
        if (this.isRelativeOffset()) {
            return 0.0f;
        }
        return this.getRealLine() + 10.0f / (float)this.cellHeight;
    }

    public float getColToAdd() {
        if (this.isRelativeOffset()) {
            return 0.0f;
        }
        return this.getRealColumn() - 0.8f;
    }

    public TabOrientation getTabOrientation() {
        return TOP_ORIENTATION;
    }

    public String getBeforeTabchangeDisplay() {
        return this.befTabchgDisplay;
    }

    public void setBeforeTabchangeDisplay(String string) {
        this.befTabchgDisplay = string;
    }

    public String getAfterTabchangeDisplay() {
        return this.aftTabchgDisplay;
    }

    public void setAfterTabchangeDisplay(String string) {
        this.aftTabchgDisplay = string;
    }

    public boolean isRelativeOffset() {
        return this.relativeOffset;
    }

    public void setRelativeOffset(boolean bl) {
        this.relativeOffset = bl;
    }

    private String getTabAlignmentString(HAlignment hAlignment) {
        switch (hAlignment.getValue()) {
            default: {
                return "\"c\"";
            }
            case 1: {
                return "\"l\"";
            }
            case 3: 
        }
        return "\"r\"";
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string3 = string != null ? string : this.getName();
        stringBuilder.append(this.getTabToAddCode(cobolFormatter, string3, string2, bl, bl2));
        stringBuilder.append(cobolFormatter.formatLine(string2 + "."));
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"accordion", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"allow-container", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.relativeOffset, (String)"relative-offset", (String)string, (StringBuilder)stringBuilder);
        stringBuilder.append(this.getTabbedPaneScreenSectionCode(cobolFormatter, string, bl3));
        if (this.allComponentInScreen && this.pages.size() > 0) {
            String string2 = "      tab-to-add (";
            for (int i = 0; i < this.pages.size(); ++i) {
                string2 = string2 + " " + ((TabPage)this.pages.elementAt(i)).getName();
            }
            string2 = string2 + ")";
            stringBuilder.append(cobolFormatter.formatLine(string2));
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public boolean isAllowContainer() {
        return true;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        if (iVariableDeclarationScreen.getValueToken() != null) {
            this.setValue((int)PropertyDescriptorRegistry.parseFloat((String)iVariableDeclarationScreen.getValueToken().getWord()));
        } else if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(i)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("TAB-TO-ADD")) continue;
            for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                if (iPropElementList.getValue(i)[n].getToken() != null) {
                    vector.add(iPropElementList.getValue(i)[n].getToken().getWord());
                    continue;
                }
                vector.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            TabPage tabPage = new TabPage();
            tabPage.setName((String)vector.elementAt(n));
            this.pages.add(tabPage);
        }
    }

    public void loadAndSet(AbstractBeanControl abstractBeanControl, ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc, float f, float f2, GroupBeanControl groupBeanControl, TabPage tabPage) {
        abstractBeanControl.setLine(f);
        abstractBeanControl.setColumn(f2);
        abstractBeanControl.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        if (groupBeanControl != null) {
            groupBeanControl.addComponent(abstractBeanControl);
        } else {
            tabPage.addComponent(abstractBeanControl);
        }
        f = abstractBeanControl.getRealLine();
        f2 = abstractBeanControl.getRealColumn() + abstractBeanControl.getSize();
    }
}

