/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BarPixelLineSetting;
import com.iscobol.screenpainter.beans.types.BarPixelLineSettingList;
import com.iscobol.screenpainter.beans.types.BarShading;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractBar
extends AbstractBeanControl {
    private static final long serialVersionUID = 1L;
    private boolean dotted;
    private boolean dashed;
    private boolean dotDash;
    private boolean horizontal;
    private int width = 1;
    private int positionShift;
    private String widthVar;
    private String positionShiftVar;
    private BarPixelLineSettingList pixelLineSettings = new BarPixelLineSettingList();

    public AbstractBar(Component component) {
        super(component);
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean bl) {
        this.dotted = bl;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setLines(10.0f);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean bl) {
        this.dashed = bl;
    }

    public boolean isDotDash() {
        return this.dotDash;
    }

    public void setDotDash(boolean bl) {
        this.dotDash = bl;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
        if (this.horizontal) {
            this.setLinesPixels(n);
        } else {
            this.setSizePixels(n);
        }
    }

    public void setWidthInCells(boolean bl) {
        this.widthInCells = bl;
        if (this.horizontal) {
            this.updateSize();
        }
    }

    public void setHeightInCells(boolean bl) {
        this.heightInCells = bl;
        if (!this.horizontal) {
            this.updateLines();
        }
    }

    public int getPositionShift() {
        return this.positionShift;
    }

    public void setPositionShift(int n) {
        this.positionShift = n;
    }

    public String getWidthVariable() {
        return this.widthVar;
    }

    public void setWidthVariable(String string) {
        this.widthVar = string;
    }

    public String getPositionShiftVariable() {
        return this.positionShiftVar;
    }

    public void setPositionShiftVariable(String string) {
        this.positionShiftVar = string;
    }

    public BarPixelLineSettingList getPixelLineSettings() {
        return this.pixelLineSettings;
    }

    public void setPixelLineSettings(BarPixelLineSettingList barPixelLineSettingList) {
        this.pixelLineSettings = barPixelLineSettingList;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    protected void getDimensionCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (this.isHorizontal()) {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("size ");
            if (this.isSizeUnitPixel()) {
                if (!bl2 && this.getSizeVariable() != null && this.getSizeVariable().length() > 0) {
                    stringBuilder2.append(this.getSizeVariable());
                } else {
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getSizePixels(), (boolean)bl, (boolean)true));
                }
                stringBuilder2.append(" pixels ");
            } else {
                BaseWindow baseWindow;
                boolean bl3;
                if (!bl2 && this.getSizeVariable() != null && this.getSizeVariable().length() > 0) {
                    stringBuilder2.append(this.getSizeVariable());
                } else {
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getSize(), (boolean)bl, (boolean)true));
                }
                boolean bl4 = bl3 = this.getSizeUnit().getValue() == 2 || this.getSizeUnit().getValue() == 0 && ((baseWindow = this.getBaseParentWindow()) == null || baseWindow.isCell());
                if (bl3) {
                    stringBuilder2.append(" cells ");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        } else {
            StringBuilder stringBuilder3 = new StringBuilder(string);
            stringBuilder3.append("lines ");
            if (this.isLinesUnitPixel()) {
                if (!bl2 && this.getLinesVariable() != null && this.getLinesVariable().length() > 0) {
                    stringBuilder3.append(this.getLinesVariable());
                } else {
                    stringBuilder3.append(IscobolBeanConstants.floatToString((float)this.getLinesPixels(), (boolean)bl, (boolean)true));
                }
                stringBuilder3.append(" pixels ");
            } else {
                boolean bl5;
                if (!bl2 && this.getLinesVariable() != null && this.getLinesVariable().length() > 0) {
                    stringBuilder3.append(this.getLinesVariable());
                } else {
                    stringBuilder3.append(IscobolBeanConstants.floatToString((float)this.getLines(), (boolean)bl, (boolean)true));
                }
                boolean bl6 = bl5 = this.getLinesUnit().getValue() == 2 || this.getLinesUnit().getValue() == 0 && (this.getParentWindow() == null || this.getParentWindow().isCell());
                if (bl5) {
                    stringBuilder3.append(" cells ");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder3.toString()));
        }
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.dotted, (String)"dotted", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.dashed, (String)"dashed", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.dotDash, (String)"dot-dash", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.widthVar, (int)this.width, (int)1, (String)"width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.positionShiftVar, (int)this.positionShift, (int)0, (String)"position-shift", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        int n2 = this.pixelLineSettings.getSettingCount();
        if (n2 > 0) {
            StringBuilder stringBuilder2;
            BarPixelLineSetting barPixelLineSetting;
            int n3;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            ForegroundColorType foregroundColorType = new ForegroundColorType(0);
            for (n3 = 0; n3 < n2; ++n3) {
                barPixelLineSetting = (BarPixelLineSetting)this.pixelLineSettings.getSettingAt(n3);
                if (!barPixelLineSetting.getColor().equals((Object)foregroundColorType)) {
                    bl4 = true;
                }
                if (barPixelLineSetting.getShading().getValue() != 2) {
                    bl5 = true;
                }
                if (barPixelLineSetting.getLeadingShift() != 0) {
                    bl6 = true;
                }
                if (barPixelLineSetting.getTrailingShift() == 0) continue;
                bl7 = true;
            }
            if (bl4) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("colors (");
                for (n3 = 0; n3 < n2; ++n3) {
                    barPixelLineSetting = (BarPixelLineSetting)this.pixelLineSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(barPixelLineSetting.getColor().getColor());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl6) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("leading-shift (");
                for (n3 = 0; n3 < n2; ++n3) {
                    barPixelLineSetting = (BarPixelLineSetting)this.pixelLineSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(barPixelLineSetting.getLeadingShift());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl5) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("shading (");
                block10: for (n3 = 0; n3 < n2; ++n3) {
                    barPixelLineSetting = (BarPixelLineSetting)this.pixelLineSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    switch (barPixelLineSetting.getShading().getValue()) {
                        case 1: {
                            stringBuilder2.append(2);
                            continue block10;
                        }
                        case 3: {
                            stringBuilder2.append(1);
                            continue block10;
                        }
                        case 2: {
                            stringBuilder2.append(0);
                            continue block10;
                        }
                        case 4: {
                            stringBuilder2.append(-1);
                            continue block10;
                        }
                        case 0: {
                            stringBuilder2.append(-2);
                        }
                    }
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl7) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("trailing-shift (");
                for (n3 = 0; n3 < n2; ++n3) {
                    barPixelLineSetting = (BarPixelLineSetting)this.pixelLineSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(barPixelLineSetting.getTrailingShift());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        this.horizontal = this.getSize() != 0.0f || this.getSizeVariable() != null;
        if (vector.contains("DOTTED")) {
            this.setDotted(true);
        }
        if (vector.contains("DASHED")) {
            this.setDashed(true);
        }
        if (vector.contains("DOT-DASH")) {
            this.setDotDash(true);
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            int n;
            if (iPropElementList.getKey(i).equals("WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getName());
                continue;
            }
            if (iPropElementList.getKey(i).equals("POSITION-SHIFT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setPositionShift((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setPositionShiftVariable(iPropElementList.getValue(i)[0].getVariableName().getName());
                continue;
            }
            if (iPropElementList.getKey(i).equals("LEADING-SHIFT")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    vector2.add(iPropElementList.getValue(i)[n].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("TRAILING-SHIFT")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    vector3.add(iPropElementList.getValue(i)[n].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("SHADING")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    vector5.add(iPropElementList.getValue(i)[n].getToken().getWord());
                }
                continue;
            }
            if (!iPropElementList.getKey(i).equals("COLORS")) continue;
            for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                vector4.add(iPropElementList.getValue(i)[n].getToken().getWord());
            }
        }
        BarPixelLineSetting barPixelLineSetting = null;
        BarPixelLineSettingList barPixelLineSettingList = null;
        int n = vector5.size();
        if (n < vector4.size()) {
            n = vector4.size();
        }
        if (n < vector2.size()) {
            n = vector2.size();
        }
        if (n < vector3.size()) {
            n = vector3.size();
        }
        for (int i = 0; i < n; ++i) {
            if (barPixelLineSettingList == null) {
                barPixelLineSettingList = new BarPixelLineSettingList();
            }
            barPixelLineSetting = new BarPixelLineSetting();
            if (vector2.size() > i) {
                barPixelLineSetting.setLeadingShift((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector2.elementAt(i))));
            }
            if (vector3.size() > i) {
                barPixelLineSetting.setTrailingShift((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector3.elementAt(i))));
            }
            if (vector4.size() > i) {
                barPixelLineSetting.setColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector4.elementAt(i)))));
            }
            if (vector5.size() > i) {
                if (((String)vector5.elementAt(i)).equals("-2")) {
                    barPixelLineSetting.setShading(new BarShading(0));
                } else if (((String)vector5.elementAt(i)).equals("2")) {
                    barPixelLineSetting.setShading(new BarShading(1));
                } else if (((String)vector5.elementAt(i)).equals("0")) {
                    barPixelLineSetting.setShading(new BarShading(2));
                } else if (((String)vector5.elementAt(i)).equals("1")) {
                    barPixelLineSetting.setShading(new BarShading(3));
                } else if (((String)vector5.elementAt(i)).equals("-1")) {
                    barPixelLineSetting.setShading(new BarShading(4));
                }
            }
            barPixelLineSettingList.addSetting((SettingItem)barPixelLineSetting);
        }
        if (barPixelLineSettingList != null) {
            this.setPixelLineSettings(barPixelLineSettingList);
        }
    }
}

