/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IGroupAttributes;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractBitmap;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractFrame;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.RibbonPage;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.BooleanChoice;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.DestroyType;
import com.iscobol.screenpainter.beans.types.DimensionUnit;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.ColorPalette;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;

public abstract class AbstractBeanControl
implements Serializable,
ScreenElement,
ResourcesProvider,
TabOrderable {
    private static final long serialVersionUID = 1L;
    private Component comp;
    private String line = "1";
    private String column = "1";
    private String baseCssStyleName;
    private String cssStyleName;
    private float size;
    private float lines;
    private int occurs;
    private int level;
    private float linePixels = 1.0f;
    private float columnPixels = 1.0f;
    private float sizePixels;
    private float linesPixels;
    private boolean lock;
    protected int cellWidth;
    protected FontMetrics metrics;
    protected int fontWidth;
    protected int cellHeight;
    private String hint;
    private String hintVar;
    private String customData;
    private String customDataVar;
    private ColorType color = ColorType.DISABLED_COLOR;
    private ForegroundColorType foregroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType backgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private FontType font;
    private String eventList;
    private BooleanChoice excludeEventList = new BooleanChoice(0);
    private BooleanChoice enabled = new BooleanChoice(0);
    private BooleanChoice visible = new BooleanChoice(0);
    private String name;
    private String key;
    private String lineVar;
    private String linesVar;
    private String sizeVar;
    private String columnVar;
    private String enabledVar;
    private String visibleVar;
    private String helpIdVar;
    private String keyVar;
    private String colorVar;
    private String backgroundColorVar;
    private String foregroundColorVar;
    private String additionalProps;
    private String idVar;
    private boolean noTab;
    private float maxWidth;
    private float maxHeight;
    private float minWidth;
    private float minHeight;
    private String maxWidthVar;
    private String maxHeightVar;
    private String minWidthVar;
    private String minHeightVar;
    private String layoutDataVar;
    private int helpId;
    private int id;
    private String layoutData;
    private int tabOrder;
    private boolean cellEditor;
    private DestroyType destroyType = new DestroyType();
    private ScreenElement parent;
    boolean widthInCells;
    boolean heightInCells;
    private DimensionUnit sizeUnit = new DimensionUnit();
    private DimensionUnit linesUnit = new DimensionUnit();
    private String baseCssStyleNameVar;
    private String cssStyleNameVar;
    private String styleVar;
    protected ColorPalette palette;
    boolean allComponentInScreen;

    public AbstractBeanControl(Component component) {
        this.comp = component;
        this.setComponent(this.comp);
        this.initializeComponent();
    }

    protected void setImportedFromCobol(boolean bl) {
        this.allComponentInScreen = bl;
    }

    protected boolean isImportedFromCobol() {
        return this.allComponentInScreen;
    }

    public FontMetrics metrics() {
        return this.metrics;
    }

    protected void updateSize() {
        if (this.getSize() > 0.0f) {
            this.setSize(this.getSize());
        } else {
            this.setSizePixels(this.getSizePixels());
        }
    }

    protected void updateLines() {
        if (this.getLines() > 0.0f) {
            this.setLines(this.getLines());
        } else {
            this.setLinesPixels(this.getLinesPixels());
        }
    }

    protected void updateLine() {
        if (this.line == null || this.line.length() == 0) {
            this.setLinePixels(this.getLinePixels());
            this.line = "";
        }
    }

    protected void updateColumn() {
        if (this.column == null || this.column.length() == 0) {
            this.setColumnPixels(this.getColumnPixels());
            this.column = "";
        }
    }

    public void setCellSize(int n, int n2) {
        this.cellWidth = n;
        this.updateSize();
        this.updateColumn();
        this.cellHeight = n2;
        this.updateLines();
        this.updateLine();
    }

    public void setMaxHeightPixels(int n) {
        this.maxHeight = (float)n / (float)this.cellHeight;
    }

    public void setMinHeightPixels(int n) {
        this.minHeight = (float)n / (float)this.cellHeight;
    }

    public void setMaxWidthPixels(int n) {
        this.maxWidth = (float)n / (float)this.cellWidth;
    }

    public void setMinWidthPixels(int n) {
        this.minWidth = (float)n / (float)this.cellWidth;
    }

    public void setFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.font, (ResourceWithHandleType)fontType);
        this.font = fontType;
        if (fontType == null || fontType.isNullFont()) {
            fontType = this.getFont(true);
        }
        if (this.comp != null) {
            this.comp.setFont(fontType.getFont());
        }
        this.metrics = this.getComponent().getFontMetrics(fontType.getFont());
        this.fontWidth = Math.round((float)this.metrics.stringWidth("0123456789") / 10.0f);
        this.updateLines();
        this.updateSize();
    }

    public String getFontVariable() {
        return this.font != null ? this.font.getHandleName() : null;
    }

    public void setFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.font == null) {
                this.font = FontType.getNullFont();
            }
            this.font.setHandleName(string);
        } else if (this.font != null) {
            this.font.setHandleName(string);
        }
    }

    public final FontType getFont() {
        return this.getFont(false);
    }

    public final FontType getFont(boolean bl) {
        FontType fontType = this.font;
        if (!bl || fontType != null && !fontType.isNullFont()) {
            return fontType;
        }
        fontType = this.getInheritedFont();
        if (fontType != null) {
            return fontType;
        }
        return this.getDefaultFont();
    }

    public FontType getDefaultFont() {
        return FontType.getStandardFont((String)"default-font");
    }

    protected FontType getInheritedFont() {
        BaseWindow baseWindow = this.getBaseParentWindow();
        if (baseWindow != null) {
            return baseWindow.getFont();
        }
        return null;
    }

    protected Color getDefaultAwtBackgroundColor() {
        return ColorType.STANDARD_COLOR.getBackgroundColor(this.palette);
    }

    protected Color getInheritedAwtBackgroundColor() {
        GroupBeanControl groupBeanControl;
        Color color;
        ScreenElement screenElement = this.getParent();
        if (screenElement instanceof GroupBeanControl && (color = (groupBeanControl = (GroupBeanControl)screenElement).getAwtBackgroundColor()) != null) {
            return color;
        }
        groupBeanControl = this.getBaseParentWindow();
        Color color2 = null;
        if (groupBeanControl != null) {
            color2 = groupBeanControl.getAwtBackgroundColor(null);
        }
        return color2;
    }

    protected Color getDefaultAwtForegroundColor() {
        return ColorType.STANDARD_COLOR.getForegroundColor(this.palette);
    }

    protected Color getInheritedAwtForegroundColor() {
        GroupBeanControl groupBeanControl;
        Color color;
        ScreenElement screenElement = this.getParent();
        if (screenElement instanceof GroupBeanControl && (color = (groupBeanControl = (GroupBeanControl)screenElement).getAwtForegroundColor()) != null) {
            return color;
        }
        groupBeanControl = this.getBaseParentWindow();
        Color color2 = null;
        if (groupBeanControl != null) {
            color2 = groupBeanControl.getAwtForegroundColor(null);
        }
        return color2;
    }

    public void setParent(ScreenElement screenElement) {
        this.parent = screenElement;
    }

    public ScreenElement getParent() {
        return this.parent;
    }

    public AbstractBeanWindow getParentWindow() {
        if (this.parent instanceof AbstractBeanWindow) {
            return (AbstractBeanWindow)this.parent;
        }
        if (this.parent != null) {
            return this.parent.getParentWindow();
        }
        return null;
    }

    public BaseWindow getBaseParentWindow() {
        if (this.parent instanceof BaseWindow) {
            return (BaseWindow)this.parent;
        }
        if (this.parent != null) {
            return this.parent.getBaseParentWindow();
        }
        return null;
    }

    protected void initializeComponent() {
        if (this.comp != null) {
            if (this.font == null) {
                this.intSetFont(this.getDefaultFont());
            }
            if (this.color == null || this.color.isDisabled()) {
                this.intSetColor(this.getDefaultAwtBackgroundColor(), this.getDefaultAwtForegroundColor());
            }
        }
    }

    private void intSetFont(FontType fontType) {
        this.comp.setFont(fontType.getFont());
        this.metrics = this.getComponent().getFontMetrics(fontType.getFont());
        this.fontWidth = Math.round((float)this.metrics.stringWidth("0123456789") / 10.0f);
    }

    protected void setComponent(Component component) {
        this.comp = component;
        if (this.comp != null) {
            this.comp.enableInputMethods(false);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void refreshComponent() {
        this.intSetFont(this.getFont(true));
        this.intSetColor(this.getAwtBackgroundColor(), this.getAwtForegroundColor());
        this.intSetEnabled(this.enabled);
    }

    public void setColor(ColorType colorType) {
        this.color = colorType;
        this.intSetColor(this.getAwtBackgroundColor(), this.getAwtForegroundColor());
    }

    public ForegroundColorType getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(ForegroundColorType foregroundColorType) {
        this.foregroundColor = foregroundColorType;
        this.intSetColor(this.getAwtBackgroundColor(), this.getAwtForegroundColor());
    }

    public BackgroundColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColorType backgroundColorType) {
        this.backgroundColor = backgroundColorType;
        this.intSetColor(this.getAwtBackgroundColor(), this.getAwtForegroundColor());
    }

    public String getBackgroundColorVariable() {
        return this.backgroundColorVar;
    }

    public void setBackgroundColorVariable(String string) {
        this.backgroundColorVar = string;
    }

    public String getForegroundColorVariable() {
        return this.foregroundColorVar;
    }

    public void setForegroundColorVariable(String string) {
        this.foregroundColorVar = string;
    }

    protected void intSetColor(Color color, Color color2) {
        if (this.comp != null) {
            if (color != null) {
                this.comp.setBackground(color);
            } else if (this.isUserWhite()) {
                this.comp.setBackground(Color.white);
            } else {
                this.comp.setBackground(SystemColor.control);
            }
            if (color2 != null) {
                this.comp.setForeground(color2);
            } else {
                this.comp.setForeground(Color.black);
            }
        }
    }

    public final ColorType getColor() {
        return this.color;
    }

    protected Color getAwtBackgroundColor() {
        if (this.backgroundColor != null && !this.backgroundColor.isDisabled()) {
            return this.backgroundColor.getBackgroundColor(this.palette);
        }
        if (this.color != null && !this.color.isDisabled()) {
            return this.color.getBackgroundColor(this.palette);
        }
        Color color = this.getInheritedAwtBackgroundColor();
        if (color != null) {
            return color;
        }
        return this.getDefaultAwtBackgroundColor();
    }

    protected Color getAwtForegroundColor() {
        if (this.foregroundColor != null && !this.foregroundColor.isDisabled()) {
            return this.foregroundColor.getForegroundColor(this.palette);
        }
        if (this.color != null && !this.color.isDisabled()) {
            return this.color.getForegroundColor(this.palette);
        }
        Color color = this.getInheritedAwtForegroundColor();
        if (color != null) {
            return color;
        }
        return this.getDefaultAwtForegroundColor();
    }

    public float getLinePixels() {
        float f = -1.0f;
        boolean[] blArray = new boolean[1];
        try {
            f = IscobolBeanConstants.parseCoordinate((String)this.line, (boolean[])blArray);
        }
        catch (Exception exception) {
            return this.linePixels;
        }
        this.setLine(f, blArray[0]);
        return this.linePixels;
    }

    protected void setBounds(int n, int n2, int n3, int n4) {
        if (this.comp != null) {
            this.comp.setBounds(n, n2, n3, n4);
        }
    }

    public String getIdVariable() {
        return this.idVar;
    }

    public void setIdVariable(String string) {
        this.idVar = string;
    }

    public boolean isCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(boolean bl) {
        this.cellEditor = bl;
    }

    public void setLinesPixels(float f) {
        this.linesPixels = f;
        this.lines = 0.0f;
        if (this.isLinesUnitPixel() || this.isLinesUnitCell()) {
            if (this.cellHeight > 0) {
                this.lines = f / (float)this.cellHeight;
            }
        } else {
            this.lines = this.getControlHeight((int)this.linesPixels);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public void setLinePixels(float f) {
        this.linePixels = f;
        if (this.cellHeight > 0) {
            this.line = Float.toString((f - 1.0f) / (float)this.cellHeight + 1.0f);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public void setLinePixels(int n) {
        this.setLinePixels((float)n);
    }

    public void setSizePixels(int n) {
        this.setSizePixels((float)n);
    }

    public void setColumnPixels(int n) {
        this.setColumnPixels((float)n);
    }

    public void setLinesPixels(int n) {
        this.setLinesPixels((float)n);
    }

    private float parseColumn(boolean[] blArray) {
        float f;
        if (this.column != null && this.column.length() > 0) {
            try {
                f = IscobolBeanConstants.parseCoordinate((String)this.column, (boolean[])blArray);
            }
            catch (Exception exception) {
                f = -1.0f;
            }
        } else if (this.line != null && this.line.length() > 0) {
            f = 1.0f;
        } else {
            f = 0.0f;
            blArray[0] = true;
        }
        return f;
    }

    public float getColumnPixels() {
        boolean[] blArray = new boolean[1];
        float f = this.parseColumn(blArray);
        this.setColumn(f, blArray[0]);
        return this.columnPixels;
    }

    public float getLinesPixels() {
        return this.linesPixels;
    }

    public void setSizePixels(float f) {
        this.sizePixels = f;
        this.size = 0.0f;
        if (this.isSizeUnitPixel() || this.isSizeUnitCell()) {
            if (this.cellWidth > 0) {
                this.size = f / (float)this.cellWidth;
            }
        } else {
            this.size = this.getControlWidth((int)this.sizePixels);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public float getSizePixels() {
        return this.sizePixels;
    }

    public void setColumnPixels(float f) {
        this.columnPixels = f;
        if (this.cellWidth > 0) {
            this.column = Float.toString((f - 1.0f) / (float)this.cellWidth + 1.0f);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public void setLine(float f) {
        this.line = "" + f;
    }

    public void setLine(String string) {
        this.line = string;
    }

    private void setLine(float f, boolean bl) {
        if (this.cellHeight > 0) {
            if (bl) {
                this.linePixels = (int)((float)this.cellHeight * f);
                AbstractBeanControl abstractBeanControl = this.getPreviousControl();
                if (abstractBeanControl != null) {
                    this.linePixels += abstractBeanControl.getLinePixels();
                    if (abstractBeanControl.getOccurs() > 1) {
                        String string = abstractBeanControl.getLine();
                        boolean[] blArray = new boolean[1];
                        float f2 = IscobolBeanConstants.parseCoordinate((String)string, (boolean[])blArray);
                        if (blArray[0]) {
                            this.linePixels += (float)this.cellHeight * f2 * (float)(abstractBeanControl.getOccurs() - 1);
                        }
                    }
                } else if (this.parent instanceof GroupBeanControl) {
                    this.linePixels += ((GroupBeanControl)this.parent).getLinePixels();
                }
                this.linePixels -= 1.0f;
            } else {
                this.linePixels = Math.round((float)this.cellHeight * (f - 1.0f) + 1.0f);
            }
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public float getSize() {
        return this.size;
    }

    public float getLines() {
        return this.lines;
    }

    public String getLine() {
        return this.line;
    }

    protected float getRealLine() {
        boolean[] blArray = new boolean[1];
        float f = IscobolBeanConstants.parseCoordinate((String)this.line, (boolean[])blArray);
        if (blArray[0] && this.getParent() instanceof GroupBeanControl) {
            AbstractBeanControl abstractBeanControl = this.getPreviousControl();
            GroupBeanControl groupBeanControl = (GroupBeanControl)this.getParent();
            if (abstractBeanControl != null) {
                f += abstractBeanControl.getRealLine();
                if (abstractBeanControl.getOccurs() > 1) {
                    String string = abstractBeanControl.getLine();
                    float f2 = IscobolBeanConstants.parseCoordinate((String)string, (boolean[])blArray);
                    if (blArray[0]) {
                        f += f2 * (float)(abstractBeanControl.getOccurs() - 1);
                    }
                }
            } else {
                f += groupBeanControl.getRealLine();
            }
        }
        return f;
    }

    protected float getRealColumn() {
        boolean[] blArray = new boolean[1];
        float f = this.parseColumn(blArray);
        if (blArray[0] && this.getParent() instanceof GroupBeanControl) {
            AbstractBeanControl abstractBeanControl = this.getPreviousControl();
            GroupBeanControl groupBeanControl = (GroupBeanControl)this.getParent();
            if (abstractBeanControl != null) {
                f += abstractBeanControl.getRealColumn() + abstractBeanControl.getSize();
                if (abstractBeanControl.getOccurs() > 1) {
                    String string = abstractBeanControl.getColumn();
                    float f2 = IscobolBeanConstants.parseCoordinate((String)string, (boolean[])blArray);
                    if (blArray[0]) {
                        f += (f2 + abstractBeanControl.getSize()) * (float)(abstractBeanControl.getOccurs() - 1);
                    }
                }
            } else {
                f += groupBeanControl.getRealColumn();
            }
        }
        return f;
    }

    public void setSize(float f) {
        this.size = f;
        if (this.isSizeUnitPixel() || this.isSizeUnitCell()) {
            if (this.cellWidth > 0) {
                this.sizePixels = (float)this.cellWidth * f;
            }
        } else {
            this.sizePixels = this.getControlWidth(this.size);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public void setLines(float f) {
        this.lines = f;
        if (this.isLinesUnitPixel() || this.isLinesUnitCell()) {
            if (this.cellHeight > 0) {
                this.linesPixels = (float)this.cellHeight * f;
            }
        } else {
            this.linesPixels = this.getControlHeight(this.lines);
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public void setColumn(float f) {
        this.column = "" + f;
    }

    public void setColumn(String string) {
        this.column = string;
    }

    AbstractBeanControl getPreviousControl() {
        int n;
        ComponentsContainer componentsContainer = (ComponentsContainer)this.getParent();
        if (componentsContainer != null && (n = componentsContainer.indexOfComponent(this) - 1) >= 0) {
            AbstractBeanControl abstractBeanControl = componentsContainer.getComponentAt(n);
            while (abstractBeanControl instanceof GroupBeanControl) {
                GroupBeanControl groupBeanControl = (GroupBeanControl)abstractBeanControl;
                if (groupBeanControl.getComponentCount() > 0) {
                    abstractBeanControl = groupBeanControl.getComponentAt(groupBeanControl.getComponentCount() - 1);
                    continue;
                }
                abstractBeanControl = abstractBeanControl.getPreviousControl();
            }
            return abstractBeanControl;
        }
        return null;
    }

    private void setColumn(float f, boolean bl) {
        if (this.cellWidth > 0) {
            if (bl) {
                this.columnPixels = (int)((float)this.cellWidth * (f -= 1.0f));
                AbstractBeanControl abstractBeanControl = this.getPreviousControl();
                if (abstractBeanControl != null) {
                    this.columnPixels += abstractBeanControl.getColumnPixels() + abstractBeanControl.getSizePixels();
                    if (abstractBeanControl.getOccurs() > 1) {
                        String string = abstractBeanControl.getColumn();
                        boolean[] blArray = new boolean[1];
                        float f2 = IscobolBeanConstants.parseCoordinate((String)string, (boolean[])blArray);
                        if (blArray[0]) {
                            this.columnPixels += ((float)this.cellWidth * f2 + abstractBeanControl.getSizePixels()) * (float)(abstractBeanControl.getOccurs() - 1);
                        }
                    }
                } else if (this.parent instanceof GroupBeanControl) {
                    this.columnPixels += ((GroupBeanControl)this.parent).getColumnPixels();
                }
                this.columnPixels -= 1.0f;
            } else {
                this.columnPixels = Math.round((float)this.cellWidth * (f - 1.0f) + 1.0f);
            }
        }
        this.setBounds((int)this.columnPixels - 1, (int)this.linePixels - 1, (int)this.sizePixels, (int)this.linesPixels);
    }

    public String getColumn() {
        return this.column;
    }

    public DimensionUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(DimensionUnit dimensionUnit) {
        this.sizeUnit = dimensionUnit;
        this.updateSize();
    }

    public DimensionUnit getLinesUnit() {
        return this.linesUnit;
    }

    public void setLinesUnit(DimensionUnit dimensionUnit) {
        this.linesUnit = dimensionUnit;
        this.updateLines();
    }

    public String getMaxWidthVariable() {
        return this.maxWidthVar;
    }

    public void setMaxWidthVariable(String string) {
        this.maxWidthVar = string;
    }

    public String getMaxHeightVariable() {
        return this.maxHeightVar;
    }

    public void setMaxHeightVariable(String string) {
        this.maxHeightVar = string;
    }

    public String getMinWidthVariable() {
        return this.minWidthVar;
    }

    public String getLayoutDataVariable() {
        return this.layoutDataVar;
    }

    public void setLayoutDataVariable(String string) {
        this.layoutDataVar = string;
    }

    public String getBaseCssStyleName() {
        return this.baseCssStyleName;
    }

    public void setBaseCssStyleName(String string) {
        this.baseCssStyleName = string;
    }

    public String getBaseCssStyleNameVariable() {
        return this.baseCssStyleNameVar;
    }

    public void setBaseCssStyleNameVariable(String string) {
        this.baseCssStyleNameVar = string;
    }

    public String getCssStyleName() {
        return this.cssStyleName;
    }

    public void setCssStyleName(String string) {
        this.cssStyleName = string;
    }

    public String getCssStyleNameVariable() {
        return this.cssStyleNameVar;
    }

    public void setCssStyleNameVariable(String string) {
        this.cssStyleNameVar = string;
    }

    public void setMinWidthVariable(String string) {
        this.minWidthVar = string;
    }

    public String getMinHeightVariable() {
        return this.minHeightVar;
    }

    public void setMinHeightVariable(String string) {
        this.minHeightVar = string;
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(new BooleanChoice(bl ? 0 : 1));
    }

    public void setEnabled(BooleanChoice booleanChoice) {
        this.enabled = booleanChoice;
        if (this.comp != null) {
            this.intSetEnabled(booleanChoice);
        }
    }

    protected void intSetEnabled(BooleanChoice booleanChoice) {
        AbstractBeanControl abstractBeanControl = this;
        while (booleanChoice.getValue() == 0 && (abstractBeanControl = abstractBeanControl.getParent()) instanceof GroupBeanControl) {
            booleanChoice = ((GroupBeanControl)abstractBeanControl).isEnabled();
        }
        this.comp.setEnabled(booleanChoice.getValue() != 1);
    }

    public BooleanChoice isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean bl) {
        this.setVisible(new BooleanChoice(bl ? 0 : 1));
    }

    public void setVisible(BooleanChoice booleanChoice) {
        this.visible = booleanChoice;
    }

    public boolean hasEvents() {
        return false;
    }

    public BooleanChoice isVisible() {
        return this.visible;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean mustManageGotoEventOnToolbar() {
        return false;
    }

    public boolean isOnToolbar() {
        ScreenElement screenElement;
        for (screenElement = this.getParent(); screenElement != null && !(screenElement instanceof IToolbar); screenElement = screenElement.getParent()) {
        }
        return screenElement instanceof IToolbar;
    }

    public void setLineVariable(String string) {
        this.lineVar = string;
    }

    public String getLineVariable() {
        return this.lineVar;
    }

    public void setLinesVariable(String string) {
        this.linesVar = string;
    }

    public String getLinesVariable() {
        return this.linesVar;
    }

    public void setSizeVariable(String string) {
        this.sizeVar = string;
    }

    public String getSizeVariable() {
        return this.sizeVar;
    }

    public void setColumnVariable(String string) {
        this.columnVar = string;
    }

    public String getColumnVariable() {
        return this.columnVar;
    }

    public void setEnabledVariable(String string) {
        this.enabledVar = string;
    }

    public String getEnabledVariable() {
        return this.enabledVar;
    }

    public void setVisibleVariable(String string) {
        this.visibleVar = string;
    }

    protected ComponentsContainer getRootContainer() {
        for (ScreenElement screenElement = this.getParent(); screenElement != null; screenElement = screenElement.getParent()) {
            if (screenElement instanceof GroupBeanControl) continue;
            return (ComponentsContainer)screenElement;
        }
        return null;
    }

    public String getVisibleVariable() {
        return this.visibleVar;
    }

    public void setNoTab(boolean bl) {
        this.noTab = bl;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    public boolean isNoTab() {
        return this.noTab;
    }

    public void setLayoutData(int n) {
        this.layoutData = "" + n;
    }

    public void setLayoutData(String string) {
        this.layoutData = string;
    }

    public String getLayoutData() {
        return this.layoutData;
    }

    public void setHelpId(int n) {
        this.helpId = n;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(float f) {
        this.maxWidth = f;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(float f) {
        this.maxHeight = f;
    }

    public float getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(float f) {
        this.minWidth = f;
    }

    public float getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(float f) {
        this.minHeight = f;
    }

    public int getHelpId() {
        return this.helpId;
    }

    public void setHelpIdVariable(String string) {
        this.helpIdVar = string;
    }

    public String getHelpIdVariable() {
        return this.helpIdVar;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setTabOrder(int n) {
        this.tabOrder = n;
    }

    public void setTabOrder(int n, boolean bl) {
        this.tabOrder = n;
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getCobolEventList() {
        return this.eventList;
    }

    public void setCobolEventList(String[] stringArray) {
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(',').append(stringArray[i]);
            }
            string = stringBuilder.toString();
        }
        this.setCobolEventList(string);
    }

    public void setCobolEventList(String string) {
        this.eventList = string;
    }

    public BooleanChoice getCobolExcludeEventList() {
        return this.excludeEventList;
    }

    public void setCobolExcludeEventList(boolean bl) {
        this.setCobolExcludeEventList(new BooleanChoice(bl ? 2 : 0));
    }

    public void setCobolExcludeEventList(BooleanChoice booleanChoice) {
        this.excludeEventList = booleanChoice;
    }

    public int getOccurs() {
        return this.occurs;
    }

    public void setOccurs(int n) {
        this.occurs = n;
    }

    protected int getDefaultLevel() {
        int n;
        if (this.parent == null) {
            return 1;
        }
        if (this.parent instanceof AbstractBeanWindow) {
            n = 3;
        } else if (this.parent instanceof AbstractBeanToolbar) {
            n = 3;
        } else if (this.parent instanceof AbstractFrame) {
            n = ((AbstractFrame)this.parent).getLevel();
        } else if (this.parent instanceof RibbonPage) {
            n = 3;
        } else if (this.parent instanceof TabPage) {
            TabPage tabPage = (TabPage)this.parent;
            n = ((AbstractTabbedPane)tabPage.getParent()).getLevel() + 2;
        } else {
            n = this.parent instanceof AbstractRibbon ? 3 : ((GroupBeanControl)this.parent).getLevel() + 2;
        }
        return n;
    }

    public int getLevel() {
        if (this.level > 0) {
            return this.level;
        }
        return this.getDefaultLevel();
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public String getCustomData() {
        return this.customData;
    }

    public void setCustomData(String string) {
        this.customData = string;
    }

    public String getCustomDataVariable() {
        return this.customDataVar;
    }

    public void setCustomDataVariable(String string) {
        this.customDataVar = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getAdditionalProps() {
        return this.additionalProps;
    }

    public void setAdditionalProps(String string) {
        this.additionalProps = string;
    }

    public DestroyType getDestroyType() {
        return this.destroyType;
    }

    public void setDestroyType(DestroyType destroyType) {
        this.destroyType = destroyType;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    public String getHintVariable() {
        return this.hintVar;
    }

    public void setHintVariable(String string) {
        this.hintVar = string;
    }

    public void setKeyVariable(String string) {
        this.keyVar = string;
    }

    public String getKeyVariable() {
        return this.keyVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public String getStyleVariable() {
        return this.styleVar;
    }

    public void setStyleVariable(String string) {
        this.styleVar = string;
    }

    public void setConstraints(int n, int n2, int n3, int n4) {
        this.setColumnPixels(n);
        this.setLinePixels(n2);
        this.setSizePixels(n3);
        this.setLinesPixels(n4);
    }

    public boolean isUserWhite() {
        return false;
    }

    public boolean isTemporary() {
        return this.destroyType.getValue() == 2;
    }

    public boolean isPermanent() {
        return this.destroyType.getValue() == 1;
    }

    public abstract int getType();

    public int getControlHeight(float f) {
        return (int)((float)this.metrics.getHeight() * f);
    }

    public int getControlWidth(float f) {
        return (int)((float)this.fontWidth * f);
    }

    public float getControlHeight(int n) {
        return (float)n / (float)this.metrics.getHeight();
    }

    public float getControlWidth(int n) {
        return (float)n / (float)this.fontWidth;
    }

    public boolean getWidthInCells() {
        return this.widthInCells;
    }

    public void setWidthInCells(boolean bl) {
        this.widthInCells = bl;
        this.updateSize();
    }

    public boolean getHeightInCells() {
        return this.heightInCells;
    }

    public void setHeightInCells(boolean bl) {
        this.heightInCells = bl;
        this.updateLines();
    }

    public boolean isSizeUnitPixel() {
        return this.sizeUnit.getValue() == 3 || this.sizeUnit.getValue() == 0 && (this.getParentWindow() == null || this.getParentWindow().getUnit().getValue() == 1);
    }

    public boolean isSizeUnitCell() {
        BaseWindow baseWindow;
        return this.sizeUnit.getValue() == 2 || this.widthInCells || this.sizeUnit.getValue() == 0 && ((baseWindow = this.getBaseParentWindow()) == null || baseWindow.isCell());
    }

    public boolean isLinesUnitPixel() {
        return this.linesUnit.getValue() == 3 || this.linesUnit.getValue() == 0 && (this.getParentWindow() == null || this.getParentWindow().getUnit().getValue() == 1);
    }

    public boolean isLinesUnitCell() {
        BaseWindow baseWindow;
        return this.linesUnit.getValue() == 2 || this.heightInCells || this.linesUnit.getValue() == 0 && ((baseWindow = this.getBaseParentWindow()) == null || baseWindow.isCell());
    }

    protected void getDimensionCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("size ");
        if (this.isSizeUnitPixel()) {
            if (!bl2 && this.sizeVar != null && this.sizeVar.length() > 0) {
                stringBuilder2.append(this.sizeVar);
            } else {
                stringBuilder2.append(Math.round(this.sizePixels));
            }
            stringBuilder2.append(" pixels ");
        } else {
            BaseWindow baseWindow;
            boolean bl3;
            if (!bl2 && this.sizeVar != null && this.sizeVar.length() > 0) {
                stringBuilder2.append(this.sizeVar);
            } else {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.size, (boolean)bl, (boolean)true));
            }
            boolean bl4 = bl3 = this.sizeUnit.getValue() == 2 || this.sizeUnit.getValue() == 0 && ((baseWindow = this.getBaseParentWindow()) == null || baseWindow.isCell());
            if (bl3) {
                stringBuilder2.append(" cells ");
            }
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("lines ");
        if (this.isLinesUnitPixel()) {
            if (!bl2 && this.linesVar != null && this.linesVar.length() > 0) {
                stringBuilder2.append(this.linesVar);
            } else {
                stringBuilder2.append(Math.round(this.linesPixels));
            }
            stringBuilder2.append(" pixels ");
        } else {
            boolean bl5;
            if (!bl2 && this.linesVar != null && this.linesVar.length() > 0) {
                stringBuilder2.append(this.linesVar);
            } else {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.lines, (boolean)bl, (boolean)true));
            }
            boolean bl6 = bl5 = this.linesUnit.getValue() == 2 || this.linesUnit.getValue() == 0 && (this.getParentWindow() == null || this.getParentWindow().isCell());
            if (bl5) {
                stringBuilder2.append(" cells ");
            }
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
    }

    protected void getLocationCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        boolean bl3;
        char c;
        StringBuilder stringBuilder2;
        boolean bl4;
        AbstractBeanWindow abstractBeanWindow = this.getParentWindow();
        boolean bl5 = bl4 = abstractBeanWindow.getUnit().getValue() == 1;
        if (this.lineVar != null && this.lineVar.length() > 0 || this.line != null && this.line.length() > 0) {
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("line ");
            if (bl4) {
                if (!bl2 && this.lineVar != null && this.lineVar.length() > 0) {
                    stringBuilder2.append(this.lineVar);
                } else {
                    stringBuilder2.append(Math.round(this.calculateLinePixels()));
                }
                stringBuilder2.append(" pixels");
            } else if (!bl2 && this.lineVar != null && this.lineVar.length() > 0) {
                stringBuilder2.append(this.lineVar);
            } else if (this.line != null) {
                c = '\u0000';
                boolean bl6 = bl3 = this.line.length() > 0 && ((c = this.line.charAt(0)) == '+' || c == '-');
                if (bl3) {
                    stringBuilder2.append(c + " ");
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)Float.parseFloat(this.line.substring(1)), (boolean)bl, (boolean)true));
                } else {
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.calculateLine(), (boolean)bl, (boolean)true));
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        if (this.columnVar != null && this.columnVar.length() > 0 || this.column != null && this.column.length() > 0) {
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("column ");
            if (bl4) {
                if (!bl2 && this.columnVar != null && this.columnVar.length() > 0) {
                    stringBuilder2.append(this.columnVar);
                } else {
                    stringBuilder2.append(Math.round(this.calculateColumnPixels()));
                }
                stringBuilder2.append(" pixels");
            } else if (!bl2 && this.columnVar != null && this.columnVar.length() > 0) {
                stringBuilder2.append(this.columnVar);
            } else if (this.column != null) {
                c = '\u0000';
                boolean bl7 = bl3 = this.column.length() > 0 && ((c = this.column.charAt(0)) == '+' || c == '-');
                if (bl3) {
                    stringBuilder2.append(c + " ");
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)Float.parseFloat(this.column.substring(1)), (boolean)bl, (boolean)true));
                } else {
                    stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.calculateColumn(), (boolean)bl, (boolean)true));
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
    }

    public float calculateLine() {
        boolean[] blArray = new boolean[1];
        float f = IscobolBeanConstants.parseCoordinate((String)this.line, (boolean[])blArray);
        return this.calculateLine(f, blArray[0]);
    }

    float calculateLine(float f, boolean bl) {
        ScreenElement screenElement = this.getParent();
        if (!bl || this.lineVar != null) {
            while (screenElement instanceof ComponentsContainer) {
                if (!(screenElement instanceof RibbonPage)) {
                    TabPage tabPage;
                    if (screenElement instanceof TabPage) {
                        tabPage = (TabPage)screenElement;
                        AbstractTabbedPane abstractTabbedPane = (AbstractTabbedPane)tabPage.getParent();
                        f += abstractTabbedPane.getLineToAdd();
                        screenElement = abstractTabbedPane;
                    } else if (screenElement instanceof AbstractFrame) {
                        tabPage = (AbstractFrame)screenElement;
                        f += tabPage.getLineToAdd();
                    }
                }
                screenElement = screenElement.getParent();
            }
        }
        return f;
    }

    public float calculateColumn() {
        boolean[] blArray = new boolean[1];
        float f = this.parseColumn(blArray);
        return this.calculateColumn(f, blArray[0]);
    }

    float calculateColumn(float f, boolean bl) {
        ScreenElement screenElement = this.getParent();
        if (!bl || this.columnVar != null) {
            while (screenElement instanceof ComponentsContainer) {
                if (!(screenElement instanceof RibbonPage)) {
                    TabPage tabPage;
                    if (screenElement instanceof TabPage) {
                        tabPage = (TabPage)screenElement;
                        AbstractTabbedPane abstractTabbedPane = (AbstractTabbedPane)tabPage.getParent();
                        f += abstractTabbedPane.getColToAdd();
                        screenElement = abstractTabbedPane;
                    } else if (screenElement instanceof AbstractFrame) {
                        tabPage = (AbstractFrame)screenElement;
                        f += tabPage.getColToAdd();
                    }
                }
                screenElement = screenElement.getParent();
            }
        }
        return f;
    }

    public float calculateLinePixels() {
        ScreenElement screenElement = this.getParent();
        float f = this.linePixels;
        while (screenElement instanceof ComponentsContainer) {
            if (!(screenElement instanceof RibbonPage)) {
                TabPage tabPage;
                if (screenElement instanceof TabPage) {
                    tabPage = (TabPage)screenElement;
                    AbstractTabbedPane abstractTabbedPane = (AbstractTabbedPane)tabPage.getParent();
                    f += abstractTabbedPane.getLinePixelsToAdd();
                    screenElement = abstractTabbedPane;
                } else if (screenElement instanceof AbstractFrame) {
                    tabPage = (AbstractFrame)screenElement;
                    f += tabPage.getLinePixelsToAdd();
                }
            }
            screenElement = screenElement.getParent();
        }
        return f;
    }

    public float calculateColumnPixels() {
        float f = this.columnPixels;
        ScreenElement screenElement = this.getParent();
        while (screenElement instanceof ComponentsContainer) {
            if (!(screenElement instanceof RibbonPage)) {
                TabPage tabPage;
                if (screenElement instanceof TabPage) {
                    tabPage = (TabPage)screenElement;
                    AbstractTabbedPane abstractTabbedPane = (AbstractTabbedPane)tabPage.getParent();
                    f += abstractTabbedPane.getColPixelsToAdd();
                    screenElement = abstractTabbedPane;
                } else if (screenElement instanceof AbstractFrame) {
                    tabPage = (AbstractFrame)screenElement;
                    f += tabPage.getColPixelsToAdd();
                }
            }
            screenElement = screenElement.getParent();
        }
        return f;
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.allComponentInScreen = bl4;
        return this.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3);
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!this.cellEditor) {
            this.getLocationCode(cobolFormatter, string, stringBuilder, bl, bl3);
            this.getDimensionCode(cobolFormatter, string, stringBuilder, bl, bl3);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.getWidthInCells(), (String)"width-in-cells", (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.getHeightInCells(), (String)"height-in-cells", (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.occurs, (int)0, (String)"occurs", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.colorVar, (ColorType)this.getColor(), (int)0, (String)"color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.backgroundColorVar, (ColorType)this.backgroundColor, (int)0, (String)"background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.foregroundColorVar, (ColorType)this.foregroundColor, (int)0, (String)"foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.getFont(), (String)"font", (String)string, (StringBuilder)stringBuilder);
        if (!this.cellEditor) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.visibleVar, (int)(this.visible.getValue() - 1), (int)-1, (String)"visible", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.enabledVar, (int)(this.enabled.getValue() - 1), (int)-1, (String)"enabled", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.helpIdVar, (int)this.helpId, (int)0, (String)"help-id", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.idVar, (int)this.id, (int)0, (String)"id", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.keyVar, (String)this.key, (String)"key", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.baseCssStyleNameVar, (String)this.baseCssStyleName, (String)"css-base-style-name", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.cssStyleNameVar, (String)this.cssStyleName, (String)"css-style-name", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        if (!this.cellEditor) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxWidthVar, (float)this.maxWidth, (float)0.0f, (boolean)bl, (String)"max-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.minWidthVar, (float)this.minWidth, (float)0.0f, (boolean)bl, (String)"min-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.minHeightVar, (float)this.minHeight, (float)0.0f, (boolean)bl, (String)"min-height", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxHeightVar, (float)this.maxHeight, (float)0.0f, (boolean)bl, (String)"max-height", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            if (!bl3 && this.layoutDataVar != null && this.layoutDataVar.length() > 0) {
                stringBuilder.append(cobolFormatter.formatLine(string + "layout-data " + this.layoutDataVar));
            } else if (this.layoutData != null && this.layoutData.length() > 0) {
                IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)IscobolBeanConstants.removeLineDelimiters((String)this.layoutData), (String)"layout-data", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)false);
            }
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isTemporary(), (String)"temporary", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isPermanent(), (String)"permanent", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoTab(), (String)"no-tab", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.hintVar, (String)this.hint, (String)"hint", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.customDataVar, (String)this.customData, (String)"custom-data", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        if (!bl3) {
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.styleVar, (String)"style", (String)string, (StringBuilder)stringBuilder);
        }
        if (this.eventList != null && this.eventList.length() > 0) {
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("event-list ( ");
            stringBuilder2.append(this.eventList.replace(',', ' '));
            stringBuilder2.append(" )");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)(this.excludeEventList.getValue() - 1), (int)-1, (String)"exclude-event-list", (String)string, (StringBuilder)stringBuilder);
        if (!bl3 && this.additionalProps != null && this.additionalProps.length() > 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(this.additionalProps));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(cobolFormatter.formatLine(string + string2));
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public Vector<Integer> getControlExceptionValues() {
        return new Vector<Integer>();
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.id > 0) {
            vector.add(new Integer(this.id));
        }
        return vector;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        this.allComponentInScreen = true;
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        Vector vector2 = iScreenAttribute.getScreenPosition();
        String string = iVariableDeclarationScreen.getName().toUpperCase();
        int n2 = -1;
        int n3 = iCompiler.getControlTypeNames().indexOf(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (n3 < 0) {
            this.setName(iVariableDeclarationScreen.getName());
        } else {
            this.setName("");
        }
        IGroupAttributes iGroupAttributes = null;
        boolean bl9 = false;
        if (this instanceof AbstractButton || this instanceof AbstractBitmap) {
            for (n = 0; n < iPropElementList.size(); ++n) {
                if (!iPropElementList.getKey(n).equals("BITMAP-HANDLE")) continue;
                bl9 = true;
                break;
            }
        }
        if (this.sizeUnit == null) {
            this.setSizeUnit(new DimensionUnit(1));
        }
        if (this.linesUnit == null) {
            this.setLinesUnit(new DimensionUnit(1));
        }
        this.setLine(null);
        this.setColumn(null);
        if (!vector2.isEmpty()) {
            for (n = 0; n < vector2.size(); ++n) {
                iGroupAttributes = (IGroupAttributes)vector2.elementAt(n);
                if (iGroupAttributes.getName().equalsIgnoreCase("Line")) {
                    if (iGroupAttributes.getSignAttr() != null && iGroupAttributes.getSignAttr().getWord().equals("+")) {
                        if (iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10002 || iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10017) {
                            this.setLine("+" + iGroupAttributes.getExprAttr().getKeyWord().getWord().replace(',', '.'));
                            continue;
                        }
                        PluginUtilities.log((String)("BeanControl Line expression not allowed for[" + this.name + "] in this release!"));
                        continue;
                    }
                    if (iGroupAttributes.getExprAttr() != null) {
                        if (iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10002 || iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10017) {
                            this.setLine(iGroupAttributes.getExprAttr().getKeyWord().getWord());
                            continue;
                        }
                        this.setLineVariable(iGroupAttributes.getExprAttr().getKeyWord().getWord());
                        continue;
                    }
                    if (iGroupAttributes.getVAttr() != null) {
                        this.setLineVariable(iGroupAttributes.getVAttr().getName());
                        continue;
                    }
                    PluginUtilities.log((String)("BeanControl no Line expression found for[" + this.name + "]!"));
                    continue;
                }
                if (!iGroupAttributes.getName().equalsIgnoreCase("Column")) continue;
                if (iGroupAttributes.getSignAttr() != null && iGroupAttributes.getSignAttr().getWord().equals("+")) {
                    if (iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10002 || iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10017) {
                        this.setColumn("+" + iGroupAttributes.getExprAttr().getKeyWord().getWord().replace(',', '.'));
                        continue;
                    }
                    PluginUtilities.log((String)("BeanControl Column expression not allowed for[" + this.name + "] in this release!"));
                    continue;
                }
                if (iGroupAttributes.getExprAttr() != null) {
                    if (iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10002 || iGroupAttributes.getExprAttr().getKeyWord().getToknum() == 10017) {
                        this.setColumn(iGroupAttributes.getExprAttr().getKeyWord().getWord());
                        continue;
                    }
                    this.setColumnVariable(iGroupAttributes.getExprAttr().getKeyWord().getWord());
                    continue;
                }
                if (iGroupAttributes.getVAttr() != null) {
                    this.setColumnVariable(iGroupAttributes.getVAttr().getName());
                    continue;
                }
                PluginUtilities.log((String)("BeanControl no Column expression found for[" + this.name + "]!"));
            }
        }
        this.setLevel(iVariableDeclarationScreen.getLevel());
        this.setOccurs(iVariableDeclarationScreen.getOccurs());
        if (iScreenAttribute.getExprSize() != null) {
            if (iScreenAttribute.getSizeInPixel() || this.getSizeUnit().getValue() == 3) {
                this.setSizeUnit(new DimensionUnit(3));
                if (iScreenAttribute.getExprSize().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprSize().getKeyWord().getToknum() == 10017) {
                    this.setSize(0.0f);
                    this.setSizePixels((int)new Float(iScreenAttribute.getExprSize().getKeyWord().getWord().replace(',', '.')).floatValue());
                }
            } else {
                if (iScreenAttribute.getSizeInCell()) {
                    this.setSizeUnit(new DimensionUnit(2));
                }
                if (iScreenAttribute.getExprSize().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprSize().getKeyWord().getToknum() == 10017) {
                    if (bl9 && !iScreenAttribute.getSizeInCell()) {
                        this.setSize(0.0f);
                        this.setSizePixels(new Float(iScreenAttribute.getExprSize().getKeyWord().getWord().replace(',', '.')).floatValue());
                        this.setSizeUnit(new DimensionUnit(3));
                    } else {
                        this.setSize(new Float(iScreenAttribute.getExprSize().getKeyWord().getWord().replace(',', '.')).floatValue());
                    }
                }
            }
        } else if (iScreenAttribute.getVSize() != null) {
            this.setSizeVariable(iScreenAttribute.getVSize().getNameIde());
            if (iScreenAttribute.getSizeInCell()) {
                this.setSizeUnit(new DimensionUnit(2));
            } else if (iScreenAttribute.getSizeInPixel()) {
                this.setSizeUnit(new DimensionUnit(3));
            }
        }
        if (iScreenAttribute.getExprColor() != null && (iScreenAttribute.getExprColor().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprColor().getKeyWord().getToknum() == 10017)) {
            n2 = (int)new Float(iScreenAttribute.getExprColor().getKeyWord().getWord().replace(',', '.')).floatValue();
        } else if (iScreenAttribute.getVColor() != null) {
            this.setColorVariable(iScreenAttribute.getVColor().getNameIde());
        }
        if (iScreenAttribute.getExprLines() != null) {
            if (iScreenAttribute.getLinesInPixel() || this.getSizeUnit().getValue() == 3) {
                this.setLinesUnit(new DimensionUnit(3));
                if (iScreenAttribute.getExprLines().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprLines().getKeyWord().getToknum() == 10017) {
                    this.setLines(0.0f);
                    this.setLinesPixels(new Float(iScreenAttribute.getExprLines().getKeyWord().getWord().replace(',', '.')).floatValue());
                }
            } else {
                if (iScreenAttribute.getLinesInCell()) {
                    this.setLinesUnit(new DimensionUnit(2));
                }
                if (iScreenAttribute.getExprLines().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprLines().getKeyWord().getToknum() == 10017) {
                    if (bl9 && !iScreenAttribute.getLinesInCell()) {
                        this.setLines(0.0f);
                        this.setLinesPixels(new Float(iScreenAttribute.getExprLines().getKeyWord().getWord().replace(',', '.')).floatValue());
                        this.setLinesUnit(new DimensionUnit(3));
                    } else {
                        this.setLines(new Float(iScreenAttribute.getExprLines().getKeyWord().getWord().replace(',', '.')).floatValue());
                    }
                }
            }
        } else if (iScreenAttribute.getVLines() != null) {
            this.setLinesVariable(iScreenAttribute.getVLines().getNameIde());
            if (iScreenAttribute.getLinesInCell()) {
                this.setLinesUnit(new DimensionUnit(2));
            } else if (iScreenAttribute.getLinesInPixel()) {
                this.setLinesUnit(new DimensionUnit(3));
            }
        }
        if (iScreenAttribute.getAttrID() != null) {
            if (iScreenAttribute.getAttrID().getToknum() == 10002 || iScreenAttribute.getAttrID().getToknum() == 10002) {
                this.setId(Integer.parseInt(iScreenAttribute.getAttrID().getAsInt()));
            } else {
                this.setIdVariable(iScreenAttribute.getAttrID().getWord());
            }
        }
        if (iScreenAttribute.getVFont() != null) {
            this.setFontVariable(iScreenAttribute.getVFont().getNameIde());
        }
        if (iScreenAttribute.getAttrHIGHLIGHT()) {
            bl = true;
        }
        if (iScreenAttribute.getAttrBACKHIGHT()) {
            bl3 = true;
        }
        if (iScreenAttribute.getAttrBACKLOW()) {
            bl4 = true;
        }
        if (iScreenAttribute.getAttrLOWLIGHT()) {
            bl2 = true;
        }
        if (iScreenAttribute.getAttrENABLED()) {
            if (iScreenAttribute.getVEnabled() != null) {
                this.setEnabledVariable(iScreenAttribute.getVEnabled().getNameIde().toString());
            } else {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
        if (iScreenAttribute.getAttrREVERSE()) {
            bl5 = true;
        }
        if (iScreenAttribute.getAttrBLINK()) {
            bl7 = true;
        }
        if (iScreenAttribute.getAttrUNDERLINE()) {
            bl8 = true;
        }
        if (iScreenAttribute.getAttrVISIBLE()) {
            if (iScreenAttribute.getVVisible() != null) {
                this.setVisibleVariable(iScreenAttribute.getVVisible().getNameIde().toString());
            } else {
                this.visible.setValue(2);
            }
        } else {
            this.visible.setValue(1);
        }
        if (n2 != -1 || bl3 || bl4 || bl || bl2 || bl5 || bl7 || bl8) {
            this.setColor(new ColorType(n2, bl3, bl4, bl, bl2, bl5, bl6, bl7, bl8));
        }
        if (iScreenAttribute.getExprBackgroundColor() != null) {
            n = (int)new Float(iScreenAttribute.getExprBackgroundColor().getKeyWord().getWord().replace(',', '.')).floatValue();
            if (iScreenAttribute.getAttrBACK_RGB()) {
                this.setBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)n));
            } else if (n < 0) {
                this.setBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)(-n)));
            } else {
                this.setBackgroundColor(new BackgroundColorType(n));
            }
        } else if (iScreenAttribute.getVBackground() != null) {
            this.setBackgroundColorVariable(iScreenAttribute.getVBackground().getNameIde());
        }
        if (iScreenAttribute.getExprForegroundColor() != null) {
            n = (int)new Float(iScreenAttribute.getExprForegroundColor().getKeyWord().getWord().replace(',', '.')).floatValue();
            if (iScreenAttribute.getAttrFORE_RGB()) {
                this.setForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)n));
            } else if (n < 0) {
                this.setForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)(-n)));
            } else {
                this.setForegroundColor(new ForegroundColorType(n));
            }
        } else if (iScreenAttribute.getVForeground() != null) {
            this.setForegroundColorVariable(iScreenAttribute.getVForeground().getNameIde());
        }
        if (vector.contains("HEIGHT-IN-CELLS")) {
            this.setHeightInCells(true);
        }
        if (vector.contains("WIDTH-IN-CELLS")) {
            this.setWidthInCells(true);
        }
        if (vector.contains("NO-TAB")) {
            this.setNoTab(true);
        }
        for (n = 0; n < iPropElementList.size(); ++n) {
            if (iPropElementList.getKey(n).equals("HINT")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    if (iPropElementList.getValue(n)[0].getToken().getWord().length() > 1 && (iPropElementList.getValue(n)[0].getToken().getWord().charAt(0) == '\"' || iPropElementList.getValue(n)[0].getToken().getWord().charAt(0) == '\'')) {
                        if (!iPropElementList.getValue(n)[0].getToken().isResource()) {
                            this.setHint(iPropElementList.getValue(n)[0].getToken().getWord().substring(1, iPropElementList.getValue(n)[0].getToken().getWord().length() - 1));
                            continue;
                        }
                        this.setHint("R" + iPropElementList.getValue(n)[0].getToken().getWord());
                        continue;
                    }
                    this.setHint(iPropElementList.getValue(n)[0].getToken().getWord());
                    continue;
                }
                this.setHintVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("CUSTOM-DATA")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    if (iPropElementList.getValue(n)[0].getToken().getWord().length() > 1 && (iPropElementList.getValue(n)[0].getToken().getWord().charAt(0) == '\"' || iPropElementList.getValue(n)[0].getToken().getWord().charAt(0) == '\'')) {
                        if (!iPropElementList.getValue(n)[0].getToken().isResource()) {
                            this.setCustomData(iPropElementList.getValue(n)[0].getToken().getWord().substring(1, iPropElementList.getValue(n)[0].getToken().getWord().length() - 1));
                            continue;
                        }
                        this.setCustomData("R" + iPropElementList.getValue(n)[0].getToken().getWord());
                        continue;
                    }
                    this.setCustomData(iPropElementList.getValue(n)[0].getToken().getWord());
                    continue;
                }
                this.setCustomDataVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("LAYOUT-DATA")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setLayoutData((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                if (iPropElementList.getValue(n)[0].getVariableName() == null) continue;
                this.setLayoutDataVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("MIN-WIDTH")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setMinWidth(Float.parseFloat(iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setMinWidthVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("MAX-WIDTH")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setMaxWidth(Float.parseFloat(iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxWidthVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("MIN-HEIGHT")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setMinHeight(Float.parseFloat(iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setMinWidthVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("MAX-HEIGHT")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setMaxHeight(Float.parseFloat(iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxHeightVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("CSS-BASE-STYLE-NAME")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setBaseCssStyleName(iPropElementList.getValue(n)[0].getToken().getWord());
                    continue;
                }
                this.setBaseCssStyleNameVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("CSS-STYLE-NAME")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setCssStyleName(iPropElementList.getValue(n)[0].getToken().getWord());
                    continue;
                }
                this.setCssStyleNameVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("EVENT-LIST")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < iPropElementList.getValue(n).length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(iPropElementList.getValue(n)[i].getToken().getWord());
                }
                this.eventList = stringBuilder.toString();
                continue;
            }
            if (!iPropElementList.getKey(n).equals("EXCLUDE-EVENT-LIST") || iPropElementList.getValue(n)[0].getToken() == null) continue;
            this.setCobolExcludeEventList(new BooleanChoice((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord())));
        }
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }
}

