/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.beans.types.SPAlignment;
import com.iscobol.screenpainter.beans.types.SPStyle;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.StatusPanelSetting;
import com.iscobol.screenpainter.beans.types.StatusPanelSettingList;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.Vector;

public abstract class AbstractBeanStatusbar
implements ScreenElement,
ResourcesProvider {
    public static final float MINIMUM_STATUS_LINES = 1.5f;
    private FontType font;
    private boolean grip;
    private int panelIndex;
    private String name;
    private String handle;
    private float lines;
    private ColorType color = ColorType.DISABLED_COLOR;
    private ForegroundColorType foregroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType backgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private String colorVar;
    private boolean visible = true;
    private String visibleVariable;
    protected int cellWidth = 10;
    protected int cellHeight = 10;
    private ScreenElement parent;
    private StatusPanelSettingList panelSettings = new StatusPanelSettingList();
    private Component component;
    private String backgroundColorVar;
    private String foregroundColorVar;
    boolean allComponentInScreen;
    private int level;
    protected ColorPalette palette;
    private int id;
    private int helpId;
    private String customData;
    private String customDataVar;
    private String idVar;
    private String helpIdVar;
    private String exceptionProc;
    private String eventProc;
    private String cmdHelpEv;
    private String cmdHelpEx;
    private String otherEv;
    private String otherEx;
    private String popupMenu;
    private String msgStDblclickEv;

    public AbstractBeanStatusbar(Component component) {
        this.component = component;
        if (this.component != null) {
            this.component.enableInputMethods(false);
        }
        this.initializeComponent();
    }

    protected void initializeComponent() {
        this.setLines(1.5f);
        this.setFont(FontType.getStandardFont((String)"Default-Font"));
        this.setColor(ColorType.STANDARD_COLOR);
    }

    public abstract int getType();

    public Component getComponent() {
        return this.component;
    }

    public float getLines() {
        return this.lines;
    }

    public void setLines(float f) {
        this.lines = f;
    }

    public FontType getFont() {
        return this.font;
    }

    public void setFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.font, (ResourceWithHandleType)fontType);
        this.font = fontType;
        this.component.setFont(fontType.getFont());
    }

    public String getFontVariable() {
        return this.font != null ? this.font.getHandleName() : null;
    }

    public void setFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.font == null) {
                this.font = FontType.getNullFont();
            }
            this.font.setHandleName(string);
        } else if (this.font != null) {
            this.font.setHandleName(string);
        }
    }

    public ColorType getColor() {
        return this.color;
    }

    public void setColor(ColorType colorType) {
        if (colorType == null) {
            return;
        }
        this.color = colorType;
        this.intSetColor();
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    private void intSetColor() {
        Color color = null;
        Color color2 = null;
        if (this.getBackgroundColor() != null && !this.getBackgroundColor().isDisabled()) {
            color = this.getBackgroundColor().getBackgroundColor(this.palette);
        } else if (this.getColor() != null && !this.getColor().isDisabled()) {
            color = this.getColor().getBackgroundColor(this.palette);
        }
        if (this.getForegroundColor() != null && !this.getForegroundColor().isDisabled()) {
            color2 = this.getForegroundColor().getForegroundColor(this.palette);
        } else if (this.getColor() != null && !this.getColor().isDisabled()) {
            color2 = this.getColor().getForegroundColor(this.palette);
        }
        if (color != null) {
            this.component.setBackground(color);
        } else {
            this.component.setBackground(SystemColor.control);
        }
        if (color2 != null) {
            this.component.setForeground(color2);
        } else {
            this.component.setForeground(Color.black);
        }
    }

    public void setCellSize(int n, int n2) {
        this.cellWidth = n;
        this.cellHeight = n2;
    }

    public boolean isGrip() {
        return this.grip;
    }

    public void setGrip(boolean bl) {
        this.grip = bl;
    }

    public String getName() {
        return this.name;
    }

    public int getPanelIndex() {
        return this.panelIndex;
    }

    public void setPanelIndex(int n) {
        this.panelIndex = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String string) {
        this.handle = string;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setParent(ScreenElement screenElement) {
        this.parent = screenElement;
    }

    public ScreenElement getParent() {
        return this.parent;
    }

    public AbstractBeanWindow getParentWindow() {
        return (AbstractBeanWindow)this.parent;
    }

    public BaseWindow getBaseParentWindow() {
        return (BaseWindow)this.parent;
    }

    public ForegroundColorType getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(ForegroundColorType foregroundColorType) {
        this.foregroundColor = foregroundColorType;
        this.intSetColor();
    }

    public BackgroundColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColorType backgroundColorType) {
        this.backgroundColor = backgroundColorType;
        this.intSetColor();
    }

    public String getBackgroundColorVariable() {
        return this.backgroundColorVar;
    }

    public void setBackgroundColorVariable(String string) {
        this.backgroundColorVar = string;
    }

    public String getForegroundColorVariable() {
        return this.foregroundColorVar;
    }

    public void setForegroundColorVariable(String string) {
        this.foregroundColorVar = string;
    }

    public StatusPanelSettingList getPanelSettings() {
        return this.panelSettings;
    }

    public void setPanelSettings(StatusPanelSettingList statusPanelSettingList) {
        this.panelSettings = statusPanelSettingList;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ColorType colorType;
        StatusPanelSetting statusPanelSetting;
        if (bl2 && (this.handle == null || this.handle.length() == 0)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        if (bl2) {
            stringBuilder2.append("modify ");
            stringBuilder2.append(this.handle);
        } else {
            stringBuilder2.append("display status-bar");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        String string2 = string + "   ";
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.grip, (String)"grip", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (float)this.lines, (float)1.5f, (boolean)bl, (String)"lines", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)(this.visible ? 1 : 0), (int)1, (String)"visible", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.font, (String)"font", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.colorVar, (ColorType)this.color, (int)0, (String)"color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl4);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.backgroundColorVar, (ColorType)this.backgroundColor, (int)0, (String)"background-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl4);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.foregroundColorVar, (ColorType)this.foregroundColor, (int)0, (String)"foreground-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl4);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.customDataVar, (String)this.customData, (String)"custom-data", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3, (boolean)bl4);
        int n = this.panelSettings.getSettingCount();
        if (n > 0) {
            int n2;
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-widths (");
            for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                stringBuilder2.append(statusPanelSetting.getWidth());
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-style (");
            block22: for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                switch (statusPanelSetting.getStyle().getValue()) {
                    case 0: {
                        stringBuilder2.append(3);
                        continue block22;
                    }
                    case 1: {
                        stringBuilder2.append(1);
                        continue block22;
                    }
                    case 2: {
                        stringBuilder2.append(2);
                    }
                }
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-alignment (");
            block23: for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                switch (statusPanelSetting.getAlignment().getValue()) {
                    case 0: {
                        stringBuilder2.append("\"U\"");
                        continue block23;
                    }
                    case 1: {
                        stringBuilder2.append("\"L\"");
                        continue block23;
                    }
                    case 2: {
                        stringBuilder2.append("\"C\"");
                        continue block23;
                    }
                    case 3: {
                        stringBuilder2.append("\"R\"");
                        continue block23;
                    }
                    case 4: {
                        stringBuilder2.append("\"D\"");
                        continue block23;
                    }
                    case 5: {
                        stringBuilder2.append("\"T\"");
                    }
                }
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-bitmap (");
            for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                colorType = statusPanelSetting.getBitmap();
                if (colorType != null && colorType.getHandleName() != null) {
                    stringBuilder2.append(statusPanelSetting.getBitmap().getHandleName());
                    continue;
                }
                stringBuilder2.append(0);
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-bitmap-width (");
            for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                stringBuilder2.append(statusPanelSetting.getBitmapWidth());
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-bitmap-number (");
            for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                stringBuilder2.append(statusPanelSetting.getBitmapNumber());
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string2);
            stringBuilder2.append("panel-bitmap-alignment (");
            block27: for (n2 = 0; n2 < n; ++n2) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                stringBuilder2.append(" ");
                switch (statusPanelSetting.getBitmapAlignment().getValue()) {
                    case 0: {
                        stringBuilder2.append("\"U\"");
                        continue block27;
                    }
                    case 1: {
                        stringBuilder2.append("\"L\"");
                        continue block27;
                    }
                    case 2: {
                        stringBuilder2.append("\"C\"");
                        continue block27;
                    }
                    case 3: {
                        stringBuilder2.append("\"R\"");
                        continue block27;
                    }
                    case 4: {
                        stringBuilder2.append("\"D\"");
                        continue block27;
                    }
                    case 5: {
                        stringBuilder2.append("\"T\"");
                    }
                }
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        if (!bl2) {
            String string3;
            if (!bl4) {
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.eventProc, (String)"event procedure", (String)string2, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.exceptionProc, (String)"exception procedure", (String)string2, (StringBuilder)stringBuilder);
            }
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.helpIdVar, (int)this.helpId, (int)0, (String)"help-id", (String)string2, (StringBuilder)stringBuilder, (boolean)bl4);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.idVar, (int)this.id, (int)0, (String)"id", (String)string2, (StringBuilder)stringBuilder, (boolean)bl4);
            if (this.popupMenu != null && this.popupMenu.length() > 0 && (string3 = CodeGenerator.findMenuHandle((Menu[])(statusPanelSetting = this.getParentWindow()).getMenus(), (String)this.popupMenu)) != null) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "pop-up menu " + string3));
            }
        }
        if (!bl2 && this.handle != null) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "handle " + this.handle));
        }
        stringBuilder.append(cobolFormatter.formatLine(string + "."));
        n = this.panelSettings.getSettingCount();
        if (n > 0 && this.handle != null) {
            boolean bl5 = true;
            for (int i = 0; i < n; ++i) {
                statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(i);
                colorType = statusPanelSetting.getColor();
                ForegroundColorType foregroundColorType = statusPanelSetting.getForegroundColor();
                BackgroundColorType backgroundColorType = statusPanelSetting.getBackgroundColor();
                if (bl5) {
                    stringBuilder.append(cobolFormatter.formatLine(string + "modify " + this.handle));
                    bl5 = false;
                }
                stringBuilder.append(cobolFormatter.formatLine(string2 + "panel-index " + (i + 1)));
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)statusPanelSetting.getTextVariable(), (String)statusPanelSetting.getText(), (String)"panel-text", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3, (boolean)bl4);
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)statusPanelSetting.getHintVariable(), (String)statusPanelSetting.getHint(), (String)"panel-hint", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3, (boolean)bl4);
                if (colorType != null && !colorType.isDisabled()) {
                    stringBuilder2 = new StringBuilder(string2);
                    if (colorType.isRgb()) {
                        stringBuilder2.append("panel-background-color rgb ");
                        stringBuilder2.append(colorType.getRgbBackground());
                        stringBuilder2.append(" panel-foreground-color rgb ");
                        stringBuilder2.append(colorType.getRgbForeground());
                    } else {
                        stringBuilder2.append("panel-color ");
                        stringBuilder2.append(colorType.getColor());
                    }
                    stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
                }
                if (foregroundColorType != null && !foregroundColorType.isDisabled()) {
                    stringBuilder2 = new StringBuilder(string2);
                    if (foregroundColorType.isRgb()) {
                        stringBuilder2.append("panel-foreground-color rgb ");
                        stringBuilder2.append(foregroundColorType.getRgbForeground());
                    } else {
                        stringBuilder2.append("panel-foreground-color ");
                        stringBuilder2.append(Integer.toString(foregroundColorType.getForeground() - 1));
                    }
                    stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
                }
                if (backgroundColorType == null || backgroundColorType.isDisabled()) continue;
                stringBuilder2 = new StringBuilder(string2);
                if (backgroundColorType.isRgb()) {
                    stringBuilder2.append("   panel-background-color rgb ");
                    stringBuilder2.append(backgroundColorType.getRgbBackground());
                } else {
                    stringBuilder2.append("   panel-background-color ");
                    stringBuilder2.append(Integer.toString(backgroundColorType.getBackground() - 1));
                }
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (!bl5) {
                stringBuilder.append(cobolFormatter.formatLine(string + "."));
            }
        }
        return stringBuilder.toString();
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    public Vector<Integer> getControlIds() {
        return new Vector<Integer>();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public Vector<Integer> getControlExceptionValues() {
        return new Vector<Integer>();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        this.allComponentInScreen = true;
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        this.level = iVariableDeclarationScreen.getLevel();
        if (!iVariableDeclarationScreen.getName().equalsIgnoreCase("STATUS-BAR")) {
            this.setName(iVariableDeclarationScreen.getName());
        } else {
            this.setName("");
        }
        if (iScreenAttribute.getExprLines() != null) {
            this.setLines(new Float(iScreenAttribute.getExprLines().getKeyWord().getWord().replace(',', '.')).floatValue());
        }
        if (iScreenAttribute.getAttrVISIBLE()) {
            if (iScreenAttribute.getVVisible() != null) {
                this.setVisibleVariable(iScreenAttribute.getVVisible().getNameIde().toString());
            } else {
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
        }
        if (iScreenAttribute.getVFont() != null) {
            this.setFont(FontType.getStandardFont((String)iScreenAttribute.getVFont().getNameIde()));
        }
        if (iScreenAttribute.getAttrBACK_RGB()) {
            if (iScreenAttribute.getExprBackgroundColor() != null) {
                this.setBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)((int)new Float(iScreenAttribute.getExprBackgroundColor().getKeyWord().getWord().replace(',', '.')).floatValue())));
            } else if (iScreenAttribute.getVBackground() != null) {
                this.setBackgroundColorVariable(iScreenAttribute.getVBackground().getNameIde());
            }
        } else if (iScreenAttribute.getExprBackgroundColor() != null) {
            this.setBackgroundColor(new BackgroundColorType((int)new Float(iScreenAttribute.getExprBackgroundColor().getKeyWord().getWord().replace(',', '.')).floatValue()));
        } else if (iScreenAttribute.getVBackground() != null) {
            this.setBackgroundColorVariable(iScreenAttribute.getVBackground().getNameIde());
        }
        if (iScreenAttribute.getAttrFORE_RGB()) {
            if (iScreenAttribute.getExprForegroundColor() != null) {
                this.setForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)((int)new Float(iScreenAttribute.getExprForegroundColor().getKeyWord().getWord().replace(',', '.')).floatValue())));
            } else if (iScreenAttribute.getVForeground() != null) {
                this.setForegroundColorVariable(iScreenAttribute.getVForeground().getNameIde());
            }
        } else if (iScreenAttribute.getExprForegroundColor() != null) {
            this.setForegroundColor(new ForegroundColorType((int)new Float(iScreenAttribute.getExprForegroundColor().getKeyWord().getWord().replace(',', '.')).floatValue()));
        } else if (iScreenAttribute.getVForeground() != null) {
            this.setForegroundColorVariable(iScreenAttribute.getVForeground().getNameIde());
        }
        if (iScreenAttribute.getExprColor() != null && (iScreenAttribute.getExprColor().getKeyWord().getToknum() == 10002 || iScreenAttribute.getExprColor().getKeyWord().getToknum() == 10017)) {
            this.color = new ColorType((int)new Float(iScreenAttribute.getExprColor().getKeyWord().getWord().replace(',', '.')).floatValue());
        } else if (iScreenAttribute.getVColor() != null) {
            this.setColorVariable(iScreenAttribute.getVColor().getNameIde());
        }
        if (vector.contains("GRIP")) {
            this.setGrip(true);
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<String> vector3 = new Vector<String>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<String> vector5 = new Vector<String>();
        Vector<Integer> vector6 = new Vector<Integer>();
        Vector<Integer> vector7 = new Vector<Integer>();
        Vector<Integer> vector8 = new Vector<Integer>();
        Vector vector9 = new Vector();
        Vector<Integer> vector10 = new Vector<Integer>();
        Vector<Integer> vector11 = new Vector<Integer>();
        Vector<Integer> vector12 = new Vector<Integer>();
        Vector<String> vector13 = new Vector<String>();
        int n2 = 0;
        for (n = 0; n < iPropElementList.size(); ++n) {
            int n3;
            if (iPropElementList.getKey(n).equals("PANEL-INDEX")) {
                this.setPanelIndex((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-STYLE")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector2.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-TEXT")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    if (iPropElementList.getValue(n)[n3].getToken() != null) {
                        vector3.add(iPropElementList.getValue(n)[n3].getToken().getWord());
                        continue;
                    }
                    vector3.add(iPropElementList.getValue(n)[n3].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-WIDTHS")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector4.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-BITMAP")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector5.add(iPropElementList.getValue(n)[n3].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-BITMAP-NUMBER")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector6.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-BITMAP-WIDTH")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector7.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-BITMAP-ALIGNMENT")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector8.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-COLOR")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector10.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-FOREGROUND-COLOR")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector11.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("PANEL-BACKGROUND-COLOR")) {
                for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                    vector12.add(Integer.valueOf(iPropElementList.getValue(n)[n3].getToken().getWord()));
                }
                continue;
            }
            if (!iPropElementList.getKey(n).equals("PANEL-HINT")) continue;
            for (n3 = 0; n3 < iPropElementList.getValue(n).length; ++n3) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    vector13.add(iPropElementList.getValue(n)[n3].getToken().getWord());
                    continue;
                }
                vector13.add(iPropElementList.getValue(n)[n3].getVariableName().getNameIde());
            }
        }
        StatusPanelSetting statusPanelSetting = null;
        StatusPanelSettingList statusPanelSettingList = null;
        if (vector2.size() > n2) {
            n2 = vector2.size();
        }
        if (vector3.size() > n2) {
            n2 = vector3.size();
        }
        if (vector4.size() > n2) {
            n2 = vector4.size();
        }
        if (vector5.size() > n2) {
            n2 = vector5.size();
        }
        if (vector6.size() > n2) {
            n2 = vector6.size();
        }
        if (vector7.size() > n2) {
            n2 = vector7.size();
        }
        if (vector8.size() > n2) {
            n2 = vector8.size();
        }
        if (vector9.size() > n2) {
            n2 = vector9.size();
        }
        if (vector10.size() > n2) {
            n2 = vector10.size();
        }
        if (vector11.size() > n2) {
            n2 = vector11.size();
        }
        if (vector12.size() > n2) {
            n2 = vector12.size();
        }
        if (vector13.size() > n2) {
            n2 = vector13.size();
        }
        for (n = 0; n < n2; ++n) {
            if (statusPanelSettingList == null) {
                statusPanelSettingList = new StatusPanelSettingList();
            }
            statusPanelSetting = new StatusPanelSetting();
            if (vector2.size() > n) {
                statusPanelSetting.setStyle(new SPStyle(((Integer)vector2.elementAt(n)).intValue()));
            }
            if (vector3.size() > n) {
                if (((String)vector3.elementAt(n)).startsWith("\"") || ((String)vector3.elementAt(n)).startsWith("'")) {
                    statusPanelSetting.setText((String)vector3.elementAt(n));
                } else {
                    statusPanelSetting.setTextVariable((String)vector3.elementAt(n));
                }
            }
            if (vector4.size() > n) {
                statusPanelSetting.setWidth(((Integer)vector4.elementAt(n)).intValue());
            }
            if (vector5.size() > n) {
                statusPanelSetting.setBitmap(new ImageType((String)vector5.elementAt(n), null));
            }
            if (vector6.size() > n) {
                statusPanelSetting.setBitmapNumber(((Integer)vector6.elementAt(n)).intValue());
            }
            if (vector7.size() > n) {
                statusPanelSetting.setBitmapWidth(((Integer)vector7.elementAt(n)).intValue());
            }
            if (vector8.size() > n) {
                statusPanelSetting.setBitmapAlignment(new SPAlignment(((Integer)vector8.elementAt(n)).intValue()));
            }
            if (vector9.size() > n) {
                statusPanelSetting.setAlignment(new SPAlignment(((Integer)vector9.elementAt(n)).intValue()));
            }
            if (vector10.size() > n) {
                statusPanelSetting.setColor(new ColorType(((Integer)vector10.elementAt(n)).intValue()));
            }
            if (vector12.size() > n) {
                statusPanelSetting.setBackgroundColor(new BackgroundColorType(((Integer)vector12.elementAt(n)).intValue()));
            }
            if (vector11.size() > n) {
                statusPanelSetting.setForegroundColor(new ForegroundColorType(((Integer)vector11.elementAt(n)).intValue()));
            }
            if (vector13.size() > n) {
                statusPanelSetting.setHint((String)vector13.elementAt(n));
            }
            statusPanelSettingList.addSetting((SettingItem)statusPanelSetting);
            if (statusPanelSettingList == null) continue;
            this.setPanelSettings(statusPanelSettingList);
        }
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgStDblclickEv, null, (String)"msg-st-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdHelpEv, (String)this.cmdHelpEx, (String)"cmd-help", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StatusPanelSetting statusPanelSetting;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = IscobolBeanConstants.getSpaces((int)n);
        StringBuilder stringBuilder2 = new StringBuilder(string);
        String string2 = cobolFormatter.getLineDelimiter();
        String string3 = this.level > 10 ? "" : "0";
        stringBuilder.append(string + string3 + this.level + " " + this.name + " status-bar" + string2);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        string = string + "   ";
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.colorVar, (ColorType)this.getColor(), (int)0, (String)"color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.backgroundColorVar, (ColorType)this.backgroundColor, (int)0, (String)"background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.foregroundColorVar, (ColorType)this.foregroundColor, (int)0, (String)"foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.getFont(), null, (String)"font", (String)string, (StringBuilder)stringBuilder);
        String string4 = string + "   ";
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.grip, (String)"grip", (String)string4, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (float)this.lines, (float)1.5f, (boolean)bl, (String)"lines", (String)string4, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)(this.visible ? 1 : 0), (int)1, (String)"visible", (String)string4, (StringBuilder)stringBuilder);
        int n3 = this.panelSettings.getSettingCount();
        for (n2 = 0; n2 < n3; ++n2) {
            statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
            if (statusPanelSetting.getStyle().getValue() != 0) {
                bl15 = true;
            }
            if (statusPanelSetting.getBitmap() != null) {
                bl14 = true;
            }
            if (statusPanelSetting.getBitmapNumber() != 0) {
                bl13 = true;
            }
            if (statusPanelSetting.getBitmapWidth() != 0) {
                bl12 = true;
            }
            if (statusPanelSetting.getBitmapAlignment().getValue() != 0) {
                bl11 = true;
            }
            if (statusPanelSetting.getAlignment().getValue() != 0) {
                bl10 = true;
            }
            if (statusPanelSetting.getWidth() != 10) {
                bl9 = true;
            }
            if (statusPanelSetting.getColor() != ColorType.DISABLED_COLOR) {
                bl7 = true;
            }
            if (statusPanelSetting.getBackgroundColor() != BackgroundColorType.DISABLED_COLOR2) {
                bl7 = true;
            }
            if (statusPanelSetting.getForegroundColor() != ForegroundColorType.DISABLED_COLOR2) {
                bl6 = true;
            }
            if (!statusPanelSetting.getText().equalsIgnoreCase("panel") || statusPanelSetting.getTextVariable() != null) {
                bl5 = true;
            }
            if (statusPanelSetting.getHint() == null && statusPanelSetting.getHintVariable() == null) continue;
            bl4 = true;
        }
        n3 = this.panelSettings.getSettingCount();
        if (n3 > 0) {
            String string5;
            ImageType imageType;
            if (bl9) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-widths (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getWidth());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl15) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-style (");
                block23: for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    switch (statusPanelSetting.getStyle().getValue()) {
                        case 0: {
                            stringBuilder2.append("panel-flat");
                            continue block23;
                        }
                        case 1: {
                            stringBuilder2.append("panel-lowered");
                            continue block23;
                        }
                        case 2: {
                            stringBuilder2.append("panel-raised");
                        }
                    }
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl10) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-alignment (");
                block24: for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    switch (statusPanelSetting.getAlignment().getValue()) {
                        case 0: {
                            stringBuilder2.append("\"U\"");
                            continue block24;
                        }
                        case 1: {
                            stringBuilder2.append("\"L\"");
                            continue block24;
                        }
                        case 2: {
                            stringBuilder2.append("\"C\"");
                            continue block24;
                        }
                        case 3: {
                            stringBuilder2.append("\"R\"");
                            continue block24;
                        }
                        case 4: {
                            stringBuilder2.append("\"D\"");
                            continue block24;
                        }
                        case 5: {
                            stringBuilder2.append("\"T\"");
                        }
                    }
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl14) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-bitmap (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    imageType = statusPanelSetting.getBitmap();
                    if (imageType != null && imageType.getHandleName() != null) {
                        stringBuilder2.append(statusPanelSetting.getBitmap().getHandleName());
                        continue;
                    }
                    stringBuilder2.append(0);
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl12) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-bitmap-width (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getBitmapWidth());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl13) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-bitmap-number (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getBitmapNumber());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl11) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-bitmap-alignment (");
                block28: for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    switch (statusPanelSetting.getBitmapAlignment().getValue()) {
                        case 0: {
                            stringBuilder2.append("\"U\"");
                            continue block28;
                        }
                        case 1: {
                            stringBuilder2.append("\"L\"");
                            continue block28;
                        }
                        case 2: {
                            stringBuilder2.append("\"C\"");
                            continue block28;
                        }
                        case 3: {
                            stringBuilder2.append("\"R\"");
                            continue block28;
                        }
                        case 4: {
                            stringBuilder2.append("\"D\"");
                            continue block28;
                        }
                        case 5: {
                            stringBuilder2.append("\"T\"");
                        }
                    }
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (!bl3) {
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.eventProc, (String)"event procedure", (String)string4, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.exceptionProc, (String)"exception procedure", (String)string4, (StringBuilder)stringBuilder);
            }
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.helpIdVar, (int)this.helpId, (int)0, (String)"help-id", (String)string4, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.idVar, (int)this.id, (int)0, (String)"id", (String)string4, (StringBuilder)stringBuilder, (boolean)bl3);
            if (this.popupMenu != null && this.popupMenu.length() > 0 && (string5 = CodeGenerator.findMenuHandle((Menu[])(imageType = this.getParentWindow()).getMenus(), (String)imageType.getPopUpMenu())) != null) {
                stringBuilder.append(cobolFormatter.formatLine(string4 + "pop-up menu " + string5));
            }
            if (this.handle != null) {
                stringBuilder.append(cobolFormatter.formatLine(string4 + "handle " + this.handle));
            }
            if (bl5) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-text (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    if (statusPanelSetting.getTextVariable() != null) {
                        stringBuilder2.append(statusPanelSetting.getTextVariable());
                        continue;
                    }
                    stringBuilder2.append(statusPanelSetting.getText());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl4) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-hint (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    if (statusPanelSetting.getHintVariable() != null) {
                        stringBuilder2.append(statusPanelSetting.getHintVariable());
                        continue;
                    }
                    stringBuilder2.append(statusPanelSetting.getHint());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl7) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-background-color (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getBackgroundColor().toString());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl6) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-foreground-color (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getForegroundColor().toString());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl8) {
                stringBuilder2 = new StringBuilder(string4);
                stringBuilder2.append("panel-color (");
                for (n2 = 0; n2 < n3; ++n2) {
                    statusPanelSetting = (StatusPanelSetting)this.panelSettings.getSettingAt(n2);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(statusPanelSetting.getColor().toString());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        stringBuilder.append(string + "." + string2);
        return stringBuilder.toString();
    }

    public String getVisibleVariable() {
        return this.visibleVariable;
    }

    public void setVisibleVariable(String string) {
        this.visibleVariable = string;
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }

    public String getExceptionProcedure() {
        return this.exceptionProc;
    }

    public void setExceptionProcedure(String string) {
        this.exceptionProc = string;
    }

    public String getEventProcedure() {
        return this.eventProc;
    }

    public void setEventProcedure(String string) {
        this.eventProc = string;
    }

    public String getCmdHelpEv() {
        return this.cmdHelpEv;
    }

    public void setCmdHelpEv(String string) {
        this.cmdHelpEv = string;
    }

    public String getCmdHelpEx() {
        return this.cmdHelpEx;
    }

    public void setCmdHelpEx(String string) {
        this.cmdHelpEx = string;
    }

    public String getOtherEv() {
        return this.otherEv;
    }

    public void setOtherEv(String string) {
        this.otherEv = string;
    }

    public String getOtherEx() {
        return this.otherEx;
    }

    public void setOtherEx(String string) {
        this.otherEx = string;
    }

    public String getPopUpMenu() {
        return this.popupMenu;
    }

    public void setPopUpMenu(String string) {
        this.popupMenu = string;
    }

    public String getMsgStDblclickEv() {
        return this.msgStDblclickEv;
    }

    public void setMsgStDblclickEv(String string) {
        this.msgStDblclickEv = string;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getHelpId() {
        return this.helpId;
    }

    public void setHelpId(int n) {
        this.helpId = n;
    }

    public String getIdVariable() {
        return this.idVar;
    }

    public void setIdVariable(String string) {
        this.idVar = string;
    }

    public String getHelpIdVariable() {
        return this.helpIdVar;
    }

    public void setHelpIdVariable(String string) {
        this.helpIdVar = string;
    }

    public void refreshComponent() {
    }

    public String getCustomData() {
        return this.customData;
    }

    public void setCustomData(String string) {
        this.customData = string;
    }

    public String getCustomDataVariable() {
        return this.customDataVar;
    }

    public void setCustomDataVariable(String string) {
        this.customDataVar = string;
    }
}

