/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.LayoutManager;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Vector;

public abstract class AbstractBeanToolbar
extends BaseWindow
implements TabOrderable,
IToolbar {
    private static final long serialVersionUID = 1L;
    private float lines = 1.0f;
    private int linesPixels;
    private int tabOrder;
    private FontType controlFont;
    private ColorType color = ColorType.DISABLED_COLOR;
    private ForegroundColorType foregroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType backgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private String colorVar;
    private boolean moveable;
    private boolean multiline;
    private String handle;
    private String popupMenu;
    private String linesVar;
    private ScreenElement parent;
    private String backgroundColorVar;
    private String foregroundColorVar;

    public AbstractBeanToolbar() {
        this.setFont(FontType.getStandardFont((String)"Default-Font"));
    }

    public void setPopUpMenu(String string) {
        this.popupMenu = string;
    }

    public String getPopUpMenu() {
        return this.popupMenu;
    }

    public void setCellWidth(int n) {
        this.origCellWidth = n;
        if (this.isCell()) {
            this.updateCellSize();
        }
    }

    public void setCellHeight(int n) {
        this.origCellHeight = n;
        if (this.isCell()) {
            this.updateCellSize();
        }
    }

    public abstract int getType();

    public void setCellSize(int n, int n2) {
        if (this.cellWidth != n) {
            this.cellWidth = n;
        }
        if (this.cellHeight != n2) {
            this.cellHeight = n2;
            this.setLines(this.getLines());
        }
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            abstractBeanControlArray[i].setCellSize(n, n2);
        }
    }

    public void setFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.controlFont, (ResourceWithHandleType)fontType);
        this.controlFont = fontType;
        if (!this.isCell()) {
            this.updateCellSize();
        }
    }

    public FontType getFont() {
        return this.controlFont;
    }

    public String getFontVariable() {
        return this.controlFont != null ? this.controlFont.getHandleName() : null;
    }

    public void setFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.controlFont == null) {
                this.controlFont = FontType.getNullFont();
            }
            this.controlFont.setHandleName(string);
        } else if (this.controlFont != null) {
            this.controlFont.setHandleName(string);
        }
    }

    public void setColor(ColorType colorType) {
        this.color = colorType;
    }

    public ForegroundColorType getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(ForegroundColorType foregroundColorType) {
        this.foregroundColor = foregroundColorType;
    }

    public BackgroundColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColorType backgroundColorType) {
        this.backgroundColor = backgroundColorType;
    }

    public String getBackgroundColorVariable() {
        return this.backgroundColorVar;
    }

    public void setBackgroundColorVariable(String string) {
        this.backgroundColorVar = string;
    }

    public String getForegroundColorVariable() {
        return this.foregroundColorVar;
    }

    public void setForegroundColorVariable(String string) {
        this.foregroundColorVar = string;
    }

    public ColorType getColor() {
        return this.color;
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    public final Color getAwtBackgroundColor(Color color) {
        AbstractBeanWindow abstractBeanWindow;
        Color color2 = null;
        if (this.backgroundColor != null && !this.backgroundColor.isDisabled()) {
            color2 = this.backgroundColor.getBackgroundColor(this.palette);
        }
        if (color2 == null && this.color != null && !this.color.isDisabled()) {
            color2 = this.color.getBackgroundColor(this.palette);
        }
        if (color2 == null && (abstractBeanWindow = this.getParentWindow()) != null) {
            color2 = abstractBeanWindow.getAwtBackgroundColor(null);
        }
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public final Color getAwtForegroundColor(Color color) {
        AbstractBeanWindow abstractBeanWindow;
        Color color2 = null;
        if (this.foregroundColor != null && !this.foregroundColor.isDisabled()) {
            color2 = this.foregroundColor.getForegroundColor(this.palette);
        }
        if (color2 == null && this.color != null && !this.color.isDisabled()) {
            color2 = this.color.getForegroundColor(this.palette);
        }
        if (color2 == null && (abstractBeanWindow = this.getParentWindow()) != null) {
            color2 = abstractBeanWindow.getAwtForegroundColor(null);
        }
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public void setLinesPixels(int n) {
        this.linesPixels = n;
        if (this.cellHeight > 0) {
            this.lines = (float)n / (float)this.cellHeight;
        }
    }

    public int getLinesPixels() {
        return this.linesPixels;
    }

    public int GetLinesPixels() {
        return this.linesPixels;
    }

    public float getLines() {
        return this.lines;
    }

    public void setLines(float f) {
        this.lines = f;
        this.linesPixels = (int)((float)this.cellHeight * f);
    }

    public void addComponent(AbstractBeanControl abstractBeanControl) {
        this.addComponent(-1, abstractBeanControl);
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        super.addComponent(n, abstractBeanControl);
        abstractBeanControl.setCellSize(this.cellWidth, this.cellHeight);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl) {
        this.removeComponent(abstractBeanControl, true);
    }

    public AbstractBeanControl[] getToolbarComponents() {
        return this.getComponents();
    }

    public void setComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.removeAllComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.addComponent(abstractBeanControlArray[i]);
        }
    }

    public String getToolbarHandle() {
        return this.handle;
    }

    public void setToolbarHandle(String string) {
        this.handle = string;
    }

    public void setParent(ScreenElement screenElement) {
        this.parent = screenElement;
    }

    public void setTabOrder(int n) {
        this.setTabOrder(n, true);
    }

    public void setTabOrder(int n, boolean bl) {
        int n2 = this.tabOrder;
        this.tabOrder = n;
        if (this.parent != null && bl) {
            ((AbstractBeanWindow)this.parent).updateTabOrders(this, n2);
        }
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public ScreenElement getParent() {
        return this.parent;
    }

    public AbstractBeanWindow getParentWindow() {
        return (AbstractBeanWindow)this.parent;
    }

    public BaseWindow getBaseParentWindow() {
        return (BaseWindow)this.parent;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("display tool-bar");
        if (this.moveable) {
            stringBuilder2.append(" moveable");
        }
        if (this.multiline) {
            stringBuilder2.append(" multiline");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        String string2 = string + "   ";
        if (this.isCell()) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cellWidthVar, (int)this.cellWidth, (int)0, (String)"cell width", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cellHeightVar, (int)this.cellHeight, (int)0, (String)"cell height", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.controlFont, (String)"control font", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.colorVar, (ColorType)this.color, (int)0, (String)"color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.backgroundColorVar, (ColorType)this.backgroundColor, (int)0, (String)"background-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.foregroundColorVar, (ColorType)this.foregroundColor, (int)0, (String)"foreground-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        stringBuilder2 = new StringBuilder();
        if (!bl3 && this.linesVar != null && this.linesVar.length() > 0) {
            stringBuilder2.append(this.linesVar);
        } else if (this.lines != 1.0f) {
            stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.lines, (boolean)bl, (boolean)true));
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.insert(0, string2 + "lines ");
            if (this.isCell()) {
                stringBuilder2.append(" cells");
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.getCustomDataVariable(), (String)this.getCustomData(), (String)"custom-data", (String)string2, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableLayoutManagerCode((CobolFormatter)cobolFormatter, (LayoutManager)this.getLayoutManager(), (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        if (this.handle != null) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "handle " + this.handle));
        }
        return stringBuilder.toString();
    }

    public String getLinesVariable() {
        return this.linesVar;
    }

    public void setLinesVariable(String string) {
        this.linesVar = string;
    }

    public int getLevel() {
        return 1;
    }

    public void setLevel(int n) {
    }

    public void setCell(boolean bl) {
        if (this.cell != bl) {
            this.cell = bl;
            this.updateCellSize();
        }
    }

    public void updateCellSize() {
        if (this.isCell()) {
            this.setCellSize(this.origCellWidth, this.origCellHeight);
        } else {
            FontMetrics fontMetrics = this.getMeasuringComponent().getFontMetrics(this.controlFont.getFont());
            this.setCellSize(fontMetrics.stringWidth("01234567890") / 10, fontMetrics.getHeight());
        }
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlExceptionValues());
        }
        return vector;
    }
}

