/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.swing.SwingAccordion;
import com.iscobol.screenpainter.beans.swing.SwingBar;
import com.iscobol.screenpainter.beans.swing.SwingBitmap;
import com.iscobol.screenpainter.beans.swing.SwingCheckBox;
import com.iscobol.screenpainter.beans.swing.SwingCheckListBox;
import com.iscobol.screenpainter.beans.swing.SwingComboBox;
import com.iscobol.screenpainter.beans.swing.SwingDateEntry;
import com.iscobol.screenpainter.beans.swing.SwingEntryField;
import com.iscobol.screenpainter.beans.swing.SwingFrame;
import com.iscobol.screenpainter.beans.swing.SwingGrid;
import com.iscobol.screenpainter.beans.swing.SwingJavaBean;
import com.iscobol.screenpainter.beans.swing.SwingLabel;
import com.iscobol.screenpainter.beans.swing.SwingListBox;
import com.iscobol.screenpainter.beans.swing.SwingPushButton;
import com.iscobol.screenpainter.beans.swing.SwingRadioButton;
import com.iscobol.screenpainter.beans.swing.SwingScrollbar;
import com.iscobol.screenpainter.beans.swing.SwingSlider;
import com.iscobol.screenpainter.beans.swing.SwingStatusbar;
import com.iscobol.screenpainter.beans.swing.SwingTab;
import com.iscobol.screenpainter.beans.swing.SwingTreeView;
import com.iscobol.screenpainter.beans.swing.SwingWebBrowser;
import com.iscobol.screenpainter.beans.types.AllowingMessages;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.BackgroundIntensity;
import com.iscobol.screenpainter.beans.types.BooleanChoice;
import com.iscobol.screenpainter.beans.types.CellMeasure;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.DestroyType;
import com.iscobol.screenpainter.beans.types.DockableList;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.GradientOrientation;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.LayoutManager;
import com.iscobol.screenpainter.beans.types.MeasuringControl;
import com.iscobol.screenpainter.beans.types.MeasuringStyle;
import com.iscobol.screenpainter.beans.types.NotificationPosition;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.beans.types.Unit;
import com.iscobol.screenpainter.beans.types.UponDockableLeaf;
import com.iscobol.screenpainter.beans.types.WindowAction;
import com.iscobol.screenpainter.beans.types.WindowType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class AbstractBeanWindow
extends BaseWindow {
    private static final long serialVersionUID = 1L;
    private Vector<IToolbar> toolbars = new Vector();
    private Vector<Menu> menus = new Vector();
    private AbstractBeanStatusbar statusbar;
    private ImageType icon;
    private boolean autoFit = true;
    private float line = 1.0f;
    private float column = 1.0f;
    private float screenLine;
    private float screenColumn;
    private float size;
    private float lines;
    private float maxLines;
    private float maxSize;
    private float minLines;
    private float minSize;
    private int screenLinePixels;
    private int screenColumnPixels;
    private int sizePixels;
    private int linesPixels;
    private int labelOffset = 20;
    private int helpId;
    private String beforeTime;
    private String beforeTimeVar;
    private WindowAction action = new WindowAction();
    private ImageType backgroundImage;
    private FontType controlFont;
    private FontType measuringFont;
    private ColorType color = ColorType.DISABLED_COLOR;
    private ForegroundColorType foregroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType backgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundIntensity backgroundIntensity = new BackgroundIntensity(2);
    private String backgroundColorVar;
    private String foregroundColorVar;
    private BooleanChoice enabled = new BooleanChoice(0);
    private BooleanChoice visible = new BooleanChoice(0);
    private boolean noClose;
    private boolean widthInCells;
    private boolean heightInCells;
    private boolean resizable;
    private boolean autoResize;
    private boolean modeless = true;
    private boolean systemMenu;
    private boolean titleBar = true;
    private boolean graphical;
    private boolean autoMinimize;
    private boolean bindToThread;
    private boolean linkToThread;
    private boolean boxed;
    private boolean eraseScreen;
    private boolean controlsUncropped;
    private boolean scroll;
    private boolean userGray;
    private boolean userWhite;
    private boolean wrap;
    private boolean undecorated;
    private AllowingMessages allowingMessages = new AllowingMessages();
    private CellMeasure cellMeasure = new CellMeasure();
    private MeasuringControl measuringControl = new MeasuringControl();
    private MeasuringStyle measuringStyle = new MeasuringStyle();
    private Unit unit = new Unit();
    private int mouseFlags;
    private String handle;
    private String exceptionProc;
    private String eventProc;
    private String beforeProc;
    private String afterProc;
    private String beforeProcThru;
    private String afterProcThru;
    private String msgIconifiedEv;
    private String msgDeiconifiedEv;
    private String msgCloseEv;
    private String cmdCloseEv;
    private String cmdActivateEv;
    private String ntfResizedEv;
    private String msgMenuInputEv;
    private String msgInitMenuEv;
    private String msgEndMenuEv;
    private String cmdCloseEx;
    private String cmdActivateEx;
    private String ntfResizedEx;
    private String afterCreate;
    private String afterInitData;
    private String afterRoutine;
    private String beforeCreate;
    private String beforeInitData;
    private String afterEndAccept;
    private String beforeRoutine;
    private String additionalProps;
    private String linkTo;
    private String otherEv;
    private String otherEx;
    private String titleVar;
    private String titlePicture;
    private String mouseFlagsVar;
    private String allowingMessagesThread;
    private String title = "Screen";
    private String colorVar;
    private String linesVar;
    private String sizeVar;
    private String screenLineVar;
    private String screenColumnVar;
    private String lineVar;
    private String columnVar;
    private String visibleVar;
    private String enabledVar;
    private String maxLinesVar;
    private String minLinesVar;
    private String maxSizeVar;
    private String minSizeVar;
    private String popupMenu;
    private String mainMenu;
    private WindowType type = new WindowType();
    private DockableList layout = new DockableList();
    private String layoutVar;
    private UponDockableLeaf uponLeaf;
    private String uponLeafVar;
    private String uponMDI;
    private boolean generateDisplayStatement = true;
    private boolean isGraphic;
    private String prefix;
    private String uponVar;
    private GradientOrientation gradientOrientation = new GradientOrientation();
    private String gradientOrientationVar;
    private ForegroundColorType gradientColor1 = ForegroundColorType.DISABLED_COLOR;
    private ForegroundColorType gradientColor2 = ForegroundColorType.DISABLED_COLOR;
    private String gradientColor1Var;
    private String gradientColor2Var;
    private int screenIndex;
    private String screenIndexVar;
    private NotificationPosition notificationPosition = new NotificationPosition();

    public AbstractBeanWindow() {
        this.setFont(FontType.getStandardFont((String)"Default-Font"));
        this.setMeasuringFont(FontType.getStandardFont((String)"Default-Font"));
        this.setSize(64.0f);
        this.setLines(48.0f);
        this.setScreenLine(5.0f);
        this.setScreenColumn(10.0f);
        this.setColor(ColorType.STANDARD_COLOR);
    }

    public boolean getGenerateDisplayStatement() {
        return this.generateDisplayStatement;
    }

    public void setGenerateDisplayStatement(boolean bl) {
        this.generateDisplayStatement = bl;
    }

    public String getWindowHandle() {
        return this.handle;
    }

    public void setWindowHandle(String string) {
        this.handle = string;
    }

    public String getMaxLinesVariable() {
        return this.maxLinesVar;
    }

    public void setMaxLinesVariable(String string) {
        this.maxLinesVar = string;
    }

    public String getMinLinesVariable() {
        return this.minLinesVar;
    }

    public void setMinLinesVariable(String string) {
        this.minLinesVar = string;
    }

    public String getMaxSizeVariable() {
        return this.maxSizeVar;
    }

    public void setMaxSizeVariable(String string) {
        this.maxSizeVar = string;
    }

    public String getMinSizeVariable() {
        return this.minSizeVar;
    }

    public void setMinSizeVariable(String string) {
        this.minSizeVar = string;
    }

    public void setPopUpMenu(String string) {
        this.popupMenu = string;
    }

    public String getPopUpMenu() {
        return this.popupMenu;
    }

    public void setMainMenu(String string) {
        this.mainMenu = string;
    }

    public String getMainMenu() {
        return this.mainMenu;
    }

    public NotificationPosition getNotificationPosition() {
        return this.notificationPosition;
    }

    public void setNotificationPosition(NotificationPosition notificationPosition) {
        this.notificationPosition = notificationPosition;
    }

    public void setWindowType(WindowType windowType) {
        this.type = windowType;
        if (this.type.getValue() == 5) {
            this.setHasSystemMenu(true);
        }
    }

    public WindowType getWindowType() {
        return this.type;
    }

    public void setStatusbar(AbstractBeanStatusbar abstractBeanStatusbar) {
        if (this.statusbar != null) {
            this.statusbar.setParent(null);
        }
        this.statusbar = abstractBeanStatusbar;
        if (this.statusbar != null) {
            this.statusbar.setParent((ScreenElement)this);
        }
    }

    public AbstractBeanStatusbar getStatusbar() {
        return this.statusbar;
    }

    public FontType getFont() {
        return this.controlFont;
    }

    public String getScreenLineVariable() {
        return this.screenLineVar;
    }

    public void setScreenLineVariable(String string) {
        this.screenLineVar = string;
    }

    public String getScreenColumnVariable() {
        return this.screenColumnVar;
    }

    public void setScreenColumnVariable(String string) {
        this.screenColumnVar = string;
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public void setLine(float f) {
        this.line = f;
    }

    public void setLine(String string) {
        try {
            this.line = PropertyDescriptorRegistry.parseFloat((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            this.line = 1.0f;
        }
    }

    public float getLine() {
        return this.line;
    }

    public void setColumn(float f) {
        this.column = f;
    }

    public void setColumn(String string) {
        try {
            this.column = PropertyDescriptorRegistry.parseFloat((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            this.column = 1.0f;
        }
    }

    public float getColumn() {
        return this.column;
    }

    public void setLineVariable(String string) {
        this.lineVar = string;
    }

    public String getLineVariable() {
        return this.lineVar;
    }

    public void setColumnVariable(String string) {
        this.columnVar = string;
    }

    public String getColumnVariable() {
        return this.columnVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    public String getLinesVariable() {
        return this.linesVar;
    }

    public void setLinesVariable(String string) {
        this.linesVar = string;
    }

    public UponDockableLeaf getUponLeaf() {
        return this.uponLeaf;
    }

    public void setUponLeaf(UponDockableLeaf uponDockableLeaf) {
        this.uponLeaf = uponDockableLeaf;
    }

    public String getUponLeafVariable() {
        return this.uponLeafVar;
    }

    public void setUponLeafVariable(String string) {
        this.uponLeafVar = string;
    }

    public String getSizeVariable() {
        return this.sizeVar;
    }

    public void setSizeVariable(String string) {
        this.sizeVar = string;
    }

    public String getVisibleVariable() {
        return this.visibleVar;
    }

    public void setVisibleVariable(String string) {
        this.visibleVar = string;
    }

    public String getEnabledVariable() {
        return this.enabledVar;
    }

    public void setEnabledVariable(String string) {
        this.enabledVar = string;
    }

    public void setColor(ColorType colorType) {
        this.color = colorType;
    }

    public ForegroundColorType getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(ForegroundColorType foregroundColorType) {
        this.foregroundColor = foregroundColorType;
    }

    public BackgroundColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColorType backgroundColorType) {
        this.backgroundColor = backgroundColorType;
    }

    public BackgroundIntensity getBackgroundIntensity() {
        return this.backgroundIntensity;
    }

    public void setBackgroundIntensity(BackgroundIntensity backgroundIntensity) {
        this.backgroundIntensity = backgroundIntensity;
    }

    public String getBackgroundColorVariable() {
        return this.backgroundColorVar;
    }

    public void setBackgroundColorVariable(String string) {
        this.backgroundColorVar = string;
    }

    public String getForegroundColorVariable() {
        return this.foregroundColorVar;
    }

    public void setForegroundColorVariable(String string) {
        this.foregroundColorVar = string;
    }

    public void setFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.controlFont, (ResourceWithHandleType)fontType);
        this.controlFont = fontType;
        if (!this.isCell()) {
            this.updateCellSize();
        }
    }

    public String getFontVariable() {
        return this.controlFont != null ? this.controlFont.getHandleName() : null;
    }

    public void setFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.controlFont == null) {
                this.controlFont = FontType.getNullFont();
            }
            this.controlFont.setHandleName(string);
        } else if (this.controlFont != null) {
            this.controlFont.setHandleName(string);
        }
    }

    public ColorType getColor() {
        return this.color;
    }

    public int getScreenLinePixels() {
        return this.screenLinePixels;
    }

    public void setTitle(String string) {
        this.title = string;
        this.titleBar = string != null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAutoResize(boolean bl) {
        this.autoResize = bl;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setHasSystemMenu(boolean bl) {
        this.systemMenu = bl;
    }

    public boolean getHasSystemMenu() {
        return this.systemMenu;
    }

    public void setHasTitleBar(boolean bl) {
        this.titleBar = bl;
    }

    public boolean getHasTitleBar() {
        return this.titleBar;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setModeless(boolean bl) {
        this.modeless = bl;
    }

    public boolean isModeless() {
        return this.modeless;
    }

    public void setGraphical(boolean bl) {
        this.graphical = bl;
    }

    public boolean isGraphical() {
        return this.graphical;
    }

    public void setCellWidth(int n) {
        if (n > 0) {
            this.origCellWidth = n;
            if (this.isCell() && this.cellMeasure.getValue() == 0) {
                this.updateCellSize();
            }
        }
    }

    public void setCellHeight(int n) {
        if (n > 0) {
            this.origCellHeight = n;
            if (this.isCell() && this.cellMeasure.getValue() == 0) {
                this.updateCellSize();
            }
        }
    }

    private void setCellSize(int n, int n2) {
        int n3;
        if (this.cellWidth != n) {
            this.cellWidth = n;
            this.setSize(this.getSize());
            this.setScreenColumn(this.getScreenColumn());
        }
        if (this.cellHeight != n2) {
            this.cellHeight = n2;
            this.setLines(this.getLines());
            this.setScreenLine(this.getScreenLine());
        }
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (n3 = 0; n3 < abstractBeanControlArray.length; ++n3) {
            abstractBeanControlArray[n3].setCellSize(n, n2);
        }
        for (n3 = 0; n3 < this.menus.size(); ++n3) {
            ((Menu)this.menus.elementAt(n3)).setCellSize(n, n2);
        }
        if (this.statusbar != null) {
            this.statusbar.setCellSize(n, n2);
        }
    }

    public void setLinesPixels(int n) {
        this.linesPixels = n;
        this.lines = (float)n / (float)this.cellHeight;
    }

    public void setScreenLinePixels(int n) {
        if (n != 0) {
            this.screenLinePixels = n;
            this.screenLine = ((float)this.screenLinePixels - 1.0f) / (float)this.cellHeight + 1.0f;
        } else {
            this.screenLinePixels = 0;
            this.screenLine = 0;
        }
    }

    public ImageType getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageType imageType) {
        this.backgroundImage = imageType;
    }

    public int getScreenColumnPixels() {
        return this.screenColumnPixels;
    }

    public int getLinesPixels() {
        return this.linesPixels;
    }

    public void setSizePixels(int n) {
        this.sizePixels = n;
        this.size = (float)n / (float)this.cellWidth;
    }

    public int getSizePixels() {
        return this.sizePixels;
    }

    public void setScreenColumnPixels(int n) {
        if (n != 0) {
            this.screenColumnPixels = n;
            this.screenColumn = ((float)this.screenColumnPixels - 1.0f) / (float)this.cellWidth + 1.0f;
        } else {
            this.screenColumnPixels = 0;
            this.screenColumn = 0;
        }
    }

    public void setScreenLine(float f) {
        if (f != 0.0f) {
            this.screenLine = f;
            this.screenLinePixels = (int)((float)this.cellHeight * (this.screenLine - 1.0f)) + 1;
        } else {
            this.screenLinePixels = 0;
            this.screenLine = 0;
        }
    }

    public int getScreenIndex() {
        return this.screenIndex;
    }

    public void setScreenIndex(int n) {
        this.screenIndex = n;
    }

    public String getScreenIndexVariable() {
        return this.screenIndexVar;
    }

    public void setScreenIndexVariable(String string) {
        this.screenIndexVar = string;
    }

    public float getSize() {
        return this.size;
    }

    public float getLines() {
        return this.lines;
    }

    public float getScreenLine() {
        return this.screenLine;
    }

    public void setSize(float f) {
        this.size = f;
        this.sizePixels = (int)((float)this.cellWidth * f);
    }

    public void setLines(float f) {
        this.lines = f;
        this.linesPixels = (int)((float)this.cellHeight * f);
    }

    public void setScreenColumn(float f) {
        if (f != 0.0f) {
            this.screenColumn = f;
            this.screenColumnPixels = (int)((float)this.cellWidth * (this.screenColumn - 1.0f)) + 1;
        } else {
            this.screenColumnPixels = 0;
            this.screenColumn = 0;
        }
    }

    public float getScreenColumn() {
        return this.screenColumn;
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(new BooleanChoice(bl ? 0 : 1));
    }

    public void setEnabled(BooleanChoice booleanChoice) {
        this.enabled = booleanChoice;
    }

    public BooleanChoice isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean bl) {
        this.setVisible(new BooleanChoice(bl ? 0 : 1));
    }

    public void setVisible(BooleanChoice booleanChoice) {
        this.visible = booleanChoice;
    }

    public BooleanChoice isVisible() {
        return this.visible;
    }

    public void setParent(ScreenElement screenElement) {
    }

    public ScreenElement getParent() {
        return null;
    }

    public AbstractBeanWindow getParentWindow() {
        return this;
    }

    public BaseWindow getBaseParentWindow() {
        return this;
    }

    public float getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(float f) {
        this.maxLines = f;
    }

    public void setMaxLinesPixels(int n) {
        this.maxLines = (float)n / (float)this.cellHeight;
    }

    public void setMinLinesPixels(int n) {
        this.minLines = (float)n / (float)this.cellHeight;
    }

    public void setMaxSizePixels(int n) {
        this.maxSize = (float)n / (float)this.cellWidth;
    }

    public void setMinSizePixels(int n) {
        this.minSize = (float)n / (float)this.cellWidth;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(float f) {
        this.maxSize = f;
    }

    public float getMinLines() {
        return this.minLines;
    }

    public void setMinLines(float f) {
        this.minLines = f;
    }

    public float getMinSize() {
        return this.minSize;
    }

    public void setMinSize(float f) {
        this.minSize = f;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(int n) {
        this.labelOffset = n;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
    }

    public String getBeforeTimeVariable() {
        return this.beforeTimeVar;
    }

    public void setBeforeTimeVariable(String string) {
        this.beforeTimeVar = string;
    }

    public String getBeforeTime() {
        return this.beforeTime;
    }

    public int getBeforeTimeAsInt() {
        if (this.beforeTime != null && this.beforeTime.length() > 0) {
            try {
                return Integer.parseInt(this.beforeTime);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return -1;
    }

    public void setBeforeTime(String string) {
        this.beforeTime = string;
        if (string != null && string.length() > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.beforeTime = "0";
            }
        }
    }

    public final Color getAwtBackgroundColor(Color color) {
        Color color2 = null;
        if (this.backgroundColor != null && !this.backgroundColor.isDisabled()) {
            color2 = this.backgroundColor.getBackgroundColor(this.palette);
        }
        if (color2 == null && this.color != null && !this.color.isDisabled()) {
            if (this.backgroundIntensity.getValue() == 2 && !this.color.isBackLow()) {
                this.color.setBackLow(true);
                color2 = this.color.getBackgroundColor(this.palette);
                this.color.setBackLow(false);
            } else if (this.backgroundIntensity.getValue() == 1 && !this.color.isBackHigh()) {
                this.color.setBackHigh(true);
                color2 = this.color.getBackgroundColor(this.palette);
                this.color.setBackHigh(false);
            } else {
                color2 = this.color.getBackgroundColor(this.palette);
            }
        }
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public final Color getAwtForegroundColor(Color color) {
        Color color2 = null;
        if (this.foregroundColor != null && !this.foregroundColor.isDisabled()) {
            color2 = this.foregroundColor.getForegroundColor(this.palette);
        }
        if (color2 == null && this.color != null && !this.color.isDisabled()) {
            color2 = this.color.getForegroundColor(this.palette);
        }
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public WindowAction getAction() {
        return this.action;
    }

    public void setAction(WindowAction windowAction) {
        this.action = windowAction;
    }

    public int getHelpId() {
        return this.helpId;
    }

    public void setHelpId(int n) {
        this.helpId = n;
    }

    public FontType getMeasuringFont() {
        return this.measuringFont;
    }

    public void setMeasuringFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.measuringFont, (ResourceWithHandleType)fontType);
        this.measuringFont = fontType;
        if (!fontType.isNullFont() && this.isCell() && this.cellMeasure.getValue() == 1) {
            this.updateCellSize();
        }
    }

    public void setMeasuringFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.measuringFont == null) {
                this.measuringFont = FontType.getNullFont();
            }
            this.measuringFont.setHandleName(string);
        } else if (this.measuringFont != null) {
            this.measuringFont.setHandleName(string);
        }
    }

    public String getMeasuringFontVariable() {
        return this.measuringFont != null ? this.measuringFont.getHandleName() : null;
    }

    public boolean isAutominimize() {
        return this.autoMinimize;
    }

    public void setAutominimize(boolean bl) {
        this.autoMinimize = bl;
    }

    public boolean isBindToThread() {
        return this.bindToThread;
    }

    public void setBindToThread(boolean bl) {
        this.bindToThread = bl;
        if (bl) {
            this.linkToThread = false;
        }
    }

    public boolean isLinkToThread() {
        return this.linkToThread;
    }

    public void setLinkToThread(boolean bl) {
        this.linkToThread = bl;
        if (bl) {
            this.bindToThread = false;
        }
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean bl) {
        this.boxed = bl;
    }

    public ImageType getIcon() {
        return this.icon;
    }

    public void setIcon(ImageType imageType) {
        this.icon = imageType;
    }

    public void setCell(boolean bl) {
        if (this.cell != bl) {
            this.cell = bl;
            this.updateCellSize();
        }
    }

    private int getCellHeight(int n) {
        if (this.measuringControl.getValue() == 1) {
            n = (int)((float)n * 1.6f);
        }
        switch (this.measuringStyle.getValue()) {
            case 1: {
                --n;
                break;
            }
            case 2: {
                n += 3;
            }
        }
        return n;
    }

    public void updateCellSize() {
        if (this.isCell()) {
            if (this.cellMeasure.getValue() == 0) {
                this.setCellSize(this.origCellWidth, this.origCellHeight);
            } else {
                FontMetrics fontMetrics = this.getMeasuringComponent().getFontMetrics(this.measuringFont.getFont());
                this.setCellSize(fontMetrics.stringWidth("01234567890") / 10, this.getCellHeight(fontMetrics.getHeight()));
            }
        } else {
            FontMetrics fontMetrics = this.getMeasuringComponent().getFontMetrics(this.controlFont.getFont());
            this.setCellSize(fontMetrics.stringWidth("01234567890") / 10, this.getCellHeight(fontMetrics.getHeight()));
        }
    }

    public boolean isEraseScreen() {
        return this.eraseScreen;
    }

    public void setEraseScreen(boolean bl) {
        this.eraseScreen = bl;
    }

    public DockableList getLayout() {
        return this.layout;
    }

    public void setLayout(DockableList dockableList) {
        this.layout = dockableList;
    }

    public String getLayoutVariable() {
        return this.layoutVar;
    }

    public void setLayoutVariable(String string) {
        this.layoutVar = string;
    }

    public String getUpon() {
        return this.uponMDI;
    }

    public void setUpon(String string) {
        this.uponMDI = string;
    }

    public boolean isControlsUncropped() {
        return this.controlsUncropped;
    }

    public void setControlsUncropped(boolean bl) {
        this.controlsUncropped = bl;
    }

    public boolean isNoClose() {
        return this.noClose;
    }

    public void setNoClose(boolean bl) {
        this.noClose = bl;
    }

    public boolean isScroll() {
        return this.scroll;
    }

    public void setScroll(boolean bl) {
        this.scroll = bl;
    }

    public boolean isUserGray() {
        return this.userGray;
    }

    public void setUserGray(boolean bl) {
        this.userGray = bl;
    }

    public boolean isUserWhite() {
        return this.userWhite;
    }

    public void setUserWhite(boolean bl) {
        this.userWhite = bl;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean bl) {
        this.autoFit = bl;
    }

    public void setName(String string) {
        super.setName(string);
        this.setPrefix(string);
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public AllowingMessages getAllowingMessages() {
        return this.allowingMessages;
    }

    public void setAllowingMessages(AllowingMessages allowingMessages) {
        this.allowingMessages = allowingMessages;
    }

    public String getAllowingMessagesThread() {
        return this.allowingMessagesThread;
    }

    public void setAllowingMessagesThread(String string) {
        this.allowingMessagesThread = string;
        if (string != null && string.length() > 0) {
            this.setAllowingMessages(new AllowingMessages(0));
        }
    }

    public CellMeasure getCellMeasure() {
        return this.cellMeasure;
    }

    public void setCellMeasure(CellMeasure cellMeasure) {
        this.cellMeasure = cellMeasure;
        if (this.isCell()) {
            this.updateCellSize();
        }
    }

    public MeasuringControl getMeasuringControl() {
        return this.measuringControl;
    }

    public void setMeasuringControl(MeasuringControl measuringControl) {
        this.measuringControl = measuringControl;
        if (this.isCell() && this.cellMeasure.getValue() == 1) {
            this.updateCellSize();
        }
    }

    public MeasuringStyle getMeasuringStyle() {
        return this.measuringStyle;
    }

    public void setMeasuringStyle(MeasuringStyle measuringStyle) {
        this.measuringStyle = measuringStyle;
        if (this.isCell() && this.cellMeasure.getValue() == 1) {
            this.updateCellSize();
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public int getMouseFlags() {
        return this.mouseFlags;
    }

    public void setMouseFlags(int n) {
        this.mouseFlags = n;
    }

    public String getMouseFlagsVariable() {
        return this.mouseFlagsVar;
    }

    public void setMouseFlagsVariable(String string) {
        this.mouseFlagsVar = string;
    }

    public String getAfterProc() {
        return this.afterProc;
    }

    public void setAfterProc(String string) {
        this.afterProc = string;
    }

    public String getAfterCreate() {
        return this.afterCreate;
    }

    public void setAfterCreate(String string) {
        this.afterCreate = string;
    }

    public String getAfterInitData() {
        return this.afterInitData;
    }

    public void setAfterInitData(String string) {
        this.afterInitData = string;
    }

    public String getAfterRoutine() {
        return this.afterRoutine;
    }

    public void setAfterRoutine(String string) {
        this.afterRoutine = string;
    }

    public String getBeforeCreate() {
        return this.beforeCreate;
    }

    public void setBeforeCreate(String string) {
        this.beforeCreate = string;
    }

    public String getBeforeInitData() {
        return this.beforeInitData;
    }

    public void setBeforeInitData(String string) {
        this.beforeInitData = string;
    }

    public String getBeforeRoutine() {
        return this.beforeRoutine;
    }

    public void setBeforeRoutine(String string) {
        this.beforeRoutine = string;
    }

    public String getAdditionalProps() {
        return this.additionalProps;
    }

    public void setAdditionalProps(String string) {
        this.additionalProps = string;
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setLinkTo(String string) {
        this.linkTo = string;
    }

    public String getOtherEv() {
        return this.otherEv;
    }

    public void setOtherEv(String string) {
        this.otherEv = string;
    }

    public String getOtherEx() {
        return this.otherEx;
    }

    public void setOtherEx(String string) {
        this.otherEx = string;
    }

    public String getTitleVariable() {
        return this.titleVar;
    }

    public void setTitleVariable(String string) {
        this.titleVar = string;
    }

    public String getTitlePicture() {
        return this.titlePicture;
    }

    public void setTitlePicture(String string) {
        this.titlePicture = string;
    }

    public boolean getWidthInCells() {
        return this.widthInCells;
    }

    public void setWidthInCells(boolean bl) {
        this.widthInCells = bl;
    }

    public boolean getHeightInCells() {
        return this.heightInCells;
    }

    public void setHeightInCells(boolean bl) {
        this.heightInCells = bl;
    }

    public void setExceptionProcedure(String string) {
        this.exceptionProc = string;
    }

    public String getExceptionProcedure() {
        return this.exceptionProc;
    }

    public void setAfterProcedure(String string) {
        this.afterProc = string;
    }

    public String getAfterProcedure() {
        return this.afterProc;
    }

    public String getAfterEndAccept() {
        return this.afterEndAccept;
    }

    public void setAfterEndAccept(String string) {
        this.afterEndAccept = string;
    }

    public void setBeforeProcedure(String string) {
        this.beforeProc = string;
    }

    public String getBeforeProcedure() {
        return this.beforeProc;
    }

    public String getBeforeProcedureThru() {
        return this.beforeProcThru;
    }

    public void setBeforeProcedureThru(String string) {
        this.beforeProcThru = string;
    }

    public String getAfterProcedureThru() {
        return this.afterProcThru;
    }

    public void setAfterProcedureThru(String string) {
        this.afterProcThru = string;
    }

    public void setEventProcedure(String string) {
        this.eventProc = string;
    }

    public String getEventProcedure() {
        return this.eventProc;
    }

    public void setMsgInitMenuEv(String string) {
        this.msgInitMenuEv = string;
    }

    public String getMsgInitMenuEv() {
        return this.msgInitMenuEv;
    }

    public void setMsgEndMenuEv(String string) {
        this.msgEndMenuEv = string;
    }

    public String getMsgEndMenuEv() {
        return this.msgEndMenuEv;
    }

    public void setMsgMenuInputEv(String string) {
        this.msgMenuInputEv = string;
    }

    public String getMsgMenuInputEv() {
        return this.msgMenuInputEv;
    }

    public void setCmdCloseEv(String string) {
        this.cmdCloseEv = string;
    }

    public String getCmdCloseEv() {
        return this.cmdCloseEv;
    }

    public void setMsgCloseEv(String string) {
        this.msgCloseEv = string;
    }

    public String getMsgCloseEv() {
        return this.msgCloseEv;
    }

    public String getMsgIconifiedEv() {
        return this.msgIconifiedEv;
    }

    public void setMsgIconifiedEv(String string) {
        this.msgIconifiedEv = string;
    }

    public String getMsgDeiconifiedEv() {
        return this.msgDeiconifiedEv;
    }

    public void setMsgDeiconifiedEv(String string) {
        this.msgDeiconifiedEv = string;
    }

    public void setCmdActivateEv(String string) {
        this.cmdActivateEv = string;
    }

    public String getCmdActivateEv() {
        return this.cmdActivateEv;
    }

    public void setNtfResizedEv(String string) {
        this.ntfResizedEv = string;
    }

    public String getNtfResizedEv() {
        return this.ntfResizedEv;
    }

    public void setCmdCloseEx(String string) {
        this.cmdCloseEx = string;
    }

    public String getCmdCloseEx() {
        return this.cmdCloseEx;
    }

    public void setCmdActivateEx(String string) {
        this.cmdActivateEx = string;
    }

    public String getCmdActivateEx() {
        return this.cmdActivateEx;
    }

    public void setNtfResizedEx(String string) {
        this.ntfResizedEx = string;
    }

    public String getNtfResizedEx() {
        return this.ntfResizedEx;
    }

    public void setToolbarAt(int n, AbstractBeanToolbar abstractBeanToolbar) {
        this.setToolbarAt(n, (IToolbar)abstractBeanToolbar);
    }

    public void setToolbarAt(int n, IToolbar iToolbar) {
        if (n < this.getToolbarCount()) {
            IToolbar iToolbar2 = (IToolbar)this.toolbars.elementAt(n);
            iToolbar2.setParent(null);
            this.toolbars.setElementAt(iToolbar, n);
            iToolbar.setParent((ScreenElement)this);
        }
    }

    public IToolbar getToolbarAt(int n) {
        if (n < this.getToolbarCount()) {
            return (IToolbar)this.toolbars.elementAt(n);
        }
        return null;
    }

    public int getToolbarCount() {
        return this.toolbars.size();
    }

    public void addToolbar(AbstractBeanToolbar abstractBeanToolbar) {
        this.addToolbar(-1, (IToolbar)abstractBeanToolbar);
    }

    public void addToolbar(IToolbar iToolbar) {
        this.addToolbar(-1, iToolbar);
    }

    public void addToolbar(int n, AbstractBeanToolbar abstractBeanToolbar) {
        this.addToolbar(n, (IToolbar)abstractBeanToolbar);
    }

    public void addToolbar(int n, IToolbar iToolbar) {
        if (n < 0 || n >= this.toolbars.size()) {
            this.toolbars.addElement(iToolbar);
        } else {
            this.toolbars.add(n, iToolbar);
        }
        iToolbar.setParent((ScreenElement)this);
    }

    public void removeToolbar(AbstractBeanToolbar abstractBeanToolbar) {
        this.removeToolbar((IToolbar)abstractBeanToolbar);
    }

    public void removeToolbar(IToolbar iToolbar) {
        this.toolbars.removeElement(iToolbar);
        iToolbar.setParent(null);
        this.removeToolbarTabOrder(iToolbar.getTabOrder());
    }

    public void removeAllToolbars() {
        while (this.toolbars.size() > 0) {
            this.removeToolbar((IToolbar)this.toolbars.elementAt(0));
        }
    }

    public IToolbar[] getToolbars() {
        IToolbar[] iToolbarArray = new IToolbar[this.getToolbarCount()];
        this.toolbars.toArray(iToolbarArray);
        return iToolbarArray;
    }

    public void setToolbars(AbstractBeanToolbar[] abstractBeanToolbarArray) {
        this.setToolbars((IToolbar[])abstractBeanToolbarArray);
    }

    public void setToolbars(IToolbar[] iToolbarArray) {
        this.removeAllToolbars();
        for (int i = 0; i < iToolbarArray.length; ++i) {
            this.addToolbar(iToolbarArray[i]);
        }
    }

    public void setMenuAt(int n, Menu menu) {
        if (n < this.getMenuCount()) {
            this.menus.setElementAt(menu, n);
        }
    }

    public Menu getMenuAt(int n) {
        if (n < this.getMenuCount()) {
            return (Menu)this.menus.elementAt(n);
        }
        return null;
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    public void addMenu(Menu menu) {
        this.addMenu(-1, menu);
    }

    public void addMenu(int n, Menu menu) {
        if (n < 0 || n >= this.menus.size()) {
            this.menus.addElement(menu);
        } else {
            this.menus.add(n, menu);
        }
        menu.setCellSize(this.cellWidth, this.cellHeight);
    }

    public void removeMenu(Menu menu) {
        this.menus.removeElement(menu);
    }

    public void removeAllMenus() {
        this.menus.removeAllElements();
    }

    public Menu[] getMenus() {
        Menu[] menuArray = new Menu[this.getMenuCount()];
        this.menus.toArray(menuArray);
        return menuArray;
    }

    public void setMenus(Menu[] menuArray) {
        this.removeAllMenus();
        for (int i = 0; i < menuArray.length; ++i) {
            this.addMenu(menuArray[i]);
        }
    }

    public void setConstraints(int n, int n2, int n3, int n4) {
        this.setScreenColumnPixels(n);
        this.setScreenLinePixels(n2);
        this.setSizePixels(n3);
        this.setLinesPixels(n4);
    }

    public abstract int getType();

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.exceptionProc, (String)"exception procedure", (String)string, (StringBuilder)stringBuilder2);
        if (this.afterProc != null && this.afterProc.length() > 0) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("after procedure ");
            stringBuilder.append(this.afterProc);
            if (this.afterProcThru != null && this.afterProcThru.length() > 0) {
                stringBuilder.append(" thru ");
                stringBuilder.append(this.afterProcThru);
            }
            stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
        }
        if (this.beforeProc != null && this.beforeProc.length() > 0) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("before procedure ");
            stringBuilder.append(this.beforeProc);
            if (this.beforeProcThru != null && this.beforeProcThru.length() > 0) {
                stringBuilder.append(" thru ");
                stringBuilder.append(this.beforeProcThru);
            }
            stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
        }
        return stringBuilder2.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgCloseEv, null, (String)"msg-close", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdCloseEv, (String)this.cmdCloseEx, (String)"cmd-close", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgInitMenuEv, null, (String)"msg-init-menu", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgEndMenuEv, null, (String)"msg-end-menu", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgMenuInputEv, null, (String)"msg-menu-input", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdActivateEv, (String)this.cmdActivateEx, (String)"cmd-activate", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.ntfResizedEv, (String)this.ntfResizedEx, (String)"ntf-resized", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgIconifiedEv, null, (String)"msg-iconified", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgDeiconifiedEv, null, (String)"msg-deiconified", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("display ");
        boolean bl5 = false;
        if (bl3) {
            switch (this.type.getValue()) {
                default: {
                    stringBuilder2.append("standard graphical");
                    break;
                }
                case 5: {
                    if (bl4) {
                        stringBuilder2.append("standard graphical");
                        break;
                    }
                    stringBuilder2.append("dockable");
                    break;
                }
                case 4: {
                    stringBuilder2.append("docking");
                    break;
                }
                case 7: {
                    if (bl4) {
                        stringBuilder2.append("standard graphical");
                        break;
                    }
                    stringBuilder2.append("mdi-child");
                    break;
                }
                case 6: {
                    stringBuilder2.append("mdi-parent");
                    break;
                }
                case 8: {
                    stringBuilder2.append("notification");
                    bl5 = true;
                }
            }
            stringBuilder2.append(" window");
        } else {
            switch (this.type.getValue()) {
                default: {
                    stringBuilder2.append("standard");
                    break;
                }
                case 2: {
                    stringBuilder2.append("independent");
                    break;
                }
                case 3: {
                    stringBuilder2.append("floating");
                    break;
                }
                case 1: {
                    stringBuilder2.append("initial");
                    break;
                }
                case 4: {
                    stringBuilder2.append("docking");
                    break;
                }
                case 5: {
                    stringBuilder2.append("dockable");
                    break;
                }
                case 6: {
                    stringBuilder2.append("mdi-parent");
                    break;
                }
                case 7: {
                    stringBuilder2.append("mdi-child");
                    break;
                }
                case 8: {
                    stringBuilder2.append("notification");
                    bl5 = true;
                }
            }
            if (this.graphical && !bl5) {
                stringBuilder2.append(" graphical");
            }
            stringBuilder2.append(" window");
        }
        String string2 = string + "   ";
        if (bl5) {
            switch (this.getNotificationPosition().getValue()) {
                case 0: {
                    stringBuilder2.append(" top left");
                    break;
                }
                default: {
                    stringBuilder2.append(" top right");
                    break;
                }
                case 2: {
                    stringBuilder2.append(" bottom left");
                    break;
                }
                case 3: {
                    stringBuilder2.append(" bottom right");
                }
            }
            if (!bl3 && this.beforeTimeVar != null && this.beforeTimeVar.length() > 0) {
                stringBuilder2.append(" before time ");
                stringBuilder2.append(this.beforeTimeVar);
            } else {
                n = this.getBeforeTimeAsInt();
                if (n > 0) {
                    stringBuilder2.append(" before time ");
                    stringBuilder2.append(n);
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        } else {
            switch (this.getBackgroundIntensity().getValue()) {
                case 2: {
                    stringBuilder2.append(" background-low");
                    break;
                }
                case 1: {
                    stringBuilder2.append(" background-high");
                    break;
                }
                case 3: {
                    stringBuilder2.append(" background-standard");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            if (this.type.getValue() == 5 && this.uponLeaf != null && this.uponLeaf.getLeafName() != null && this.uponLeaf.getLeafName().length() > 0) {
                if (!bl3 || !bl4) {
                    IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.uponLeafVar, (String)this.uponLeaf.getLeafName(), (String)"upon-leaf", (String)string2, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
                }
            } else if (this.type.getValue() == 4) {
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.layoutVar, (String)this.layout.stringValue(), (String)"layout", (String)string2, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
            }
            if (!bl3 && this.action.getValue() > 0) {
                stringBuilder2 = new StringBuilder(string2);
                stringBuilder2.append("action action-");
                if (this.action.getValue() == 1) {
                    stringBuilder2.append("maximize");
                } else {
                    stringBuilder2.append("minimize");
                }
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (this.getLine() == 1.0f && this.getColumn() == 1.0f && (this.getLineVariable() == null || this.getLineVariable().equals("")) && (this.getColumnVariable() == null || this.getColumnVariable().equals(""))) {
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.screenLineVar, (int)(bl3 ? 100 : this.screenLinePixels), (int)0, (String)"screen line", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.screenColumnVar, (int)(bl3 ? 100 : this.screenColumnPixels), (int)0, (String)"screen column", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            }
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.screenIndexVar, (int)this.screenIndex, (int)0, (String)"screen-index", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.sizeVar, (float)this.size, (float)80.0f, (boolean)bl, (String)"size", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.linesVar, (float)this.lines, (float)25.0f, (boolean)bl, (String)"lines", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!bl5) {
            IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.icon, (String)"icon", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.lineVar, (float)this.line, (float)(this.getWindowType().getValue() == 7 ? -1.0f : 1.0f), (boolean)bl, (String)"line", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.columnVar, (float)this.column, (float)(this.getWindowType().getValue() == 7 ? -1.0f : 1.0f), (boolean)bl, (String)"column", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        if (this.isCell()) {
            if (this.cellMeasure.getValue() == 0) {
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cellWidthVar, (int)this.cellWidth, (int)0, (String)"cell width", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cellHeightVar, (int)this.cellHeight, (int)0, (String)"cell height", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            } else {
                stringBuilder2 = new StringBuilder(string2);
                stringBuilder2.append("cell size is ");
                if (this.measuringControl.getValue() == 1) {
                    stringBuilder2.append("entry-field");
                } else {
                    stringBuilder2.append("label");
                }
                stringBuilder2.append(" font");
                String string3 = this.measuringFont.getHandleName();
                if (string3 != null && string3.length() > 0 || this.measuringFont.isStandardFont()) {
                    stringBuilder2.append(" ");
                    if (string3 != null && string3.length() > 0) {
                        stringBuilder2.append(string3);
                    } else {
                        stringBuilder2.append(this.measuringFont.getDisplayName());
                    }
                } else {
                    stringBuilder2.append(" default-font");
                }
                switch (this.measuringStyle.getValue()) {
                    case 2: {
                        stringBuilder2.append(" separate");
                        break;
                    }
                    case 1: {
                        stringBuilder2.append(" overlapped");
                    }
                }
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.labelOffset, (int)0, (String)"label-offset", (String)string2, (StringBuilder)stringBuilder);
        if (this.controlFont != null && !"default-font".equalsIgnoreCase(this.controlFont.getDisplayName())) {
            IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.controlFont, (String)"control font", (String)string2, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.colorVar, (ColorType)this.color, (int)0, (String)"color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.backgroundColorVar, (ColorType)this.backgroundColor, (int)0, (String)"background-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.foregroundColorVar, (ColorType)this.foregroundColor, (int)0, (String)"foreground-color", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!bl3) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.visibleVar, (int)(this.visible.getValue() - 1), (int)-1, (String)"visible", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.enabledVar, (int)(this.enabled.getValue() - 1), (int)-1, (String)"enabled", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        if (!bl5) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.resizable, (String)"resizable", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.modeless, (String)"modeless", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.systemMenu, (String)"system menu", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.titleBar, (String)"title-bar", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.autoMinimize, (String)"auto-minimize", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.autoResize, (String)"auto-resize", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.linkToThread, (String)"link to thread", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.bindToThread, (String)"bind to thread", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noClose, (String)"no-close", (String)string2, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (!this.wrap ? 1 : 0) != 0, (String)"no wrap", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.controlsUncropped, (String)"controls-uncropped", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.userGray, (String)"user-gray", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.userWhite, (String)"user-white", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.getWidthInCells(), (String)"width-in-cells", (String)string2, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.getHeightInCells(), (String)"height-in-cells", (String)string2, (StringBuilder)stringBuilder);
        if (!bl5) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.eraseScreen, (String)"erase", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.undecorated, (String)"undecorated", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.titleVar, (String)this.title, (String)"title", (String)string2, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
            IscobolBeanConstants.getVariableLayoutManagerCode((CobolFormatter)cobolFormatter, (LayoutManager)this.getLayoutManager(), (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxSizeVar, (float)this.maxSize, (float)0.0f, (boolean)bl, (String)"max-size", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.minSizeVar, (float)this.minSize, (float)0.0f, (boolean)bl, (String)"min-size", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.minLinesVar, (float)this.minLines, (float)0.0f, (boolean)bl, (String)"min-lines", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxLinesVar, (float)this.maxLines, (float)0.0f, (boolean)bl, (String)"max-lines", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        n = this.gradientOrientation.getValue() - 1;
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.gradientOrientationVar, (int)n, (int)-1, (String)"gradient-orientation", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.gradientColor1Var, (ColorType)this.gradientColor1, (int)0, (String)"gradient-color-1", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.gradientColor2Var, (ColorType)this.gradientColor2, (int)0, (String)"gradient-color-2", (String)string2, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.getCustomDataVariable(), (String)this.getCustomData(), (String)"custom-data", (String)string2, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        if (!bl3 && !bl5) {
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.eventProc, (String)"event procedure", (String)string2, (StringBuilder)stringBuilder);
        }
        if (!bl3 && this.additionalProps != null && this.additionalProps.length() > 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(this.additionalProps));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    stringBuilder.append(cobolFormatter.formatLine(string2 + string4));
                    string4 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.handle != null) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "handle " + this.handle));
        }
        return stringBuilder.toString();
    }

    public Vector<String> getControlNames() {
        int n;
        Vector vector = super.getControlNames();
        for (n = 0; n < this.toolbars.size(); ++n) {
            vector.addAll(((IToolbar)this.toolbars.elementAt(n)).getControlNames());
        }
        for (n = 0; n < this.menus.size(); ++n) {
            vector.add(((Menu)this.menus.elementAt(n)).getName());
        }
        if (this.statusbar != null) {
            vector.add(this.statusbar.getName());
        }
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector vector = super.getControlIds();
        for (int i = 0; i < this.toolbars.size(); ++i) {
            vector.addAll(((IToolbar)this.toolbars.elementAt(i)).getControlIds());
        }
        return vector;
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        super.addComponent(n, abstractBeanControl);
        abstractBeanControl.setCellSize(this.cellWidth, this.cellHeight);
    }

    public void updateTabOrders(AbstractBeanToolbar abstractBeanToolbar, int n) {
        IscobolBeanConstants.updateTabOrders((TabOrderable[])this.getToolbars(), (TabOrderable)abstractBeanToolbar, (int)n);
    }

    public void removeToolbarTabOrder(int n) {
        IscobolBeanConstants.removeTabOrder((TabOrderable[])this.getToolbars(), (int)n);
    }

    public int getLevel() {
        return 1;
    }

    public void setLevel(int n) {
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlExceptionValues());
        }
        IToolbar[] iToolbarArray = this.getToolbars();
        for (int i = 0; i < iToolbarArray.length; ++i) {
            vector.addAll(iToolbarArray[i].getControlExceptionValues());
        }
        Menu[] menuArray = this.getMenus();
        for (int i = 0; i < menuArray.length; ++i) {
            vector.addAll(menuArray[i].getControlExceptionValues());
        }
        return vector;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (iVariableDeclarationScreen.getChildren().getFirst() == null) {
            this.setName("SCREEN-" + iVariableDeclarationScreen.getName());
        } else {
            this.setName(iVariableDeclarationScreen.getName());
        }
        this.setLines(24.0f);
        this.setIsGraphic(iVariableDeclarationScreen);
        this.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc, f2, f, null);
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc, float f, float f2, GroupBeanControl groupBeanControl) {
        IPreferenceStore iPreferenceStore = IscobolScreenPainterPlugin.getDefault().getPreferenceStore();
        this.setCell(iPreferenceStore.getBoolean("iscobolsp.cell"));
        if (this.isCell()) {
            this.setCellHeight(iPreferenceStore.getInt("iscobolsp.cell.height"));
            this.setCellWidth(iPreferenceStore.getInt("iscobolsp.cell.width"));
            this.setMeasuringFont(new FontType(iPreferenceStore.getString("iscobolsp.cell.measuring.font")));
            this.setMeasuringControl(new MeasuringControl(iPreferenceStore.getInt("iscobolsp.cell.measuring.control")));
        }
        int n = iVariableDeclarationScreen.getGuiControl().getGraphicControlType();
        if (iVariableDeclarationScreen.getGuiControl().getSa() != null) {
            if (iVariableDeclarationScreen.getGuiControl().getSa().getAttrAFTER_p1() != null) {
                this.afterProc = iVariableDeclarationScreen.getGuiControl().getSa().getAttrAFTER_p1().getWord();
            }
            if (iVariableDeclarationScreen.getGuiControl().getSa().getAttrAFTER_p2() != null) {
                this.afterProcThru = iVariableDeclarationScreen.getGuiControl().getSa().getAttrAFTER_p2().getWord();
            }
            if (iVariableDeclarationScreen.getGuiControl().getSa().getAttrBEFORE_p1() != null) {
                this.beforeProc = iVariableDeclarationScreen.getGuiControl().getSa().getAttrBEFORE_p1().getWord();
            }
            if (iVariableDeclarationScreen.getGuiControl().getSa().getAttrBEFORE_p2() != null) {
                this.beforeProcThru = iVariableDeclarationScreen.getGuiControl().getSa().getAttrBEFORE_p2().getWord();
            }
        }
        IVariableDeclarationScreen iVariableDeclarationScreen2 = (IVariableDeclarationScreen)iVariableDeclarationScreen.getChildren().getFirst();
        if (iVariableDeclarationScreen.getLevel() == 1 && iVariableDeclarationScreen2 == null) {
            iVariableDeclarationScreen2 = iVariableDeclarationScreen;
        }
        while (iVariableDeclarationScreen2 != null) {
            n = iVariableDeclarationScreen2.getGuiControl().getGraphicControlType();
            switch (n) {
                default: {
                    PluginUtilities.log((String)("Control type not managed[" + n + "] for variable name [" + iVariableDeclarationScreen2.getName() + "] in this release!"));
                    break;
                }
                case -1: {
                    if (!this.isGraphic) {
                        if (iVariableDeclarationScreen2.getGuiControl() == null || iVariableDeclarationScreen2.getGuiControl().getSa() == null) break;
                        if (iVariableDeclarationScreen2.getGuiControl().getSa().getTitle() != null && !iVariableDeclarationScreen2.getGuiControl().getSa().getTitleIDE().equals("") && iVariableDeclarationScreen2.getGuiControl().getSa().getTitleIDE().charAt(0) == '\"' || iVariableDeclarationScreen2.getGuiControl().getSa().getVFrom() != null || iVariableDeclarationScreen2.getGuiControl().getSa().getFrom() != null) {
                            SwingLabel swingLabel = new SwingLabel();
                            swingLabel.setLine(f2);
                            swingLabel.setColumn(f);
                            swingLabel.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                            if (iVariableDeclarationScreen2.getGuiControl().getSa().getVFrom() != null) {
                                swingLabel.setTitle("");
                                swingLabel.setTitleVariable(iVariableDeclarationScreen2.getGuiControl().getSa().getVFrom().getNameIde());
                                swingLabel.setSize((float)iVariableDeclarationScreen2.getGuiControl().getSa().getVFrom().getVarDecl().getPhisicLen());
                            } else if (iVariableDeclarationScreen2.getGuiControl().getSa().getFrom() != null) {
                                if (!iVariableDeclarationScreen2.getGuiControl().getSa().getFrom().isResource()) {
                                    swingLabel.setTitle(iVariableDeclarationScreen2.getGuiControl().getSa().getFrom().getWord().substring(1, iVariableDeclarationScreen2.getGuiControl().getSa().getFrom().getWord().length() - 1));
                                } else {
                                    swingLabel.setTitle("R" + iVariableDeclarationScreen2.getGuiControl().getSa().getFrom().getWord());
                                }
                                swingLabel.setSize((float)(iVariableDeclarationScreen2.getGuiControl().getSa().getFrom().getWord().length() - 2));
                            } else {
                                swingLabel.setSize((float)swingLabel.getTitle().length());
                            }
                            f2 = swingLabel.getRealLine();
                            f = swingLabel.getRealColumn() + swingLabel.getSize();
                            swingLabel.setDestroyType(new DestroyType(2));
                            if (groupBeanControl != null) {
                                groupBeanControl.addComponent((AbstractBeanControl)swingLabel);
                                break;
                            }
                            this.addComponent((AbstractBeanControl)swingLabel);
                            break;
                        }
                        SwingEntryField swingEntryField = new SwingEntryField();
                        swingEntryField.setLine(f2);
                        swingEntryField.setColumn(f);
                        swingEntryField.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                        if (iVariableDeclarationScreen2.getGuiControl().getSa().getVUsing() != null) {
                            swingEntryField.setSize((float)iVariableDeclarationScreen2.getGuiControl().getSa().getVUsing().getVarDecl().getPhisicLen());
                        }
                        f2 = swingEntryField.getRealLine();
                        f = swingEntryField.getRealColumn() + swingEntryField.getSize();
                        swingEntryField.setDestroyType(new DestroyType(2));
                        if (groupBeanControl != null) {
                            groupBeanControl.addComponent((AbstractBeanControl)swingEntryField);
                            break;
                        }
                        this.addComponent((AbstractBeanControl)swingEntryField);
                        break;
                    }
                    GroupBeanControl groupBeanControl2 = new GroupBeanControl();
                    groupBeanControl2.setName(iVariableDeclarationScreen2.getName());
                    groupBeanControl2.setLine(null);
                    groupBeanControl2.setColumn(null);
                    groupBeanControl2.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                    this.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc, f, f2, groupBeanControl2);
                    if (groupBeanControl != null) {
                        groupBeanControl.addComponent((AbstractBeanControl)groupBeanControl2);
                        break;
                    }
                    this.addComponent((AbstractBeanControl)groupBeanControl2);
                    break;
                }
                case 11: {
                    this.loadAndSet((AbstractBeanControl)new SwingBar(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 13: {
                    this.loadAndSet((AbstractBeanControl)new SwingBitmap(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 4: {
                    this.loadAndSet((AbstractBeanControl)new SwingCheckBox(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 20: {
                    this.loadAndSet((AbstractBeanControl)new SwingDateEntry(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 8: {
                    this.loadAndSet((AbstractBeanControl)new SwingComboBox(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 2: {
                    this.loadAndSet((AbstractBeanControl)new SwingEntryField(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 9: {
                    this.loadAndSet((AbstractBeanControl)new SwingFrame(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 12: {
                    this.loadAndSet((AbstractBeanControl)new SwingGrid(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 19: {
                    this.loadAndSet((AbstractBeanControl)new SwingJavaBean(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 1: {
                    this.loadAndSet((AbstractBeanControl)new SwingLabel(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 3: {
                    this.loadAndSet((AbstractBeanControl)new SwingPushButton(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 7: {
                    boolean bl = iVariableDeclarationScreen2.getGuiControl().getControlStyles().contains("CHECK-LIST");
                    this.loadAndSet((AbstractBeanControl)(bl ? new SwingCheckListBox() : new SwingListBox()), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 5: {
                    this.loadAndSet((AbstractBeanControl)new SwingRadioButton(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 6: {
                    this.loadAndSet((AbstractBeanControl)new SwingScrollbar(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 18: {
                    this.loadAndSet((AbstractBeanControl)new SwingSlider(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 10: {
                    SwingAccordion swingAccordion;
                    if (iVariableDeclarationScreen2.getGuiControl().getControlStyles().contains("ACCORDION")) {
                        swingAccordion = new SwingAccordion();
                        swingAccordion.setLine(f2);
                        swingAccordion.setColumn(f);
                        swingAccordion.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                        if (groupBeanControl != null) {
                            groupBeanControl.addComponent((AbstractBeanControl)swingAccordion);
                        } else {
                            this.addComponent((AbstractBeanControl)swingAccordion);
                        }
                        f2 = swingAccordion.getRealLine();
                        f = swingAccordion.getRealColumn() + swingAccordion.getSize();
                        break;
                    }
                    swingAccordion = new SwingTab();
                    swingAccordion.setLine(f2);
                    swingAccordion.setColumn(f);
                    swingAccordion.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                    if (groupBeanControl != null) {
                        groupBeanControl.addComponent((AbstractBeanControl)swingAccordion);
                    } else {
                        this.addComponent((AbstractBeanControl)swingAccordion);
                    }
                    f2 = swingAccordion.getRealLine();
                    f = swingAccordion.getRealColumn() + swingAccordion.getSize();
                    break;
                }
                case 17: {
                    this.setStatusbar((AbstractBeanStatusbar)new SwingStatusbar());
                    this.statusbar.loadFromCbl(iCompiler, iVariableDeclarationScreen2, iPcc);
                    break;
                }
                case 14: {
                    this.loadAndSet((AbstractBeanControl)new SwingTreeView(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                    break;
                }
                case 15: {
                    this.loadAndSet((AbstractBeanControl)new SwingWebBrowser(), iCompiler, iVariableDeclarationScreen2, iPcc, f2, f, groupBeanControl);
                }
            }
            iVariableDeclarationScreen2 = (IVariableDeclarationScreen)iVariableDeclarationScreen.getChildren().getNext();
        }
    }

    private void setIsGraphic(IVariableDeclarationScreen iVariableDeclarationScreen) {
        IVariableDeclarationScreen iVariableDeclarationScreen2 = (IVariableDeclarationScreen)iVariableDeclarationScreen.getChildren().getFirst();
        while (iVariableDeclarationScreen2 != null && !this.isGraphic) {
            if (iVariableDeclarationScreen2.getGuiControl().getGraphicControlType() != -1) {
                this.isGraphic = true;
            }
            if (!this.isGraphic && iVariableDeclarationScreen2.getChildren() != null) {
                IVariableDeclarationScreen iVariableDeclarationScreen3 = (IVariableDeclarationScreen)iVariableDeclarationScreen2.getChildren().getFirst();
                while (iVariableDeclarationScreen3 != null && !this.isGraphic) {
                    if (iVariableDeclarationScreen3.getGuiControl().getGraphicControlType() != -1) {
                        this.isGraphic = true;
                    } else {
                        this.setIsGraphic(iVariableDeclarationScreen3);
                    }
                    iVariableDeclarationScreen3 = (IVariableDeclarationScreen)iVariableDeclarationScreen2.getChildren().getNext();
                }
            }
            iVariableDeclarationScreen2 = (IVariableDeclarationScreen)iVariableDeclarationScreen.getChildren().getNext();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getUponVariable() {
        return this.uponVar;
    }

    public void setUponVariable(String string) {
        this.uponVar = string;
    }

    public boolean hasGradient() {
        return this.getGradientOrientation().getValue() > 0 && !this.getGradientColor1().isDisabled() && !this.getGradientColor2().isDisabled();
    }

    public GradientOrientation getGradientOrientation() {
        return this.gradientOrientation;
    }

    public String getGradientOrientationVariable() {
        return this.gradientOrientationVar;
    }

    public ForegroundColorType getGradientColor1() {
        return this.gradientColor1;
    }

    public ForegroundColorType getGradientColor2() {
        return this.gradientColor2;
    }

    public String getGradientColor1Variable() {
        return this.gradientColor1Var;
    }

    public String getGradientColor2Variable() {
        return this.gradientColor2Var;
    }

    public void setGradientOrientation(GradientOrientation gradientOrientation) {
        this.gradientOrientation = gradientOrientation;
    }

    public void setGradientOrientationVariable(String string) {
        this.gradientOrientationVar = string;
    }

    public void setGradientColor1(ForegroundColorType foregroundColorType) {
        this.gradientColor1 = foregroundColorType;
    }

    public void setGradientColor2(ForegroundColorType foregroundColorType) {
        this.gradientColor2 = foregroundColorType;
    }

    public void setGradientColor1Variable(String string) {
        this.gradientColor1Var = string;
    }

    public void setGradientColor2Variable(String string) {
        this.gradientColor2Var = string;
    }

    public void loadAndSet(AbstractBeanControl abstractBeanControl, ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc, float f, float f2, GroupBeanControl groupBeanControl) {
        if (!this.isGraphic) {
            abstractBeanControl.setLine(f);
            abstractBeanControl.setColumn(f2);
        }
        abstractBeanControl.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        if (groupBeanControl != null) {
            groupBeanControl.addComponent(abstractBeanControl);
        } else {
            this.addComponent(abstractBeanControl);
        }
        f = abstractBeanControl.getRealLine();
        f2 = abstractBeanControl.getRealColumn() + abstractBeanControl.getSize();
    }
}

