/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BitmapScale;
import com.iscobol.screenpainter.beans.types.DimensionUnit;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;

public abstract class AbstractBitmap
extends AbstractInputField {
    private static final long serialVersionUID = 1L;
    private ImageType image;
    private int bitmapNumber = 1;
    private BitmapScale bitmapScale;
    private int bitmapStart;
    private int bitmapEnd;
    private int bitmapTimer;
    private int transparentColor = -1;
    private String bitmapNumberVar;
    private String bitmapScaleVar;
    private String bitmapStartVar;
    private String bitmapTimerVar;
    private String bitmapEndVar;
    private String transparentColorVar;
    private String eventProc;
    private String msgMouseClickedEv;
    private String msgMouseDblclickEv;
    private String msgMouseEnteredEv;
    private String msgMouseExitedEv;

    public AbstractBitmap(Component component) {
        super(component);
        this.setSizeUnit(new DimensionUnit(3));
        this.setLinesUnit(new DimensionUnit(3));
    }

    public void setBitmap(ImageType imageType) {
        this.image = imageType;
    }

    public ImageType getBitmap() {
        return this.image;
    }

    public final boolean hasEvents() {
        return this.eventProc != null && this.eventProc.length() > 0 || this.msgMouseClickedEv != null && this.msgMouseClickedEv.length() > 0 || this.msgMouseDblclickEv != null && this.msgMouseDblclickEv.length() > 0 || this.msgMouseEnteredEv != null && this.msgMouseEnteredEv.length() > 0 || this.msgMouseExitedEv != null && this.msgMouseExitedEv.length() > 0;
    }

    public void setBitmapScale(int n) {
        this.bitmapScale = new BitmapScale(n);
    }

    public void setBitmapScale(BitmapScale bitmapScale) {
        this.bitmapScale = bitmapScale;
    }

    public BitmapScale getBitmapScale() {
        return this.bitmapScale;
    }

    public void setBitmapScaleVariable(String string) {
        this.bitmapScaleVar = string;
    }

    public String getBitmapScaleVariable() {
        return this.bitmapScaleVar;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapTimer() {
        return this.bitmapTimer;
    }

    public void setBitmapTimer(int n) {
        this.bitmapTimer = n;
    }

    public String getBitmapTimerVariable() {
        return this.bitmapTimerVar;
    }

    public void setBitmapTimerVariable(String string) {
        this.bitmapTimerVar = string;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapStart(int n) {
        this.bitmapStart = n;
    }

    public int getBitmapStart() {
        return this.bitmapStart;
    }

    public void setBitmapEnd(int n) {
        this.bitmapEnd = n;
    }

    public int getBitmapEnd() {
        return this.bitmapEnd;
    }

    public void setTransparentColor(int n) {
        this.transparentColor = n;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public void setBitmapNumberVariable(String string) {
        this.bitmapNumberVar = string;
    }

    public String getBitmapNumberVariable() {
        return this.bitmapNumberVar;
    }

    public void setBitmapStartVariable(String string) {
        this.bitmapStartVar = string;
    }

    public String getBitmapStartVariable() {
        return this.bitmapStartVar;
    }

    public void setBitmapEndVariable(String string) {
        this.bitmapEndVar = string;
    }

    public String getBitmapEndVariable() {
        return this.bitmapEndVar;
    }

    public void setTransparentColorVariable(String string) {
        this.transparentColorVar = string;
    }

    public String getTransparentColorVariable() {
        return this.transparentColorVar;
    }

    public void setMsgMouseEnteredEv(String string) {
        this.msgMouseEnteredEv = string;
    }

    public String getMsgMouseEnteredEv() {
        return this.msgMouseEnteredEv;
    }

    public void setMsgMouseExitedEv(String string) {
        this.msgMouseExitedEv = string;
    }

    public String getMsgMouseExitedEv() {
        return this.msgMouseExitedEv;
    }

    public void setMsgMouseClickedEv(String string) {
        this.msgMouseClickedEv = string;
    }

    public String getMsgMouseClickedEv() {
        return this.msgMouseClickedEv;
    }

    public void setMsgMouseDblclickEv(String string) {
        this.msgMouseDblclickEv = string;
    }

    public String getMsgMouseDblclickEv() {
        return this.msgMouseDblclickEv;
    }

    public int getType() {
        return 106;
    }

    public String getOtherEv() {
        return null;
    }

    public void setOtherEv(String string) {
    }

    public String getOtherEx() {
        return null;
    }

    public void setOtherEx(String string) {
    }

    public void setExceptionProcedure(String string) {
    }

    public String getExceptionProcedure() {
        return null;
    }

    public void setAfterProcedure(String string) {
    }

    public String getAfterProcedure() {
        return null;
    }

    public void setBeforeProcedure(String string) {
    }

    public String getBeforeProcedure() {
        return null;
    }

    public void setEventProcedure(String string) {
        this.eventProc = string;
    }

    public String getEventProcedure() {
        return this.eventProc;
    }

    public void setMsgInitMenuEv(String string) {
    }

    public String getMsgInitMenuEv() {
        return null;
    }

    public void setMsgEndMenuEv(String string) {
    }

    public String getMsgEndMenuEv() {
        return null;
    }

    public void setMsgMenuInputEv(String string) {
    }

    public String getMsgMenuInputEv() {
        return null;
    }

    public void setMsgValidateEv(String string) {
    }

    public String getMsgValidateEv() {
        return null;
    }

    public void setCmdGotoEv(String string) {
    }

    public String getCmdGotoEv() {
        return null;
    }

    public void setCmdGotoEx(String string) {
    }

    public String getCmdGotoEx() {
        return null;
    }

    public void setCmdHelpEx(String string) {
    }

    public String getCmdHelpEx() {
        return null;
    }

    public void setCmdHelpEv(String string) {
    }

    public String getCmdHelpEv() {
        return null;
    }

    protected void getDimensionCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("size ");
        String string2 = this.getSizeVariable();
        if (!bl2 && string2 != null && string2.length() > 0) {
            stringBuilder2.append(string2);
        } else if (this.getWidthInCells() || this.getSizeUnit().getValue() == 2) {
            stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getSize(), (boolean)bl, (boolean)true));
        } else {
            stringBuilder2.append(Math.round(this.getSizePixels()));
        }
        if (this.getSizeUnit().getValue() == 2) {
            stringBuilder2.append(" cells ");
        } else if (this.isSizeUnitPixel() && !this.getWidthInCells()) {
            stringBuilder2.append(" pixels ");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("lines ");
        String string3 = this.getLinesVariable();
        if (!bl2 && string3 != null && string3.length() > 0) {
            stringBuilder2.append(string3);
        } else if (this.getHeightInCells() || this.getLinesUnit().getValue() == 2) {
            stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getLines(), (boolean)bl, (boolean)true));
        } else {
            stringBuilder2.append(Math.round(this.getLinesPixels()));
        }
        if (this.getLinesUnit().getValue() == 2) {
            stringBuilder2.append(" cells ");
        } else if (this.isLinesUnitPixel() && !this.getHeightInCells()) {
            stringBuilder2.append(" pixels ");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(2.0f);
        this.setLines(2.0f);
        this.setBitmapScale(new BitmapScale());
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapScaleVar, (int)this.bitmapScale.getValue(), (int)0, (String)"bitmap-scale", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.image, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapNumberVar, (int)this.bitmapNumber, (int)0, (String)"bitmap-number", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapStartVar, (int)this.bitmapStart, (int)0, (String)"bitmap-start", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapEndVar, (int)this.bitmapEnd, (int)0, (String)"bitmap-end", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapTimerVar, (int)this.bitmapTimer, (int)0, (String)"bitmap-timer", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.transparentColorVar, (int)this.transparentColor, (int)-1, (String)"transparent-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!bl3) {
            IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.eventProc, (String)"event procedure", (String)string, (StringBuilder)stringBuilder);
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgMouseClickedEv, null, (String)"msg-mouse-clicked", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgMouseDblclickEv, null, (String)"msg-mouse-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgMouseEnteredEv, null, (String)"msg-mouse-enter", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgMouseExitedEv, null, (String)"msg-mouse-exit", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        if (this.getSizeUnit().getValue() == 1) {
            this.setSizeUnit(new DimensionUnit(3));
        }
        if (this.getLinesUnit().getValue() == 1) {
            this.setLinesUnit(new DimensionUnit(3));
        }
        if (iScreenAttribute.getAttrEVENT_p1() != null) {
            this.setEventProcedure(iScreenAttribute.getAttrEVENT_p1().getWord());
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("BITMAP-NUMBER")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapNumber((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapNumberVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-SCALE")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapScale((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapScaleVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-START")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapStart((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapStartVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-END")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapEnd((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapEndVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-TIMER")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapTimer((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapTimerVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("TRANSPARENT-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setTransparentColor((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setTransparentColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("BITMAP-HANDLE")) continue;
            this.setBitmap(new ImageType("", iPropElementList.getValue(i)[0].getVariableName().getNameIde()));
        }
    }
}

