/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IPropElementValue;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.ExceptionTerminationValueProvider;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BitmapFrame;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractButton
extends AbstractInputField
implements ExceptionTerminationValueProvider {
    private static final long serialVersionUID = 1L;
    public static final int BITMAP_WIDTH_OVERHEAD = 8;
    public static final int BITMAP_HEIGHT_OVERHEAD = 8;
    private String title;
    private ImageType image;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapRollover;
    private int bitmapPressed;
    private int bitmapWidth;
    private boolean flat;
    private boolean multiline;
    private boolean bitmapSquare = true;
    private boolean copyResource;
    private boolean selfAct;
    private boolean autoFit;
    private BitmapFrame bitmapFrame;
    private int exceptionVal;
    private int terminationVal;
    private String titleVar;
    private String bitmapNumberVar;
    private String bitmapDisabledVar;
    private String bitmapPressedVar;
    private String bitmapRolloverVar;
    private String bitmapWidthVar;
    private String titlePositionVar;
    private String exceptionValVar;
    private String terminationValVar;
    private String cmdClickedEv;
    private String cmdClickedEx;
    private String linkTo;
    private String cssIconVar;
    private String cssIcon;

    public AbstractButton(Component component) {
        super(component);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setTitle(this.title);
        this.setBitmap(this.image);
    }

    public String getTitle() {
        return this.title;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setTitle(IscobolBeanConstants.getTypeName((int)this.getType()));
        this.setLines(2.0f);
        if (this.getTitle().length() > 2) {
            this.setSize((float)(this.getTitle().length() + 1));
        }
        if (this.getTitle().length() > 2 && this.getTitle().startsWith("R\"")) {
            this.setSize(this.getSize() - 3.0f);
        }
        this.setBitmapFrame(new BitmapFrame(0));
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean bl) {
        this.autoFit = bl;
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    protected void getDimensionCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        BaseWindow baseWindow;
        Object object;
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("size ");
        String string2 = this.getSizeVariable();
        if (!this.getWidthInCells() && this.isSizeUnitPixel()) {
            if (!bl2 && string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2);
            } else {
                stringBuilder2.append(Math.round(this.getSizePixels()));
            }
            stringBuilder2.append(" pixels ");
        } else if (this.getBitmap() != null) {
            if (!bl2 && string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2);
            } else if (this.getWidthInCells() || this.getSizeUnit().getValue() == 2) {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getSize(), (boolean)bl, (boolean)true));
                if (this.getSizeUnit().getValue() == 2) {
                    stringBuilder2.append(" cells ");
                }
            } else {
                stringBuilder2.append(Math.round(this.getSizePixels()));
            }
        } else {
            boolean bl3;
            if (!bl2 && string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2);
            } else {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getSize(), (boolean)bl, (boolean)true));
            }
            object = this.getSizeUnit();
            boolean bl4 = bl3 = !this.getWidthInCells() && (object.getValue() == 2 || object.getValue() == 0 && ((baseWindow = this.getBaseParentWindow()) == null || baseWindow.isCell()));
            if (bl3) {
                stringBuilder2.append(" cells ");
            }
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        object = this.getLinesVariable();
        stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("lines ");
        if (!this.getHeightInCells() && this.isLinesUnitPixel()) {
            if (!bl2 && object != null && ((String)object).length() > 0) {
                stringBuilder2.append((String)object);
            } else {
                stringBuilder2.append(Math.round(this.getLinesPixels()));
            }
            stringBuilder2.append(" pixels ");
        } else if (this.getBitmap() != null) {
            if (!bl2 && object != null && ((String)object).length() > 0) {
                stringBuilder2.append((String)object);
            } else if (this.getHeightInCells() || this.getLinesUnit().getValue() == 2) {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getLines(), (boolean)bl, (boolean)true));
                if (this.getLinesUnit().getValue() == 2) {
                    stringBuilder2.append(" cells ");
                }
            } else {
                stringBuilder2.append(Math.round(this.getLinesPixels()));
            }
        } else {
            BaseWindow baseWindow2;
            boolean bl5;
            if (!bl2 && object != null && ((String)object).length() > 0) {
                stringBuilder2.append((String)object);
            } else {
                stringBuilder2.append(IscobolBeanConstants.floatToString((float)this.getLines(), (boolean)bl, (boolean)true));
            }
            baseWindow = this.getLinesUnit();
            boolean bl6 = bl5 = !this.getHeightInCells() && (baseWindow.getValue() == 2 || baseWindow.getValue() == 0 && ((baseWindow2 = this.getBaseParentWindow()) == null || baseWindow2.isCell()));
            if (bl5) {
                stringBuilder2.append(" cells ");
            }
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setFlat(boolean bl) {
        this.flat = bl;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isBitmapFramed() {
        return this.bitmapFrame.getValue() == 1;
    }

    public boolean isBitmapUnframed() {
        return this.bitmapFrame.getValue() == 2;
    }

    public BitmapFrame isBitmapFrame() {
        return this.bitmapFrame;
    }

    public void setBitmapFrame(boolean bl) {
        this.setBitmapFrame(new BitmapFrame(bl ? 1 : 2));
    }

    public void setBitmapFrame(BitmapFrame bitmapFrame) {
        this.bitmapFrame = bitmapFrame;
    }

    public boolean isBitmapSquare() {
        return this.bitmapSquare;
    }

    public void setBitmapSquare(boolean bl) {
        this.bitmapSquare = bl;
    }

    public boolean isCopyResource() {
        return this.copyResource;
    }

    public void setCopyResource(boolean bl) {
        this.copyResource = bl;
    }

    public void setBitmap(ImageType imageType) {
        this.image = imageType;
    }

    public ImageType getBitmap() {
        return this.image;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapDisabled(int n) {
        this.bitmapDisabled = n;
    }

    public int getBitmapDisabled() {
        return this.bitmapDisabled;
    }

    public void setBitmapPressed(int n) {
        this.bitmapPressed = n;
    }

    public int getBitmapPressed() {
        return this.bitmapPressed;
    }

    public void setBitmapRollover(int n) {
        this.bitmapRollover = n;
    }

    public int getBitmapRollover() {
        return this.bitmapRollover;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setTitleVariable(String string) {
        this.titleVar = string;
    }

    public String getTitleVariable() {
        return this.titleVar;
    }

    public void setSelfAct(boolean bl) {
        this.selfAct = bl;
    }

    public boolean isSelfAct() {
        return this.selfAct;
    }

    public void setBitmapNumberVariable(String string) {
        this.bitmapNumberVar = string;
    }

    public String getBitmapNumberVariable() {
        return this.bitmapNumberVar;
    }

    public void setBitmapDisabledVariable(String string) {
        this.bitmapDisabledVar = string;
    }

    public String getBitmapDisabledVariable() {
        return this.bitmapDisabledVar;
    }

    public void setBitmapRolloverVariable(String string) {
        this.bitmapRolloverVar = string;
    }

    public String getBitmapRolloverVariable() {
        return this.bitmapRolloverVar;
    }

    public void setBitmapPressedVariable(String string) {
        this.bitmapPressedVar = string;
    }

    public String getBitmapPressedVariable() {
        return this.bitmapPressedVar;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public void setTitlePositionVariable(String string) {
        this.titlePositionVar = string;
    }

    public String getTitlePositionVariable() {
        return this.titlePositionVar;
    }

    public void setExceptionValueVariable(String string) {
        this.exceptionValVar = string;
    }

    public String getExceptionValueVariable() {
        return this.exceptionValVar;
    }

    public void setTerminationValueVariable(String string) {
        this.terminationValVar = string;
    }

    public String getTerminationValueVariable() {
        return this.terminationValVar;
    }

    public void setExceptionValue(int n) {
        this.exceptionVal = n;
    }

    public int getExceptionValue() {
        return this.exceptionVal;
    }

    public void setTerminationValue(int n) {
        this.terminationVal = n;
    }

    public int getTerminationValue() {
        return this.terminationVal;
    }

    public String getCssIcon() {
        return this.cssIcon;
    }

    public void setCssIcon(String string) {
        this.cssIcon = string;
    }

    public String getCssIconVariable() {
        return this.cssIconVar;
    }

    public void setCssIconVariable(String string) {
        this.cssIconVar = string;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string3 = string != null ? string : this.getName();
        IscobolBeanConstants.getAutoFitCode((CobolFormatter)cobolFormatter, (boolean)this.autoFit, (ImageType)this.image, (String)string3, (int)((int)this.getSizePixels()), (int)((int)this.getLinesPixels()), (String)string2, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setLinkTo(String string) {
        this.linkTo = string;
    }

    public void setCmdClickedEv(String string) {
        this.cmdClickedEv = string;
    }

    public String getCmdClickedEv() {
        return this.cmdClickedEv;
    }

    public void setCmdClickedEx(String string) {
        this.cmdClickedEx = string;
    }

    public String getCmdClickedEx() {
        return this.cmdClickedEx;
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.flat, (String)"flat", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.multiline, (String)"multiline", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.selfAct, (String)"self-act", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.titleVar, (String)this.title, (String)"title", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.image, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        if (this.getBitmap() != null) {
            if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBitmapFramed(), (String)"framed", (String)string, (StringBuilder)stringBuilder)) {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBitmapUnframed(), (String)"unframed", (String)string, (StringBuilder)stringBuilder);
            }
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.bitmapSquare, (String)"square", (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapNumberVar, (int)this.bitmapNumber, (int)0, (String)"bitmap-number", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapDisabledVar, (int)this.bitmapDisabled, (int)0, (String)"bitmap-disabled", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapRolloverVar, (int)this.bitmapRollover, (int)0, (String)"bitmap-rollover", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapPressedVar, (int)this.bitmapPressed, (int)0, (String)"bitmap-pressed", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)0, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.cssIconVar, (String)this.cssIcon, (String)"css-icon", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdClickedEv, (String)this.cmdClickedEx, (String)"cmd-clicked", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.exceptionVal > 0) {
            vector.addElement(new Integer(this.exceptionVal));
        }
        return vector;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        if (!iScreenAttribute.getTitleIDE().equals("")) {
            if (iScreenAttribute.getTitleIDE().contains("\"")) {
                if (iScreenAttribute.getTitleIDE().charAt(0) == '\"') {
                    this.setTitle(iScreenAttribute.getTitleIDE().substring(1, iVariableDeclarationScreen.getGuiControl().getSa().getTitleIDE().length() - 1));
                } else {
                    this.setTitle(iScreenAttribute.getTitleIDE());
                }
            } else {
                this.setTitleVariable(iScreenAttribute.getTitleIDE());
            }
            if (iScreenAttribute.getExprSize() == null) {
                this.setSize((float)iScreenAttribute.getTitleIDELen());
            }
        }
        int n = iPropElementList.size();
        for (int i = 0; i < n; ++i) {
            Object object = iPropElementList.getKey(i);
            IPropElementValue[] iPropElementValueArray = iPropElementList.getValue(i);
            if (object instanceof String) {
                if (((String)object).equalsIgnoreCase("BITMAP-NUMBER")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setBitmapNumber((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setBitmapNumberVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("BITMAP-HANDLE")) {
                    if (iPropElementValueArray.length > 0 && iPropElementValueArray[0].getVariableName() != null) {
                        this.setBitmap(new ImageType("", iPropElementValueArray[0].getVariableName().getNameIde()));
                    }
                } else if (((String)object).equalsIgnoreCase("BITMAP-DISABLED")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setBitmapDisabled((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setBitmapDisabledVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("BITMAP-ROLLOVER")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setBitmapRollover((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setBitmapRolloverVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("BITMAP-PRESSED")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setBitmapPressed((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setBitmapPressedVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("BITMAP-WIDTH")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setBitmapWidthVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("TERMINATION-VALUE")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setTerminationValue((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setTerminationValueVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                } else if (((String)object).equalsIgnoreCase("EXCEPTION-VALUE")) {
                    if (iPropElementValueArray[0].getToken() != null) {
                        if (iPropElementValueArray[0].getToken().getToknum() == 10002) {
                            this.setExceptionValue((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                        }
                    } else {
                        this.setExceptionValueVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                    }
                }
            }
            if (iGUIControl.getControlStyles().contains("MULTILINE")) {
                this.setMultiline(true);
            }
            if (iGUIControl.getControlStyles().contains("SELF-ACT")) {
                this.setSelfAct(true);
            }
            if (iGUIControl.getControlStyles().contains("SELF-ACT")) {
                this.setSelfAct(true);
            }
            if (iGUIControl.getControlStyles().contains("SQUARE")) {
                this.setBitmapSquare(true);
            }
            this.setBitmapFrame(new BitmapFrame(0));
            if (iGUIControl.getControlStyles().contains("UNFRAMED")) {
                this.setBitmapFrame(new BitmapFrame(2));
            } else if (iGUIControl.getControlStyles().contains("FRAMED")) {
                this.setBitmapFrame(new BitmapFrame(1));
            }
            if (!iGUIControl.getControlStyles().contains("FLAT")) continue;
            this.setFlat(true);
        }
    }
}

