/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IPropElementValue;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.LeftTextAlignment;
import com.iscobol.screenpainter.beans.types.Position;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractCheckBox
extends AbstractButton {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_WIDTH_INSETS = 17;
    private int bitmapSelected;
    private int bitmapDisabledSelected;
    private int bitmapRolloverSelected;
    private boolean leftText;
    private boolean vTop;
    private int value;
    private String bitmapSelVar;
    private String bitmapDisSelVar;
    private String bitmapRollSelVar;
    private String valueVar;
    private String valuePicture = "9";
    private boolean notify;
    private LeftTextAlignment leftTextAlignment;
    private boolean transparent;
    private Position titlePosition = new Position(0);

    public AbstractCheckBox(Component component) {
        super(component);
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setLeftTextAlignment(new LeftTextAlignment());
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setTitlePosition(this.titlePosition);
    }

    public void setTitlePosition(Position position) {
        this.titlePosition = position;
    }

    public Position getTitlePosition() {
        return this.titlePosition;
    }

    public void setBitmapSelected(int n) {
        this.bitmapSelected = n;
    }

    public int getBitmapSelected() {
        return this.bitmapSelected;
    }

    public void setBitmapRolloverSelected(int n) {
        this.bitmapRolloverSelected = n;
    }

    public int getBitmapRolloverSelected() {
        return this.bitmapRolloverSelected;
    }

    public void setLeftText(boolean bl) {
        this.leftText = bl;
    }

    public boolean isLeftText() {
        return this.leftText;
    }

    public LeftTextAlignment getLeftTextAlignment() {
        return this.leftTextAlignment;
    }

    public void setLeftTextAlignment(LeftTextAlignment leftTextAlignment) {
        this.leftTextAlignment = leftTextAlignment;
    }

    public void setVTop(boolean bl) {
        this.vTop = bl;
    }

    public boolean isVTop() {
        return this.vTop;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)this.fontWidth * f);
        if (this.getBitmap() == null) {
            n += 17;
        }
        return n;
    }

    public float getControlWidth(int n) {
        if (this.getBitmap() == null) {
            n -= 17;
        }
        return (float)n / (float)this.fontWidth;
    }

    public void setBitmapSelectedVariable(String string) {
        this.bitmapSelVar = string;
    }

    public String getBitmapSelectedVariable() {
        return this.bitmapSelVar;
    }

    public void setBitmapRolloverSelectedVariable(String string) {
        this.bitmapRollSelVar = string;
    }

    public String getBitmapRolloverSelectedVariable() {
        return this.bitmapRollSelVar;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public int getBitmapDisabledSelected() {
        return this.bitmapDisabledSelected;
    }

    public void setBitmapDisabledSelected(int n) {
        this.bitmapDisabledSelected = n;
    }

    public String getBitmapDisabledSelectedVariable() {
        return this.bitmapDisSelVar;
    }

    public void setBitmapDisabledSelectedVariable(String string) {
        this.bitmapDisSelVar = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.updateSize();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.leftText, (String)"left-text", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.transparent, (String)"transparent", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.leftTextAlignment.getValue(), (int)0, (String)"left-text-alignment", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.vTop, (String)"vtop", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.notify, (String)"notify", (String)string, (StringBuilder)stringBuilder);
        if (this.getBitmap() != null) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapRollSelVar, (int)this.bitmapRolloverSelected, (int)0, (String)"bitmap-rollover-selected", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapSelVar, (int)this.bitmapSelected, (int)0, (String)"bitmap-selected", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapDisSelVar, (int)this.bitmapDisabledSelected, (int)0, (String)"bitmap-disabled-selected", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (int)this.value, (int)0, (String)"value", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.getTitlePositionVariable(), (int)this.titlePosition.getValue(), (int)0, (String)"title-position", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        } else if (iScreenAttribute.getFrom() != null && !iScreenAttribute.getFrom().getWord().equals("") && iScreenAttribute.getFrom().getWord().length() > 0 && iScreenAttribute.getFrom().getWord().charAt(0) == '\"') {
            this.setValue((int)PropertyDescriptorRegistry.parseFloat((String)iScreenAttribute.getFrom().getWord().substring(1, iScreenAttribute.getFrom().getWord().length() - 1)));
        }
        if (vector.contains("LEFT-TEXT")) {
            this.setLeftText(true);
        }
        if (vector.contains("NOTIFY")) {
            this.setNotify(true);
        }
        if (vector.contains("VTOP")) {
            this.setVTop(true);
        }
        this.setTitlePosition(new Position(0));
        for (int i = 0; i < iGUIControl.getControlProperties().size(); ++i) {
            String string = iPropElementList.getKey(i).toString();
            IPropElementValue[] iPropElementValueArray = iPropElementList.getValue(i);
            if (string.equalsIgnoreCase("BITMAP-SELECTED")) {
                if (iPropElementValueArray[0].getToken() != null) {
                    this.setBitmapSelected((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapSelectedVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                continue;
            }
            if (string.equalsIgnoreCase("BITMAP-DISABLED-SELECTED")) {
                if (iPropElementValueArray[0].getToken() != null) {
                    this.setBitmapDisabledSelected((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapDisabledSelectedVariable(iGUIControl.getControlProperties().getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (string.equalsIgnoreCase("BITMAP-ROLLOVER-SELECTED")) {
                if (iPropElementValueArray[0].getToken() != null) {
                    this.setBitmapRolloverSelected((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementValueArray[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapRolloverSelectedVariable(iPropElementValueArray[0].getVariableName().getNameIde());
                continue;
            }
            if (!string.equalsIgnoreCase("TITLE-POSITION") || iPropElementValueArray[0].getToken() == null) continue;
            if (iPropElementValueArray[0].getToken().getWord().equalsIgnoreCase("1")) {
                this.setTitlePosition(new Position(1));
                continue;
            }
            if (iPropElementValueArray[0].getToken().getWord().equalsIgnoreCase("2")) {
                this.setTitlePosition(new Position(2));
                continue;
            }
            if (iPropElementValueArray[0].getToken().getWord().equalsIgnoreCase("3")) {
                this.setTitlePosition(new Position(3));
                continue;
            }
            if (iPropElementValueArray[0].getToken().getWord().equalsIgnoreCase("4")) {
                this.setTitlePosition(new Position(4));
                continue;
            }
            if (!iPropElementValueArray[0].getToken().getWord().equalsIgnoreCase("5")) continue;
            this.setTitlePosition(new Position(5));
        }
    }
}

