/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractTextInputField;
import com.iscobol.screenpainter.beans.ExceptionTerminationValueProvider;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.CaseStyle;
import com.iscobol.screenpainter.beans.types.ComboBoxStyle;
import com.iscobol.screenpainter.beans.types.ComboItemSetting;
import com.iscobol.screenpainter.beans.types.ComboItemSettingList;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractComboBox
extends AbstractTextInputField
implements ExceptionTerminationValueProvider {
    private static final float DEFAULT_WIDTH_INSETS = 8.0f;
    private static final long serialVersionUID = 1L;
    private boolean notifySelchange;
    private boolean notifyDblclick;
    private boolean unsorted;
    private boolean noAutosel;
    private ComboItemSettingList itemSettings;
    private String value;
    private String valueVar;
    private String maxTextVar;
    private String itemToAddVar;
    private String valuePicture;
    private String bitmapWidthVar;
    private String exceptionValueVar;
    private String terminationValueVar;
    private String valueContainer;
    private String ntfSelchangeEv;
    private String ntfSelchangeEx;
    private String cmdDblclickEv;
    private String cmdDblclickEx;
    private String valueContainerItem;
    private String formatPicture;
    private ImageType image;
    private int exceptionValue;
    private int terminationValue;
    private int maxText;
    private int bitmapWidth;
    private BorderStyle border;
    private CaseStyle caseStyle;
    private int itemCount;
    private String linkTo;
    private ComboBoxStyle style;
    private String placeholder;
    private String placeholderVar;

    public AbstractComboBox(Component component) {
        super(component);
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)(this.fontWidth + 2) * f);
        n = (int)((float)n + 8.0f);
        return n;
    }

    public float getControlWidth(int n) {
        n = (int)((float)n - 8.0f);
        return n / this.fontWidth - 2;
    }

    public boolean isUserWhite() {
        return true;
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setLinkTo(String string) {
        this.linkTo = string;
    }

    public void setBorder(BorderStyle borderStyle) {
        this.border = borderStyle;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public void setCase(CaseStyle caseStyle) {
        this.caseStyle = caseStyle;
    }

    public CaseStyle getCase() {
        return this.caseStyle;
    }

    public String getFormatPicture() {
        return this.formatPicture;
    }

    public void setFormatPicture(String string) {
        this.formatPicture = string;
    }

    public void setNoAutosel(boolean bl) {
        this.noAutosel = bl;
    }

    public boolean isNoAutosel() {
        return this.noAutosel;
    }

    public String getItemToAddVariable() {
        return this.itemToAddVar;
    }

    public int getComboHeight(int n) {
        return this.getComponent().getFontMetrics(this.getComponent().getFont()).getHeight() + 5;
    }

    public void setItemToAddVariable(String string) {
        this.itemToAddVar = string;
    }

    public String getValueContainer() {
        return this.valueContainer;
    }

    public void setValueContainer(String string) {
        this.valueContainer = string;
    }

    public void set3D(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(0));
        }
    }

    public boolean is3D() {
        return this.border.getValue() == 0;
    }

    public ComboBoxStyle getStyle() {
        return this.style;
    }

    public void setStyle(ComboBoxStyle comboBoxStyle) {
        this.style = comboBoxStyle;
    }

    public void setBoxed(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(1));
        }
    }

    public boolean isBoxed() {
        return this.border.getValue() == 1;
    }

    public void setLower(boolean bl) {
        if (bl) {
            this.setCase(new CaseStyle(2));
        }
    }

    public boolean isLower() {
        return this.caseStyle.getValue() == 2;
    }

    public void setDropDown(boolean bl) {
        if (bl) {
            this.setStyle(new ComboBoxStyle(0));
        }
    }

    public boolean isDropDown() {
        return this.style.getValue() == 0;
    }

    public void setUnsorted(boolean bl) {
        this.unsorted = bl;
    }

    public boolean isUnsorted() {
        return this.unsorted;
    }

    public void setNotifySelchange(boolean bl) {
        this.notifySelchange = bl;
    }

    public boolean isNotifySelchange() {
        return this.notifySelchange;
    }

    public void setNotifyDblclick(boolean bl) {
        this.notifyDblclick = bl;
    }

    public boolean isNotifyDblclick() {
        return this.notifyDblclick;
    }

    public void setDropList(boolean bl) {
        if (bl) {
            this.setStyle(new ComboBoxStyle(1));
        }
    }

    public boolean isDropList() {
        return this.style.getValue() == 1;
    }

    public void setStaticList(boolean bl) {
    }

    public boolean isStaticList() {
        return false;
    }

    public void setUpper(boolean bl) {
        if (bl) {
            this.setCase(new CaseStyle(1));
        }
    }

    public boolean isUpper() {
        return this.caseStyle.getValue() == 1;
    }

    public void setNoBox(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(2));
        }
    }

    public boolean isNoBox() {
        return this.border.getValue() == 2;
    }

    public void setItemToAdd(ComboItemSettingList comboItemSettingList) {
        this.itemSettings = comboItemSettingList;
        this.itemCount = this.itemSettings.getSettingCount();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public ComboItemSettingList getItemToAdd() {
        return this.itemSettings;
    }

    public void setTerminationValueVariable(String string) {
        this.terminationValueVar = string;
    }

    public String getTerminationValueVariable() {
        return this.terminationValueVar;
    }

    public void setExceptionValueVariable(String string) {
        this.exceptionValueVar = string;
    }

    public String getExceptionValueVariable() {
        return this.exceptionValueVar;
    }

    public void setTerminationValue(int n) {
        this.terminationValue = n;
    }

    public int getTerminationValue() {
        return this.terminationValue;
    }

    public void setExceptionValue(int n) {
        this.exceptionValue = n;
    }

    public int getExceptionValue() {
        return this.exceptionValue;
    }

    public void setNtfSelChangeEv(String string) {
        this.ntfSelchangeEv = string;
    }

    public String getNtfSelChangeEv() {
        return this.ntfSelchangeEv;
    }

    public void setCmdDblClickEv(String string) {
        this.cmdDblclickEv = string;
    }

    public String getCmdDblClickEv() {
        return this.cmdDblclickEv;
    }

    public void setNtfSelChangeEx(String string) {
        this.ntfSelchangeEx = string;
    }

    public String getNtfSelChangeEx() {
        return this.ntfSelchangeEx;
    }

    public void setCmdDblClickEx(String string) {
        this.cmdDblclickEx = string;
    }

    public String getCmdDblClickEx() {
        return this.cmdDblclickEx;
    }

    public void setMaxText(int n) {
        this.maxText = n;
    }

    public int getMaxText() {
        return this.maxText;
    }

    public void setMaxTextVariable(String string) {
        this.maxTextVar = string;
    }

    public String getMaxTextVariable() {
        return this.maxTextVar;
    }

    public String getValueContainerItem() {
        return this.valueContainerItem;
    }

    public void setValueContainerItem(String string) {
        this.valueContainerItem = string;
    }

    public void setBitmap(ImageType imageType) {
        this.image = imageType;
    }

    public ImageType getBitmap() {
        return this.image;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(12.0f);
        this.setLines(5.0f);
        this.setCase(new CaseStyle());
        this.setBorder(new BorderStyle(0));
        this.setItemToAdd(new ComboItemSettingList());
        this.setStyle(new ComboBoxStyle());
        this.itemCount = 3;
        for (int i = 0; i < this.itemCount; ++i) {
            this.itemSettings.addSetting((SettingItem)new ComboItemSetting());
        }
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public String getPlaceholderVariable() {
        return this.placeholderVar;
    }

    public void setPlaceholderVariable(String string) {
        this.placeholderVar = string;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string3 = string != null ? string : this.getName();
        int n = this.itemSettings.getSettingCount();
        if (n > 0) {
            ComboItemSetting comboItemSetting;
            int n2;
            stringBuilder.append(cobolFormatter.formatLine(string2 + "modify " + string3));
            if (bl2 || !IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.valueContainer, (String)"item-to-add table", (String)("   " + string2), (StringBuilder)stringBuilder)) {
                for (n2 = 0; n2 < n; ++n2) {
                    comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n2);
                    IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)comboItemSetting.getText(), (String)"item-to-add", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)true);
                    IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)comboItemSetting.getHiddenDataVariable(), (String)comboItemSetting.getHiddenData(), (String)"hidden-data", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)bl2);
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(string2 + "."));
            for (n2 = 0; n2 < n; ++n2) {
                comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n2);
                if (comboItemSetting.getBitmapNumber() <= 0) continue;
                StringBuilder stringBuilder2 = new StringBuilder(string2);
                stringBuilder2.append("modify ");
                stringBuilder2.append(string3);
                stringBuilder2.append(" item ");
                stringBuilder2.append(n2 + 1);
                stringBuilder2.append(" bitmap-number ");
                stringBuilder2.append(comboItemSetting.getBitmapNumber());
                stringBuilder2.append(".");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.is3D(), (String)"3-d", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBoxed(), (String)"boxed", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoBox(), (String)"no-box", (String)string, (StringBuilder)stringBuilder);
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isUpper(), (String)"upper", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isLower(), (String)"lower", (String)string, (StringBuilder)stringBuilder);
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isDropDown(), (String)"drop-down", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isDropList(), (String)"drop-list", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.unsorted, (String)"unsorted", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.notifySelchange, (String)"notify-selchange", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.notifyDblclick, (String)"notify-dblclick", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noAutosel, (String)"no-autosel", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (String)this.value, (String)"value", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.placeholderVar, (String)this.placeholder, (String)"placeholder", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxTextVar, (int)this.maxText, (int)0, (String)"max-text", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)0, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getPictureCode((CobolFormatter)cobolFormatter, (String)this.formatPicture, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.image, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        if (this.allComponentInScreen) {
            this.getOtherScreenSectionCode(stringBuilder, cobolFormatter, n, bl, bl2, bl3);
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.ntfSelchangeEv, (String)this.ntfSelchangeEx, (String)"ntf-selchange", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdDblclickEv, (String)this.cmdDblclickEx, (String)"cmd-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.exceptionValue > 0) {
            vector.addElement(new Integer(this.exceptionValue));
        }
        return vector;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        for (n = this.itemCount - 1; n >= 0; --n) {
            this.itemSettings.removeSetting(n);
        }
        this.itemCount = 0;
        if (iVariableDeclarationScreen.getValueToken() != null) {
            this.setValue(iVariableDeclarationScreen.getValueToken().getWord());
        } else if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        }
        this.setBorder(new BorderStyle(3));
        if (vector.contains("BOXED")) {
            this.setBorder(new BorderStyle(1));
        } else if (vector.contains("3-D")) {
            this.setBorder(new BorderStyle(0));
        } else if (vector.contains("NO-BOX")) {
            this.setBorder(new BorderStyle(2));
        }
        this.setCase(new CaseStyle(0));
        if (vector.contains("LOWER")) {
            this.setCase(new CaseStyle(2));
        } else if (vector.contains("UPPER")) {
            this.setCase(new CaseStyle(1));
        }
        if (vector.contains("DROP-DOWN")) {
            this.setStyle(new ComboBoxStyle(0));
        } else if (vector.contains("DROP-LIST")) {
            this.setStyle(new ComboBoxStyle(1));
        }
        if (vector.contains("UNSORTED")) {
            this.setUnsorted(true);
        }
        if (vector.contains("NO-AUTOSEL")) {
            this.setUnsorted(true);
        }
        if (vector.contains("NOTIFY-SELCHANGE")) {
            this.setNotifySelchange(true);
        }
        if (vector.contains("NOTIFY-DBLCLICK")) {
            this.setNotifyDblclick(true);
        }
        for (n = 0; n < iPropElementList.size(); ++n) {
            int n2;
            if (iPropElementList.getKey(n).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(n)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(n).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("MAX-TEXT")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setMaxText((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxTextVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iGUIControl.getControlProperties().getKey(n).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iGUIControl.getControlProperties().getValue(n)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(n).equals("EXCEPTION-VALUE")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setExceptionValue((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setExceptionValueVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("TERMINATION-VALUE")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setTerminationValue((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setTerminationValueVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("ITEM-TO-ADD")) {
                for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                    vector3.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("BITMAP-NUMBER")) {
                for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                    vector2.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                }
                continue;
            }
            if (!iPropElementList.getKey(n).equals("HIDDEN-DATA")) continue;
            for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    vector4.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                    continue;
                }
                vector4.add(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
            }
        }
        ComboItemSetting comboItemSetting = null;
        ComboItemSettingList comboItemSettingList = null;
        int n3 = vector4.size();
        if (n3 < vector3.size()) {
            n3 = vector3.size();
        }
        if (n3 < vector2.size()) {
            n3 = vector2.size();
        }
        for (int i = 0; i < n3; ++i) {
            if (comboItemSettingList == null) {
                comboItemSettingList = new ComboItemSettingList();
            }
            comboItemSetting = new ComboItemSetting();
            if (vector4.size() > i) {
                comboItemSetting.setHiddenData((String)vector4.elementAt(i));
            }
            if (vector3.size() > i) {
                comboItemSetting.setText((String)vector3.elementAt(i));
            }
            if (vector2.size() > i) {
                comboItemSetting.setBitmapNumber((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector2.elementAt(i))));
            }
            comboItemSettingList.addSetting((SettingItem)comboItemSetting);
        }
        if (comboItemSettingList != null) {
            this.setItemToAdd(comboItemSettingList);
        }
    }

    public void getOtherScreenSectionCode(StringBuilder stringBuilder, CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        String string = IscobolBeanConstants.getSpaces((int)n);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = this.itemSettings.getSettingCount();
        if (n2 > 0) {
            StringBuilder stringBuilder2;
            ComboItemSetting comboItemSetting;
            int n3;
            stringBuilder.append(cobolFormatter.formatLine(string));
            for (n3 = 0; n3 < n2; ++n3) {
                comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n3);
                if (comboItemSetting.getText() != null) {
                    bl5 = true;
                }
                if (comboItemSetting.getHiddenDataVariable() != null || comboItemSetting.getHiddenData() != null) {
                    bl4 = true;
                }
                if (comboItemSetting.getBitmapNumber() == 0) continue;
                bl6 = true;
            }
            if (bl5) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   item-to-add (");
                for (n3 = 0; n3 < n2; ++n3) {
                    comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(comboItemSetting.getText());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl4 && n2 > 1) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   hidden-data (");
                for (n3 = 0; n3 < n2; ++n3) {
                    comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    if (comboItemSetting.getHiddenDataVariable() != null && !comboItemSetting.getHiddenDataVariable().equals("")) {
                        stringBuilder2.append(comboItemSetting.getHiddenDataVariable());
                        continue;
                    }
                    stringBuilder2.append(comboItemSetting.getHiddenData());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl6 && n2 > 1) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   bitmap-number (");
                for (n3 = 0; n3 < n2; ++n3) {
                    comboItemSetting = (ComboItemSetting)this.itemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(comboItemSetting.getBitmapNumber());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
    }
}

