/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractTextInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.DateEntryMaxDC;
import com.iscobol.screenpainter.beans.types.DateEntryStyle;
import com.iscobol.screenpainter.beans.types.DateEntryValueFormat;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractDateEntry
extends AbstractTextInputField {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_WIDTH_INSETS = 50.0f;
    private boolean readOnly;
    private boolean numeric;
    private boolean allowEmpty;
    private boolean noF4;
    private boolean notifyChange;
    private boolean rightAlign;
    private boolean noUpdown;
    private boolean showNone;
    private boolean spinner;
    private boolean decorationBackgroundVisible;
    private boolean decorationBordersVisible;
    private boolean weekOfYearVisible;
    private boolean selfAct;
    private DateEntryStyle style;
    private String maxVal;
    private String minVal;
    private int bitmapNumber;
    private int bitmapWidth = 16;
    private ImageType bitmap;
    private DateEntryMaxDC maxDayCharacters;
    private DateEntryValueFormat valueFormat;
    private String value;
    private String valueVar;
    private String maxValVar;
    private String minValVar;
    private String displayFormat;
    private String displayFormatVar;
    private String valueFormatVar;
    private String bitmapNumberVar;
    private String valuePicture;
    private String bitmapWidthVar;
    private String decorationBackgroundVar;
    private String sundayForegroundVar;
    private String weekdayForegroundVar;
    private String maxDayCharactersVar;
    private String ntfChangedEv;
    private String ntfChangedEx;
    private FontType calendarFont = FontType.getStandardFont((String)"Default-Font");
    private BackgroundColorType decorationBackground = BackgroundColorType.DISABLED_COLOR;
    private ForegroundColorType sundayForeground = ForegroundColorType.DISABLED_COLOR;
    private ForegroundColorType weekdayForeground = ForegroundColorType.DISABLED_COLOR;

    public AbstractDateEntry(Component component) {
        super(component);
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(15.0f);
        this.setLines(2.0f);
        this.setStyle(new DateEntryStyle());
        this.setValueFormat(new DateEntryValueFormat());
        this.setMaxDayCharacters(new DateEntryMaxDC());
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public boolean isNoF4() {
        return this.noF4;
    }

    public boolean isUserWhite() {
        return true;
    }

    public void setNoF4(boolean bl) {
        this.noF4 = bl;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)this.fontWidth * f);
        n = (int)((float)n + 50.0f);
        return n;
    }

    public float getControlWidth(int n) {
        n = (int)((float)n - 50.0f);
        return (float)n / (float)this.fontWidth;
    }

    public boolean isNotifyChange() {
        return this.notifyChange;
    }

    public void setNotifyChange(boolean bl) {
        this.notifyChange = bl;
    }

    public boolean isRightAlign() {
        return this.rightAlign;
    }

    public void setRightAlign(boolean bl) {
        this.rightAlign = bl;
    }

    public boolean isTime() {
        return this.style.getValue() == 3;
    }

    public void setTime(boolean bl) {
        if (bl) {
            this.setStyle(new DateEntryStyle(3));
        }
    }

    public boolean isLongDate() {
        return this.style.getValue() == 1;
    }

    public void setLongDate(boolean bl) {
        if (bl) {
            this.setStyle(new DateEntryStyle(1));
        }
    }

    public boolean isShortDate() {
        return this.style.getValue() == 2;
    }

    public void setShortDate(boolean bl) {
        if (bl) {
            this.setStyle(new DateEntryStyle(2));
        }
    }

    public boolean isCenturyDate() {
        return this.style.getValue() == 0;
    }

    public void setCenturyDate(boolean bl) {
        if (bl) {
            this.setStyle(new DateEntryStyle(0));
        }
    }

    public DateEntryStyle getStyle() {
        return this.style;
    }

    public void setStyle(DateEntryStyle dateEntryStyle) {
        this.style = dateEntryStyle;
        switch (dateEntryStyle.getValue()) {
            case 2: {
                this.setValueFormat(new DateEntryValueFormat(1));
                break;
            }
            case 0: 
            case 1: {
                this.setValueFormat(new DateEntryValueFormat(0));
                break;
            }
            case 3: {
                this.setValueFormat(new DateEntryValueFormat(3));
            }
        }
    }

    public boolean isNoUpdown() {
        return this.noUpdown;
    }

    public void setNoUpdown(boolean bl) {
        this.noUpdown = bl;
    }

    public boolean isShowNone() {
        return this.showNone;
    }

    public void setShowNone(boolean bl) {
        this.showNone = bl;
    }

    public boolean isSpinner() {
        return this.spinner;
    }

    public void setSpinner(boolean bl) {
        this.spinner = bl;
    }

    public boolean isDecorationBackgroundVisible() {
        return this.decorationBackgroundVisible;
    }

    public void setDecorationBackgroundVisible(boolean bl) {
        this.decorationBackgroundVisible = bl;
    }

    public boolean isDecorationBordersVisible() {
        return this.decorationBordersVisible;
    }

    public void setDecorationBordersVisible(boolean bl) {
        this.decorationBordersVisible = bl;
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public boolean isWeekOfYearVisible() {
        return this.weekOfYearVisible;
    }

    public void setWeekOfYearVisible(boolean bl) {
        this.weekOfYearVisible = bl;
    }

    public String getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(String string) {
        this.maxVal = string;
    }

    public String getMinVal() {
        return this.minVal;
    }

    public void setMinVal(String string) {
        this.minVal = string;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public DateEntryMaxDC getMaxDayCharacters() {
        return this.maxDayCharacters;
    }

    public void setMaxDayCharacters(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 3) {
            n = 3;
        }
        this.setMaxDayCharacters(new DateEntryMaxDC(n));
    }

    public void setMaxDayCharacters(DateEntryMaxDC dateEntryMaxDC) {
        this.maxDayCharacters = dateEntryMaxDC;
    }

    public ImageType getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(ImageType imageType) {
        this.bitmap = imageType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String string) {
        this.displayFormat = string;
    }

    public DateEntryValueFormat getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(String string) {
        boolean bl = false;
        if (string != null) {
            String[] stringArray = this.valueFormat.getNames();
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                this.setValueFormat(new DateEntryValueFormat(i));
                bl = true;
            }
        }
        if (!bl) {
            this.setValueFormat(new DateEntryValueFormat());
        }
    }

    public void setValueFormat(DateEntryValueFormat dateEntryValueFormat) {
        this.valueFormat = dateEntryValueFormat;
    }

    public String getDisplayFormatVariable() {
        return this.displayFormatVar;
    }

    public void setDisplayFormatVariable(String string) {
        this.displayFormatVar = string;
    }

    public String getValueFormatVariable() {
        return this.valueFormatVar;
    }

    public void setValueFormatVariable(String string) {
        this.valueFormatVar = string;
    }

    public String getBitmapNumberVariable() {
        return this.bitmapNumberVar;
    }

    public void setBitmapNumberVariable(String string) {
        this.bitmapNumberVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getDecorationBackgroundVariable() {
        return this.decorationBackgroundVar;
    }

    public void setDecorationBackgroundVariable(String string) {
        this.decorationBackgroundVar = string;
    }

    public String getSundayForegroundVariable() {
        return this.sundayForegroundVar;
    }

    public void setSundayForegroundVariable(String string) {
        this.sundayForegroundVar = string;
    }

    public String getWeekdayForegroundVariable() {
        return this.weekdayForegroundVar;
    }

    public void setWeekdayForegroundVariable(String string) {
        this.weekdayForegroundVar = string;
    }

    public boolean isSelfAct() {
        return this.selfAct;
    }

    public void setSelfAct(boolean bl) {
        this.selfAct = bl;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean bl) {
        this.allowEmpty = bl;
    }

    public String getMaxDayCharactersVariable() {
        return this.maxDayCharactersVar;
    }

    public void setMaxDayCharactersVariable(String string) {
        this.maxDayCharactersVar = string;
    }

    public String getNtfChangedEv() {
        return this.ntfChangedEv;
    }

    public void setNtfChangedEv(String string) {
        this.ntfChangedEv = string;
    }

    public String getNtfChangedEx() {
        return this.ntfChangedEx;
    }

    public void setNtfChangedEx(String string) {
        this.ntfChangedEx = string;
    }

    public FontType getCalendarFont() {
        return this.calendarFont;
    }

    public void setCalendarFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.calendarFont, (ResourceWithHandleType)fontType);
        this.calendarFont = fontType;
    }

    public String getCalendarFontVariable() {
        return this.calendarFont != null ? this.calendarFont.getHandleName() : null;
    }

    public void setCalendarFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.calendarFont == null) {
                this.calendarFont = FontType.getNullFont();
            }
            this.calendarFont.setHandleName(string);
        } else if (this.calendarFont != null) {
            this.calendarFont.setHandleName(string);
        }
    }

    public BackgroundColorType getDecorationBackground() {
        return this.decorationBackground;
    }

    public void setDecorationBackground(BackgroundColorType backgroundColorType) {
        this.decorationBackground = backgroundColorType;
    }

    public ForegroundColorType getSundayForeground() {
        return this.sundayForeground;
    }

    public void setSundayForeground(ForegroundColorType foregroundColorType) {
        this.sundayForeground = foregroundColorType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public ForegroundColorType getWeekdayForeground() {
        return this.weekdayForeground;
    }

    public void setWeekdayForeground(ForegroundColorType foregroundColorType) {
        this.weekdayForeground = foregroundColorType;
    }

    public String getMaxValVariable() {
        return this.maxValVar;
    }

    public void setMaxValVariable(String string) {
        this.maxValVar = string;
    }

    public String getMinValVariable() {
        return this.minValVar;
    }

    public void setMinValVariable(String string) {
        this.minValVar = string;
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!(IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isTime(), (String)"time", (String)string, (StringBuilder)stringBuilder) || IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isLongDate(), (String)"long-date", (String)string, (StringBuilder)stringBuilder) || IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isCenturyDate(), (String)"century-date", (String)string, (StringBuilder)stringBuilder))) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isShortDate(), (String)"short-date", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.selfAct, (String)"self-act", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noF4, (String)"no-f4", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.notifyChange, (String)"notify-change", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.rightAlign, (String)"right-align", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noUpdown, (String)"no-updown", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.showNone, (String)"show-none", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.spinner, (String)"spinner", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.numeric, (String)"numeric", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.allowEmpty, (String)"allow-empty", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.readOnly, (String)"read-only", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.decorationBackgroundVisible, (String)"decoration-background-visible", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.decorationBordersVisible, (String)"decoration-borders-visible", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.weekOfYearVisible, (String)"week-of-year-visible", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.maxValVar, (String)this.maxVal, (String)"max-val", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.minValVar, (String)this.minVal, (String)"min-val", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (String)this.value, (String)"value", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.displayFormatVar, (String)this.displayFormat, (String)"display-format", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        if (bl3 || !IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.valueFormatVar, (String)"value-format", (String)string, (StringBuilder)stringBuilder)) {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("value-format ");
            switch (this.valueFormat.getValue()) {
                case 3: {
                    stringBuilder2.append("davf-hhmmss");
                    break;
                }
                case 2: {
                    stringBuilder2.append("davf-hhmmsshh");
                    break;
                }
                case 1: {
                    stringBuilder2.append("davf-yymmdd");
                    break;
                }
                case 0: {
                    stringBuilder2.append("davf-yyyymmdd");
                    break;
                }
                case 4: {
                    stringBuilder2.append("davf-yyyymmddhhmmsshh");
                    break;
                }
                case 6: {
                    stringBuilder2.append("davf-mmddyy");
                    break;
                }
                case 5: {
                    stringBuilder2.append("davf-mmddyyyy");
                    break;
                }
                case 7: {
                    stringBuilder2.append("davf-mmddyyyyhhmmsshh");
                    break;
                }
                case 9: {
                    stringBuilder2.append("davf-ddmmyy");
                    break;
                }
                case 8: {
                    stringBuilder2.append("davf-ddmmyyyy");
                    break;
                }
                case 10: {
                    stringBuilder2.append("davf-ddmmyyyyhhmmsshh");
                    break;
                }
                case 11: {
                    stringBuilder2.append("davf-hhmm");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapNumberVar, (int)this.bitmapNumber, (int)0, (String)"bitmap-number", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)16, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxDayCharactersVar, (int)this.maxDayCharacters.getValue(), (int)0, (String)"maxday-characters", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.bitmap, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.calendarFont, (String)"calendar-font", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.decorationBackgroundVar, (ColorType)this.decorationBackground, (int)0, (String)"decoration-background", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.sundayForegroundVar, (ColorType)this.sundayForeground, (int)0, (String)"sunday-foreground", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.weekdayForegroundVar, (ColorType)this.weekdayForeground, (int)0, (String)"weekday-foreground", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.ntfChangedEv, (String)this.ntfChangedEx, (String)"ntf-changed", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        } else if (iScreenAttribute.getFrom() != null) {
            this.setValue(iScreenAttribute.getFrom().getWord().substring(1, iScreenAttribute.getFrom().getWord().length() - 1));
        }
        if (vector.contains("NUMERIC")) {
            this.setNumeric(true);
        }
        if (vector.contains("ALLOW-EMPTY")) {
            this.setAllowEmpty(true);
        }
        if (vector.contains("NO-F4")) {
            this.setNoF4(true);
        }
        if (vector.contains("NOTIFY-CHANGE")) {
            this.setNotifyChange(true);
        }
        if (vector.contains("RIGHT-ALIGN")) {
            this.setRightAlign(true);
        }
        if (vector.contains("SHOW-NONE")) {
            this.setShowNone(true);
        }
        if (vector.contains("SPINNER")) {
            this.setSpinner(true);
        }
        if (vector.contains("DECORATION-BACKGROUND-VISIBLE")) {
            this.setDecorationBackgroundVisible(true);
        }
        if (vector.contains("DECORATION-BORDERS-VISIBLE")) {
            this.setDecorationBordersVisible(true);
        }
        if (vector.contains("WEEK-OF-YEAR-VISIBLE")) {
            this.setWeekOfYearVisible(true);
        }
        if (vector.contains("SELF-ACT")) {
            this.setWeekOfYearVisible(true);
        }
        if (vector.contains("TIME")) {
            this.setStyle(new DateEntryStyle(3));
        } else if (vector.contains("CENTURY-DATE")) {
            this.setStyle(new DateEntryStyle(0));
        } else if (vector.contains("LONG-DATE")) {
            this.setStyle(new DateEntryStyle(1));
        } else if (vector.contains("SHORT-DATE")) {
            this.setStyle(new DateEntryStyle(2));
        }
        if (vector.contains("READ-ONLY")) {
            this.setReadOnly(true);
        }
        iPropElementList = iGUIControl.getControlProperties();
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("BITMAP-NUMBER")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapNumber((int)PropertyDescriptorRegistry.parseFloat((String)iGUIControl.getControlProperties().getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapNumberVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iGUIControl.getControlProperties().getKey(i).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(i)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("MAX-VAL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMaxVal(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setMaxValVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MIN-VAL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMinVal(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setMinValVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DISPLAY-FORMAT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDisplayFormat(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setDisplayFormatVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VALUE-FORMAT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setValueFormat(new DateEntryValueFormat((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt())));
                    continue;
                }
                this.setValueFormatVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MAXDAY-CHARACTERS")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMaxDayCharacters(new DateEntryMaxDC((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt())));
                    continue;
                }
                this.setMaxDayCharactersVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DECORATION-BACKGROUND")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDecorationBackground(new BackgroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt())));
                    continue;
                }
                this.setDecorationBackgroundVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("SUNDAY-FOREGROUND")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setSundayForeground(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt())));
                    continue;
                }
                this.setSundayForegroundVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("WEEKDAY-FOREGROUND")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setWeekdayForeground(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getAsInt())));
                    continue;
                }
                this.setWeekdayForegroundVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("CALENDAR-FONT") || iPropElementList.getValue(i)[0].getToken() == null) continue;
            this.setCalendarFont(new FontType(iPropElementList.getValue(i)[0].getToken().getWord()));
        }
    }
}

