/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractTextInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.CaseStyle;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.EntryFieldAction;
import com.iscobol.screenpainter.beans.types.EntryFieldFormatType;
import com.iscobol.screenpainter.beans.types.EntryFieldStyle;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.HAlignment;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ItemSetting;
import com.iscobol.screenpainter.beans.types.ItemSettingList;
import com.iscobol.screenpainter.beans.types.ItemToAddSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.TextOrientation;
import com.iscobol.screenpainter.beans.types.ValidationOpts;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractEntryField
extends AbstractTextInputField {
    private static final int DEFAULT_HEIGHT_INSETS = 6;
    private static final int DEFAULT_SCROLLBAR_INSETS = 3;
    private static final int DEFAULT_WIDTH_INSETS = 10;
    private static final int DEFAULT_VSCROLLBAR_WIDTH = 15;
    private static final int DEFAULT_SPINNER_WIDTH = 15;
    private static final long serialVersionUID = 1L;
    private boolean noWrap;
    private boolean auto;
    private boolean noAutosel;
    private boolean notifyChange;
    private boolean numeric;
    private boolean readOnly;
    private boolean secure;
    private boolean useReturn;
    private boolean useTab;
    private boolean required;
    private boolean valueMultiple;
    private int autodecimal;
    private int cursor;
    private int cursorRow;
    private int cursorCol;
    private int maxLines;
    private int maxText;
    private int minVal;
    private int maxVal;
    private int selectionStart;
    private int selectionStartRow;
    private int selectionStartCol;
    private EntryFieldFormatType formatType;
    private EntryFieldAction action;
    private String value;
    private String valueVar;
    private String selectionText;
    private String formatString;
    private String autodecimalVar;
    private String cursorVar;
    private String cursorColVar;
    private String cursorRowVar;
    private String maxLinesVar;
    private String maxTextVar;
    private String minValVar;
    private String maxValVar;
    private String valuePicture;
    private String visibleProposalCountVar;
    private String proposalDelayVar;
    private String selectionStartVar;
    private String selectionTextVar;
    private String selectionStartRowVar;
    private String selectionStartColVar;
    private String msgSpinDownEv;
    private String msgSpinUpEv;
    private String ntfChangedEv;
    private String ntfChangedEx;
    private String formatPicture;
    private String fillChar;
    private ValidationOpts validationOpts;
    private String validationOptsVar;
    private String validationErrmsg;
    private String validationErrmsgVar;
    private String validationRegexp;
    private String validationRegexpVar;
    private EntryFieldStyle style;
    private HAlignment alignment;
    private BorderStyle border;
    private CaseStyle caseStyle;
    private ItemSettingList proposal;
    private TextOrientation textOrientation;
    private int visibleProposalCount = 5;
    private int proposalDelay = 500;
    private boolean proposalsUnsorted;
    private int proposalMinText = 1;
    private String proposalMinTextVar;
    private String placeholder;
    private String placeholderVar;
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private String borderColorVar;
    private ImageType image;
    private int bitmapWidth;
    private int bitmapNumber;
    private int bitmapTrailingNumber;
    private int bitmapDisabled;
    private int bitmapTrailingDisabled;
    private String bitmapWidthVar;
    private String bitmapNumberVar;
    private String bitmapTrailingNumberVar;
    private String bitmapDisabledVar;
    private String bitmapTrailingDisabledVar;
    private String msgBitmapClickedEv;
    private String msgBitmapDblclickEv;
    private String spellChecking;
    private String spellCheckingVar;
    private String bitmapHint;
    private String bitmapHintVar;
    private String bitmapTrailingHint;
    private String bitmapTrailingHintVar;
    private int bitmapRollover;
    private String bitmapRolloverVar;
    private int bitmapTrailingRollover;
    private String bitmapTrailingRolloverVar;
    private int notifyChangeDelay;
    private String notifyChangeDelayVar;

    public AbstractEntryField(Component component) {
        super(component);
    }

    public int getControlHeight(float f) {
        int n = (int)((float)this.metrics.getHeight() * f);
        if (this.border.getValue() != 2) {
            n += 6;
        }
        if (this.style.getValue() == 3) {
            n += 3;
        }
        return n;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)this.fontWidth * f);
        n += 10;
        if (this.style.getValue() == 3) {
            n += 15;
        } else if (this.style.getValue() == 4) {
            n += 15;
        }
        return n;
    }

    public float getControlHeight(int n) {
        if (this.border.getValue() != 2) {
            n -= 6;
        }
        if (this.style.getValue() == 3) {
            n -= 3;
        }
        return (float)n / (float)this.metrics.getHeight();
    }

    public float getControlWidth(int n) {
        n -= 10;
        if (this.style.getValue() == 3) {
            n -= 15;
        } else if (this.style.getValue() == 4) {
            n -= 15;
        }
        return (float)n / (float)this.fontWidth;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(15.0f);
        this.setLines(2.0f);
        this.setValidationOpts(new ValidationOpts());
        this.setProposal(new ItemSettingList());
        this.setFormatType(new EntryFieldFormatType());
        this.setStyle(new EntryFieldStyle());
        this.setAlignment(new HAlignment());
        this.setCase(new CaseStyle());
        this.setBorder(new BorderStyle(0));
        this.setAction(new EntryFieldAction());
        this.setTextOrientation(new TextOrientation());
    }

    public boolean isUserWhite() {
        return true;
    }

    public EntryFieldStyle getStyle() {
        return this.style;
    }

    public void setStyle(EntryFieldStyle entryFieldStyle) {
        this.style = entryFieldStyle;
        this.updateSize();
        this.updateLines();
    }

    public String getFormatPicture() {
        return this.formatPicture;
    }

    public void setFormatPicture(String string) {
        this.formatPicture = string;
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public void setBorder(BorderStyle borderStyle) {
        this.border = borderStyle;
        this.updateLines();
    }

    public String getVisibleProposalCountVariable() {
        return this.visibleProposalCountVar;
    }

    public void setVisibleProposalCountVariable(String string) {
        this.visibleProposalCountVar = string;
    }

    public void setBitmap(ImageType imageType) {
        this.image = imageType;
    }

    public ImageType getBitmap() {
        return this.image;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getBitmapTrailingNumber() {
        return this.bitmapTrailingNumber;
    }

    public void setBitmapTrailingNumber(int n) {
        this.bitmapTrailingNumber = n;
    }

    public String getBitmapNumberVariable() {
        return this.bitmapNumberVar;
    }

    public void setBitmapNumberVariable(String string) {
        this.bitmapNumberVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getBitmapHint() {
        return this.bitmapHint;
    }

    public void setBitmapHint(String string) {
        this.bitmapHint = string;
    }

    public String getBitmapHintVariable() {
        return this.bitmapHintVar;
    }

    public void setBitmapHintVariable(String string) {
        this.bitmapHintVar = string;
    }

    public String getBitmapTrailingHint() {
        return this.bitmapTrailingHint;
    }

    public void setBitmapTrailingHint(String string) {
        this.bitmapTrailingHint = string;
    }

    public String getBitmapTrailingHintVariable() {
        return this.bitmapTrailingHintVar;
    }

    public void setBitmapTrailingHintVariable(String string) {
        this.bitmapTrailingHintVar = string;
    }

    public int getBitmapRollover() {
        return this.bitmapRollover;
    }

    public void setBitmapRollover(int n) {
        this.bitmapRollover = n;
    }

    public String getBitmapRolloverVariable() {
        return this.bitmapRolloverVar;
    }

    public void setBitmapRolloverVariable(String string) {
        this.bitmapRolloverVar = string;
    }

    public int getBitmapTrailingRollover() {
        return this.bitmapTrailingRollover;
    }

    public void setBitmapTrailingRollover(int n) {
        this.bitmapTrailingRollover = n;
    }

    public String getBitmapTrailingRolloverVariable() {
        return this.bitmapTrailingRolloverVar;
    }

    public void setBitmapTrailingRolloverVariable(String string) {
        this.bitmapTrailingRolloverVar = string;
    }

    public String getBitmapTrailingNumberVariable() {
        return this.bitmapTrailingNumberVar;
    }

    public void setBitmapTrailingNumberVariable(String string) {
        this.bitmapTrailingNumberVar = string;
    }

    public int getBitmapDisabled() {
        return this.bitmapDisabled;
    }

    public void setBitmapDisabled(int n) {
        this.bitmapDisabled = n;
    }

    public int getBitmapTrailingDisabled() {
        return this.bitmapTrailingDisabled;
    }

    public void setBitmapTrailingDisabled(int n) {
        this.bitmapTrailingDisabled = n;
    }

    public String getBitmapDisabledVariable() {
        return this.bitmapDisabledVar;
    }

    public void setBitmapDisabledVariable(String string) {
        this.bitmapDisabledVar = string;
    }

    public String getBitmapTrailingDisabledVariable() {
        return this.bitmapTrailingDisabledVar;
    }

    public void setBitmapTrailingDisabledVariable(String string) {
        this.bitmapTrailingDisabledVar = string;
    }

    public String getMsgBitmapClickedEv() {
        return this.msgBitmapClickedEv;
    }

    public void setMsgBitmapClickedEv(String string) {
        this.msgBitmapClickedEv = string;
    }

    public String getMsgBitmapDblclickEv() {
        return this.msgBitmapDblclickEv;
    }

    public void setMsgBitmapDblclickEv(String string) {
        this.msgBitmapDblclickEv = string;
    }

    public String getProposalDelayVariable() {
        return this.proposalDelayVar;
    }

    public void setProposalDelayVariable(String string) {
        this.proposalDelayVar = string;
    }

    public ItemSettingList getProposal() {
        return this.proposal;
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public void setProposal(ItemToAddSettingList itemToAddSettingList) {
        ItemSettingList itemSettingList = new ItemSettingList();
        itemSettingList.setSettings(itemToAddSettingList.getSettings());
        this.setProposal(itemSettingList);
    }

    public void setProposal(ItemSettingList itemSettingList) {
        this.proposal = itemSettingList;
    }

    public int getVisibleProposalCount() {
        return this.visibleProposalCount;
    }

    public void setVisibleProposalCount(int n) {
        this.visibleProposalCount = n;
    }

    public int getProposalDelay() {
        return this.proposalDelay;
    }

    public void setProposalDelay(int n) {
        this.proposalDelay = n;
    }

    public int getProposalAfterDigits() {
        return this.proposalMinText;
    }

    public void setProposalAfterDigits(int n) {
        this.proposalMinText = n;
    }

    public String getProposalAfterDigitsVariable() {
        return this.proposalMinTextVar;
    }

    public void setProposalAfterDigitsVariable(String string) {
        this.proposalMinTextVar = string;
    }

    public boolean isProposalsUnsorted() {
        return this.proposalsUnsorted;
    }

    public void setProposalsUnsorted(boolean bl) {
        this.proposalsUnsorted = bl;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public void setCase(CaseStyle caseStyle) {
        this.caseStyle = caseStyle;
    }

    public CaseStyle getCase() {
        return this.caseStyle;
    }

    public void set3D(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(0));
        }
    }

    public boolean is3D() {
        return this.border.getValue() == 0;
    }

    public void setAuto(boolean bl) {
        this.auto = bl;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setBoxed(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(1));
        }
    }

    public boolean isBoxed() {
        return this.border.getValue() == 1;
    }

    public void setCenter(boolean bl) {
        if (bl) {
            this.setAlignment(new HAlignment(2));
        }
    }

    public boolean isCenter() {
        return this.alignment.getValue() == 2;
    }

    public void setLower(boolean bl) {
        if (bl) {
            this.setCase(new CaseStyle(2));
        }
    }

    public boolean isLower() {
        return this.caseStyle.getValue() == 2;
    }

    public void setLeft(boolean bl) {
        if (bl) {
            this.setAlignment(new HAlignment(1));
        }
    }

    public HAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HAlignment hAlignment) {
        this.alignment = hAlignment != null && hAlignment.getValue() == 4 ? new HAlignment() : hAlignment;
    }

    public boolean isLeft() {
        return this.alignment.getValue() == 1;
    }

    public void setMultiline(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(1));
        }
    }

    public boolean isMultiline() {
        return this.style.getValue() == 1;
    }

    public void setUpper(boolean bl) {
        if (bl) {
            this.setCase(new CaseStyle(1));
        }
    }

    public boolean isUpper() {
        return this.caseStyle.getValue() == 1;
    }

    public void setNoAutosel(boolean bl) {
        this.noAutosel = bl;
    }

    public boolean isNoAutosel() {
        return this.noAutosel;
    }

    public void setNoBox(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(2));
        }
    }

    public boolean isNoBox() {
        return this.border.getValue() == 2;
    }

    public void setNotifyChange(boolean bl) {
        this.notifyChange = bl;
    }

    public boolean isNotifyChange() {
        return this.notifyChange;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setRight(boolean bl) {
        if (bl) {
            this.setAlignment(new HAlignment(3));
        }
    }

    public boolean isRight() {
        return this.alignment.getValue() == 3;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSpinner(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(4));
        }
    }

    public boolean isSpinner() {
        return this.style.getValue() == 4;
    }

    public void setUseReturn(boolean bl) {
        this.useReturn = bl;
    }

    public boolean isUseReturn() {
        return this.useReturn;
    }

    public void setUseTab(boolean bl) {
        this.useTab = bl;
    }

    public boolean isUseTab() {
        return this.useTab;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setEmptyCheck(boolean bl) {
        this.setRequired(bl);
    }

    public boolean isEmptyCheck() {
        return this.isRequired();
    }

    public void setVScroll(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(2));
        }
    }

    public boolean isVScroll() {
        return this.style.getValue() == 2;
    }

    public void setVScrollBar(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(3));
        }
    }

    public boolean isVScrollBar() {
        return this.style.getValue() == 3;
    }

    public void setSingleline(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(0));
        }
    }

    public boolean isSingleline() {
        return this.style.getValue() == 0;
    }

    public void setAutodecimal(int n) {
        this.autodecimal = n;
    }

    public int getAutodecimal() {
        return this.autodecimal;
    }

    public void setAction(int n) {
        if (n >= 0 && n < this.action.getNames().length) {
            this.setAction(new EntryFieldAction(n));
        }
    }

    public void setAction(EntryFieldAction entryFieldAction) {
        this.action = entryFieldAction;
    }

    public EntryFieldAction getAction() {
        return this.action;
    }

    public void setCursor(int n) {
        this.cursor = n;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCursorRow(int n) {
        this.cursorRow = n;
    }

    public int getCursorRow() {
        return this.cursorRow;
    }

    public void setCursorCol(int n) {
        this.cursorCol = n;
    }

    public int getCursorCol() {
        return this.cursorCol;
    }

    public void setMinVal(int n) {
        this.minVal = n;
    }

    public int getMinVal() {
        return this.minVal;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxText(int n) {
        this.maxText = n;
    }

    public int getMaxText() {
        return this.maxText;
    }

    public void setMaxVal(int n) {
        this.maxVal = n;
    }

    public int getMaxVal() {
        return this.maxVal;
    }

    public void setSelectionStart(int n) {
        this.selectionStart = n;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStartRow(int n) {
        this.selectionStartRow = n;
    }

    public int getSelectionStartRow() {
        return this.selectionStartRow;
    }

    public void setSelectionStartCol(int n) {
        this.selectionStartCol = n;
    }

    public int getSelectionStartCol() {
        return this.selectionStartCol;
    }

    public void setFormatType(EntryFieldFormatType entryFieldFormatType) {
        this.formatType = entryFieldFormatType;
    }

    public EntryFieldFormatType getFormatType() {
        return this.formatType;
    }

    public void setAutodecimalVariable(String string) {
        this.autodecimalVar = string;
    }

    public String getAutodecimalVariable() {
        return this.autodecimalVar;
    }

    public void setCursorVariable(String string) {
        this.cursorVar = string;
    }

    public String getCursorVariable() {
        return this.cursorVar;
    }

    public void setCursorRowVariable(String string) {
        this.cursorRowVar = string;
    }

    public boolean isAutoSpin() {
        return this.style.getValue() == 5;
    }

    public void setAutoSpin(boolean bl) {
        if (bl) {
            this.setStyle(new EntryFieldStyle(5));
        }
    }

    public boolean isValueMultiple() {
        return this.valueMultiple;
    }

    public void setValueMultiple(boolean bl) {
        this.valueMultiple = bl;
    }

    public String getCursorRowVariable() {
        return this.cursorRowVar;
    }

    public void setCursorColVariable(String string) {
        this.cursorColVar = string;
    }

    public String getCursorColVariable() {
        return this.cursorColVar;
    }

    public void setMinValVariable(String string) {
        this.minValVar = string;
    }

    public String getMinValVariable() {
        return this.minValVar;
    }

    public void setMaxValVariable(String string) {
        this.maxValVar = string;
    }

    public String getMaxValVariable() {
        return this.maxValVar;
    }

    public void setSelectionStartVariable(String string) {
        this.selectionStartVar = string;
    }

    public String getSelectionStartVariable() {
        return this.selectionStartVar;
    }

    public void setSelectionStartRowVariable(String string) {
        this.selectionStartRowVar = string;
    }

    public String getSelectionStartRowVariable() {
        return this.selectionStartRowVar;
    }

    public void setSelectionStartColVariable(String string) {
        this.selectionStartColVar = string;
    }

    public String getSelectionStartColVariable() {
        return this.selectionStartColVar;
    }

    public void setMaxLinesVariable(String string) {
        this.maxLinesVar = string;
    }

    public String getMaxLinesVariable() {
        return this.maxLinesVar;
    }

    public void setMaxTextVariable(String string) {
        this.maxTextVar = string;
    }

    public String getMaxTextVariable() {
        return this.maxTextVar;
    }

    public void setSelectionText(String string) {
        this.selectionText = string;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public void setSelectionTextVariable(String string) {
        this.selectionTextVar = string;
    }

    public String getSelectionTextVariable() {
        return this.selectionTextVar;
    }

    public void setFillChar(String string) {
        this.fillChar = string;
    }

    public String getFillChar() {
        return this.fillChar;
    }

    public void setFormatString(String string) {
        this.formatString = string;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setMsgSpinUpEv(String string) {
        this.msgSpinUpEv = string;
    }

    public String getMsgSpinUpEv() {
        return this.msgSpinUpEv;
    }

    public void setMsgSpinDownEv(String string) {
        this.msgSpinDownEv = string;
    }

    public String getMsgSpinDownEv() {
        return this.msgSpinDownEv;
    }

    public void setNtfChangedEv(String string) {
        this.ntfChangedEv = string;
    }

    public String getNtfChangedEv() {
        return this.ntfChangedEv;
    }

    public void setNtfChangedEx(String string) {
        this.ntfChangedEx = string;
    }

    public String getNtfChangedEx() {
        return this.ntfChangedEx;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public TextOrientation getTextOrientation() {
        return this.textOrientation;
    }

    public void setTextOrientation(TextOrientation textOrientation) {
        this.textOrientation = textOrientation;
    }

    public String getValidationErrorMessage() {
        return this.validationErrmsg;
    }

    public void setValidationErrorMessage(String string) {
        this.validationErrmsg = string;
    }

    public String getValidationErrorMessageVariable() {
        return this.validationErrmsgVar;
    }

    public void setValidationErrorMessageVariable(String string) {
        this.validationErrmsgVar = string;
    }

    public String getValidationRegexp() {
        return this.validationRegexp;
    }

    public void setValidationRegexp(String string) {
        this.validationRegexp = string;
    }

    public String getValidationRegexpVariable() {
        return this.validationRegexpVar;
    }

    public void setValidationRegexpVariable(String string) {
        this.validationRegexpVar = string;
    }

    public ValidationOpts getValidationOpts() {
        return this.validationOpts;
    }

    public void setValidationOpts(ValidationOpts validationOpts) {
        this.validationOpts = validationOpts;
    }

    public String getValidationOptsVariable() {
        return this.validationOptsVar;
    }

    public void setValidationOptsVariable(String string) {
        this.validationOptsVar = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public String getBorderColorVariable() {
        return this.borderColorVar;
    }

    public void setBorderColorVariable(String string) {
        this.borderColorVar = string;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public String getPlaceholderVariable() {
        return this.placeholderVar;
    }

    public void setPlaceholderVariable(String string) {
        this.placeholderVar = string;
    }

    public String getSpellChecking() {
        return this.spellChecking;
    }

    public void setSpellChecking(String string) {
        this.spellChecking = string;
    }

    public String getSpellCheckingVariable() {
        return this.spellCheckingVar;
    }

    public void setSpellCheckingVariable(String string) {
        this.spellCheckingVar = string;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean bl) {
        this.noWrap = bl;
    }

    public int getNotifyChangeDelay() {
        return this.notifyChangeDelay;
    }

    public void setNotifyChangeDelay(int n) {
        this.notifyChangeDelay = n;
    }

    public String getNotifyChangeDelayVariable() {
        return this.notifyChangeDelayVar;
    }

    public void setNotifyChangeDelayVariable(String string) {
        this.notifyChangeDelayVar = string;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        int n = this.proposal.getSettingCount();
        if (n > 0) {
            String string3 = string != null ? string : this.getName();
            stringBuilder.append(cobolFormatter.formatLine(string2 + "modify " + string3));
            for (int i = 0; i < n; ++i) {
                ItemSetting itemSetting = (ItemSetting)this.proposal.getSettingAt(i);
                IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)itemSetting.getData(), (String)"proposal", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)true);
            }
            stringBuilder.append(cobolFormatter.formatLine(string2 + "."));
        }
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.is3D(), (String)"3-d", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBoxed(), (String)"boxed", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoBox(), (String)"no-box", (String)string, (StringBuilder)stringBuilder);
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isCenter(), (String)"center", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isRight(), (String)"right", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isLeft(), (String)"left", (String)string, (StringBuilder)stringBuilder);
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isUpper(), (String)"upper", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isLower(), (String)"lower", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.auto, (String)"auto", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isMultiline(), (String)"multiline", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noAutosel, (String)"no-autosel", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isSpinner(), (String)"spinner", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.notifyChange, (String)"notify-change", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.numeric, (String)"numeric", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.readOnly, (String)"read-only", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.secure, (String)"secure", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useReturn, (String)"use-return", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useTab, (String)"use-tab", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.required, (String)"required", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isVScroll(), (String)"vscroll", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isVScrollBar(), (String)"vscroll-bar", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isAutoSpin(), (String)"auto-spin", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noWrap, (String)"no-wrap", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isProposalsUnsorted(), (String)"proposals-unsorted", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.notifyChangeDelayVar, (int)this.notifyChangeDelay, (int)0, (String)"notify-change-delay", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.autodecimalVar, (int)this.autodecimal, (int)0, (String)"auto-decimal", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorVar, (int)this.cursor, (int)0, (String)"cursor", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.visibleProposalCountVar, (int)this.visibleProposalCount, (int)5, (String)"visible-proposal-count", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.proposalMinTextVar, (int)this.proposalMinText, (int)1, (String)"proposal-min-text", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.proposalDelayVar, (int)this.proposalDelay, (int)500, (String)"proposal-delay", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (this.isMultiline() || this.isVScroll() || this.isVScrollBar()) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorRowVar, (int)this.cursorRow, (int)0, (String)"cursor-row", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorColVar, (int)this.cursorCol, (int)0, (String)"cursor-col", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxLinesVar, (int)this.maxLines, (int)0, (String)"max-lines", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxTextVar, (int)this.maxText, (int)0, (String)"max-text", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.minValVar, (int)this.minVal, (int)0, (String)"min-val", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.maxValVar, (int)this.maxVal, (int)0, (String)"max-val", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.selectionStartVar, (int)this.selectionStart, (int)0, (String)"selection-start", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.selectionStartRowVar, (int)this.selectionStartRow, (int)0, (String)"selection-start-row", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.selectionStartColVar, (int)this.selectionStartCol, (int)0, (String)"selection-start-col", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (this.action.getValue() > 0) {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("action action-");
            switch (this.action.getValue()) {
                case 2: {
                    stringBuilder2.append("copy");
                    break;
                }
                case 1: {
                    stringBuilder2.append("cut");
                    break;
                }
                case 4: {
                    stringBuilder2.append("delete");
                    break;
                }
                case 3: {
                    stringBuilder2.append("paste");
                    break;
                }
                case 5: {
                    stringBuilder2.append("undo");
                    break;
                }
                case 6: {
                    stringBuilder2.append("redo");
                    break;
                }
                case 7: {
                    stringBuilder2.append("select-all");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.formatType.getValue(), (int)0, (String)"format-type", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getCharCode((CobolFormatter)cobolFormatter, (String)this.fillChar, (String)"fill-char", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (String)this.value, (String)(this.valueMultiple ? "value multiple" : "value"), (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.selectionTextVar, (String)this.selectionText, (String)"selection-text", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.spellCheckingVar, (String)this.spellChecking, (String)"spell-checking", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.placeholderVar, (String)this.placeholder, (String)"placeholder", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.validationRegexpVar, (String)this.validationRegexp, (String)"validation-regexp", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.validationErrmsgVar, (String)this.validationErrmsg, (String)"validation-errmsg", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.validationOptsVar, (int)this.validationOpts.getValue(), (int)0, (String)"validation-opts", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.textOrientation.getValue(), (int)0, (String)"text-orientation", (String)string, (StringBuilder)stringBuilder);
        if (!this.isCellEditor()) {
            IscobolBeanConstants.getPictureCode((CobolFormatter)cobolFormatter, (String)this.formatPicture, (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)this.formatString, (String)"format-string", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)false);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.borderColorVar, (ColorType)this.borderColor, (int)0, (String)"border-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.image, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        if (this.getBitmap() != null) {
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)0, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapNumberVar, (int)this.bitmapNumber, (int)0, (String)"bitmap-number", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapTrailingNumberVar, (int)this.bitmapTrailingNumber, (int)0, (String)"bitmap-trailing-number", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapDisabledVar, (int)this.bitmapDisabled, (int)0, (String)"bitmap-disabled", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapTrailingDisabledVar, (int)this.bitmapTrailingDisabled, (int)0, (String)"bitmap-trailing-disabled", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.bitmapHintVar, (String)this.bitmapHint, (String)"bitmap-hint", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
            IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.bitmapTrailingHintVar, (String)this.bitmapTrailingHint, (String)"bitmap-trailing-hint", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapRolloverVar, (int)this.bitmapRollover, (int)0, (String)"bitmap-rollover", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
            IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapTrailingRolloverVar, (int)this.bitmapTrailingRollover, (int)0, (String)"bitmap-trailing-rollover", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgSpinDownEv, null, (String)"msg-spin-down", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgSpinUpEv, null, (String)"msg-spin-up", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBitmapClickedEv, null, (String)"msg-bitmap-clicked", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBitmapDblclickEv, null, (String)"msg-bitmap-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.ntfChangedEv, (String)this.ntfChangedEx, (String)"ntf-changed", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector2 = iGUIControl.getControlStyles();
        if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
            if (iScreenAttribute.getExprSize() == null) {
                this.setSize((float)iScreenAttribute.getVUsing().getVariableName().getVariableLength());
            }
        } else if (iScreenAttribute.getFrom() != null && !iScreenAttribute.getFrom().getWord().equals("")) {
            this.setValue(IscobolBeanConstants.removeQuotes((String)iScreenAttribute.getFrom().getWord()));
        }
        this.setBorder(new BorderStyle(3));
        if (vector2.contains("BOXED")) {
            this.setBorder(new BorderStyle(1));
        } else if (vector2.contains("3-D")) {
            this.setBorder(new BorderStyle(0));
        } else if (vector2.contains("NO-BOX")) {
            this.setBorder(new BorderStyle(2));
        }
        this.setCase(new CaseStyle(0));
        if (vector2.contains("LOWER")) {
            this.setCase(new CaseStyle(2));
        } else if (vector2.contains("UPPER")) {
            this.setCase(new CaseStyle(1));
        }
        this.setAlignment(new HAlignment(0));
        if (vector2.contains("LEFT")) {
            this.setAlignment(new HAlignment(1));
        } else if (vector2.contains("RIGHT")) {
            this.setAlignment(new HAlignment(3));
        } else if (vector2.contains("CENTER")) {
            this.setAlignment(new HAlignment(2));
        }
        if (vector2.contains("AUTO")) {
            this.setAuto(true);
        }
        if (vector2.contains("NO-AUTOSEL")) {
            this.setNoAutosel(true);
        }
        if (vector2.contains("NOTIFY-CHANGE")) {
            this.setNotifyChange(true);
        }
        if (vector2.contains("NUMERIC")) {
            this.setNumeric(true);
        }
        if (vector2.contains("READ-ONLY")) {
            this.setReadOnly(true);
        }
        if (vector2.contains("SECURE")) {
            this.setSecure(true);
        }
        if (vector2.contains("USE-RETURN")) {
            this.setUseReturn(true);
        }
        if (vector2.contains("USE-TAB")) {
            this.setUseTab(true);
        }
        if (vector2.contains("PROPOSALS-UNSORTED")) {
            this.setProposalsUnsorted(true);
        }
        if (vector2.contains("MULTILINE")) {
            this.setStyle(new EntryFieldStyle(1));
        } else if (vector2.contains("VSCROLL")) {
            this.setStyle(new EntryFieldStyle(2));
        } else if (vector2.contains("VSCROLL-BAR")) {
            this.setStyle(new EntryFieldStyle(3));
        } else if (vector2.contains("SPINNER")) {
            this.setStyle(new EntryFieldStyle(4));
        } else if (vector2.contains("AUTO-SPIN")) {
            this.setStyle(new EntryFieldStyle(5));
        }
        if (iScreenAttribute.getAttrREQUIRED()) {
            this.required = true;
        }
        if (iScreenAttribute.getAttrUSING_MULTIPLE() != null && iScreenAttribute.getAttrUSING_MULTIPLE().getWord().equalsIgnoreCase("MULTIPLE")) {
            this.valueMultiple = true;
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("ACTION")) {
                this.setAction(new EntryFieldAction((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                continue;
            }
            if (iPropElementList.getKey(i).equals("AUTO-DECIMAL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setAutodecimal((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setAutodecimalVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursor((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-ROW")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorRow((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorRowVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-COL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorCol((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorColVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MAX-LINES")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMaxLines((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxLinesVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MAX-TEXT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMaxText((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxTextVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MIN-VAL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMinVal((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setMinValVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("MAX-VAL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMaxVal((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setMaxValVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("SELECTION-START")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setSelectionStart((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setSelectionStartVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("SELECTION-START-ROW")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setSelectionStartRow((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setSelectionStartRowVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("SELECTION-START-COL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setSelectionStartCol((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setSelectionStartColVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("SELECTION-TEXT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setSelectionText(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setSelectionTextVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("FORMAT-STRING")) {
                if (iPropElementList.getValue(i)[0].getToken() == null) continue;
                this.setFormatString(iPropElementList.getValue(i)[0].getToken().getWord().substring(1, iPropElementList.getValue(i)[0].getToken().getWord().length() - 2));
                continue;
            }
            if (iPropElementList.getKey(i).equals("FILL-CHAR")) {
                this.setFillChar(iPropElementList.getValue(i)[0].getToken().getWord());
                continue;
            }
            if (iPropElementList.getKey(i).equals("FORMAT-TYPE")) {
                this.setFormatType(new EntryFieldFormatType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                continue;
            }
            if (iPropElementList.getKey(i).equals("PROPOSAL")) {
                for (int j = 0; j < iPropElementList.getValue(i).length; ++j) {
                    vector.add(iPropElementList.getValue(i)[j].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("PROPOSAL-DELAY")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setProposalDelay((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setProposalDelayVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VALIDATION-ERRMSG")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setValidationErrorMessage(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setValidationErrorMessageVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VALIDATION-REGEXP")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setValidationRegexp(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setValidationRegexpVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VISIBLE-PROPOSAL-COUNT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setVisibleProposalCount((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setVisibleProposalCountVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("PROPOSAL-MIN-TEXT")) continue;
            if (iPropElementList.getValue(i)[0].getToken() != null) {
                this.setProposalAfterDigits((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                continue;
            }
            this.setProposalAfterDigitsVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
        }
        ItemSetting itemSetting = null;
        ItemSettingList itemSettingList = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (itemSettingList == null) {
                itemSettingList = new ItemSettingList();
            }
            itemSetting = new ItemSetting();
            itemSetting.setData((String)vector.elementAt(i));
            itemSettingList.addSetting((SettingItem)itemSetting);
        }
        if (itemSettingList != null) {
            this.setProposal(itemSettingList);
        }
    }
}

