/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.Frame3DStyle;
import com.iscobol.screenpainter.beans.types.FrameTitlePosition;
import com.iscobol.screenpainter.beans.types.Percentage;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractFrame
extends AbstractBeanControl
implements ComponentsContainer {
    private static final long serialVersionUID = 1L;
    private boolean heavy;
    private boolean veryHeavy;
    private boolean alternate;
    private Frame3DStyle style;
    private boolean fullHeight;
    private ForegroundColorType highColor = ForegroundColorType.DISABLED_COLOR;
    private ForegroundColorType lowColor = ForegroundColorType.DISABLED_COLOR;
    private ForegroundColorType fillColor = ForegroundColorType.DISABLED_COLOR;
    private ForegroundColorType fillColor2 = ForegroundColorType.DISABLED_COLOR;
    private Percentage fillPercent = new Percentage(100);
    private FrameTitlePosition titlePosition = new FrameTitlePosition(0);
    private boolean transparent;
    private String title;
    private String titleVar;
    private String highColorVar;
    private String lowColorVar;
    private String fillColorVar;
    private String fillColor2Var;
    private String fillPercentVar;
    private String titlePositionVar;
    private Vector<AbstractBeanControl> components = new Vector();

    public AbstractFrame(Component component) {
        super(component);
    }

    public int indexOfComponent(AbstractBeanControl abstractBeanControl) {
        return this.components.indexOf(abstractBeanControl);
    }

    public void setComponentAt(int n, AbstractBeanControl abstractBeanControl) {
        if (n < this.getComponentCount()) {
            AbstractBeanControl abstractBeanControl2 = (AbstractBeanControl)this.components.elementAt(n);
            abstractBeanControl2.setParent(null);
            this.components.setElementAt(abstractBeanControl, n);
            abstractBeanControl.setParent((ScreenElement)this);
        }
    }

    public float getLineToAdd() {
        return this.getRealLine() - 0.9f;
    }

    public float getColToAdd() {
        return this.getRealColumn() - 0.9f;
    }

    public float getLinePixelsToAdd() {
        return this.getLinePixels() - 1.0f;
    }

    public float getColPixelsToAdd() {
        return this.getColumnPixels() - 1.0f;
    }

    public void setCellSize(int n, int n2) {
        super.setCellSize(n, n2);
        for (int i = 0; i < this.components.size(); ++i) {
            ((AbstractBeanControl)this.components.elementAt(i)).setCellSize(n, n2);
        }
    }

    public Frame3DStyle get3DStyle() {
        return this.style;
    }

    public void set3DStyle(Frame3DStyle frame3DStyle) {
        this.style = frame3DStyle;
    }

    public AbstractBeanControl getComponentAt(int n) {
        if (n < this.getComponentCount()) {
            return (AbstractBeanControl)this.components.elementAt(n);
        }
        return null;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void addComponent(AbstractBeanControl abstractBeanControl) {
        this.addComponent(-1, abstractBeanControl);
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        ComponentsContainer componentsContainer = (ComponentsContainer)abstractBeanControl.getParent();
        if (componentsContainer != null) {
            componentsContainer.removeComponent(abstractBeanControl);
        }
        if (n < 0 || n >= this.components.size()) {
            this.components.addElement(abstractBeanControl);
        } else {
            this.components.add(n, abstractBeanControl);
        }
        abstractBeanControl.setParent((ScreenElement)this);
        abstractBeanControl.setCellSize(this.cellWidth, this.cellHeight);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl) {
        this.removeComponent(abstractBeanControl, true);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl, boolean bl) {
        this.components.removeElement(abstractBeanControl);
        abstractBeanControl.setParent(null);
        if (bl) {
            this.removeTabOrder(abstractBeanControl.getTabOrder());
        }
    }

    public void removeAllComponents() {
        while (this.components.size() > 0) {
            this.removeComponent((AbstractBeanControl)this.components.elementAt(0), false);
        }
    }

    public AbstractBeanControl[] getComponents() {
        AbstractBeanControl[] abstractBeanControlArray = new AbstractBeanControl[this.getComponentCount()];
        this.components.toArray(abstractBeanControlArray);
        return abstractBeanControlArray;
    }

    public void setComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.removeAllComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.addComponent(abstractBeanControlArray[i]);
        }
    }

    public void setHeavy(boolean bl) {
        this.heavy = bl;
        if (this.heavy) {
            this.veryHeavy = false;
        }
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public void setVeryHeavy(boolean bl) {
        this.veryHeavy = bl;
        if (this.veryHeavy) {
            this.heavy = false;
        }
    }

    public boolean isVeryHeavy() {
        return this.veryHeavy;
    }

    public void setRaised(boolean bl) {
        this.set3DStyle(new Frame3DStyle(3));
    }

    public boolean isRaised() {
        return this.get3DStyle().getValue() == 3;
    }

    public void setLowered(boolean bl) {
        this.set3DStyle(new Frame3DStyle(1));
    }

    public boolean isLowered() {
        return this.get3DStyle().getValue() == 1;
    }

    public void setRimmed(boolean bl) {
        this.set3DStyle(new Frame3DStyle(4));
    }

    public boolean isRimmed() {
        return this.get3DStyle().getValue() == 4;
    }

    public void setEngraved(boolean bl) {
        this.set3DStyle(new Frame3DStyle(0));
    }

    public boolean isEngraved() {
        return this.get3DStyle().getValue() == 0;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(20.0f);
        this.setLines(10.0f);
        this.set3DStyle(new Frame3DStyle(2));
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setFullHeight(boolean bl) {
        this.fullHeight = bl;
    }

    public boolean isFullHeight() {
        return this.fullHeight;
    }

    public void setFillPercent(Percentage percentage) {
        this.fillPercent = percentage;
    }

    public Percentage getFillPercent() {
        return this.fillPercent;
    }

    public void setTitlePosition(FrameTitlePosition frameTitlePosition) {
        this.titlePosition = frameTitlePosition;
    }

    public FrameTitlePosition getTitlePosition() {
        return this.titlePosition;
    }

    public void setFillColor(ForegroundColorType foregroundColorType) {
        this.fillColor = foregroundColorType;
    }

    public ForegroundColorType getFillColor() {
        return this.fillColor;
    }

    public void setFillColor2(ForegroundColorType foregroundColorType) {
        this.fillColor2 = foregroundColorType;
    }

    public ForegroundColorType getFillColor2() {
        return this.fillColor2;
    }

    public void setHighColor(ForegroundColorType foregroundColorType) {
        this.highColor = foregroundColorType;
    }

    public ForegroundColorType getHighColor() {
        return this.highColor;
    }

    public void setLowColor(ForegroundColorType foregroundColorType) {
        this.lowColor = foregroundColorType;
    }

    public ForegroundColorType getLowColor() {
        return this.lowColor;
    }

    public void setFillPercentVariable(String string) {
        this.fillPercentVar = string;
    }

    public String getFillPercentVariable() {
        return this.fillPercentVar;
    }

    public void setTitlePositionVariable(String string) {
        this.titlePositionVar = string;
    }

    public String getTitlePositionVariable() {
        return this.titlePositionVar;
    }

    public void setFillColorVariable(String string) {
        this.fillColorVar = string;
    }

    public String getFillColorVariable() {
        return this.fillColorVar;
    }

    public void setFillColor2Variable(String string) {
        this.fillColor2Var = string;
    }

    public String getFillColor2Variable() {
        return this.fillColor2Var;
    }

    public void setHighColorVariable(String string) {
        this.highColorVar = string;
    }

    public String getHighColorVariable() {
        return this.highColorVar;
    }

    public void setLowColorVariable(String string) {
        this.lowColorVar = string;
    }

    public String getLowColorVariable() {
        return this.lowColorVar;
    }

    public void setTitleVariable(String string) {
        this.titleVar = string;
    }

    public String getTitleVariable() {
        return this.titleVar;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isLowered(), (String)"lowered", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isRaised(), (String)"raised", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.heavy, (String)"heavy", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.veryHeavy, (String)"very-heavy", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.alternate, (String)"alternate", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isEngraved(), (String)"engraved", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isRimmed(), (String)"rimmed", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.fullHeight, (String)"full-height", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.transparent, (String)"transparent", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.fillColorVar, (ColorType)this.fillColor, (int)0, (String)"fill-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.fillColor2Var, (ColorType)this.fillColor2, (int)0, (String)"fill-color2", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.lowColorVar, (ColorType)this.lowColor, (int)0, (String)"low-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.highColorVar, (ColorType)this.highColor, (int)0, (String)"high-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.fillPercentVar, (int)this.fillPercent.getValue(), (int)100, (String)"fill-percent", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.titlePositionVar, (int)this.titlePosition.getValue(), (int)0, (String)"title-position", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.titleVar, (String)this.title, (String)"title", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public Vector<String> getControlNames() {
        Vector vector = super.getControlNames();
        for (int i = 0; i < this.components.size(); ++i) {
            vector.addAll(((AbstractBeanControl)this.components.elementAt(i)).getControlNames());
        }
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector vector = super.getControlIds();
        for (int i = 0; i < this.components.size(); ++i) {
            vector.addAll(((AbstractBeanControl)this.components.elementAt(i)).getControlIds());
        }
        return vector;
    }

    public void updateTabOrders(AbstractBeanControl abstractBeanControl, int n) {
        IscobolBeanConstants.updateTabOrders((AbstractBeanControl[])this.getComponents(), (TabOrderable)abstractBeanControl, (int)n);
    }

    public void removeTabOrder(int n) {
        IscobolBeanConstants.removeTabOrder((AbstractBeanControl[])this.getComponents(), (int)n);
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlExceptionValues());
        }
        return vector;
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        if (!iScreenAttribute.getTitleIDE().equals("")) {
            if (iScreenAttribute.getTitleIDE().charAt(0) == '\"') {
                this.setTitle(iScreenAttribute.getTitleIDE().substring(1, iScreenAttribute.getTitleIDE().length() - 1));
            } else {
                this.setTitleVariable(iScreenAttribute.getTitleIDE());
            }
        }
        this.set3DStyle(new Frame3DStyle(2));
        if (vector.contains("LOWERED")) {
            this.set3DStyle(new Frame3DStyle(1));
        } else if (vector.contains("RIMMED")) {
            this.set3DStyle(new Frame3DStyle(4));
        } else if (vector.contains("RAISED")) {
            this.set3DStyle(new Frame3DStyle(3));
        } else if (vector.contains("ENGRAVED")) {
            this.set3DStyle(new Frame3DStyle(0));
        }
        if (vector.contains("ALTERNATE")) {
            this.setAlternate(true);
        }
        if (vector.contains("HEAVY")) {
            this.setHeavy(true);
        }
        if (vector.contains("VERY-HEAVY")) {
            this.setVeryHeavy(true);
        }
        if (vector.contains("FULL-HEIGHT")) {
            this.setFullHeight(true);
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("TITLE-POSITION")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setTitlePosition(new FrameTitlePosition((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setTitlePositionVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HIGH-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHighColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHighColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("LOW-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setLowColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setLowColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("FILL-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setFillColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setFillColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("FILL-COLOR2")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setFillColor2(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setFillColor2Variable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("FILL-PERCENT")) continue;
            if (iPropElementList.getValue(i)[0].getToken() != null) {
                this.setFillPercent(new Percentage((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                continue;
            }
            this.setFillPercentVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
        }
    }
}

