/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractComboBox;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.AbstractList;
import com.iscobol.screenpainter.beans.AbstractTextInputField;
import com.iscobol.screenpainter.beans.ColumnSettingsProvider;
import com.iscobol.screenpainter.beans.ExceptionTerminationValueProvider;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.BooleanChoice;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.EditableItem;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.GridAction;
import com.iscobol.screenpainter.beans.types.GridCellSetting;
import com.iscobol.screenpainter.beans.types.GridCellSettingList;
import com.iscobol.screenpainter.beans.types.GridColumnSetting;
import com.iscobol.screenpainter.beans.types.GridColumnSettingList;
import com.iscobol.screenpainter.beans.types.GridEditorCodeGeneration;
import com.iscobol.screenpainter.beans.types.GridRowSetting;
import com.iscobol.screenpainter.beans.types.GridRowSettingList;
import com.iscobol.screenpainter.beans.types.HAlignmentExt;
import com.iscobol.screenpainter.beans.types.HeadingMenuPopup;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ItemSetting;
import com.iscobol.screenpainter.beans.types.ItemSettingList;
import com.iscobol.screenpainter.beans.types.ItemToAddSettingList;
import com.iscobol.screenpainter.beans.types.MassUpdate;
import com.iscobol.screenpainter.beans.types.Percentage;
import com.iscobol.screenpainter.beans.types.Protection;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.beans.types.RowColorPatternSetting;
import com.iscobol.screenpainter.beans.types.RowColorPatternSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;

public abstract class AbstractGrid
extends AbstractTextInputField
implements ColumnSettingsProvider {
    private static final int DEFAULT_SCROLLBAR_INSETS = 17;
    private static final long serialVersionUID = 1L;
    private boolean noAutosel;
    private int cursorFrameWidth = 3;
    private int cursorX;
    private int cursorY;
    private int numColHeadings;
    private int numRows;
    private int numColumns;
    private int lastRow;
    private int virtualWidth;
    private int rowDividers = 1;
    private float columnHeadingsHeight = 1.0f;
    private int numRowHeadings;
    private int vPadding;
    private GridAction action;
    private Protection protection;
    private boolean useTab;
    private boolean vScroll;
    private boolean adjustableRows;
    private boolean adjustableColumns;
    private boolean centeredHeadings;
    private boolean columnHeadings;
    private boolean hScroll;
    private boolean paged;
    private boolean reorderingColumns;
    private boolean rowHeadings;
    private boolean sortableColumns;
    private boolean tiledHeadings;
    private boolean noSearch;
    private boolean filterableColumns;
    private boolean noCellDrag;
    private MassUpdate massUpdate;
    private ItemSettingList recordToAdd;
    private ColorType cursorColor;
    private ColorType cellEntryColor;
    private ColorType rowCursorColor;
    private ColorType dragColor;
    private ColorType headingColor;
    private ColorType regionColor;
    private ColorType rowSelectedColor;
    private ColorType columnSelectedColor;
    private ColorType cellSelectedColor;
    private BackgroundColorType cursorBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundColorType cellEntryBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundColorType rowCursorBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundColorType dragBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundColorType headingBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private BackgroundColorType regionBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private ForegroundColorType cursorForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType cellEntryForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType rowCursorForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType dragForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType headingForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType regionForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private ForegroundColorType rowSelectedForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType rowSelectedBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private ForegroundColorType columnSelectedForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType columnSelectedBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private ForegroundColorType cellSelectedForegroundColor = ForegroundColorType.DISABLED_COLOR2;
    private BackgroundColorType cellSelectedBackgroundColor = BackgroundColorType.DISABLED_COLOR2;
    private ForegroundColorType headingDividerColor;
    private ForegroundColorType dividerColor;
    private BackgroundColorType endColor;
    private GridEditorCodeGeneration editorCodeGeneration;
    private FontType headingFont;
    private GridColumnSettingList columnSettings;
    private GridRowSettingList rowSettings;
    private GridCellSettingList cellSettings;
    private RowColorPatternSettingList rowColorPatterns;
    private String cursorColorVar;
    private String cursorBackgroundColorVar;
    private String cursorForegroundColorVar;
    private String cellEntryColorVar;
    private String cellEntryBackgroundColorVar;
    private String cellEntryForegroundColorVar;
    private String rowCursorColorVar;
    private String rowCursorBackgroundColorVar;
    private String rowCursorForegroundColorVar;
    private String dragBackgroundColorVar;
    private String dragForegroundColorVar;
    private String headingBackgroundColorVar;
    private String headingForegroundColorVar;
    private String regionBackgroundColorVar;
    private String regionForegroundColorVar;
    private String columnHeadingsHeightVar;
    private String numRowHeadingsVar;
    private String cursorXVar;
    private String cursorYVar;
    private String cursorFrameWidthVar;
    private String dragColorVar;
    private String endColorVar;
    private String protectionVar;
    private String headingColorVar;
    private String headingDividerColorVar;
    private String numColHeadingsVar;
    private String numRowsVar;
    private String lastRowVar;
    private String dividerColorVar;
    private String regionColorVar;
    private String recordToAddVar;
    private String vPaddingVar;
    private String virtualWidthVar;
    private String recordData;
    private String massUpdateVar;
    private String msgBeginDragEv;
    private String msgBeginEntryEv;
    private String msgBeginHeadingDragEv;
    private String msgBitmapClickedEv;
    private String msgBitmapDblclickEv;
    private String msgCancelEntryEv;
    private String msgColWidthChangedEv;
    private String msgEndDragEv;
    private String msgEndHeadingDragEv;
    private String msgFinishEntryEv;
    private String msgGotoCellEv;
    private String msgGotoCellMouseEv;
    private String msgGotoCellDragEv;
    private String msgGotoCellOutNextEv;
    private String msgGotoCellOutPrevEv;
    private String msgGridRButtonDownEv;
    private String msgGridRButtonUpEv;
    private String msgHeadingClickedEv;
    private String msgHeadingDblclickEv;
    private String msgHeadingDraggedEv;
    private String msgPagedFirstEv;
    private String msgPagedLastEv;
    private String msgPagedPrevEv;
    private String msgPagedNextEv;
    private String msgPagedNextPageEv;
    private String msgPagedPrevPageEv;
    private String msgBeginSortEv;
    private String msgFinishSortEv;
    private String msgGdDblclickEv;
    private String mouseWheelScrollVar;
    private int mouseWheelScroll;
    private BorderStyle border;
    private int headingMenuPopup;
    private BooleanChoice lmOnColumns;
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private String borderColorVar;
    private int selectionMode;
    private String selectionModeVar;
    private String rowSelectedColorVar;
    private String rowSelectedForegroundColorVar;
    private String rowSelectedBackgroundColorVar;
    private String columnSelectedColorVar;
    private String columnSelectedForegroundColorVar;
    private String columnSelectedBackgroundColorVar;
    private String cellSelectedColorVar;
    private String cellSelectedForegroundColorVar;
    private String cellSelectedBackgroundColorVar;
    private String exportFileName;
    private String exportFileFormat;
    private String exportFileNameVar;
    private String exportFileFormatVar;
    private int rowsPerPage;
    private String rowsPerPageVar;

    public AbstractGrid(Component component) {
        super(component);
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(20.0f);
        this.setLines(10.0f);
        this.setLmOnColumns(new BooleanChoice());
        this.setEditorCodeGeneration(new GridEditorCodeGeneration());
        this.setHeadingMenuPopup(0);
        this.setRowHeadingLineHeight(1.0f);
        this.setBorder(new BorderStyle(2));
        this.setVPadding(50);
        this.setRecordToAdd(new ItemSettingList());
        this.setColumnSettings(new GridColumnSettingList());
        this.setRowSettings(new GridRowSettingList());
        this.setCellSettings(new GridCellSettingList());
        this.setRowColorPatterns(new RowColorPatternSettingList());
        this.setCursorColor(ColorType.DISABLED_COLOR);
        this.setCellEntryColor(ColorType.DISABLED_COLOR);
        this.setDragColor(ColorType.DISABLED_COLOR);
        this.setEndColor(BackgroundColorType.DISABLED_COLOR);
        this.setHeadingColor(ColorType.DISABLED_COLOR);
        this.setRegionColor(ColorType.DISABLED_COLOR);
        this.setHeadingDividerColor(ForegroundColorType.DISABLED_COLOR);
        this.setDividerColor(ForegroundColorType.DISABLED_COLOR);
        this.setNumRows(5);
        this.setNumColumns(5);
        this.setColumnHeadings(true);
        this.setAction(new GridAction());
        this.setProtection(new Protection());
        this.setMassUpdate(new MassUpdate());
        this.setRowsPerPage(0);
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public ColorType getCellEntryColor() {
        return this.cellEntryColor;
    }

    public void setCellEntryColor(ColorType colorType) {
        this.cellEntryColor = colorType;
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public String getBorderColorVariable() {
        return this.borderColorVar;
    }

    public void setBorderColorVariable(String string) {
        this.borderColorVar = string;
    }

    public BackgroundColorType getCellEntryBackgroundColor() {
        return this.cellEntryBackgroundColor;
    }

    public void setCellEntryBackgroundColor(BackgroundColorType backgroundColorType) {
        this.cellEntryBackgroundColor = backgroundColorType;
    }

    public ForegroundColorType getCellEntryForegroundColor() {
        return this.cellEntryForegroundColor;
    }

    public void setCellEntryForegroundColor(ForegroundColorType foregroundColorType) {
        this.cellEntryForegroundColor = foregroundColorType;
    }

    public String getCellEntryColorVariable() {
        return this.cellEntryColorVar;
    }

    public void setCellEntryColorVariable(String string) {
        this.cellEntryColorVar = string;
    }

    public String getCellEntryBackgroundColorVariable() {
        return this.cellEntryBackgroundColorVar;
    }

    public void setCellEntryBackgroundColorVariable(String string) {
        this.cellEntryBackgroundColorVar = string;
    }

    public String getCellEntryForegroundColorVariable() {
        return this.cellEntryForegroundColorVar;
    }

    public void setCellEntryForegroundColorVariable(String string) {
        this.cellEntryForegroundColorVar = string;
    }

    public void setAction(GridAction gridAction) {
        this.action = gridAction;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= 100) {
            n = 99;
        }
        this.numColumns = n;
        GridColumnSettingList gridColumnSettingList = this.getColumnSettings();
        int n2 = this.getNumColumns() - gridColumnSettingList.getSettingCount();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                gridColumnSettingList.addSetting((SettingItem)new GridColumnSetting());
            }
        } else if (n2 < 0) {
            for (int i = 0; i < -n2; ++i) {
                gridColumnSettingList.removeSetting(gridColumnSettingList.getSettingCount() - 1);
            }
        }
        if (n2 != 0) {
            this.setColumnSettings(gridColumnSettingList);
        }
    }

    public GridAction getAction() {
        return this.action;
    }

    public boolean isUserWhite() {
        return true;
    }

    public void setCursorColor(ColorType colorType) {
        this.cursorColor = colorType;
    }

    public ColorType getCursorColor() {
        return this.cursorColor;
    }

    public int getCursorFrameWidth() {
        return this.cursorFrameWidth;
    }

    public void setCursorFrameWidth(int n) {
        this.cursorFrameWidth = n;
    }

    public String getRecordToAddVariable() {
        return this.recordToAddVar;
    }

    public void setRecordToAddVariable(String string) {
        this.recordToAddVar = string;
    }

    public void setBorder(BorderStyle borderStyle) {
        this.border = borderStyle;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public void setMassUpdate(boolean bl) {
        this.setMassUpdate(new MassUpdate(bl ? 1 : 0));
    }

    public void setMassUpdate(MassUpdate massUpdate) {
        this.massUpdate = massUpdate;
    }

    public MassUpdate isMassUpdate() {
        return this.massUpdate;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String string) {
        this.exportFileName = string;
    }

    public String getExportFileFormat() {
        return this.exportFileFormat;
    }

    public void setExportFileFormat(String string) {
        this.exportFileFormat = string;
    }

    public String getExportFileNameVariable() {
        return this.exportFileNameVar;
    }

    public void setExportFileNameVariable(String string) {
        this.exportFileNameVar = string;
    }

    public String getExportFileFormatVariable() {
        return this.exportFileFormatVar;
    }

    public void setExportFileFormatVariable(String string) {
        this.exportFileFormatVar = string;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int n) {
        this.rowsPerPage = n;
    }

    public String getRowsPerPageVariable() {
        return this.rowsPerPageVar;
    }

    public void setRowsPerPageVariable(String string) {
        this.rowsPerPageVar = string;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public void setCursorX(int n) {
        this.cursorX = n;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public void setCursorY(int n) {
        this.cursorY = n;
    }

    public int getVirtualWidth() {
        return this.virtualWidth;
    }

    public void setVirtualWidth(int n) {
        this.virtualWidth = n;
    }

    public BooleanChoice getLmOnColumns() {
        return this.lmOnColumns;
    }

    public void setLmOnColumns(BooleanChoice booleanChoice) {
        this.lmOnColumns = booleanChoice;
    }

    public String getVirtualWidthVariable() {
        return this.virtualWidthVar;
    }

    public void setVirtualWidthVariable(String string) {
        this.virtualWidthVar = string;
    }

    public Protection getProtection() {
        return this.protection;
    }

    public void setProtection(int n) {
        this.protection = new Protection(n);
    }

    public void setNoAutosel(boolean bl) {
        this.noAutosel = bl;
    }

    public boolean isNoAutosel() {
        return this.noAutosel;
    }

    public int isHeadingMenuPopup() {
        return this.headingMenuPopup;
    }

    public void setHeadingMenuPopup(boolean bl) {
        this.setHeadingMenuPopup(new HeadingMenuPopup(bl ? 1 : 0));
    }

    public void setHeadingMenuPopup(HeadingMenuPopup headingMenuPopup) {
        this.headingMenuPopup = headingMenuPopup.getValue();
    }

    public void setHeadingMenuPopup(int n) {
        this.headingMenuPopup = n;
    }

    public void setProtection(Protection protection) {
        this.protection = protection;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(int n) {
        this.lastRow = n;
    }

    public ForegroundColorType getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(ForegroundColorType foregroundColorType) {
        this.dividerColor = foregroundColorType;
    }

    public String getLastRowVariable() {
        return this.lastRowVar;
    }

    public void setLastRowVariable(String string) {
        this.lastRowVar = string;
    }

    public String getDividerColorVariable() {
        return this.dividerColorVar;
    }

    public void setDividerColorVariable(String string) {
        this.dividerColorVar = string;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    public int getNumColHeadings() {
        return this.numColHeadings;
    }

    public void setNumColHeadings(int n) {
        this.numColHeadings = n;
    }

    public boolean isNoCellDrag() {
        return this.noCellDrag;
    }

    public void setNoCellDrag(boolean bl) {
        this.noCellDrag = bl;
    }

    public GridEditorCodeGeneration getEditorCodeGeneration() {
        return this.editorCodeGeneration;
    }

    public void setEditorCodeGeneration(GridEditorCodeGeneration gridEditorCodeGeneration) {
        this.editorCodeGeneration = gridEditorCodeGeneration;
    }

    public float getRowHeadingLineHeight() {
        return this.columnHeadingsHeight;
    }

    public void setRowHeadingLineHeight(int n) {
        this.columnHeadingsHeight = n;
    }

    public void setRowHeadingLineHeight(float f) {
        this.columnHeadingsHeight = f;
    }

    public String getRowHeadingLineHeightVariable() {
        return this.columnHeadingsHeightVar;
    }

    public void setRowHeadingLineHeightVariable(String string) {
        this.columnHeadingsHeightVar = string;
    }

    public int getNumRowHeadings() {
        return this.numRowHeadings;
    }

    public void setNumRowHeadings(int n) {
        this.numRowHeadings = n;
    }

    public String getNumRowHeadingsVariable() {
        return this.numRowHeadingsVar;
    }

    public void setNumRowHeadingsVariable(String string) {
        this.numRowHeadingsVar = string;
    }

    public int getType() {
        return 110;
    }

    public void set3D(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(0));
        }
    }

    public boolean is3D() {
        return this.border.getValue() == 0;
    }

    public void setBoxed(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(1));
        }
    }

    public boolean isBoxed() {
        return this.border.getValue() == 1;
    }

    public void setPaged(boolean bl) {
        this.paged = bl;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public void setNoBox(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(2));
        }
    }

    public boolean isNoBox() {
        return this.border.getValue() == 2;
    }

    public void setColumnSettings(GridColumnSettingList gridColumnSettingList) {
        this.columnSettings = gridColumnSettingList;
        this.numColumns = this.columnSettings.getSettingCount();
    }

    public GridColumnSettingList getColumnSettings() {
        return this.columnSettings;
    }

    public void setRecordToAdd(ItemToAddSettingList itemToAddSettingList) {
        ItemSettingList itemSettingList = new ItemSettingList();
        itemSettingList.setSettings(itemToAddSettingList.getSettings());
        this.setRecordToAdd(itemSettingList);
    }

    public void setRecordToAdd(ItemSettingList itemSettingList) {
        this.recordToAdd = itemSettingList;
        if (this.recordToAdd != null) {
            this.recordToAdd.setName("Record to Add");
        }
    }

    public ItemSettingList getRecordToAdd() {
        return this.recordToAdd;
    }

    public boolean isUseTab() {
        return this.useTab;
    }

    public void setUseTab(boolean bl) {
        this.useTab = bl;
    }

    public boolean isVScroll() {
        return this.vScroll;
    }

    public void setVScroll(boolean bl) {
        this.vScroll = bl;
    }

    public boolean isAdjustableRows() {
        return this.adjustableRows;
    }

    public void setAdjustableRows(boolean bl) {
        this.adjustableRows = bl;
    }

    public int getRowDividers() {
        return this.rowDividers;
    }

    public void setRowDividers(int n) {
        this.rowDividers = n;
        this.updateLines();
    }

    public boolean isAdjustableColumns() {
        return this.adjustableColumns;
    }

    public void setAdjustableColumns(boolean bl) {
        this.adjustableColumns = bl;
    }

    public boolean isCenteredHeadings() {
        return this.centeredHeadings;
    }

    public void setCenteredHeadings(boolean bl) {
        this.centeredHeadings = bl;
    }

    public boolean isColumnHeadings() {
        return this.columnHeadings;
    }

    public void setColumnHeadings(boolean bl) {
        this.columnHeadings = bl;
    }

    public boolean isHScroll() {
        return this.hScroll;
    }

    public void setHScroll(boolean bl) {
        this.hScroll = bl;
        this.updateLines();
    }

    public boolean isReorderingColumns() {
        return this.reorderingColumns;
    }

    public void setReorderingColumns(boolean bl) {
        this.reorderingColumns = bl;
    }

    public boolean isNoSearch() {
        return this.noSearch;
    }

    public boolean isFilterableColumns() {
        return this.filterableColumns;
    }

    public void setNoSearch(boolean bl) {
        this.noSearch = bl;
    }

    public void setFilterableColumns(boolean bl) {
        this.filterableColumns = bl;
    }

    public boolean isRowHeadings() {
        return this.rowHeadings;
    }

    public void setRowHeadings(boolean bl) {
        this.rowHeadings = bl;
    }

    public boolean isSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortableColumns(boolean bl) {
        this.sortableColumns = bl;
    }

    public boolean isTiledHeadings() {
        return this.tiledHeadings;
    }

    public void setTiledHeadings(boolean bl) {
        this.tiledHeadings = bl;
    }

    public ColorType getDragColor() {
        return this.dragColor;
    }

    public void setDragColor(ColorType colorType) {
        this.dragColor = colorType;
    }

    public int getControlHeight(float f) {
        float f2 = (float)this.metrics.getHeight() * (1.0f + (float)this.getVPadding() / 100.0f);
        int n = (int)(f2 * f);
        n += this.rowSettings.getSettingCount() * this.getRowDividers();
        if (this.isHScroll()) {
            n += 17;
        }
        return n;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)this.fontWidth * f);
        int n2 = this.columnSettings.getSettingCount();
        for (int i = 0; i < n2; ++i) {
            GridColumnSetting gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(i);
            n += gridColumnSetting.getDivider();
        }
        if (this.isVScroll()) {
            n += 17;
        }
        return n;
    }

    public float getControlHeight(int n) {
        if (this.isHScroll()) {
            n -= 17;
        }
        float f = (float)this.metrics.getHeight() * (1.0f + (float)this.getVPadding() / 100.0f);
        return (float)(n -= this.rowSettings.getSettingCount() * this.getRowDividers()) / f;
    }

    public float getControlWidth(int n) {
        int n2 = this.columnSettings.getSettingCount();
        for (int i = 0; i < n2; ++i) {
            GridColumnSetting gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(i);
            n -= gridColumnSetting.getDivider();
        }
        if (this.isVScroll()) {
            n -= 17;
        }
        return (float)n / (float)this.fontWidth;
    }

    public BackgroundColorType getEndColor() {
        return this.endColor;
    }

    public void setEndColor(BackgroundColorType backgroundColorType) {
        this.endColor = backgroundColorType;
    }

    public ColorType getHeadingColor() {
        return this.headingColor;
    }

    public void setHeadingColor(ColorType colorType) {
        this.headingColor = colorType;
    }

    public ColorType getRegionColor() {
        return this.regionColor;
    }

    public void setRegionColor(ColorType colorType) {
        this.regionColor = colorType;
    }

    public ForegroundColorType getHeadingDividerColor() {
        return this.headingDividerColor;
    }

    public void setHeadingDividerColor(ForegroundColorType foregroundColorType) {
        this.headingDividerColor = foregroundColorType;
    }

    public FontType getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(FontType fontType) {
        if (fontType == null) {
            fontType = FontType.getNullFont();
        }
        IscobolBeanConstants.setHandleName((ResourceWithHandleType)this.headingFont, (ResourceWithHandleType)fontType);
        this.headingFont = fontType;
    }

    public String getHeadingFontVariable() {
        return this.headingFont != null ? this.headingFont.getHandleName() : null;
    }

    public void setHeadingFontVariable(String string) {
        if (string != null && string.length() > 0) {
            if (this.headingFont == null) {
                this.headingFont = FontType.getNullFont();
            }
            this.headingFont.setHandleName(string);
        } else if (this.headingFont != null) {
            this.headingFont.setHandleName(string);
        }
    }

    public GridRowSettingList getRowSettings() {
        return this.rowSettings;
    }

    public void setRowSettings(GridRowSettingList gridRowSettingList) {
        this.rowSettings = gridRowSettingList;
        this.updateLines();
    }

    public GridCellSettingList getCellSettings() {
        return this.cellSettings;
    }

    public void setCellSettings(GridCellSettingList gridCellSettingList) {
        this.cellSettings = gridCellSettingList;
    }

    public String getCursorColorVariable() {
        return this.cursorColorVar;
    }

    public int getVPadding() {
        return this.vPadding;
    }

    public void setVPadding(Percentage percentage) {
        this.setVPadding(percentage.getValue());
    }

    public void setVPadding(int n) {
        this.vPadding = n;
        this.updateLines();
    }

    public String getVPaddingVariable() {
        return this.vPaddingVar;
    }

    public void setVPaddingVariable(String string) {
        this.vPaddingVar = string;
    }

    public void setCursorColorVariable(String string) {
        this.cursorColorVar = string;
    }

    public int getMouseWheelScroll() {
        return this.mouseWheelScroll;
    }

    public void setMouseWheelScroll(int n) {
        this.mouseWheelScroll = n;
    }

    public String getMouseWheelScrollVariable() {
        return this.mouseWheelScrollVar;
    }

    public void setMouseWheelScrollVariable(String string) {
        this.mouseWheelScrollVar = string;
    }

    public String getCursorXVariable() {
        return this.cursorXVar;
    }

    public void setCursorXVariable(String string) {
        this.cursorXVar = string;
    }

    public String getCursorYVariable() {
        return this.cursorYVar;
    }

    public void setCursorYVariable(String string) {
        this.cursorYVar = string;
    }

    public String getRecordData() {
        return this.recordData;
    }

    public void setRecordData(String string) {
        this.recordData = string;
    }

    public String getCursorFrameWidthVariable() {
        return this.cursorFrameWidthVar;
    }

    public void setCursorFrameWidthVariable(String string) {
        this.cursorFrameWidthVar = string;
    }

    public String getDragColorVariable() {
        return this.dragColorVar;
    }

    public void setDragColorVariable(String string) {
        this.dragColorVar = string;
    }

    public String getEndColorVariable() {
        return this.endColorVar;
    }

    public void setEndColorVariable(String string) {
        this.endColorVar = string;
    }

    public String getProtectionVariable() {
        return this.protectionVar;
    }

    public RowColorPatternSettingList getRowColorPatterns() {
        return this.rowColorPatterns;
    }

    public void setRowColorPatterns(RowColorPatternSettingList rowColorPatternSettingList) {
        this.rowColorPatterns = rowColorPatternSettingList;
    }

    public void setProtectionVariable(String string) {
        this.protectionVar = string;
    }

    public String getHeadingColorVariable() {
        return this.headingColorVar;
    }

    public void setHeadingColorVariable(String string) {
        this.headingColorVar = string;
    }

    public String getHeadingDividerColorVariable() {
        return this.headingDividerColorVar;
    }

    public void setHeadingDividerColorVariable(String string) {
        this.headingDividerColorVar = string;
    }

    public ColorType getRowCursorColor() {
        return this.rowCursorColor;
    }

    public void setRowCursorColor(ColorType colorType) {
        this.rowCursorColor = colorType;
    }

    public BackgroundColorType getRowCursorBackgroundColor() {
        return this.rowCursorBackgroundColor;
    }

    public void setRowCursorBackgroundColor(BackgroundColorType backgroundColorType) {
        this.rowCursorBackgroundColor = backgroundColorType;
    }

    public ForegroundColorType getRowCursorForegroundColor() {
        return this.rowCursorForegroundColor;
    }

    public void setRowCursorForegroundColor(ForegroundColorType foregroundColorType) {
        this.rowCursorForegroundColor = foregroundColorType;
    }

    public String getRowCursorColorVariable() {
        return this.rowCursorColorVar;
    }

    public void setRowCursorColorVariable(String string) {
        this.rowCursorColorVar = string;
    }

    public String getRowCursorBackgroundColorVariable() {
        return this.rowCursorBackgroundColorVar;
    }

    public void setRowCursorBackgroundColorVariable(String string) {
        this.rowCursorBackgroundColorVar = string;
    }

    public String getRowCursorForegroundColorVariable() {
        return this.rowCursorForegroundColorVar;
    }

    public void setRowCursorForegroundColorVariable(String string) {
        this.rowCursorForegroundColorVar = string;
    }

    public String getNumColHeadingsVariable() {
        return this.numColHeadingsVar;
    }

    public void setNumColHeadingsVariable(String string) {
        this.numColHeadingsVar = string;
    }

    public String getNumRowsVariable() {
        return this.numRowsVar;
    }

    public void setNumRowsVariable(String string) {
        this.numRowsVar = string;
    }

    public String getMassUpdateVariable() {
        return this.massUpdateVar;
    }

    public void setMassUpdateVariable(String string) {
        this.massUpdateVar = string;
    }

    public String getRegionColorVariable() {
        return this.regionColorVar;
    }

    public void setRegionColorVariable(String string) {
        this.regionColorVar = string;
    }

    public BackgroundColorType getCursorBackgroundColor() {
        return this.cursorBackgroundColor;
    }

    public void setCursorBackgroundColor(BackgroundColorType backgroundColorType) {
        this.cursorBackgroundColor = backgroundColorType;
    }

    public BackgroundColorType getDragBackgroundColor() {
        return this.dragBackgroundColor;
    }

    public void setDragBackgroundColor(BackgroundColorType backgroundColorType) {
        this.dragBackgroundColor = backgroundColorType;
    }

    public BackgroundColorType getHeadingBackgroundColor() {
        return this.headingBackgroundColor;
    }

    public void setHeadingBackgroundColor(BackgroundColorType backgroundColorType) {
        this.headingBackgroundColor = backgroundColorType;
    }

    public BackgroundColorType getRegionBackgroundColor() {
        return this.regionBackgroundColor;
    }

    public void setRegionBackgroundColor(BackgroundColorType backgroundColorType) {
        this.regionBackgroundColor = backgroundColorType;
    }

    public ForegroundColorType getCursorForegroundColor() {
        return this.cursorForegroundColor;
    }

    public void setCursorForegroundColor(ForegroundColorType foregroundColorType) {
        this.cursorForegroundColor = foregroundColorType;
    }

    public ForegroundColorType getDragForegroundColor() {
        return this.dragForegroundColor;
    }

    public void setDragForegroundColor(ForegroundColorType foregroundColorType) {
        this.dragForegroundColor = foregroundColorType;
    }

    public ForegroundColorType getHeadingForegroundColor() {
        return this.headingForegroundColor;
    }

    public void setHeadingForegroundColor(ForegroundColorType foregroundColorType) {
        this.headingForegroundColor = foregroundColorType;
    }

    public ForegroundColorType getRegionForegroundColor() {
        return this.regionForegroundColor;
    }

    public void setRegionForegroundColor(ForegroundColorType foregroundColorType) {
        this.regionForegroundColor = foregroundColorType;
    }

    public String getCursorBackgroundColorVariable() {
        return this.cursorBackgroundColorVar;
    }

    public void setCursorBackgroundColorVariable(String string) {
        this.cursorBackgroundColorVar = string;
    }

    public String getCursorForegroundColorVariable() {
        return this.cursorForegroundColorVar;
    }

    public void setCursorForegroundColorVariable(String string) {
        this.cursorForegroundColorVar = string;
    }

    public String getDragBackgroundColorVariable() {
        return this.dragBackgroundColorVar;
    }

    public void setDragBackgroundColorVariable(String string) {
        this.dragBackgroundColorVar = string;
    }

    public String getDragForegroundColorVariable() {
        return this.dragForegroundColorVar;
    }

    public void setDragForegroundColorVariable(String string) {
        this.dragForegroundColorVar = string;
    }

    public String getHeadingBackgroundColorVariable() {
        return this.headingBackgroundColorVar;
    }

    public void setHeadingBackgroundColorVariable(String string) {
        this.headingBackgroundColorVar = string;
    }

    public String getHeadingForegroundColorVariable() {
        return this.headingForegroundColorVar;
    }

    public void setHeadingForegroundColorVariable(String string) {
        this.headingForegroundColorVar = string;
    }

    public String getRegionBackgroundColorVariable() {
        return this.regionBackgroundColorVar;
    }

    public void setRegionBackgroundColorVariable(String string) {
        this.regionBackgroundColorVar = string;
    }

    public String getRegionForegroundColorVariable() {
        return this.regionForegroundColorVar;
    }

    public void setRegionForegroundColorVariable(String string) {
        this.regionForegroundColorVar = string;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public String getSelectionModeVariable() {
        return this.selectionModeVar;
    }

    public void setSelectionModeVariable(String string) {
        this.selectionModeVar = string;
    }

    public ForegroundColorType getRowSelectedForegroundColor() {
        return this.rowSelectedForegroundColor;
    }

    public void setRowSelectedForegroundColor(ForegroundColorType foregroundColorType) {
        this.rowSelectedForegroundColor = foregroundColorType;
    }

    public ForegroundColorType getColumnSelectedForegroundColor() {
        return this.columnSelectedForegroundColor;
    }

    public void setColumnSelectedForegroundColor(ForegroundColorType foregroundColorType) {
        this.columnSelectedForegroundColor = foregroundColorType;
    }

    public BackgroundColorType getRowSelectedBackgroundColor() {
        return this.rowSelectedBackgroundColor;
    }

    public void setRowSelectedBackgroundColor(BackgroundColorType backgroundColorType) {
        this.rowSelectedBackgroundColor = backgroundColorType;
    }

    public BackgroundColorType getColumnSelectedBackgroundColor() {
        return this.columnSelectedBackgroundColor;
    }

    public void setColumnSelectedBackgroundColor(BackgroundColorType backgroundColorType) {
        this.columnSelectedBackgroundColor = backgroundColorType;
    }

    public String getRowSelectedForegroundColorVariable() {
        return this.rowSelectedForegroundColorVar;
    }

    public void setRowSelectedForegroundColorVariable(String string) {
        this.rowSelectedForegroundColorVar = string;
    }

    public String getColumnSelectedForegroundColorVariable() {
        return this.columnSelectedForegroundColorVar;
    }

    public void setColumnSelectedForegroundColorVariable(String string) {
        this.columnSelectedForegroundColorVar = string;
    }

    public String getRowSelectedBackgroundColorVariable() {
        return this.rowSelectedBackgroundColorVar;
    }

    public void setRowSelectedBackgroundColorVariable(String string) {
        this.rowSelectedBackgroundColorVar = string;
    }

    public String getColumnSelectedBackgroundColorVariable() {
        return this.columnSelectedBackgroundColorVar;
    }

    public void setColumnSelectedBackgroundColorVariable(String string) {
        this.columnSelectedBackgroundColorVar = string;
    }

    public ColorType getRowSelectedColor() {
        return this.rowSelectedColor;
    }

    public void setRowSelectedColor(ColorType colorType) {
        this.rowSelectedColor = colorType;
    }

    public ColorType getColumnSelectedColor() {
        return this.columnSelectedColor;
    }

    public void setColumnSelectedColor(ColorType colorType) {
        this.columnSelectedColor = colorType;
    }

    public ColorType getCellSelectedColor() {
        return this.cellSelectedColor;
    }

    public void setCellSelectedColor(ColorType colorType) {
        this.cellSelectedColor = colorType;
    }

    public ForegroundColorType getCellSelectedForegroundColor() {
        return this.cellSelectedForegroundColor;
    }

    public void setCellSelectedForegroundColor(ForegroundColorType foregroundColorType) {
        this.cellSelectedForegroundColor = foregroundColorType;
    }

    public BackgroundColorType getCellSelectedBackgroundColor() {
        return this.cellSelectedBackgroundColor;
    }

    public void setCellSelectedBackgroundColor(BackgroundColorType backgroundColorType) {
        this.cellSelectedBackgroundColor = backgroundColorType;
    }

    public String getRowSelectedColorVariable() {
        return this.rowSelectedColorVar;
    }

    public void setRowSelectedColorVariable(String string) {
        this.rowSelectedColorVar = string;
    }

    public String getColumnSelectedColorVariable() {
        return this.columnSelectedColorVar;
    }

    public void setColumnSelectedColorVariable(String string) {
        this.columnSelectedColorVar = string;
    }

    public String getCellSelectedColorVariable() {
        return this.cellSelectedColorVar;
    }

    public void setCellSelectedColorVariable(String string) {
        this.cellSelectedColorVar = string;
    }

    public String getCellSelectedForegroundColorVariable() {
        return this.cellSelectedForegroundColorVar;
    }

    public void setCellSelectedForegroundColorVariable(String string) {
        this.cellSelectedForegroundColorVar = string;
    }

    public String getCellSelectedBackgroundColorVariable() {
        return this.cellSelectedBackgroundColorVar;
    }

    public void setCellSelectedBackgroundColorVariable(String string) {
        this.cellSelectedBackgroundColorVar = string;
    }

    public String getMsgBeginDragEv() {
        return this.msgBeginDragEv;
    }

    public void setMsgBeginDragEv(String string) {
        this.msgBeginDragEv = string;
    }

    public String getMsgBeginEntryEv() {
        return this.msgBeginEntryEv;
    }

    public void setMsgBeginEntryEv(String string) {
        this.msgBeginEntryEv = string;
    }

    public String getMsgBeginHeadingDragEv() {
        return this.msgBeginHeadingDragEv;
    }

    public void setMsgBeginHeadingDragEv(String string) {
        this.msgBeginHeadingDragEv = string;
    }

    public String getMsgBitmapClickedEv() {
        return this.msgBitmapClickedEv;
    }

    public void setMsgBitmapClickedEv(String string) {
        this.msgBitmapClickedEv = string;
    }

    public String getMsgBitmapDblclickEv() {
        return this.msgBitmapDblclickEv;
    }

    public void setMsgBitmapDblclickEv(String string) {
        this.msgBitmapDblclickEv = string;
    }

    public String getMsgCancelEntryEv() {
        return this.msgCancelEntryEv;
    }

    public void setMsgCancelEntryEv(String string) {
        this.msgCancelEntryEv = string;
    }

    public String getMsgColWidthChangedEv() {
        return this.msgColWidthChangedEv;
    }

    public void setMsgColWidthChangedEv(String string) {
        this.msgColWidthChangedEv = string;
    }

    public String getMsgGdDblclickEv() {
        return this.msgGdDblclickEv;
    }

    public void setMsgGdDblclickEv(String string) {
        this.msgGdDblclickEv = string;
    }

    public String getMsgEndDragEv() {
        return this.msgEndDragEv;
    }

    public void setMsgEndDragEv(String string) {
        this.msgEndDragEv = string;
    }

    public String getMsgEndHeadingDragEv() {
        return this.msgEndHeadingDragEv;
    }

    public void setMsgEndHeadingDragEv(String string) {
        this.msgEndHeadingDragEv = string;
    }

    public String getMsgFinishEntryEv() {
        return this.msgFinishEntryEv;
    }

    public void setMsgFinishEntryEv(String string) {
        this.msgFinishEntryEv = string;
    }

    public String getMsgGotoCellEv() {
        return this.msgGotoCellEv;
    }

    public void setMsgGotoCellEv(String string) {
        this.msgGotoCellEv = string;
    }

    public String getMsgGotoCellMouseEv() {
        return this.msgGotoCellMouseEv;
    }

    public void setMsgGotoCellMouseEv(String string) {
        this.msgGotoCellMouseEv = string;
    }

    public String getMsgGotoCellDragEv() {
        return this.msgGotoCellDragEv;
    }

    public void setMsgGotoCellDragEv(String string) {
        this.msgGotoCellDragEv = string;
    }

    public String getMsgGridRButtonDownEv() {
        return this.msgGridRButtonDownEv;
    }

    public void setMsgGotoCellOutNextEv(String string) {
        this.msgGotoCellOutNextEv = string;
    }

    public String getMsgGotoCellOutNextEv() {
        return this.msgGotoCellOutNextEv;
    }

    public void setMsgGotoCellOutPrevEv(String string) {
        this.msgGotoCellOutPrevEv = string;
    }

    public String getMsgGotoCellOutPrevEv() {
        return this.msgGotoCellOutPrevEv;
    }

    public void setMsgGridRButtonDownEv(String string) {
        this.msgGridRButtonDownEv = string;
    }

    public String getMsgGridRButtonUpEv() {
        return this.msgGridRButtonUpEv;
    }

    public void setMsgGridRButtonUpEv(String string) {
        this.msgGridRButtonUpEv = string;
    }

    public String getMsgHeadingClickedEv() {
        return this.msgHeadingClickedEv;
    }

    public void setMsgHeadingClickedEv(String string) {
        this.msgHeadingClickedEv = string;
    }

    public String getMsgHeadingDblclickEv() {
        return this.msgHeadingDblclickEv;
    }

    public void setMsgHeadingDblclickEv(String string) {
        this.msgHeadingDblclickEv = string;
    }

    public String getMsgBeginSortEv() {
        return this.msgBeginSortEv;
    }

    public void setMsgBeginSortEv(String string) {
        this.msgBeginSortEv = string;
    }

    public String getMsgFinishSortEv() {
        return this.msgFinishSortEv;
    }

    public void setMsgFinishSortEv(String string) {
        this.msgFinishSortEv = string;
    }

    public String getMsgHeadingDraggedEv() {
        return this.msgHeadingDraggedEv;
    }

    public void setMsgHeadingDraggedEv(String string) {
        this.msgHeadingDraggedEv = string;
    }

    public String getMsgPagedFirstEv() {
        return this.msgPagedFirstEv;
    }

    public void setMsgPagedFirstEv(String string) {
        this.msgPagedFirstEv = string;
    }

    public String getMsgPagedLastEv() {
        return this.msgPagedLastEv;
    }

    public void setMsgPagedLastEv(String string) {
        this.msgPagedLastEv = string;
    }

    public String getMsgPagedPrevEv() {
        return this.msgPagedPrevEv;
    }

    public void setMsgPagedPrevEv(String string) {
        this.msgPagedPrevEv = string;
    }

    public String getMsgPagedNextEv() {
        return this.msgPagedNextEv;
    }

    public void setMsgPagedNextEv(String string) {
        this.msgPagedNextEv = string;
    }

    public String getMsgPagedNextPageEv() {
        return this.msgPagedNextPageEv;
    }

    public void setMsgPagedNextPageEv(String string) {
        this.msgPagedNextPageEv = string;
    }

    public String getMsgPagedPrevPageEv() {
        return this.msgPagedPrevPageEv;
    }

    public void setMsgPagedPrevPageEv(String string) {
        this.msgPagedPrevPageEv = string;
    }

    private String getColumnSettingsCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.columnSettings.getSettingCount();
        if (n > 0) {
            int n2;
            int n3;
            GridColumnSetting gridColumnSetting;
            int n4;
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("column-dividers (");
            for (n4 = 0; n4 < n; ++n4) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n4);
                stringBuilder2.append(" ");
                stringBuilder2.append(gridColumnSetting.getDivider());
            }
            stringBuilder2.append(" )");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            if (n > 1) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("data-columns ( ");
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(0);
                if (!bl && gridColumnSetting.getDataColumnVarPos() != null && gridColumnSetting.getDataColumnVarPos().length() > 0) {
                    stringBuilder2.append("record-position of " + gridColumnSetting.getDataColumnVarPos());
                } else {
                    stringBuilder2.append("1");
                }
                n4 = 1;
                for (n3 = 0; n3 < n - 1; ++n3) {
                    gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n3);
                    GridColumnSetting gridColumnSetting2 = (GridColumnSetting)this.columnSettings.getSettingAt(n3 + 1);
                    n4 += gridColumnSetting.getDataColumn();
                    stringBuilder2.append(" ");
                    if (!bl && gridColumnSetting2.getDataColumnVarPos() != null && gridColumnSetting2.getDataColumnVarPos().length() > 0) {
                        stringBuilder2.append("record-position of " + gridColumnSetting2.getDataColumnVarPos());
                        continue;
                    }
                    stringBuilder2.append(n4);
                }
                stringBuilder2.append(" )");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("display-columns ( 1");
                n4 = 1;
                for (n3 = 0; n3 < n - 1; ++n3) {
                    gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append(n4 += gridColumnSetting.getDisplayColumn());
                }
                stringBuilder2.append(" )");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("separation (");
            for (n4 = 0; n4 < n; ++n4) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n4);
                stringBuilder2.append(" ");
                stringBuilder2.append(gridColumnSetting.getSeparation());
            }
            stringBuilder2.append(" )");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("alignment (");
            block11: for (n4 = 0; n4 < n; ++n4) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n4);
                stringBuilder2.append(" ");
                switch (gridColumnSetting.getAlignmentExt().getValue()) {
                    case 0: {
                        stringBuilder2.append("\"U\"");
                        continue block11;
                    }
                    case 1: {
                        stringBuilder2.append("\"L\"");
                        continue block11;
                    }
                    case 2: {
                        stringBuilder2.append("\"C\"");
                        continue block11;
                    }
                    case 3: {
                        stringBuilder2.append("\"R\"");
                        continue block11;
                    }
                    case 4: {
                        stringBuilder2.append("\"H\"");
                    }
                }
            }
            stringBuilder2.append(" )");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            n4 = 0;
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("column-headings-layout (");
            for (n3 = 0; n3 < n; ++n3) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n3);
                stringBuilder2.append(" ");
                stringBuilder2.append(gridColumnSetting.getHeadingLayout());
                n4 |= gridColumnSetting.getHeadingLayout() > 0 ? 1 : 0;
            }
            stringBuilder2.append(" )");
            if (n4 != 0) {
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("data-types (");
            for (n3 = 0; n3 < n; ++n3) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n3);
                stringBuilder2.append(" \"");
                stringBuilder2.append(gridColumnSetting.getDataType());
                stringBuilder2.append("\"");
            }
            stringBuilder2.append(" )");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            n3 = 0;
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("sort-types (");
            for (n2 = 0; n2 < n; ++n2) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n2);
                stringBuilder2.append(" \"");
                String string2 = gridColumnSetting.getSortType();
                if (string2 == null || string2.length() == 0) {
                    string2 = "-";
                }
                n3 |= !string2.equals("-") ? 1 : 0;
                stringBuilder2.append(string2);
                stringBuilder2.append("\"");
            }
            stringBuilder2.append(" )");
            if (n3 != 0) {
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("editor-show-always (");
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                gridColumnSetting = (GridColumnSetting)this.columnSettings.getSettingAt(i);
                stringBuilder2.append(gridColumnSetting.getEditorShowAlways() ? " 1" : " 0");
                n2 |= gridColumnSetting.getEditorShowAlways();
            }
            stringBuilder2.append(" )");
            if (n2 != 0) {
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        return stringBuilder.toString();
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        throw new RuntimeException("Wrong method invocation");
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        GridCellSetting gridCellSetting;
        int n;
        int n2;
        StringBuilder stringBuilder;
        int n3;
        String string3;
        StringBuilder stringBuilder2 = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string4 = string3 = string != null ? string : this.getName();
        if (this.isCellEditor() || !bl3) {
            stringBuilder2.append(cobolFormatter.formatLine(string2 + "modify " + string3));
            stringBuilder2.append(this.getColumnSettingsCode(cobolFormatter, bl2, string2 + "   "));
            stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
        }
        if ((n3 = this.rowColorPatterns.getSettingCount()) > 0) {
            stringBuilder = new StringBuilder(string2);
            stringBuilder.append("modify ");
            stringBuilder.append(string3);
            stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
            n2 = this.rowColorPatterns.hasRgbColors() ? 1 : 0;
            for (n = 0; n < n3; ++n) {
                stringBuilder = new StringBuilder(string2);
                gridCellSetting = (RowColorPatternSetting)this.rowColorPatterns.getSettingAt(n);
                ColorType colorType = gridCellSetting.getColor();
                if (n2 != 0) {
                    stringBuilder.append("   row-background-color-pattern rgb ");
                    if (colorType.isRgb()) {
                        stringBuilder.append(colorType.getRgbBackground());
                    } else {
                        stringBuilder.append(colorType.getBackgroundColor(this.palette).getRGB() & 0xFFFFFF);
                    }
                    stringBuilder.append(" row-foreground-color-pattern rgb ");
                    if (colorType.isRgb()) {
                        stringBuilder.append(colorType.getRgbForeground());
                    } else {
                        stringBuilder.append(colorType.getForegroundColor(this.palette).getRGB() & 0xFFFFFF);
                    }
                } else {
                    stringBuilder.append("   row-color-pattern ");
                    stringBuilder.append(gridCellSetting.getColor().getColor());
                }
                stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
            }
            stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
        }
        if ((n3 = this.recordToAdd.getSettingCount()) > 0) {
            stringBuilder = new StringBuilder(string2);
            stringBuilder.append("modify ");
            stringBuilder.append(string3);
            stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
            for (n = 0; n < n3; ++n) {
                gridCellSetting = (ItemSetting)this.recordToAdd.getSettingAt(n);
                String string5 = gridCellSetting.getData();
                if (string5 == null) continue;
                stringBuilder = new StringBuilder(string2);
                stringBuilder.append("   record-to-add ");
                IscobolBeanConstants.getStringCode((String)string5, (boolean)bl, (StringBuilder)stringBuilder);
                stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
            }
            stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
        }
        if ((n3 = this.cellSettings.getSettingCount()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                gridCellSetting = (GridCellSetting)this.cellSettings.getSettingAt(n2);
                if (!gridCellSetting.isChanged()) continue;
                stringBuilder = new StringBuilder(string2);
                stringBuilder.append("modify ");
                stringBuilder.append(string3);
                stringBuilder.append(" x = ");
                stringBuilder.append(gridCellSetting.getX());
                stringBuilder.append(", y = ");
                stringBuilder.append(gridCellSetting.getY());
                stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
                String string6 = string2 + "   ";
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getProtectionVariable(), (int)gridCellSetting.isProtection().getValue(), (int)0, (String)"cell-protection", (String)string6, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)gridCellSetting.getBitmap(), (String)"bitmap", (String)string6, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)gridCellSetting.getBitmapNumber(), (int)0, (String)"bitmap-number", (String)string6, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)gridCellSetting.getBitmapTrailing(), (int)0, (String)"bitmap-trailing", (String)string6, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)gridCellSetting.getBitmapWidth(), (int)16, (String)"bitmap-width", (String)string6, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getColorVariable(), (ColorType)gridCellSetting.getColor(), (int)0, (String)"cell-color", (String)string6, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getBackgroundColorVariable(), (ColorType)gridCellSetting.getBackgroundColor(), (int)0, (String)"cell-background-color", (String)string6, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getForegroundColorVariable(), (ColorType)gridCellSetting.getForegroundColor(), (int)0, (String)"cell-foreground-color", (String)string6, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)gridCellSetting.getFont(), (String)"cell-font", (String)string6, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getDataVariable(), (String)gridCellSetting.getData(), (String)"cell-data", (String)string6, (StringBuilder)stringBuilder2, (boolean)bl, (boolean)bl2);
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getHiddenDataVariable(), (String)gridCellSetting.getHiddenData(), (String)"hidden-data", (String)string6, (StringBuilder)stringBuilder2, (boolean)bl, (boolean)bl2);
                IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getHintVariable(), (String)gridCellSetting.getHint(), (String)"cell-hint", (String)string6, (StringBuilder)stringBuilder2, (boolean)bl, (boolean)bl2);
                stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
            }
        }
        if ((n3 = this.rowSettings.getSettingCount()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                gridCellSetting = (GridRowSetting)this.rowSettings.getSettingAt(n2);
                if (!gridCellSetting.isChanged()) continue;
                stringBuilder2.append(cobolFormatter.formatLine(string2 + "modify " + string3 + " y = " + gridCellSetting.getRowIndex()));
                String string7 = string2 + "   ";
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getColorVariable(), (ColorType)gridCellSetting.getColor(), (int)0, (String)"row-color", (String)string7, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getBackgroundColorVariable(), (ColorType)gridCellSetting.getBackgroundColor(), (int)0, (String)"row-background-color", (String)string7, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getForegroundColorVariable(), (ColorType)gridCellSetting.getForegroundColor(), (int)0, (String)"row-foreground-color", (String)string7, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)gridCellSetting.getFont(), (String)"row-font", (String)string7, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getProtectionVariable(), (int)gridCellSetting.getProtection().getValue(), (int)0, (String)"row-protection", (String)string7, (StringBuilder)stringBuilder2, (boolean)false);
                stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
            }
        }
        if ((n3 = this.columnSettings.getSettingCount()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                gridCellSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n2);
                if (!gridCellSetting.isChanged()) continue;
                stringBuilder = new StringBuilder(string2);
                stringBuilder.append("modify ");
                stringBuilder.append(string3);
                stringBuilder.append(" x = ");
                stringBuilder.append(n2 + 1);
                stringBuilder2.append(cobolFormatter.formatLine(stringBuilder.toString()));
                String string8 = string2 + "   ";
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getColorVariable(), (ColorType)gridCellSetting.getColor(), (int)0, (String)"column-color", (String)string8, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getBackgroundColorVariable(), (ColorType)gridCellSetting.getBackgroundColor(), (int)0, (String)"column-background-color", (String)string8, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getForegroundColorVariable(), (ColorType)gridCellSetting.getForegroundColor(), (int)0, (String)"column-foreground-color", (String)string8, (StringBuilder)stringBuilder2, (boolean)false);
                IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)gridCellSetting.getFont(), (String)"column-font", (String)string8, (StringBuilder)stringBuilder2);
                IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)gridCellSetting.getProtectionVariable(), (int)gridCellSetting.getProtection().getValue(), (int)0, (String)"column-protection", (String)string8, (StringBuilder)stringBuilder2, (boolean)false);
                stringBuilder2.append(cobolFormatter.formatLine(string2 + "."));
            }
        }
        return stringBuilder2.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        throw new RuntimeException("Wrong method invocation");
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.setImportedFromCobol(bl4);
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (bl3 && (this.getColumnSettings().hasEditors() || this.getCellSettings().hasEditors())) {
            IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.getEventProcedure(), (String)"event procedure", (String)string, (StringBuilder)stringBuilder);
        }
        if (!this.isCellEditor() && bl5 || this.allComponentInScreen) {
            stringBuilder.append(this.getColumnSettingsCode(cobolFormatter, bl3, string));
        }
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.is3D(), (String)"3-d", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBoxed(), (String)"boxed", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoBox(), (String)"no-box", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.headingMenuPopup, (int)0, (String)"heading-menu-popup", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noAutosel, (String)"no-autosel", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.centeredHeadings, (String)"centered-headings", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.columnHeadings, (String)"column-headings", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useTab, (String)"use-tab", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.vScroll, (String)"vscroll", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noCellDrag, (String)"no-cell-drag", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.adjustableRows, (String)"adjustable-rows", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.adjustableColumns, (String)"adjustable-columns", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.hScroll, (String)"hscroll", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.paged, (String)"paged", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.reorderingColumns, (String)"reordering-columns", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.filterableColumns, (String)"filterable-columns", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noSearch, (String)"no-search", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.rowHeadings, (String)"row-headings", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.columnHeadingsHeightVar, (float)this.columnHeadingsHeight, (float)1.0f, (boolean)bl, (String)"column-headings-height", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)(this.lmOnColumns.getValue() - 1), (int)-1, (String)"lm-on-columns", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.sortableColumns, (String)"sortable-columns", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.tiledHeadings, (String)"tiled-headings", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.massUpdateVar, (int)this.massUpdate.getValue(), (int)0, (String)"mass-update", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.mouseWheelScrollVar, (int)this.mouseWheelScroll, (int)0, (String)"mouse-wheel-scroll", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!bl3) {
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.recordData, (String)"record-data", (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.recordToAddVar, (String)"record-to-add", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.rowDividers, (int)0, (String)"row-dividers", (String)string, (StringBuilder)stringBuilder);
        if (this.action.getValue() > 0) {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("action action-");
            switch (this.action.getValue()) {
                case 1: {
                    stringBuilder2.append("first-page");
                    break;
                }
                case 2: {
                    stringBuilder2.append("last-page");
                    break;
                }
                case 3: {
                    stringBuilder2.append("current-page");
                }
            }
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.vPaddingVar, (int)this.vPadding, (int)50, (String)"vpadding", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.virtualWidthVar, (int)this.virtualWidth, (int)0, (String)"virtual-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cursorColorVar, (ColorType)this.cursorColor, (int)0, (String)"cursor-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cursorBackgroundColorVar, (ColorType)this.cursorBackgroundColor, (int)0, (String)"cursor-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cursorForegroundColorVar, (ColorType)this.cursorForegroundColor, (int)0, (String)"cursor-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowCursorColorVar, (ColorType)this.rowCursorColor, (int)0, (String)"row-cursor-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowCursorBackgroundColorVar, (ColorType)this.rowCursorBackgroundColor, (int)0, (String)"row-cursor-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowCursorForegroundColorVar, (ColorType)this.rowCursorForegroundColor, (int)0, (String)"row-cursor-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellEntryColorVar, (ColorType)this.cellEntryColor, (int)0, (String)"cell-entry-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellEntryBackgroundColorVar, (ColorType)this.cellEntryBackgroundColor, (int)0, (String)"cell-entry-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellEntryForegroundColorVar, (ColorType)this.cellEntryForegroundColor, (int)0, (String)"cell-entry-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.dragColorVar, (ColorType)this.dragColor, (int)0, (String)"drag-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.dragBackgroundColorVar, (ColorType)this.dragBackgroundColor, (int)0, (String)"drag-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.dragForegroundColorVar, (ColorType)this.dragForegroundColor, (int)0, (String)"drag-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.endColorVar, (ColorType)this.endColor, (int)0, (String)"end-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.headingColorVar, (ColorType)this.headingColor, (int)0, (String)"heading-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.headingBackgroundColorVar, (ColorType)this.headingBackgroundColor, (int)0, (String)"heading-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.headingForegroundColorVar, (ColorType)this.headingForegroundColor, (int)0, (String)"heading-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.regionColorVar, (ColorType)this.regionColor, (int)0, (String)"region-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.regionBackgroundColorVar, (ColorType)this.regionBackgroundColor, (int)0, (String)"region-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.regionForegroundColorVar, (ColorType)this.regionForegroundColor, (int)0, (String)"region-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.headingDividerColorVar, (ColorType)this.headingDividerColor, (int)0, (String)"heading-divider-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.dividerColorVar, (ColorType)this.dividerColor, (int)0, (String)"divider-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getFontCode((CobolFormatter)cobolFormatter, (FontType)this.headingFont, (String)"heading-font", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorXVar, (int)this.cursorX, (int)0, (String)"x", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorYVar, (int)this.cursorY, (int)0, (String)"y", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.cursorFrameWidthVar, (int)this.cursorFrameWidth, (int)Integer.MIN_VALUE, (String)"cursor-frame-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.protectionVar, (int)this.protection.getValue(), (int)0, (String)"protection", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.numColHeadingsVar, (int)this.numColHeadings, (int)0, (String)"num-col-headings", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.numRowHeadingsVar, (int)this.numRowHeadings, (int)0, (String)"num-row-headings", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.numRowsVar, (int)this.numRows, (int)0, (String)"num-rows", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.borderColorVar, (ColorType)this.borderColor, (int)0, (String)"border-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.selectionModeVar, (int)this.selectionMode, (int)0, (String)"selection-mode", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowSelectedColorVar, (ColorType)this.rowSelectedColor, (int)0, (String)"row-selected-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowSelectedBackgroundColorVar, (ColorType)this.rowSelectedBackgroundColor, (int)0, (String)"row-selected-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.rowSelectedForegroundColorVar, (ColorType)this.rowSelectedForegroundColor, (int)0, (String)"row-selected-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.columnSelectedColorVar, (ColorType)this.columnSelectedColor, (int)0, (String)"column-selected-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.columnSelectedBackgroundColorVar, (ColorType)this.columnSelectedBackgroundColor, (int)0, (String)"column-selected-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.columnSelectedForegroundColorVar, (ColorType)this.columnSelectedForegroundColor, (int)0, (String)"column-selected-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellSelectedColorVar, (ColorType)this.cellSelectedColor, (int)0, (String)"cell-selected-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellSelectedBackgroundColorVar, (ColorType)this.cellSelectedBackgroundColor, (int)0, (String)"cell-selected-background-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.cellSelectedForegroundColorVar, (ColorType)this.cellSelectedForegroundColor, (int)0, (String)"cell-selected-foreground-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.exportFileNameVar, (String)this.exportFileName, (String)"export-file-name", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.exportFileFormatVar, (String)this.exportFileFormat, (String)"export-file-format", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.rowsPerPageVar, (int)this.rowsPerPage, (int)0, (String)"rows-per-page", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    private String findMenuHandle(Menu[] menuArray, String string) {
        String string2 = null;
        for (int i = 0; i < menuArray.length && string2 == null; ++i) {
            if (!menuArray[i].getName().equals(string)) continue;
            string2 = menuArray[i].getMenuHandle();
        }
        return string2;
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        throw new RuntimeException("Wrong method invocation");
    }

    public void getDisplayEditorCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, AbstractBeanControl abstractBeanControl, String string, String string2, String string3, String string4, boolean bl, boolean bl2, Menu[] menuArray, ScreenProgram screenProgram, String string5, boolean bl3) {
        String string6;
        AbstractInputField abstractInputField;
        StringBuilder stringBuilder2 = new StringBuilder(string5);
        stringBuilder2.append("display ");
        stringBuilder2.append(IscobolBeanConstants.getTypeName((int)abstractBeanControl.getType()));
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        abstractBeanControl.setCellEditor(true);
        stringBuilder.append(abstractBeanControl.getScreenSectionCode(cobolFormatter, string5.length() + 3, bl, bl2, bl3));
        if (abstractBeanControl instanceof AbstractInputField && (abstractInputField = (AbstractInputField)abstractBeanControl).getPopUpMenu() != null && abstractInputField.getPopUpMenu().length() > 0 && (string6 = this.findMenuHandle(menuArray, abstractInputField.getPopUpMenu())) != null) {
            stringBuilder.append(cobolFormatter.formatLine(string5 + "   pop-up menu " + string6));
        }
        if (abstractBeanControl instanceof ExceptionTerminationValueProvider) {
            String string7;
            abstractInputField = (ExceptionTerminationValueProvider)abstractBeanControl;
            string6 = CodeGenerator.getExceptionValue((ExceptionTerminationValueProvider)abstractInputField, (ScreenProgram)screenProgram);
            if (string6 != null && string6.length() > 0) {
                stringBuilder.append(cobolFormatter.formatLine(string5 + "   exception-value " + string6));
            }
            if ((string7 = CodeGenerator.getTerminationValue((ExceptionTerminationValueProvider)abstractInputField, (ScreenProgram)screenProgram)) != null && string7.length() > 0) {
                stringBuilder.append(cobolFormatter.formatLine(string5 + "   termination-value " + string7));
            }
        }
        stringBuilder.append(cobolFormatter.formatLine(string5 + "   handle " + string));
        stringBuilder.append(cobolFormatter.formatLine(string5 + "   upon " + this.getName() + " (" + string3 + " " + string4 + ")"));
        if (abstractBeanControl instanceof AbstractList || abstractBeanControl instanceof AbstractComboBox) {
            CodeGenerator.getPerformParagraphCode((String)string2, (String)string5, (CobolFormatter)cobolFormatter, (boolean)false, (StringBuilder)stringBuilder);
        }
    }

    private boolean accept(EditableItem editableItem, boolean bl, boolean bl2) {
        if (editableItem.getEditor() == null) {
            return false;
        }
        if (editableItem.getEditorHandle() == null) {
            return false;
        }
        if (editableItem.getEditorHandle().length() == 0) {
            return false;
        }
        return !(bl ? (bl2 ? editableItem.getEditorCodeGeneration().getValue() == 1 : editableItem.getEditorCodeGeneration().getValue() != 2) : (bl2 ? editableItem.getEditorCodeGeneration().getValue() != 1 : editableItem.getEditorCodeGeneration().getValue() == 2));
    }

    public LinkedHashMap<Integer, ArrayList<SettingItem>[]> getEditorsForColumns(boolean bl) {
        ArrayList<SettingItem>[] arrayListArray;
        Integer n;
        GridCellSetting gridCellSetting;
        int n2;
        int n3;
        boolean bl2;
        boolean bl3 = this.getColumnSettings().hasEditors();
        boolean bl4 = this.getCellSettings().hasEditors();
        if (!bl3 && !bl4) {
            return null;
        }
        LinkedHashMap<Integer, ArrayList<SettingItem>[]> linkedHashMap = new LinkedHashMap<Integer, ArrayList<SettingItem>[]>();
        boolean bl5 = bl2 = this.getEditorCodeGeneration().getValue() == 1;
        if (bl4) {
            n3 = this.cellSettings.getSettingCount();
            for (n2 = 0; n2 < n3; ++n2) {
                gridCellSetting = (GridCellSetting)this.cellSettings.getSettingAt(n2);
                if (!this.accept((EditableItem)gridCellSetting, bl, bl2)) continue;
                n = new Integer(gridCellSetting.getX());
                arrayListArray = linkedHashMap.get(n);
                if (arrayListArray == null) {
                    arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                    linkedHashMap.put(n, arrayListArray);
                }
                arrayListArray[0].add((SettingItem)gridCellSetting);
            }
        }
        if (bl3) {
            n3 = this.columnSettings.getSettingCount();
            for (n2 = 0; n2 < n3; ++n2) {
                gridCellSetting = (GridColumnSetting)this.columnSettings.getSettingAt(n2);
                if (!this.accept((EditableItem)gridCellSetting, bl, bl2)) continue;
                n = new Integer(n2 + 1);
                arrayListArray = linkedHashMap.get(n);
                if (arrayListArray == null) {
                    arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                    linkedHashMap.put(n, arrayListArray);
                }
                arrayListArray[1].add((SettingItem)gridCellSetting);
            }
        }
        return linkedHashMap;
    }

    public void getDestroyEditorCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, String string2) {
        stringBuilder.append(cobolFormatter.formatLine(string2 + "destroy " + string));
    }

    private void getEmbeddedEditorsCode(CobolFormatter cobolFormatter, boolean bl, Menu[] menuArray, ScreenProgram screenProgram, LinkedHashMap<Integer, ArrayList<SettingItem>[]> linkedHashMap, boolean bl2, boolean bl3, boolean bl4, String string, StringBuilder stringBuilder) {
        stringBuilder.append(cobolFormatter.formatLine(string + "   evaluate event-data-1"));
        for (Integer n : linkedHashMap.keySet()) {
            String string2;
            stringBuilder.append(cobolFormatter.formatLine(string + "   when " + n));
            ArrayList<SettingItem>[] arrayListArray = linkedHashMap.get(n);
            int n2 = arrayListArray[0].size();
            if (n2 > 0) {
                String string3;
                int n3;
                stringBuilder.append(cobolFormatter.formatLine(string + "      evaluate event-data-2"));
                for (n3 = 0; n3 < n2; ++n3) {
                    string2 = (GridCellSetting)arrayListArray[0].get(n3);
                    stringBuilder.append(cobolFormatter.formatLine(string + "         when " + string2.getY()));
                    string3 = CodeGenerator.getControlEditorInitDataParName((String)this.getName(), (GridCellSetting)string2);
                    if (bl2) {
                        this.getDisplayEditorCode(cobolFormatter, stringBuilder, string2.getEditor(), string2.getEditorHandle(), string3, "event-data-2", "event-data-1", bl, bl3, menuArray, screenProgram, string + "         ", bl4);
                        continue;
                    }
                    this.getDestroyEditorCode(cobolFormatter, string2.getEditorHandle(), stringBuilder, string + "      ");
                }
                n3 = arrayListArray[1].size();
                if (n3 > 0) {
                    stringBuilder.append(cobolFormatter.formatLine(string + "      when other"));
                    string2 = (GridColumnSetting)arrayListArray[1].get(0);
                    if (bl2) {
                        string3 = CodeGenerator.getControlEditorInitDataParName((String)this.getName(), (int)n);
                        this.getDisplayEditorCode(cobolFormatter, stringBuilder, string2.getEditor(), string2.getEditorHandle(), string3, "event-data-2", "event-data-1", bl, bl3, menuArray, screenProgram, string + "         ", bl4);
                    } else {
                        this.getDestroyEditorCode(cobolFormatter, string2.getEditorHandle(), stringBuilder, string + "      ");
                    }
                }
                stringBuilder.append(cobolFormatter.formatLine(string + "      end-evaluate"));
                continue;
            }
            GridColumnSetting gridColumnSetting = (GridColumnSetting)arrayListArray[1].get(0);
            if (bl2) {
                string2 = CodeGenerator.getControlEditorInitDataParName((String)this.getName(), (int)n);
                this.getDisplayEditorCode(cobolFormatter, stringBuilder, gridColumnSetting.getEditor(), gridColumnSetting.getEditorHandle(), string2, "event-data-2", "event-data-1", bl, bl3, menuArray, screenProgram, string + "      ", bl4);
                continue;
            }
            this.getDestroyEditorCode(cobolFormatter, gridColumnSetting.getEditorHandle(), stringBuilder, string + "      ");
        }
        stringBuilder.append(cobolFormatter.formatLine(string + "   end-evaluate"));
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, boolean bl2, Menu[] menuArray, ScreenProgram screenProgram, String string, boolean bl3, boolean bl4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl4) {
            stringBuilder.append(super.getParagraphCode(cobolFormatter, bl, string));
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginDragEv, null, (String)"msg-begin-drag", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        LinkedHashMap linkedHashMap = null;
        if (!bl) {
            linkedHashMap = this.getEditorsForColumns(false);
        }
        if (bl) {
            if (!bl4) {
                IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginEntryEv, null, (String)"msg-begin-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            }
        } else if (linkedHashMap != null && linkedHashMap.size() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + "when msg-begin-entry"));
            this.getEmbeddedEditorsCode(cobolFormatter, bl2, menuArray, screenProgram, linkedHashMap, true, bl3, bl4, string, stringBuilder);
            if (!bl4 && this.msgBeginEntryEv != null && this.msgBeginEntryEv.length() > 0) {
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.msgBeginEntryEv, (String)"perform", (String)string, (StringBuilder)stringBuilder);
            }
        } else if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginEntryEv, null, (String)"msg-begin-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginHeadingDragEv, null, (String)"msg-begin-heading-drag", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBitmapClickedEv, null, (String)"msg-bitmap-clicked", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBitmapDblclickEv, null, (String)"msg-bitmap-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        if (bl) {
            if (!bl4) {
                IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgCancelEntryEv, null, (String)"msg-cancel-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            }
        } else if (linkedHashMap != null && linkedHashMap.size() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + "when msg-cancel-entry"));
            this.getEmbeddedEditorsCode(cobolFormatter, bl2, menuArray, screenProgram, linkedHashMap, false, bl3, bl4, string, stringBuilder);
            if (!bl4 && this.msgCancelEntryEv != null && this.msgCancelEntryEv.length() > 0) {
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.msgCancelEntryEv, (String)"perform", (String)string, (StringBuilder)stringBuilder);
            }
        } else if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgCancelEntryEv, null, (String)"msg-cancel-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgColWidthChangedEv, null, (String)"msg-col-width-changed", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgEndDragEv, null, (String)"msg-end-drag", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgEndHeadingDragEv, null, (String)"msg-end-heading-drag", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        if (bl) {
            if (!bl4) {
                IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgFinishEntryEv, null, (String)"msg-finish-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            }
        } else if (linkedHashMap != null && linkedHashMap.size() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + "when msg-finish-entry"));
            this.getEmbeddedEditorsCode(cobolFormatter, bl2, menuArray, screenProgram, linkedHashMap, false, bl3, bl4, string, stringBuilder);
            if (!bl4 && this.msgFinishEntryEv != null && this.msgFinishEntryEv.length() > 0) {
                IscobolBeanConstants.getUsernameCode((CobolFormatter)cobolFormatter, (String)this.msgFinishEntryEv, (String)"perform", (String)string, (StringBuilder)stringBuilder);
            }
        } else if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgFinishEntryEv, null, (String)"msg-finish-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        if (!bl4) {
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGotoCellEv, null, (String)"msg-goto-cell", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGotoCellMouseEv, null, (String)"msg-goto-cell-mouse", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGotoCellDragEv, null, (String)"msg-goto-cell-drag", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGotoCellOutNextEv, null, (String)"msg-goto-cell-out-next", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGotoCellOutPrevEv, null, (String)"msg-goto-cell-out-prev", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGridRButtonDownEv, null, (String)"msg-grid-rbutton-down", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGridRButtonUpEv, null, (String)"msg-grid-rbutton-up", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgHeadingClickedEv, null, (String)"msg-heading-clicked", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgHeadingDblclickEv, null, (String)"msg-heading-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgHeadingDraggedEv, null, (String)"msg-heading-dragged", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginSortEv, null, (String)"msg-begin-sort", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgFinishSortEv, null, (String)"msg-finish-sort", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedFirstEv, null, (String)"msg-paged-first", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedLastEv, null, (String)"msg-paged-last", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedPrevEv, null, (String)"msg-paged-prev", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedNextEv, null, (String)"msg-paged-next", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedNextPageEv, null, (String)"msg-paged-nextpage", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgPagedPrevPageEv, null, (String)"msg-paged-prevpage", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgGdDblclickEv, null, (String)"msg-gd-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        String string = "";
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector10 = iGUIControl.getControlStyles();
        this.setNumRows(0);
        this.setNumColumns(0);
        if (vector10.contains("ADJUSTABLE-COLUMNS")) {
            this.setAdjustableColumns(true);
        }
        if (vector10.contains("ADJUSTABLE-ROWS")) {
            this.setAdjustableRows(true);
        }
        this.setBorder(new BorderStyle(3));
        if (vector10.contains("BOXED")) {
            this.setBorder(new BorderStyle(1));
        } else if (vector10.contains("3-D")) {
            this.setBorder(new BorderStyle(0));
        } else if (vector10.contains("NO-BOX")) {
            this.setBorder(new BorderStyle(2));
        }
        if (vector10.contains("COLUMN-HEADINGS")) {
            this.setColumnHeadings(true);
        }
        if (vector10.contains("ROW-HEADINGS")) {
            this.setRowHeadings(true);
        }
        if (vector10.contains("VSCROLL")) {
            this.setVScroll(true);
        }
        if (vector10.contains("HSCROLL")) {
            this.setHScroll(true);
        }
        if (vector10.contains("CENTERED-HEADINGS")) {
            this.setCenteredHeadings(true);
        }
        if (vector10.contains("PAGED")) {
            this.setPaged(true);
        }
        if (vector10.contains("REORDERING-COLUMNS")) {
            this.setReorderingColumns(true);
        }
        if (vector10.contains("SORTABLE-COLUMNS")) {
            this.setSortableColumns(true);
        }
        if (vector10.contains("TILED-HEADINGS")) {
            this.setTiledHeadings(true);
        }
        if (vector10.contains("MASS-UPDATE")) {
            this.setMassUpdate(new MassUpdate(1));
        }
        if (vector10.contains("USE-TAB")) {
            this.setUseTab(true);
        }
        if (vector10.contains("NO-AUTOSEL")) {
            this.setNoAutosel(true);
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            int n;
            if (iPropElementList.getKey(i).equals("DATA-COLUMNS")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    string = iPropElementList.getValue(i)[n].getToken() != null ? iPropElementList.getValue(i)[n].getToken().getWord() : iPropElementList.getValue(i)[n].getVariableName().getNameIde();
                    if (vector.size() == 0 && !string.equals("1")) {
                        vector.add("1");
                    }
                    vector.add(string);
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("ALIGNMENT")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector5.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector5.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("DATA-TYPES")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector6.add(iPropElementList.getValue(i)[n].getToken().getWord().substring(1, iPropElementList.getValue(i)[n].getToken().getWord().length() - 1));
                        continue;
                    }
                    vector6.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("SEPARATION")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector4.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector4.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("NUM-COL-HEADINGS")) {
                this.setNumColHeadings((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("DIVIDER-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDividerColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setDividerColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHeadingColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHeadingColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-DIVIDER-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHeadingDividerColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHeadingDividerColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-FRAME-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorFrameWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorFrameWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("RECORD-DATA")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRecordData(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setRecordData(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VPADDING")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setVPadding((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setVPaddingVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-X")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorX((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorXVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-Y")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorY((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setCursorYVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("NUM-ROWS")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setNumRows((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setNumRowsVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("NUM-COLUMNS")) {
                if (iPropElementList.getValue(i)[0].getToken() == null) continue;
                this.setNumColumns((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("LAST-ROW")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setLastRow((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setLastRowVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("VIRTUAL-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setVirtualWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setVirtualWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-DIVIDERS")) {
                if (iPropElementList.getValue(i)[0].getToken() == null) continue;
                this.setRowDividers((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("NUM-ROW-HEADINGS")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setNumRowHeadings((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setNumRowHeadingsVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-HEADING-LINE-HEIGHT")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRowHeadingLineHeight(Float.parseFloat(iPropElementList.getValue(i)[0].getToken().getWord().replace(',', '.')));
                    continue;
                }
                this.setRowHeadingLineHeightVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ACTION")) {
                if (iPropElementList.getValue(i)[0].getToken() == null) continue;
                this.setAction(new GridAction((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                continue;
            }
            if (iPropElementList.getKey(i).equals("PROTECTION")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setProtection(new Protection((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setProtectionVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("RECORD-TO-ADD")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector3.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector3.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setCursorColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setCursorColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-CURSOR-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRowCursorColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setRowCursorColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DRAG-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDragColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setDragColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("REGION-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRegionColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setRegionColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DIVIDER-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDividerColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setDividerColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-BACKGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    n = (int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord());
                    if (iPropElementList.getValue(i)[0].isRgb()) {
                        this.setCursorBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)n));
                        continue;
                    }
                    if (n < 0) {
                        this.setCursorBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)(-n)));
                        continue;
                    }
                    this.setCursorBackgroundColor(new BackgroundColorType(n));
                    continue;
                }
                this.setCursorBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-CURSOR-BACKGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    n = (int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord());
                    if (iPropElementList.getValue(i)[0].isRgb()) {
                        this.setRowCursorBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)n));
                        continue;
                    }
                    if (n < 0) {
                        this.setRowCursorBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)(-n)));
                        continue;
                    }
                    this.setRowCursorBackgroundColor(new BackgroundColorType(n));
                    continue;
                }
                this.setRowCursorBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DRAG-BACKGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDragBackgroundColor(new BackgroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setDragBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-BACKGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHeadingBackgroundColor(new BackgroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHeadingBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("REGION-BACKGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRegionBackgroundColor(new BackgroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setRegionBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("CURSOR-FOREGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    n = (int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord());
                    if (iPropElementList.getValue(i)[0].isRgb()) {
                        this.setCursorForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)n));
                        continue;
                    }
                    if (n < 0) {
                        this.setCursorForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)(-n)));
                        continue;
                    }
                    this.setCursorForegroundColor(new ForegroundColorType(n));
                    continue;
                }
                this.setCursorForegroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-CURSOR-FOREGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    n = (int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord());
                    if (iPropElementList.getValue(i)[0].isRgb()) {
                        this.setRowCursorForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)n));
                        continue;
                    }
                    if (n < 0) {
                        this.setRowCursorForegroundColor(ForegroundColorType.getRgbForegroundColorType((int)(-n)));
                        continue;
                    }
                    this.setRowCursorForegroundColor(new ForegroundColorType(n));
                    continue;
                }
                this.setRowCursorForegroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DRAG-FOREGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setDragForegroundColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setDragForegroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-FOREGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHeadingForegroundColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHeadingBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("REGION-FOREGROUND-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setRegionForegroundColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setRegionForegroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-DIVIDER-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setHeadingDividerColor(new ForegroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setHeadingDividerColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("END-COLOR")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setEndColor(new BackgroundColorType((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord())));
                    continue;
                }
                this.setEndColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("HEADING-FONT")) {
                if (iPropElementList.getValue(i)[0].getToken() == null) continue;
                this.setHeadingFont(new FontType(iPropElementList.getValue(i)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-COLOR-PATTERN")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector7.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector7.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("ROW-SETTING")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector8.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector8.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("CELL-SETTING")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        vector9.add(iPropElementList.getValue(i)[n].getToken().getWord());
                        continue;
                    }
                    vector9.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("MOUSE-WHEEL-SCROLL")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setMouseWheelScroll((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setMouseWheelScrollVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("DISPLAY-COLUMNS")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    string = iPropElementList.getValue(i)[n].getToken() != null ? iPropElementList.getValue(i)[n].getToken().getWord() : iPropElementList.getValue(i)[n].getVariableName().getNameIde();
                    if (vector2.size() == 0 && !string.equals("1")) {
                        vector2.add("1");
                    }
                    vector2.add(string);
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("SELECTION-MODE")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        this.setSelectionMode((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[n].getToken().getWord()));
                        continue;
                    }
                    this.setSelectionModeVariable(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("EXPORT-FILE-NAME")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        this.setExportFileName(iPropElementList.getValue(i)[n].getToken().getWord().substring(1, iPropElementList.getValue(i)[0].getToken().getWord().length() - 1));
                        continue;
                    }
                    this.setExportFileNameVariable(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("EXPORT-FILE-FORMAT")) {
                for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                    if (iPropElementList.getValue(i)[n].getToken() != null) {
                        this.setExportFileFormat(iPropElementList.getValue(i)[n].getToken().getWord().substring(1, iPropElementList.getValue(i)[0].getToken().getWord().length() - 1));
                        continue;
                    }
                    this.setExportFileFormatVariable(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
                }
                continue;
            }
            if (!iPropElementList.getKey(i).equals("ROW-SELECTED-BACKGROUND-COLOR")) continue;
            if (iPropElementList.getValue(i)[0].getToken() != null) {
                n = (int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord());
                if (iPropElementList.getValue(i)[0].isRgb()) {
                    this.setRowSelectedBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)n));
                    continue;
                }
                if (n < 0) {
                    this.setRowSelectedBackgroundColor(BackgroundColorType.getRgbBackgroundColorType((int)(-n)));
                    continue;
                }
                this.setRowSelectedBackgroundColor(new BackgroundColorType(n));
                continue;
            }
            this.setRowSelectedBackgroundColorVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
        }
        GridColumnSetting gridColumnSetting = null;
        GridColumnSetting gridColumnSetting2 = null;
        GridColumnSettingList gridColumnSettingList = null;
        int n = vector.size();
        if (n < vector2.size()) {
            n = vector2.size();
        }
        if (n < vector4.size()) {
            n = vector4.size();
        }
        if (n < vector6.size()) {
            n = vector6.size();
        }
        if (n < vector5.size()) {
            n = vector5.size();
        }
        for (int i = 0; i < n; ++i) {
            if (gridColumnSettingList == null) {
                gridColumnSettingList = new GridColumnSettingList();
            }
            gridColumnSetting = new GridColumnSetting();
            if (vector.size() > i && i > 0) {
                try {
                    gridColumnSetting2.setDataColumn((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector.elementAt(i))) - (int)PropertyDescriptorRegistry.parseFloat((String)((String)vector.elementAt(i - 1))));
                }
                catch (Exception exception) {
                    gridColumnSetting.setDataColumnVarPos((String)vector.elementAt(i));
                }
            }
            if (vector6.size() > i) {
                gridColumnSetting.setDataType((String)vector6.elementAt(i));
            }
            if (vector5.size() > i) {
                if (((String)vector5.elementAt(i)).contains("U")) {
                    gridColumnSetting.setAlignmentExt(new HAlignmentExt(0));
                } else if (((String)vector5.elementAt(i)).contains("L")) {
                    gridColumnSetting.setAlignmentExt(new HAlignmentExt(1));
                } else if (((String)vector5.elementAt(i)).contains("C")) {
                    gridColumnSetting.setAlignmentExt(new HAlignmentExt(2));
                } else if (((String)vector5.elementAt(i)).contains("R")) {
                    gridColumnSetting.setAlignmentExt(new HAlignmentExt(3));
                } else if (((String)vector5.elementAt(i)).contains("H")) {
                    gridColumnSetting.setAlignmentExt(new HAlignmentExt(4));
                }
            }
            if (vector2.size() >= i && i > 0) {
                try {
                    gridColumnSetting2.setDisplayColumn((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector2.elementAt(i))) - (int)PropertyDescriptorRegistry.parseFloat((String)((String)vector2.elementAt(i - 1))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (vector4.size() > i) {
                gridColumnSetting.setSeparation((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector4.elementAt(i))));
            }
            gridColumnSettingList.addSetting((SettingItem)gridColumnSetting);
            gridColumnSetting2 = gridColumnSetting;
        }
        if (gridColumnSettingList != null) {
            this.setColumnSettings(gridColumnSettingList);
        }
        ItemSetting itemSetting = null;
        ItemSettingList itemSettingList = null;
        for (int i = 0; i < vector3.size(); ++i) {
            if (itemSettingList == null) {
                itemSettingList = new ItemSettingList();
            }
            itemSetting = new ItemSetting();
            itemSetting.setData((String)vector3.elementAt(i));
            itemSettingList.addSetting((SettingItem)itemSetting);
        }
        if (itemSettingList != null) {
            this.setRecordToAdd(itemSettingList);
        }
        RowColorPatternSetting rowColorPatternSetting = null;
        RowColorPatternSettingList rowColorPatternSettingList = null;
        for (int i = 0; i < vector7.size(); ++i) {
            if (rowColorPatternSettingList == null) {
                rowColorPatternSettingList = new RowColorPatternSettingList();
            }
            rowColorPatternSetting = new RowColorPatternSetting();
            rowColorPatternSetting.setColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector7.elementAt(i)))));
            rowColorPatternSettingList.addSetting((SettingItem)itemSetting);
        }
        if (rowColorPatternSettingList != null) {
            this.setRowColorPatterns(rowColorPatternSettingList);
        }
        GridRowSetting gridRowSetting = null;
        GridRowSettingList gridRowSettingList = null;
        for (int i = 0; i < vector8.size(); ++i) {
            if (gridRowSettingList == null) {
                gridRowSettingList = new GridRowSettingList();
            }
            gridRowSetting = new GridRowSetting();
            gridRowSetting.setColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector8.elementAt(i)))));
            gridRowSettingList.addSetting((SettingItem)gridRowSetting);
        }
        if (gridRowSettingList != null) {
            this.setRowSettings(gridRowSettingList);
        }
        GridCellSetting gridCellSetting = null;
        GridCellSettingList gridCellSettingList = null;
        for (int i = 0; i < vector9.size(); ++i) {
            if (gridCellSettingList == null) {
                gridCellSettingList = new GridCellSettingList();
            }
            gridCellSetting = new GridCellSetting();
            gridCellSetting.setColor(new ColorType((int)PropertyDescriptorRegistry.parseFloat((String)((String)vector9.elementAt(i)))));
            gridCellSettingList.addSetting((SettingItem)gridCellSetting);
        }
        if (gridCellSettingList != null) {
            this.setCellSettings(gridCellSettingList);
        }
    }
}

