/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ItemSetting;
import com.iscobol.screenpainter.beans.types.ItemSettingList;
import com.iscobol.screenpainter.beans.types.ItemToAddSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractJavaBean
extends AbstractInputField {
    private static final long serialVersionUID = 1L;
    public static final Set<String> JAVA_BEAN_EVENTS;
    private boolean useReturn;
    private boolean useTab;
    private boolean useAlt;
    private boolean hScroll;
    private boolean vScroll;
    private ImageType bitmap;
    private int bitmapWidth = 16;
    private String clsid;
    private String clsidVar;
    private String eventList;
    private String initSignature;
    private String msgJbEventEv;
    private String objectIn;
    private String bitmapWidthVar;
    private ItemSettingList initParams;
    private String javaBeanInitPar;
    private BorderStyle border;
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private String borderColorVar;

    public AbstractJavaBean(Component component) {
        super(component);
    }

    public void set3D(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(0));
        }
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(15.0f);
        this.setLines(2.0f);
        this.setBorder(new BorderStyle(2));
        this.setInitParams(new ItemSettingList());
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public String[] getInitSignatures() {
        if (this.clsid != null && this.clsid.length() > 0) {
            try {
                Class<?> clazz = Class.forName(this.clsid);
                Constructor<?> constructor = null;
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Constructor<?>[] constructorArray = clazz.getConstructors();
                String[] stringArray = new String[constructor != null ? constructorArray.length : constructorArray.length + 1];
                stringArray[0] = "";
                int n = 1;
                for (int i = 0; i < constructorArray.length; ++i) {
                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                    if (classArray.length <= 0) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.typeToString(classArray[0]));
                    for (int j = 1; j < classArray.length; ++j) {
                        stringBuilder.append(",").append(this.typeToString(classArray[j]));
                    }
                    stringArray[n++] = stringBuilder.toString();
                }
                return stringArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String[0];
    }

    private String typeToString(Class clazz) throws Exception {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        String string = clazz.getName().replace('$', '.');
        for (int i = 0; i < n; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public boolean is3D() {
        return this.border.getValue() == 0;
    }

    public void setBoxed(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(1));
        }
    }

    public boolean isBoxed() {
        return this.border.getValue() == 1;
    }

    public void setNoBox(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(2));
        }
    }

    public boolean isNoBox() {
        return this.border.getValue() == 2;
    }

    public void setBorder(BorderStyle borderStyle) {
        this.border = borderStyle;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public String getBorderColorVariable() {
        return this.borderColorVar;
    }

    public void setBorderColorVariable(String string) {
        this.borderColorVar = string;
    }

    public boolean isUseReturn() {
        return this.useReturn;
    }

    public void setUseReturn(boolean bl) {
        this.useReturn = bl;
    }

    public boolean isUseTab() {
        return this.useTab;
    }

    public void setUseTab(boolean bl) {
        this.useTab = bl;
    }

    public boolean isUseAlt() {
        return this.useAlt;
    }

    public void setUseAlt(boolean bl) {
        this.useAlt = bl;
    }

    public boolean isHScroll() {
        return this.hScroll;
    }

    public void setHScroll(boolean bl) {
        this.hScroll = bl;
    }

    public boolean isVScroll() {
        return this.vScroll;
    }

    public void setVScroll(boolean bl) {
        this.vScroll = bl;
    }

    public ImageType getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(ImageType imageType) {
        this.bitmap = imageType;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public String getClsid() {
        return this.clsid;
    }

    public void setClsid(String string) {
        this.clsid = string;
    }

    public String getClsidVariable() {
        return this.clsidVar;
    }

    public void setClsidVariable(String string) {
        this.clsidVar = string;
    }

    public String getEventList() {
        return this.eventList;
    }

    public void setEventList(String string) {
        this.eventList = string;
    }

    public ItemSettingList getInitParams() {
        return this.initParams;
    }

    public void setInitParams(String string) {
        ItemSettingList itemSettingList = new ItemSettingList();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                ItemSetting itemSetting = new ItemSetting();
                itemSetting.setData(stringTokenizer.nextToken());
                itemSettingList.addSetting((SettingItem)itemSetting);
            }
        }
        this.setInitParams(itemSettingList);
    }

    public void setInitParams(ItemToAddSettingList itemToAddSettingList) {
        ItemSettingList itemSettingList = new ItemSettingList();
        itemSettingList.setSettings(itemToAddSettingList.getSettings());
        this.setInitParams(itemSettingList);
    }

    public void setInitParams(ItemSettingList itemSettingList) {
        this.initParams = itemSettingList;
        if (this.initParams != null) {
            this.initParams.setName("Java Bean Init Params");
        }
    }

    public String getInitSignature() {
        return this.initSignature;
    }

    public void setInitSignature(String string) {
        this.initSignature = string;
    }

    public String getMsgJbEventEv() {
        return this.msgJbEventEv;
    }

    public void setMsgJbEventEv(String string) {
        this.msgJbEventEv = string;
    }

    public String getInitParagraph() {
        return this.javaBeanInitPar;
    }

    public void setInitParagraph(String string) {
        this.javaBeanInitPar = string;
    }

    public String getObjectIn() {
        return this.objectIn;
    }

    public void setObjectIn(String string) {
        this.objectIn = string;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        if (!bl2 && this.javaBeanInitPar != null && this.javaBeanInitPar.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "perform " + this.javaBeanInitPar + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgJbEventEv, null, (String)"msg-jb-event", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.is3D(), (String)"3-d", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBoxed(), (String)"boxed", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoBox(), (String)"no-box", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useReturn, (String)"use-return", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useTab, (String)"use-tab", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.useAlt, (String)"use-alt", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.hScroll, (String)"hscroll", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.vScroll, (String)"vscroll", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.bitmap, (String)"bitmap", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)16, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.clsidVar, (String)this.clsid, (String)"clsid", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)this.initSignature, (String)"init-signature", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)false);
        if (this.initParams != null && this.initParams.getSettingCount() > 0) {
            object = new StringBuilder(string);
            ((StringBuilder)object).append("   init-params (");
            for (int i = 0; i < this.initParams.getSettingCount(); ++i) {
                ((StringBuilder)object).append(" ");
                ((StringBuilder)object).append(((ItemSetting)this.initParams.getSettingAt(i)).getData());
            }
            ((StringBuilder)object).append(")");
            stringBuilder.append(cobolFormatter.formatLine(((StringBuilder)object).toString()));
        }
        if (this.eventList != null && this.eventList.length() > 0) {
            object = new StringTokenizer(this.eventList, ", ");
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("   event-list (");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                stringBuilder2.append(" ");
                if (JAVA_BEAN_EVENTS.contains(string2)) {
                    stringBuilder2.append(string2);
                    continue;
                }
                stringBuilder2.append("\"");
                stringBuilder2.append(string2);
                stringBuilder2.append("\"");
            }
            stringBuilder2.append(")");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.borderColorVar, (ColorType)this.borderColor, (int)0, (String)"border-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!bl3) {
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.objectIn, (String)"object in", (String)string, (StringBuilder)stringBuilder);
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector3 = iGUIControl.getControlStyles();
        this.setBorder(new BorderStyle(3));
        if (vector3.contains("BOXED")) {
            this.setBorder(new BorderStyle(1));
        } else if (vector3.contains("3-D")) {
            this.setBorder(new BorderStyle(0));
        } else if (vector3.contains("NO-BOX")) {
            this.setBorder(new BorderStyle(2));
        }
        if (vector3.contains("USE-RETURN")) {
            this.setUseReturn(true);
        }
        if (vector3.contains("USE-TAB")) {
            this.setUseTab(true);
        }
        if (vector3.contains("USE-ALT")) {
            this.setUseAlt(true);
        }
        if (vector3.contains("HSCROLL")) {
            this.setHScroll(true);
        }
        if (vector3.contains("VSCROLL")) {
            this.setVScroll(true);
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(i)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("CLSID")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    if (iPropElementList.getValue(i)[0].getToken().getWord().charAt(0) == '\"') {
                        this.setClsid(iPropElementList.getValue(i)[0].getToken().getWord().substring(1, iPropElementList.getValue(i)[0].getToken().getWord().length() - 1));
                        continue;
                    }
                    this.setClsid(iPropElementList.getValue(i)[0].getToken().getWord());
                    continue;
                }
                this.setClsidVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(i).equals("INIT-PARAMS")) {
                for (int j = 0; j < iPropElementList.getValue(i).length; ++j) {
                    vector.add(iPropElementList.getValue(i)[j].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(i).equals("EVENT-LIST")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setEventList(iPropElementList.getValue(i)[0].getToken().getWord().substring(1, iPropElementList.getValue(i)[0].getToken().getWord().length() - 1));
                    continue;
                }
                this.setEventList(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("INIT-SIGNATURE")) continue;
            if (iPropElementList.getValue(i)[0].getToken() != null) {
                this.setInitSignature(iPropElementList.getValue(i)[0].getToken().getWord());
                continue;
            }
            this.setInitSignature(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
        }
        if (iScreenAttribute.getVObject() != null) {
            this.objectIn = iScreenAttribute.getVObject().getNameIde();
        }
        ItemSetting itemSetting = null;
        ItemSettingList itemSettingList = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (itemSettingList == null) {
                itemSettingList = new ItemSettingList();
            }
            itemSetting = new ItemSetting();
            if (vector2.size() > i) {
                itemSetting.setData((String)vector.elementAt(i));
            }
            itemSettingList.addSetting((SettingItem)itemSetting);
        }
        if (itemSettingList != null) {
            this.setInitParams(itemSettingList);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("msg-jb-event");
        hashSet.add("msg-menu-input");
        hashSet.add("msg-init-menu");
        hashSet.add("msg-end-menu");
        hashSet.add("msg-validate");
        hashSet.add("cmd-goto");
        hashSet.add("cmd-help");
        JAVA_BEAN_EVENTS = Collections.unmodifiableSet(hashSet);
    }
}

