/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.HAlignment;
import com.iscobol.screenpainter.beans.types.LabelOrientation;
import com.iscobol.screenpainter.beans.types.VAlignment;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractLabel
extends AbstractBeanControl {
    private static final long serialVersionUID = 1L;
    private String title;
    private int labelOffset = 20;
    private boolean transparent;
    private boolean noKeyLetter;
    private boolean vertical;
    private String labelOffsVar;
    private String titleVar;
    private String titlePicture;
    private String formatPicture;
    private VAlignment vAlignment;
    private HAlignment hAlignment;
    private LabelOrientation orientation = new LabelOrientation();

    public AbstractLabel(Component component) {
        super(component);
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setOrientation(this.getOrientation());
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitlePicture() {
        return this.titlePicture;
    }

    public void setTitlePicture(String string) {
        this.titlePicture = string;
    }

    public void setTop(boolean bl) {
        if (bl) {
            this.setVerticalAlignment(new VAlignment(2));
        }
    }

    public boolean isTop() {
        switch (this.getOrientation().getValue()) {
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public void setBottom(boolean bl) {
        if (bl) {
            this.setVerticalAlignment(new VAlignment(1));
        }
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setTitle(IscobolBeanConstants.getTypeName((int)this.getType()));
        this.setLines(2.0f);
        if (this.getTitle().length() > 2) {
            this.setSize((float)(this.getTitle().length() + 1));
        }
        if (this.getTitle().length() > 2 && this.getTitle().startsWith("R\"")) {
            this.setSize(this.getSize() - 3.0f);
        }
    }

    public boolean isBottom() {
        switch (this.getOrientation().getValue()) {
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public void setRight(boolean bl) {
        if (bl) {
            this.setHorizontalAlignment(new HAlignment(3));
        }
    }

    public boolean isRight() {
        switch (this.getOrientation().getValue()) {
            case 2: 
            case 4: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public void setLeft(boolean bl) {
        if (bl) {
            this.setHorizontalAlignment(new HAlignment(1));
        }
    }

    public boolean isLeft() {
        switch (this.getOrientation().getValue()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public void setCenter(boolean bl) {
        if (bl) {
            this.setHorizontalAlignment(new HAlignment(2));
        }
    }

    public boolean isCenter() {
        switch (this.getOrientation().getValue()) {
            case 1: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }

    public boolean isVertical() {
        switch (this.getOrientation().getValue()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public LabelOrientation getOrientation() {
        if (this.vertical || this.vAlignment != null || this.hAlignment != null) {
            int n;
            int n2;
            int n3 = this.vAlignment != null ? this.vAlignment.getValue() : 0;
            int n4 = n2 = this.hAlignment != null ? this.hAlignment.getValue() : 0;
            if (this.vertical) {
                block0 : switch (n2) {
                    default: {
                        switch (n3) {
                            default: {
                                n = 3;
                                break block0;
                            }
                            case 1: 
                        }
                        n = 6;
                        break;
                    }
                    case 2: {
                        n = 5;
                        break;
                    }
                    case 3: {
                        switch (n3) {
                            default: {
                                n = 4;
                                break block0;
                            }
                            case 1: 
                        }
                        n = 7;
                        break;
                    }
                }
            } else {
                block10 : switch (n2) {
                    default: {
                        switch (n3) {
                            default: {
                                n = 0;
                                break block10;
                            }
                            case 2: {
                                n = 3;
                                break block10;
                            }
                            case 1: 
                        }
                        n = 6;
                        break;
                    }
                    case 2: {
                        switch (n3) {
                            default: {
                                n = 1;
                                break block10;
                            }
                            case 1: 
                            case 2: 
                        }
                        n = 5;
                        break;
                    }
                    case 3: {
                        switch (n3) {
                            default: {
                                n = 2;
                                break block10;
                            }
                            case 2: {
                                n = 4;
                                break block10;
                            }
                            case 1: 
                        }
                        n = 7;
                    }
                }
            }
            this.setOrientation(new LabelOrientation(n));
            this.vertical = false;
            this.vAlignment = null;
            this.hAlignment = null;
        }
        return this.orientation;
    }

    public void setOrientation(LabelOrientation labelOrientation) {
        this.orientation = labelOrientation;
    }

    public void setNoKeyLetter(boolean bl) {
        this.noKeyLetter = bl;
    }

    public boolean isNoKeyLetter() {
        return this.noKeyLetter;
    }

    protected Color getAwtBackgroundColor() {
        if (!this.isTransparent()) {
            return super.getAwtBackgroundColor();
        }
        Color color = this.getInheritedAwtBackgroundColor();
        if (color != null) {
            return color;
        }
        return this.getDefaultAwtBackgroundColor();
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.intSetColor(this.getAwtBackgroundColor(), this.getAwtForegroundColor());
    }

    public VAlignment getVerticalAlignment() {
        return this.vAlignment;
    }

    public void setVerticalAlignment(VAlignment vAlignment) {
        this.vAlignment = vAlignment;
    }

    public HAlignment getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setHorizontalAlignment(HAlignment hAlignment) {
        this.hAlignment = hAlignment;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setLines(float f) {
        super.setLines(f);
    }

    public void setLinesPixels(int n) {
        super.setLinesPixels(n);
    }

    public void setLabelOffset(int n) {
        this.labelOffset = n;
        this.setBounds((int)this.getColumnPixels(), (int)this.getLinePixels(), (int)this.getSizePixels(), (int)this.getLinesPixels());
    }

    public void setTitleVariable(String string) {
        this.titleVar = string;
    }

    public String getFormatPicture() {
        return this.formatPicture;
    }

    public void setFormatPicture(String string) {
        this.formatPicture = string;
    }

    public String getTitleVariable() {
        return this.titleVar;
    }

    public void setLabelOffsetVariable(String string) {
        this.labelOffsVar = string;
    }

    public String getLabelOffsetVariable() {
        return this.labelOffsVar;
    }

    protected void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2 + (int)((float)this.cellHeight / 100.0f * (float)this.labelOffset), n3, n4);
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    protected void setComponent(Component component) {
        super.setComponent(component);
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        switch (this.getOrientation().getValue()) {
            case 1: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"center", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 2: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"right", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 3: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"vertical", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 4: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"vertical", (String)string, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"right", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 6: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"vertical", (String)string, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"bottom", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 7: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"vertical", (String)string, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"bottom", (String)string, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"right", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 5: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"vertical", (String)string, (StringBuilder)stringBuilder);
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"center", (String)string, (StringBuilder)stringBuilder);
            }
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.transparent, (String)"transparent", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noKeyLetter, (String)"no-key-letter", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.labelOffsVar, (int)this.labelOffset, (int)20, (String)"label-offset", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)this.titleVar, (String)this.title, (String)"title", (String)string, (StringBuilder)stringBuilder, (boolean)bl2, (boolean)bl3);
        IscobolBeanConstants.getPictureCode((CobolFormatter)cobolFormatter, (String)this.formatPicture, (String)string, (StringBuilder)stringBuilder);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        this.transparent = false;
        this.noKeyLetter = false;
        this.vertical = false;
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        this.setTitle("");
        if (iScreenAttribute.getVFrom() != null) {
            this.setTitleVariable(iScreenAttribute.getVFrom().getNameIde());
            if (iScreenAttribute.getExprSize() == null) {
                this.setSize((float)iScreenAttribute.getVFrom().getVariableLength());
            }
        } else if (iScreenAttribute.getFrom() != null) {
            if (!iScreenAttribute.getFrom().isResource()) {
                if (iScreenAttribute.getTitleIDELen() > 0) {
                    this.setTitle(iScreenAttribute.getFrom().getWord().substring(1, iScreenAttribute.getTitleIDELen()));
                } else {
                    this.setTitle(iScreenAttribute.getFrom().getWord().substring(1, iScreenAttribute.getFrom().getWord().length()));
                }
            } else {
                this.setTitle("R" + iScreenAttribute.getFrom().getWord());
            }
            if (iScreenAttribute.getExprSize() == null) {
                this.setSize((float)(iScreenAttribute.getFrom().getWord().length() - 2));
            }
        } else {
            if (!iScreenAttribute.getTitleIDE().equals("") && iScreenAttribute.getTitleIDE().contains("\"")) {
                if (iScreenAttribute.getTitleIDE().charAt(0) == '\"' || iScreenAttribute.getTitleIDE().charAt(0) == '\'') {
                    this.setTitle(iScreenAttribute.getTitleIDE().substring(1, iScreenAttribute.getTitleIDE().length() - 1));
                } else {
                    this.setTitle(iScreenAttribute.getTitleIDE());
                }
            } else {
                this.setTitleVariable(iScreenAttribute.getTitleIDE());
            }
            if (iScreenAttribute.getExprSize() == null) {
                this.setSize((float)iScreenAttribute.getTitleIDELen());
            }
        }
        if (vector.contains("TRANSPARENT")) {
            this.setTransparent(true);
        }
        if (vector.contains("VERTICAL")) {
            this.setVertical(true);
        }
        if (vector.contains("NO-KEY-LETTER")) {
            this.setNoKeyLetter(true);
        }
        if (vector.contains("TOP")) {
            this.setVerticalAlignment(new VAlignment(2));
        } else if (vector.contains("BOTTOM")) {
            this.setVerticalAlignment(new VAlignment(1));
        }
        if (vector.contains("LEFT")) {
            this.setHorizontalAlignment(new HAlignment(1));
        } else if (vector.contains("RIGHT")) {
            this.setHorizontalAlignment(new HAlignment(3));
        } else if (vector.contains("CENTER")) {
            this.setHorizontalAlignment(new HAlignment(2));
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (!iPropElementList.getKey(i).equals("LABEL-OFFSET")) continue;
            if (iPropElementList.getValue(i)[0].getToken() != null) {
                try {
                    this.setLabelOffset((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            this.setLabelOffsetVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
        }
        if (iVariableDeclarationScreen.getGuiControl().getControlStyles().contains("TRANSPARENT")) {
            this.setTransparent(true);
        }
        if (iVariableDeclarationScreen.getGuiControl().getControlStyles().contains("VERTICAL")) {
            this.setVertical(true);
        }
        if (iVariableDeclarationScreen.getGuiControl().getControlStyles().contains("NO-KEY-LETTER")) {
            this.setNoKeyLetter(true);
        }
        if (iVariableDeclarationScreen.getGuiControl().getSa().hasTitleAttributeTB("BOTTOM")) {
            this.setVerticalAlignment(new VAlignment(1));
        }
        if (iVariableDeclarationScreen.getGuiControl().getSa().hasTitleAttribute("LEFT")) {
            this.setHorizontalAlignment(new HAlignment(1));
        } else if (iVariableDeclarationScreen.getGuiControl().getSa().hasTitleAttribute("RIGHT")) {
            this.setHorizontalAlignment(new HAlignment(3));
        } else if (iVariableDeclarationScreen.getGuiControl().getSa().hasTitleAttribute("CENTER")) {
            this.setHorizontalAlignment(new HAlignment(2));
        }
    }
}

