/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IPropElementValue;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.Position;
import com.iscobol.screenpainter.beans.types.PositionExt;
import com.iscobol.screenpainter.beans.types.PushButtonAlignment;
import com.iscobol.screenpainter.beans.types.PushButtonStyle;
import java.awt.Component;
import java.awt.Image;
import java.util.Vector;

public abstract class AbstractPushButton
extends AbstractButton {
    private static final long serialVersionUID = 1L;
    private boolean noAutoDefault;
    private boolean onHeader;
    private PushButtonStyle style;
    private PushButtonAlignment alignment;
    private String formatPicture;
    private PositionExt titlePosition = new PositionExt(0);

    public AbstractPushButton(Component component) {
        super(component);
        this.setStyle(new PushButtonStyle());
        this.setAlignment(new PushButtonAlignment());
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setTitlePosition(this.titlePosition);
    }

    public void setTitlePosition(Position position) {
        this.setTitlePosition(new PositionExt(position.getValue()));
    }

    public void setTitlePosition(PositionExt positionExt) {
        this.titlePosition = positionExt;
    }

    public PositionExt getTitlePosition() {
        return this.titlePosition;
    }

    public PushButtonAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(PushButtonAlignment pushButtonAlignment) {
        this.alignment = pushButtonAlignment;
    }

    public abstract void setBitmap(Image var1, float var2, float var3, boolean var4, boolean var5, boolean var6, int var7);

    protected void getLocationCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        if (!(this.getParent() instanceof AbstractRibbon)) {
            super.getLocationCode(cobolFormatter, string, stringBuilder, bl, bl2);
        }
    }

    public void setDefaultButton(boolean bl) {
        if (bl) {
            this.setStyle(new PushButtonStyle(1));
        }
    }

    public boolean isDefaultButton() {
        return this.style.getValue() == 1;
    }

    public void setOkButton(boolean bl) {
        if (bl) {
            this.setStyle(new PushButtonStyle(4));
        }
    }

    public PushButtonStyle getStyle() {
        return this.style;
    }

    public int getControlHeight(float f) {
        int n = (int)((float)this.metrics.getHeight() * f);
        if (this.getBitmap() == null) {
            n += 8;
        }
        return n;
    }

    public int getControlWidth(float f) {
        int n = (int)((float)this.fontWidth * f);
        if (this.getBitmap() == null) {
            n += 8;
        }
        return n;
    }

    public float getControlHeight(int n) {
        if (this.getBitmap() == null) {
            n -= 8;
        }
        return (float)n / (float)this.metrics.getHeight();
    }

    public float getControlWidth(int n) {
        if (this.getBitmap() == null) {
            n -= 8;
        }
        return (float)n / (float)this.fontWidth;
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.updateSize();
        this.updateLines();
    }

    public void setStyle(PushButtonStyle pushButtonStyle) {
        this.style = pushButtonStyle;
    }

    public String getFormatPicture() {
        return this.formatPicture;
    }

    public void setFormatPicture(String string) {
        this.formatPicture = string;
    }

    public boolean isOkButton() {
        return this.style.getValue() == 4;
    }

    public void setCancelButton(boolean bl) {
        if (bl) {
            this.setStyle(new PushButtonStyle(2));
        }
    }

    public boolean isCancelButton() {
        return this.style.getValue() == 2;
    }

    public void setEscapeButton(boolean bl) {
        if (bl) {
            this.setStyle(new PushButtonStyle(3));
        }
    }

    public boolean isEscapeButton() {
        return this.style.getValue() == 3;
    }

    public void setNoAutoDefault(boolean bl) {
        this.noAutoDefault = bl;
    }

    public boolean isOnHeader() {
        return this.onHeader;
    }

    public void setOnHeader(boolean bl) {
        this.onHeader = bl;
    }

    public boolean isNoAutoDefault() {
        return this.noAutoDefault;
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!bl3) {
            switch (this.getStyle().getValue()) {
                case 4: {
                    IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"ok-button", (String)string, (StringBuilder)stringBuilder);
                    break;
                }
                case 3: {
                    IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"escape-button", (String)string, (StringBuilder)stringBuilder);
                    break;
                }
                case 2: {
                    IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"cancel-button", (String)string, (StringBuilder)stringBuilder);
                    break;
                }
                case 1: {
                    IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"default-button", (String)string, (StringBuilder)stringBuilder);
                    break;
                }
            }
        }
        switch (this.getAlignment().getValue()) {
            case 0: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"top left", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 1: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"top", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 2: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"top right", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 3: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"left", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            default: {
                break;
            }
            case 5: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"right", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 6: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"bottom left", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 7: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"bottom", (String)string, (StringBuilder)stringBuilder);
                break;
            }
            case 8: {
                IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)true, (String)"bottom right", (String)string, (StringBuilder)stringBuilder);
            }
        }
        IscobolBeanConstants.getPictureCode((CobolFormatter)cobolFormatter, (String)this.formatPicture, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noAutoDefault, (String)"no-auto-default", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.onHeader, (String)"on-header", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.getTitlePositionVariable(), (int)this.titlePosition.getValue(), (int)0, (String)"title-position", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector = iGUIControl.getControlStyles();
        this.setStyle(new PushButtonStyle(0));
        if (vector.contains("CANCEL-BUTTON")) {
            this.setStyle(new PushButtonStyle(2));
        } else if (vector.contains("DEFAULT-BUTTON")) {
            this.setStyle(new PushButtonStyle(1));
        } else if (vector.contains("ESCAPE-BUTTON")) {
            this.setStyle(new PushButtonStyle(3));
        } else if (vector.contains("OK-BUTTON")) {
            this.setStyle(new PushButtonStyle(4));
        }
        if (vector.contains("NO-AUTO-DEFAULT")) {
            this.setNoAutoDefault(true);
        }
        if (vector.contains("ON-HEADER")) {
            this.setOnHeader(true);
        }
        this.setTitlePosition(new PositionExt(0));
        for (int i = 0; i < iPropElementList.size(); ++i) {
            String string = iPropElementList.getKey(i).toString();
            IPropElementValue[] iPropElementValueArray = iPropElementList.getValue(i);
            if (string.equalsIgnoreCase("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementValueArray[0].getVariableName().getNameIde()));
                continue;
            }
            if (!string.equalsIgnoreCase("TITLE-POSITION") || iPropElementValueArray[0].getToken() == null) continue;
            String string2 = iPropElementValueArray[0].getToken().getWord();
            if (string2.equalsIgnoreCase("1")) {
                this.setTitlePosition(new PositionExt(1));
                continue;
            }
            if (string2.equalsIgnoreCase("2")) {
                this.setTitlePosition(new PositionExt(2));
                continue;
            }
            if (string2.equalsIgnoreCase("3")) {
                this.setTitlePosition(new PositionExt(3));
                continue;
            }
            if (string2.equalsIgnoreCase("4")) {
                this.setTitlePosition(new PositionExt(4));
                continue;
            }
            if (string2.equalsIgnoreCase("5")) {
                this.setTitlePosition(new PositionExt(5));
                continue;
            }
            if (string2.equalsIgnoreCase("6")) {
                this.setTitlePosition(new PositionExt(6));
                continue;
            }
            if (string2.equalsIgnoreCase("7")) {
                this.setTitlePosition(new PositionExt(7));
                continue;
            }
            if (string2.equalsIgnoreCase("8")) {
                this.setTitlePosition(new PositionExt(8));
                continue;
            }
            if (string2.equalsIgnoreCase("9")) {
                this.setTitlePosition(new PositionExt(9));
                continue;
            }
            if (string2.equalsIgnoreCase("10")) {
                this.setTitlePosition(new PositionExt(10));
                continue;
            }
            if (string2.equalsIgnoreCase("11")) {
                this.setTitlePosition(new PositionExt(11));
                continue;
            }
            if (string2.equalsIgnoreCase("12")) {
                this.setTitlePosition(new PositionExt(12));
                continue;
            }
            if (!string2.equalsIgnoreCase("13")) continue;
            this.setTitlePosition(new PositionExt(13));
        }
    }
}

