/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.LayoutManager;
import com.iscobol.screenpainter.beans.types.LayoutTypeExt;
import com.iscobol.screenpainter.beans.types.RibbonHeaderAlignment;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;

public abstract class AbstractRibbon
extends AbstractTabbedPane
implements IToolbar,
ComponentsContainer {
    private static final long serialVersionUID = 1L;
    private static final TabOrientation ribbonTabOrientation = new TabOrientation(0);
    public static final int RIBBON_HEADER_HEIGHT = 28;
    private boolean collapse;
    private RibbonHeaderAlignment headerAlignment = new RibbonHeaderAlignment();
    private String headerAlignVar;
    private String handle;
    private Vector<AbstractBeanControl> headerComponents = new Vector();
    private LayoutManager layoutManager = new LayoutManager();
    private String layoutManagerHandle;

    public AbstractRibbon(Component component) {
        super(component);
    }

    public int indexOfHeaderComponent(AbstractBeanControl abstractBeanControl) {
        return this.headerComponents.indexOf(abstractBeanControl);
    }

    public void setHeaderComponentAt(int n, AbstractBeanControl abstractBeanControl) {
        if (n < this.getHeaderComponentCount()) {
            AbstractBeanControl abstractBeanControl2 = (AbstractBeanControl)this.headerComponents.elementAt(n);
            abstractBeanControl2.setParent(null);
            this.headerComponents.setElementAt(abstractBeanControl, n);
            abstractBeanControl.setParent((ScreenElement)this);
        }
    }

    public AbstractBeanControl getHeaderComponentAt(int n) {
        if (n < this.getHeaderComponentCount()) {
            return (AbstractBeanControl)this.headerComponents.elementAt(n);
        }
        return null;
    }

    public int getHeaderComponentCount() {
        return this.headerComponents.size();
    }

    public void addHeaderComponent(AbstractBeanControl abstractBeanControl) {
        this.addHeaderComponent(-1, abstractBeanControl);
    }

    public void addHeaderComponent(int n, AbstractBeanControl abstractBeanControl) {
        ComponentsContainer componentsContainer = (ComponentsContainer)abstractBeanControl.getParent();
        if (componentsContainer != null) {
            componentsContainer.removeComponent(abstractBeanControl);
        }
        if (n < 0 || n >= this.headerComponents.size()) {
            this.headerComponents.addElement(abstractBeanControl);
        } else {
            this.headerComponents.add(n, abstractBeanControl);
        }
        abstractBeanControl.setParent((ScreenElement)this);
    }

    public void removeHeaderComponent(AbstractBeanControl abstractBeanControl) {
        this.removeHeaderComponent(abstractBeanControl, true);
    }

    public void removeHeaderComponent(AbstractBeanControl abstractBeanControl, boolean bl) {
        this.headerComponents.removeElement(abstractBeanControl);
        abstractBeanControl.setParent(null);
        if (bl) {
            this.removeTabOrder(abstractBeanControl.getTabOrder());
        }
    }

    public void removeAllHeaderComponents() {
        while (this.headerComponents.size() > 0) {
            this.removeHeaderComponent((AbstractBeanControl)this.headerComponents.elementAt(0), false);
        }
    }

    public AbstractBeanControl[] getHeaderComponents() {
        AbstractBeanControl[] abstractBeanControlArray = new AbstractBeanControl[this.getHeaderComponentCount()];
        this.headerComponents.toArray(abstractBeanControlArray);
        return abstractBeanControlArray;
    }

    public void setHeaderComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.removeAllHeaderComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.addHeaderComponent(abstractBeanControlArray[i]);
        }
    }

    public TabOrientation getTabOrientation() {
        return ribbonTabOrientation;
    }

    public String getRibbonHandle() {
        return this.handle;
    }

    public void setRibbonHandle(String string) {
        this.handle = string;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void setCollapse(boolean bl) {
        this.collapse = bl;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(LayoutTypeExt layoutTypeExt) {
        int n = layoutTypeExt.getValue();
        if (n == 3) {
            n = 4;
        }
        this.layoutManager = new LayoutManager(n, null);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public String getLayoutManagerHandle() {
        return this.layoutManagerHandle;
    }

    public void setLayoutManagerHandle(String string) {
        this.layoutManagerHandle = string;
    }

    public RibbonHeaderAlignment getHeaderAlignment() {
        return this.headerAlignment;
    }

    public String getHeaderAlignmentVariable() {
        return this.headerAlignVar;
    }

    public void setHeaderAlignmentVariable(String string) {
        this.headerAlignVar = string;
    }

    public void setHeaderAlignment(RibbonHeaderAlignment ribbonHeaderAlignment) {
        this.headerAlignment = ribbonHeaderAlignment;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cobolFormatter.formatLine(string + "display ribbon"));
        string = string + "   ";
        stringBuilder.append(this.getTabToAddCode(cobolFormatter, null, string, bl2, bl3));
        stringBuilder.append(super.getScreenSectionCode(cobolFormatter, string.length(), bl, bl2, bl3));
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)(this.collapse ? 1 : 0), (int)0, (String)"collapse", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.headerAlignVar, (int)this.headerAlignment.getValue(), (int)0, (String)"header-align", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableLayoutManagerCode((CobolFormatter)cobolFormatter, (LayoutManager)this.layoutManager, (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        stringBuilder.append(this.getTabbedPaneScreenSectionCode(cobolFormatter, string, bl3));
        if (this.handle != null) {
            stringBuilder.append(cobolFormatter.formatLine(string + "handle " + this.handle));
        }
        return stringBuilder.toString();
    }

    protected final void getLocationCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
    }

    protected void getDimensionCode(CobolFormatter cobolFormatter, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.getLinesVariable(), (float)this.getLines(), (float)0.0f, (boolean)bl, (String)"lines", (String)string, (StringBuilder)stringBuilder, (boolean)bl2);
    }

    public AbstractBeanControl[] getComponents() {
        return this.getHeaderComponents();
    }

    public AbstractBeanControl[] getToolbarComponents() {
        ArrayList<AbstractBeanControl> arrayList = new ArrayList<AbstractBeanControl>(this.headerComponents);
        for (TabPage tabPage : this.getPages()) {
            for (AbstractBeanControl abstractBeanControl : tabPage.getComponents()) {
                arrayList.add(abstractBeanControl);
            }
        }
        return arrayList.toArray(new AbstractBeanControl[arrayList.size()]);
    }

    public int GetLinesPixels() {
        return (int)this.getLinesPixels();
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        throw new RuntimeException("Wrong method invocation");
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        throw new RuntimeException("Wrong method invocation");
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        throw new RuntimeException("Wrong method invocation");
    }

    public abstract int getMargin();

    public abstract void setHeader(boolean var1);

    public void setCellSize(int n, int n2) {
        super.setCellSize(n, n2);
        for (AbstractBeanControl abstractBeanControl : this.headerComponents) {
            abstractBeanControl.setCellSize(n, n2);
        }
    }

    public boolean isLinesUnitPixel() {
        return false;
    }

    public boolean isLinesUnitCell() {
        return false;
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>(super.getControlNames());
        for (AbstractBeanControl abstractBeanControl : this.headerComponents) {
            vector.addAll(abstractBeanControl.getControlNames());
        }
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector<Integer> vector = new Vector<Integer>(super.getControlIds());
        for (AbstractBeanControl abstractBeanControl : this.headerComponents) {
            vector.addAll(abstractBeanControl.getControlIds());
        }
        return vector;
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>(super.getControlExceptionValues());
        for (AbstractBeanControl abstractBeanControl : this.headerComponents) {
            vector.addAll(abstractBeanControl.getControlExceptionValues());
        }
        return vector;
    }

    public void setComponentAt(int n, AbstractBeanControl abstractBeanControl) {
        this.setHeaderComponentAt(n, abstractBeanControl);
    }

    public AbstractBeanControl getComponentAt(int n) {
        return this.getHeaderComponentAt(n);
    }

    public int getComponentCount() {
        return this.getHeaderComponentCount();
    }

    public void addComponent(AbstractBeanControl abstractBeanControl) {
        this.addHeaderComponent(abstractBeanControl);
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        this.addHeaderComponent(n, abstractBeanControl);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl) {
        this.removeHeaderComponent(abstractBeanControl);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl, boolean bl) {
        this.removeHeaderComponent(abstractBeanControl, bl);
    }

    public void removeAllComponents() {
        this.removeAllHeaderComponents();
    }

    public void setComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.setHeaderComponents(abstractBeanControlArray);
    }

    public void updateTabOrders(AbstractBeanControl abstractBeanControl, int n) {
    }

    public int indexOfComponent(AbstractBeanControl abstractBeanControl) {
        return this.indexOfHeaderComponent(abstractBeanControl);
    }

    public float getLinePixelsToAdd() {
        return this.getLinePixels() + (float)this.getButtonsHeight() - (float)this.cellHeight * 0.9f;
    }

    public float getColPixelsToAdd() {
        return this.getColumnPixels() - (float)this.cellWidth * 0.8f;
    }

    public float getLineToAdd() {
        return this.getRealLine() + (float)this.getButtonsHeight() / (float)this.cellHeight - 0.9f;
    }

    public float getColToAdd() {
        return this.getRealColumn() - 0.8f;
    }

    public boolean isAllowContainer() {
        return true;
    }

    public String getBeforeTabchangeDisplay() {
        return null;
    }

    public String getAfterTabchangeDisplay() {
        return null;
    }
}

