/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractTab
extends AbstractTabbedPane {
    private static final long serialVersionUID = 1L;
    private boolean fixedWidth;
    private boolean multiline;
    private boolean hotTrack;
    private boolean buttons;
    private boolean flatButtons;
    private boolean noDividers;
    private boolean vertical;
    private boolean bottom;
    private boolean textNoRotate;
    private TabOrientation tabOrientation;
    private String befTabchgDisplay;
    private String aftTabchgDisplay;
    private boolean allowContainer;
    private boolean relativeOffset;

    public AbstractTab(Component component) {
        super(component);
    }

    public float getLinePixelsToAdd() {
        if (this.isAllowContainer() && this.isRelativeOffset()) {
            return 0.0f;
        }
        switch (this.tabOrientation.getValue()) {
            case 0: {
                return this.getLinePixels() + (float)this.getButtonsHeight() - 1.0f;
            }
        }
        return this.getLinePixels() - 1.0f;
    }

    public float getColPixelsToAdd() {
        if (this.isAllowContainer() && this.isRelativeOffset()) {
            return 0.0f;
        }
        switch (this.tabOrientation.getValue()) {
            case 1: {
                return this.getColumnPixels() + (float)this.getButtonsHeight() - 1.0f;
            }
        }
        return this.getColumnPixels() - 1.0f;
    }

    public float getLineToAdd() {
        if (this.isAllowContainer() && this.isRelativeOffset()) {
            return 0.0f;
        }
        switch (this.tabOrientation.getValue()) {
            case 0: {
                return this.getRealLine() + (float)this.getButtonsHeight() / (float)this.cellHeight - 0.9f;
            }
        }
        return this.getRealLine() - 0.8f;
    }

    public float getColToAdd() {
        if (this.isAllowContainer() && this.isRelativeOffset()) {
            return 0.0f;
        }
        switch (this.tabOrientation.getValue()) {
            case 1: {
                return this.getRealColumn() + (float)this.getButtonsHeight() / (float)this.cellWidth - 0.9f;
            }
        }
        return this.getRealColumn() - 0.8f;
    }

    public TabOrientation getTabOrientation() {
        return this.tabOrientation;
    }

    public void setTabOrientation(TabOrientation tabOrientation) {
        this.tabOrientation = tabOrientation;
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    protected boolean isBottom() {
        return this.tabOrientation.getValue() == 3 || this.tabOrientation.getValue() == 2;
    }

    public String getBeforeTabchangeDisplay() {
        return this.befTabchgDisplay;
    }

    public void setBeforeTabchangeDisplay(String string) {
        this.befTabchgDisplay = string;
    }

    public String getAfterTabchangeDisplay() {
        return this.aftTabchgDisplay;
    }

    public void setAfterTabchangeDisplay(String string) {
        this.aftTabchgDisplay = string;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
        if (this.vertical) {
            if (this.bottom) {
                this.setTabOrientation(new TabOrientation(2));
            } else {
                this.setTabOrientation(new TabOrientation(1));
            }
        } else if (this.bottom) {
            this.setTabOrientation(new TabOrientation(3));
        } else {
            this.setTabOrientation(new TabOrientation(0));
        }
    }

    public void setBottom(boolean bl) {
        this.bottom = bl;
        if (this.bottom) {
            if (this.vertical) {
                this.setTabOrientation(new TabOrientation(2));
            } else {
                this.setTabOrientation(new TabOrientation(3));
            }
        } else if (this.vertical) {
            this.setTabOrientation(new TabOrientation(1));
        } else {
            this.setTabOrientation(new TabOrientation(0));
        }
    }

    protected boolean isVertical() {
        return this.tabOrientation.getValue() == 1 || this.tabOrientation.getValue() == 2;
    }

    public void setButtons(boolean bl) {
        this.buttons = bl;
    }

    public boolean isTextNoRotate() {
        return this.textNoRotate;
    }

    public void setTextNoRotate(boolean bl) {
        this.textNoRotate = bl;
    }

    public boolean isButtons() {
        return this.buttons;
    }

    public void setFlatButtons(boolean bl) {
        this.flatButtons = bl;
    }

    public boolean isFlatButtons() {
        return this.flatButtons;
    }

    public void setFixedWidth(boolean bl) {
        this.fixedWidth = bl;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setHotTrack(boolean bl) {
        this.hotTrack = bl;
    }

    public boolean isHotTrack() {
        return this.hotTrack;
    }

    public boolean isAllowContainer() {
        return this.allowContainer;
    }

    public void setAllowContainer(boolean bl) {
        this.allowContainer = bl;
    }

    public boolean isRelativeOffset() {
        return this.relativeOffset;
    }

    public void setRelativeOffset(boolean bl) {
        this.relativeOffset = bl;
    }

    public void setNoDividers(boolean bl) {
        this.noDividers = bl;
    }

    public boolean isNoDividers() {
        return this.noDividers;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string3 = string != null ? string : this.getName();
        stringBuilder.append(this.getTabToAddCode(cobolFormatter, string3, string2, bl, bl2));
        stringBuilder.append(cobolFormatter.formatLine(string2 + "."));
        return stringBuilder.toString();
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBottom(), (String)"bottom", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isVertical(), (String)"vertical", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.fixedWidth, (String)"fixed-width", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.multiline, (String)"multiline", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.hotTrack, (String)"hot-track", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.buttons, (String)"buttons", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.flatButtons, (String)"flat-buttons", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.noDividers, (String)"no-dividers", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.textNoRotate, (String)"text-norotate", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.allowContainer, (String)"allow-container", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.relativeOffset, (String)"relative-offset", (String)string, (StringBuilder)stringBuilder);
        stringBuilder.append(this.getTabbedPaneScreenSectionCode(cobolFormatter, string, bl3));
        if (this.allComponentInScreen && this.pages.size() > 0) {
            String string2 = "      tab-to-add (";
            for (int i = 0; i < this.pages.size(); ++i) {
                string2 = string2 + " " + ((TabPage)this.pages.elementAt(i)).getName();
            }
            string2 = string2 + ")";
            stringBuilder.append(cobolFormatter.formatLine(string2));
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector2 = iGUIControl.getControlStyles();
        if (iVariableDeclarationScreen.getValueToken() != null) {
            this.setValue((int)PropertyDescriptorRegistry.parseFloat((String)iVariableDeclarationScreen.getValueToken().getWord()));
        } else if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        }
        if (vector2.contains("FIXED-WIDTH")) {
            this.setFixedWidth(true);
        }
        if (vector2.contains("MULTILINE")) {
            this.setMultiline(true);
        }
        if (vector2.contains("HOT-TRACK")) {
            this.setHotTrack(true);
        }
        if (vector2.contains("BUTTONS")) {
            this.setButtons(true);
        }
        if (vector2.contains("FLAT-BUTTONS")) {
            this.setFlatButtons(true);
        }
        if (vector2.contains("NO-DIVIDERS")) {
            this.setNoDividers(true);
        }
        if (vector2.contains("VERTICAL")) {
            this.setVertical(true);
        }
        if (vector2.contains("BOTTOM")) {
            this.setBottom(true);
        }
        if (vector2.contains("TEXT-NOROTATE")) {
            this.setTextNoRotate(true);
        }
        if (vector2.contains("ALLOW-CONTAINER")) {
            this.setAllowContainer(true);
        }
        if (vector2.contains("RELATIVE-OFFSET")) {
            this.setRelativeOffset(true);
        }
        for (int i = 0; i < iPropElementList.size(); ++i) {
            if (iPropElementList.getKey(i).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(i)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(i).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(i)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(i)[0].getToken().getWord()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(i)[0].getVariableName().getNameIde());
                continue;
            }
            if (!iPropElementList.getKey(i).equals("TAB-TO-ADD")) continue;
            for (n = 0; n < iPropElementList.getValue(i).length; ++n) {
                if (iPropElementList.getValue(i)[n].getToken() != null) {
                    vector.add(iPropElementList.getValue(i)[n].getToken().getWord());
                    continue;
                }
                vector.add(iPropElementList.getValue(i)[n].getVariableName().getNameIde());
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            TabPage tabPage = new TabPage();
            tabPage.setName((String)vector.elementAt(n));
            this.pages.add(tabPage);
        }
    }

    public void loadAndSet(AbstractBeanControl abstractBeanControl, ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc, float f, float f2, GroupBeanControl groupBeanControl, TabPage tabPage) {
        abstractBeanControl.setLine(f);
        abstractBeanControl.setColumn(f2);
        abstractBeanControl.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        if (groupBeanControl != null) {
            groupBeanControl.addComponent(abstractBeanControl);
        } else {
            tabPage.addComponent(abstractBeanControl);
        }
        f = abstractBeanControl.getRealLine();
        f2 = abstractBeanControl.getRealColumn() + abstractBeanControl.getSize();
    }
}

