/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public abstract class AbstractTabbedPane
extends AbstractInputField {
    private static final Comparator<TabPage> tabpageTabOrderComparator = new /* Unavailable Anonymous Inner Class!! */;
    private static final long serialVersionUID = 1L;
    private int bitmapWidth = 16;
    private int value = 1;
    private String valueVar;
    private String valuePicture;
    private String bitmapWidthVar;
    private String cmdTabChangedEv;
    private String cmdTabChangedEx;
    private ImageType image;
    protected Vector<TabPage> pages = new Vector();

    public AbstractTabbedPane(Component component) {
        super(component);
    }

    public abstract TabOrientation getTabOrientation();

    public abstract boolean isAllowContainer();

    public abstract String getBeforeTabchangeDisplay();

    public abstract String getAfterTabchangeDisplay();

    public abstract float getLinePixelsToAdd();

    public abstract float getColPixelsToAdd();

    public abstract float getLineToAdd();

    public abstract float getColToAdd();

    public void setPageAt(int n, TabPage tabPage) {
        if (n >= 0 && n < this.getPageCount()) {
            TabPage tabPage2 = (TabPage)this.pages.elementAt(n);
            tabPage2.setParent(null);
            this.pages.setElementAt(tabPage, n);
            tabPage.setParent((ScreenElement)this);
            this.intSetPageAt(n, tabPage);
            tabPage.setCellSize(this.cellWidth, this.cellHeight);
        } else {
            this.addPage(tabPage);
        }
    }

    public void addPage(TabPage tabPage) {
        this.addPage(-1, tabPage);
    }

    public void addPage(int n, TabPage tabPage) {
        if (n < 0 || n >= this.pages.size()) {
            this.pages.addElement(tabPage);
        } else {
            this.pages.add(n, tabPage);
        }
        tabPage.setCellSize(this.cellWidth, this.cellHeight);
        tabPage.setParent((ScreenElement)this);
        this.intAddPage(n, tabPage);
    }

    public int indexOfPage(TabPage tabPage) {
        return this.pages.indexOf(tabPage);
    }

    protected abstract void intAddPage(int var1, TabPage var2);

    protected abstract void intSetPageAt(int var1, TabPage var2);

    public TabPage getPageAt(int n) {
        if (n < this.getPageCount()) {
            return (TabPage)this.pages.elementAt(n);
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void removePage(TabPage tabPage) {
        int n = this.pages.indexOf(tabPage);
        this.pages.removeElement(tabPage);
        tabPage.setParent(null);
        this.intRemovePage(n, tabPage);
        this.removeTabOrder(tabPage.getTabOrder());
    }

    protected abstract void intRemovePage(int var1, TabPage var2);

    public void removeAllPages() {
        while (this.pages.size() > 0) {
            this.removePage((TabPage)this.pages.elementAt(0));
        }
    }

    public TabPage[] getPages() {
        TabPage[] tabPageArray = new TabPage[this.getPageCount()];
        this.pages.toArray(tabPageArray);
        return tabPageArray;
    }

    public void setPages(TabPage[] tabPageArray) {
        this.removeAllPages();
        for (int i = 0; i < tabPageArray.length; ++i) {
            this.addPage(tabPageArray[i]);
        }
    }

    public void setCellSize(int n, int n2) {
        super.setCellSize(n, n2);
        for (int i = 0; i < this.pages.size(); ++i) {
            ((TabPage)this.pages.elementAt(i)).setCellSize(n, n2);
        }
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public void setBitmap(ImageType imageType) {
        this.image = imageType;
    }

    public ImageType getBitmap() {
        return this.image;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(20.0f);
        this.setLines(10.0f);
    }

    public abstract int indexAtLocation(int var1, int var2);

    public abstract boolean leftScrollAtLocation(int var1, int var2);

    public abstract boolean rightScrollAtLocation(int var1, int var2);

    public abstract void selectPage(int var1);

    public abstract void scrollRight();

    public abstract void scrollLeft();

    public abstract int getButtonsHeight();

    public abstract int getSelectedIndex();

    public void setCmdTabChangedEv(String string) {
        this.cmdTabChangedEv = string;
    }

    public String getCmdTabChangedEv() {
        return this.cmdTabChangedEv;
    }

    public void setCmdTabChangedEx(String string) {
        this.cmdTabChangedEx = string;
    }

    public String getCmdTabChangedEx() {
        return this.cmdTabChangedEx;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    protected void getTabPagesCode(TabPage[] tabPageArray, CobolFormatter cobolFormatter, String string, boolean bl, boolean bl2, StringBuilder stringBuilder) {
        int n;
        String string2;
        String string3;
        int n2 = tabPageArray.length;
        StringBuilder stringBuilder2 = new StringBuilder(string);
        if (n2 == 1) {
            string3 = tabPageArray[0].getTitleVariable();
            if (!bl2 && string3 != null && string3.length() > 0) {
                stringBuilder2.append("tab-to-add ");
                stringBuilder2.append(string3);
            } else {
                string2 = tabPageArray[0].getTitle();
                if (string2 != null) {
                    stringBuilder2.append("tab-to-add ");
                    IscobolBeanConstants.getStringCode((String)string2, (boolean)bl, (StringBuilder)stringBuilder2);
                }
            }
        } else {
            stringBuilder2.append("tab-to-add (");
            for (n = 0; n < n2; ++n) {
                string3 = tabPageArray[n].getTitleVariable();
                if (!bl2 && string3 != null && string3.length() > 0) {
                    stringBuilder2.append(" ");
                    stringBuilder2.append(string3);
                    continue;
                }
                string2 = tabPageArray[n].getTitle();
                if (string2 == null) continue;
                stringBuilder2.append(" ");
                IscobolBeanConstants.getStringCode((String)string2, (boolean)bl, (StringBuilder)stringBuilder2);
            }
            stringBuilder2.append(")");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        stringBuilder2 = new StringBuilder(string);
        if (n2 == 1) {
            stringBuilder2.append("bitmap-number ");
            stringBuilder2.append(tabPageArray[0].getBitmapNumber());
        } else {
            stringBuilder2.append("bitmap-number (");
            for (n = 0; n < n2; ++n) {
                stringBuilder2.append(" ");
                stringBuilder2.append(tabPageArray[n].getBitmapNumber());
            }
            stringBuilder2.append(")");
        }
        stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        for (n = 0; n < n2; ++n) {
            TabPage tabPage = tabPageArray[n];
            if (tabPage.isEnabled()) continue;
            stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("tab-index ");
            stringBuilder2.append(n + 1);
            stringBuilder2.append(" tab-enabled 0");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
    }

    protected String getTabToAddCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        TabPage[] tabPageArray = this.getPages();
        if (tabPageArray.length > 0) {
            Arrays.sort(tabPageArray, tabpageTabOrderComparator);
            String string3 = string2;
            if (string != null) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "modify " + string));
                string3 = string3 + "   ";
            }
            this.getTabPagesCode(tabPageArray, cobolFormatter, string3, bl, bl2, stringBuilder);
            if (this.value > 1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if (string != null) {
                    stringBuilder2.append(string2);
                    stringBuilder2.append("modify ");
                    stringBuilder2.append(string);
                    stringBuilder2.append(" value ");
                } else {
                    stringBuilder2.append(string3);
                    stringBuilder2.append("value ");
                }
                if (this.valueVar != null && this.valueVar.length() > 0) {
                    stringBuilder2.append(this.valueVar);
                } else {
                    stringBuilder2.append(this.value);
                }
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
        return stringBuilder.toString();
    }

    protected String getTabbedPaneScreenSectionCode(CobolFormatter cobolFormatter, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            IscobolBeanConstants.getVariableCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (String)"value", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)0, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.image, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.cmdTabChangedEv, (String)this.cmdTabChangedEx, (String)"cmd-tabchanged", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getName());
        for (int i = 0; i < this.pages.size(); ++i) {
            vector.addAll(((TabPage)this.pages.elementAt(i)).getControlNames());
        }
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addAll(super.getControlIds());
        for (int i = 0; i < this.pages.size(); ++i) {
            vector.addAll(((TabPage)this.pages.elementAt(i)).getControlIds());
        }
        return vector;
    }

    public void updateTabOrders(TabPage tabPage, int n) {
        IscobolBeanConstants.updateTabOrders((TabOrderable[])this.getPages(), (TabOrderable)tabPage, (int)n);
    }

    public void removeTabOrder(int n) {
        IscobolBeanConstants.removeTabOrder((TabOrderable[])this.getPages(), (int)n);
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        TabPage[] tabPageArray = this.getPages();
        for (int i = 0; i < tabPageArray.length; ++i) {
            vector.addAll(tabPageArray[i].getControlExceptionValues());
        }
        return vector;
    }
}

