/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IGUIControl;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPropElementList;
import com.iscobol.interfaces.compiler.IScreenAttribute;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.beans.AbstractTextInputField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.MassUpdate;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.TreeViewItemSetting;
import com.iscobol.screenpainter.beans.types.TreeViewItemSettingList;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.awt.Component;
import java.util.Vector;

public abstract class AbstractTreeView
extends AbstractTextInputField {
    private static final long serialVersionUID = 1L;
    private int action;
    private boolean linesAtRoot;
    private boolean showLines;
    private boolean showSelAlways;
    private MassUpdate massUpdate;
    private boolean buttons;
    private ImageType bitmap;
    private BorderStyle border;
    private String valueVar;
    private String valuePicture;
    private String bitmapWidthVar;
    private String massUpdateVar;
    private String msgTvDblclickEv;
    private String msgTvExpandingEv;
    private String msgTvExpandedEv;
    private String msgTvSelchangingEv;
    private String msgTvSelchangedEv;
    private String msgTvSelchangeOutPrev;
    private String msgTvSelchangeOutNext;
    private String msgBeginEntryEv;
    private String msgFinishEntryEv;
    private String msgCancelEntryEv;
    private int bitmapWidth;
    private int value;
    private TreeViewItemSettingList treeItemSettings = new TreeViewItemSettingList();
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private String borderColorVar;

    public AbstractTreeView(Component component) {
        super(component);
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setSize(12.0f);
        this.setLines(5.0f);
        this.setBorder(new BorderStyle(2));
        this.setMassUpdate(new MassUpdate());
    }

    public boolean mustManageGotoEventOnToolbar() {
        return true;
    }

    public boolean isUserWhite() {
        return true;
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public String getBorderColorVariable() {
        return this.borderColorVar;
    }

    public void setBorderColorVariable(String string) {
        this.borderColorVar = string;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public void setBorder(BorderStyle borderStyle) {
        this.border = borderStyle;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public void setMassUpdate(boolean bl) {
        this.setMassUpdate(new MassUpdate(bl ? 1 : 0));
    }

    public void setMassUpdate(MassUpdate massUpdate) {
        this.massUpdate = massUpdate;
    }

    public MassUpdate isMassUpdate() {
        return this.massUpdate;
    }

    public String getMassUpdateVariable() {
        return this.massUpdateVar;
    }

    public void setMassUpdateVariable(String string) {
        this.massUpdateVar = string;
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public void set3D(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(0));
        }
    }

    public boolean is3D() {
        return this.border.getValue() == 0;
    }

    public void setBoxed(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(1));
        }
    }

    public boolean isBoxed() {
        return this.border.getValue() == 1;
    }

    public void setNoBox(boolean bl) {
        if (bl) {
            this.setBorder(new BorderStyle(2));
        }
    }

    public boolean isNoBox() {
        return this.border.getValue() == 2;
    }

    public boolean isButtons() {
        return this.buttons;
    }

    public void setButtons(boolean bl) {
        this.buttons = bl;
    }

    public boolean isLinesAtRoot() {
        return this.linesAtRoot;
    }

    public void setLinesAtRoot(boolean bl) {
        this.linesAtRoot = bl;
    }

    public boolean isShowLines() {
        return this.showLines;
    }

    public void setShowLines(boolean bl) {
        this.showLines = bl;
    }

    public boolean isShowSelAlways() {
        return this.showSelAlways;
    }

    public void setShowSelAlways(boolean bl) {
        this.showSelAlways = bl;
    }

    public ImageType getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(ImageType imageType) {
        this.bitmap = imageType;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public String getBitmapWidthVariable() {
        return this.bitmapWidthVar;
    }

    public void setBitmapWidthVariable(String string) {
        this.bitmapWidthVar = string;
    }

    public String getMsgTvDblclickEv() {
        return this.msgTvDblclickEv;
    }

    public void setMsgTvDblclickEv(String string) {
        this.msgTvDblclickEv = string;
    }

    public String getMsgTvExpandingEv() {
        return this.msgTvExpandingEv;
    }

    public void setMsgTvExpandingEv(String string) {
        this.msgTvExpandingEv = string;
    }

    public String getMsgTvExpandedEv() {
        return this.msgTvExpandedEv;
    }

    public void setMsgTvExpandedEv(String string) {
        this.msgTvExpandedEv = string;
    }

    public String getMsgTvSelchangingEv() {
        return this.msgTvSelchangingEv;
    }

    public void setMsgTvSelchangingEv(String string) {
        this.msgTvSelchangingEv = string;
    }

    public String getMsgTvSelchangedEv() {
        return this.msgTvSelchangedEv;
    }

    public void setMsgTvSelchangedEv(String string) {
        this.msgTvSelchangedEv = string;
    }

    public String getMsgTvSelchangeOutPrevEv() {
        return this.msgTvSelchangeOutPrev;
    }

    public void setMsgTvSelchangeOutPrevEv(String string) {
        this.msgTvSelchangeOutPrev = string;
    }

    public String getMsgTvSelchangeOutNextEv() {
        return this.msgTvSelchangeOutNext;
    }

    public void setMsgTvSelchangeOutNextEv(String string) {
        this.msgTvSelchangeOutNext = string;
    }

    public String getMsgBeginEntryEv() {
        return this.msgBeginEntryEv;
    }

    public void setMsgBeginEntryEv(String string) {
        this.msgBeginEntryEv = string;
    }

    public String getMsgFinishEntryEv() {
        return this.msgFinishEntryEv;
    }

    public void setMsgFinishEntryEv(String string) {
        this.msgFinishEntryEv = string;
    }

    public String getMsgCancelEntryEv() {
        return this.msgCancelEntryEv;
    }

    public void setMsgCancelEntryEv(String string) {
        this.msgCancelEntryEv = string;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public TreeViewItemSettingList getTreeItemSettings() {
        return this.treeItemSettings;
    }

    public void setTreeItemSettings(TreeViewItemSettingList treeViewItemSettingList) {
        this.treeItemSettings = treeViewItemSettingList;
    }

    public String getProcedureDivisionCode(CobolFormatter cobolFormatter, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder(super.getProcedureDivisionCode(cobolFormatter, string, string2, bl, bl2));
        String string4 = string3 = string != null ? string : this.getName();
        if (this.treeItemSettings.getSettingCount() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "modify " + string3));
            this.getProcedureDivisionCode(cobolFormatter, this.treeItemSettings.getSettings(), "null", string2, stringBuilder, bl, bl2);
            stringBuilder.append(cobolFormatter.formatLine(string2 + "."));
        }
        return stringBuilder.toString();
    }

    private void getProcedureDivisionCode(CobolFormatter cobolFormatter, SettingItem[] settingItemArray, String string, String string2, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        for (int i = 0; i < settingItemArray.length; ++i) {
            TreeViewItemSetting treeViewItemSetting = (TreeViewItemSetting)settingItemArray[i];
            stringBuilder.append(cobolFormatter.formatLine(string2 + "   parent = " + string));
            IscobolBeanConstants.getStringCode((CobolFormatter)cobolFormatter, (String)treeViewItemSetting.getText(), (String)"item-to-add", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)true);
            String string3 = treeViewItemSetting.getIdentifierHandle();
            if (string3 != null && string3.length() > 0) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "   giving " + string3));
            }
            if (treeViewItemSetting.getHasChildren()) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "   has-children 1"));
            }
            IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)treeViewItemSetting.getBitmapNumber(), (int)0, (String)"   bitmap-number", (String)string2, (StringBuilder)stringBuilder);
            IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)treeViewItemSetting.getHiddenDataVariable(), (String)treeViewItemSetting.getHiddenData(), (String)"hidden-data", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)bl2);
            IscobolBeanConstants.getVariableStringCode((CobolFormatter)cobolFormatter, (String)treeViewItemSetting.getHintVariable(), (String)treeViewItemSetting.getHint(), (String)"item-hint", (String)(string2 + "   "), (StringBuilder)stringBuilder, (boolean)bl, (boolean)bl2);
            if (treeViewItemSetting.getExpand()) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "   expand = tvflag-expand"));
            }
            if (string3 == null || string3.length() <= 0) continue;
            if (treeViewItemSetting.getEnsureVisible()) {
                stringBuilder.append(cobolFormatter.formatLine(string2 + "   ensure-visible = " + string3));
            }
            if (treeViewItemSetting.getChildCount() <= 0) continue;
            this.getProcedureDivisionCode(cobolFormatter, (SettingItem[])treeViewItemSetting.getChildren(), string3, string2, stringBuilder, bl, bl2);
        }
    }

    public String getScreenSectionCode(CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(super.getScreenSectionCode(cobolFormatter, n, bl, bl2, bl3));
        String string = IscobolBeanConstants.getSpaces((int)n);
        if (!IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.is3D(), (String)"3-d", (String)string, (StringBuilder)stringBuilder) && !IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isBoxed(), (String)"boxed", (String)string, (StringBuilder)stringBuilder)) {
            IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.isNoBox(), (String)"no-box", (String)string, (StringBuilder)stringBuilder);
        }
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.buttons, (String)"buttons", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.linesAtRoot, (String)"lines-at-root", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.showLines, (String)"show-lines", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBooleanCode((CobolFormatter)cobolFormatter, (boolean)this.showSelAlways, (String)"show-sel-always", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getBitmapCode((CobolFormatter)cobolFormatter, (ImageType)this.bitmap, (String)"bitmap-handle", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getNumericCode((CobolFormatter)cobolFormatter, (int)this.action, (int)0, (String)"action", (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.massUpdateVar, (int)this.massUpdate.getValue(), (int)0, (String)"mass-update", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.valueVar, (int)this.value, (int)0, (String)"value", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableNumericCode((CobolFormatter)cobolFormatter, (String)this.bitmapWidthVar, (int)this.bitmapWidth, (int)0, (String)"bitmap-width", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        IscobolBeanConstants.getVariableColorCode((CobolFormatter)cobolFormatter, (String)this.borderColorVar, (ColorType)this.borderColor, (int)0, (String)"border-color", (String)string, (StringBuilder)stringBuilder, (boolean)bl3);
        if (this.allComponentInScreen) {
            this.getOtherScreenSectionCode(stringBuilder, cobolFormatter, n, bl, bl2, bl3);
        }
        if (!this.isCellEditor()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "."));
        }
        return stringBuilder.toString();
    }

    public String getParagraphCode(CobolFormatter cobolFormatter, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder(super.getParagraphCode(cobolFormatter, bl, string));
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvDblclickEv, null, (String)"msg-tv-dblclick", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvExpandingEv, null, (String)"msg-tv-expanding", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvExpandedEv, null, (String)"msg-tv-expanded", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvSelchangingEv, null, (String)"msg-tv-selchanging", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvSelchangedEv, null, (String)"msg-tv-selchange", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvSelchangeOutPrev, null, (String)"msg-tv-selchange-out-prev", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgTvSelchangeOutNext, null, (String)"msg-tv-selchange-out-next", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgBeginEntryEv, null, (String)"msg-begin-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgFinishEntryEv, null, (String)"msg-finish-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        IscobolBeanConstants.getEventCode((CobolFormatter)cobolFormatter, (String)this.msgCancelEntryEv, null, (String)"msg-cancel-entry", (boolean)bl, (String)string, (StringBuilder)stringBuilder);
        return stringBuilder.toString();
    }

    public void loadFromCbl(ICompiler iCompiler, IVariableDeclarationScreen iVariableDeclarationScreen, IPcc iPcc) {
        int n;
        super.loadFromCbl(iCompiler, iVariableDeclarationScreen, iPcc);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        IGUIControl iGUIControl = iVariableDeclarationScreen.getGuiControl();
        IScreenAttribute iScreenAttribute = iGUIControl.getSa();
        IPropElementList iPropElementList = iGUIControl.getControlProperties();
        Vector vector4 = iGUIControl.getControlStyles();
        if (iVariableDeclarationScreen.getValueToken() != null) {
            this.setValue((int)PropertyDescriptorRegistry.parseFloat((String)iVariableDeclarationScreen.getValueToken().getWord()));
        } else if (iScreenAttribute.getVUsing() != null) {
            this.setValueVariable(iScreenAttribute.getVUsing().getNameIde());
        }
        this.setBorder(new BorderStyle(3));
        if (vector4.contains("BOXED")) {
            this.setBorder(new BorderStyle(1));
        } else if (vector4.contains("3-D")) {
            this.setBorder(new BorderStyle(0));
        } else if (vector4.contains("NO-BOX")) {
            this.setBorder(new BorderStyle(2));
        }
        if (vector4.contains("LINES-AT-ROOT")) {
            this.setLinesAtRoot(true);
        }
        if (vector4.contains("SHOW-LINES")) {
            this.setShowLines(true);
        }
        if (vector4.contains("SHOW-SEL-ALWAYS")) {
            this.setShowSelAlways(true);
        }
        if (vector4.contains("BUTTONS")) {
            this.setButtons(true);
        }
        for (n = 0; n < iPropElementList.size(); ++n) {
            int n2;
            if (iPropElementList.getKey(n).equals("BITMAP-HANDLE")) {
                this.setBitmap(new ImageType("", iPropElementList.getValue(n)[0].getVariableName().getNameIde()));
                continue;
            }
            if (iPropElementList.getKey(n).equals("BITMAP-WIDTH")) {
                if (iPropElementList.getValue(n)[0].getToken() != null) {
                    this.setBitmapWidth((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                    continue;
                }
                this.setBitmapWidthVariable(iPropElementList.getValue(n)[0].getVariableName().getNameIde());
                continue;
            }
            if (iPropElementList.getKey(n).equals("ACTION")) {
                this.setAction((int)PropertyDescriptorRegistry.parseFloat((String)iPropElementList.getValue(n)[0].getToken().getWord()));
                continue;
            }
            if (iPropElementList.getKey(n).equals("ITEM-TO-ADD")) {
                for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                    vector.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                }
                continue;
            }
            if (iPropElementList.getKey(n).equals("ITEM-HINT")) {
                for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                    if (iPropElementList.getValue(n)[n2].getToken() != null) {
                        vector2.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                        continue;
                    }
                    vector2.add(iPropElementList.getValue(n)[n2].getVariableName().getNameIde());
                }
                continue;
            }
            if (!iPropElementList.getKey(n).equals("HIDDEN-DATA")) continue;
            for (n2 = 0; n2 < iPropElementList.getValue(n).length; ++n2) {
                if (iPropElementList.getValue(n)[n2].getToken() != null) {
                    vector3.add(iPropElementList.getValue(n)[n2].getToken().getWord());
                    continue;
                }
                vector3.add(iPropElementList.getValue(n)[n2].getVariableName().getNameIde());
            }
        }
        n = vector3.size();
        if (n < vector2.size()) {
            n = vector2.size();
        }
        if (n < vector2.size()) {
            n = vector.size();
        }
        if (n > 0) {
            TreeViewItemSettingList treeViewItemSettingList = new TreeViewItemSettingList();
            for (int i = 0; n > 0 && i <= n; ++i) {
                TreeViewItemSetting treeViewItemSetting = new TreeViewItemSetting();
                if (vector3.size() >= n) {
                    if (((String)vector3.get(i)).substring(0, 1).equals("\"")) {
                        treeViewItemSetting.setHiddenData((String)vector3.get(i));
                    } else {
                        treeViewItemSetting.setHiddenDataVariable((String)vector3.get(i));
                    }
                }
                if (vector2.size() >= n) {
                    if (((String)vector2.get(i)).substring(0, 1).equals("\"")) {
                        treeViewItemSetting.setHint((String)vector2.get(i));
                    } else {
                        treeViewItemSetting.setHintVariable((String)vector2.get(i));
                    }
                }
                if (vector.size() >= n) {
                    if (((String)vector.get(i)).substring(0, 1).equals("\"")) {
                        treeViewItemSetting.setText((String)vector.get(i));
                    } else {
                        treeViewItemSetting.setTextVariable((String)vector.get(i));
                    }
                }
                treeViewItemSettingList.addSetting((SettingItem)treeViewItemSetting);
            }
            this.treeItemSettings = treeViewItemSettingList;
        }
    }

    public void getOtherScreenSectionCode(StringBuilder stringBuilder, CobolFormatter cobolFormatter, int n, boolean bl, boolean bl2, boolean bl3) {
        String string = IscobolBeanConstants.getSpaces((int)n);
        int n2 = this.treeItemSettings.getSettingCount();
        if (n2 > 0) {
            StringBuilder stringBuilder2;
            TreeViewItemSetting treeViewItemSetting;
            int n3;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            stringBuilder.append(cobolFormatter.formatLine(string));
            for (n3 = 0; n3 < n2; ++n3) {
                treeViewItemSetting = (TreeViewItemSetting)this.treeItemSettings.getSettingAt(n3);
                if (treeViewItemSetting.getHint() == null || treeViewItemSetting.getHintVariable() != null) {
                    bl5 = true;
                }
                if (treeViewItemSetting.getText() != null || treeViewItemSetting.getTextVariable() != null) {
                    bl6 = true;
                }
                if (treeViewItemSetting.getHiddenData() == null && treeViewItemSetting.getHiddenDataVariable() == null) continue;
                bl4 = true;
            }
            if (bl6) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   item-to-add (");
                for (n3 = 0; n3 < n2; ++n3) {
                    treeViewItemSetting = (TreeViewItemSetting)this.treeItemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    if (treeViewItemSetting.getText() != null) {
                        stringBuilder2.append(treeViewItemSetting.getText());
                        continue;
                    }
                    stringBuilder2.append(treeViewItemSetting.getTextVariable());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl5) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   item-hint (");
                for (n3 = 0; n3 < n2; ++n3) {
                    treeViewItemSetting = (TreeViewItemSetting)this.treeItemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    if (treeViewItemSetting.getText() != null) {
                        stringBuilder2.append(treeViewItemSetting.getHint());
                        continue;
                    }
                    stringBuilder2.append(treeViewItemSetting.getHintVariable());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
            if (bl4) {
                stringBuilder2 = new StringBuilder(string);
                stringBuilder2.append("   hidden-data (");
                for (n3 = 0; n3 < n2; ++n3) {
                    treeViewItemSetting = (TreeViewItemSetting)this.treeItemSettings.getSettingAt(n3);
                    stringBuilder2.append(" ");
                    if (treeViewItemSetting.getText() != null) {
                        stringBuilder2.append(treeViewItemSetting.getHiddenData());
                        continue;
                    }
                    stringBuilder2.append(treeViewItemSetting.getHiddenDataVariable());
                }
                stringBuilder2.append(")");
                stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
            }
        }
    }
}

