/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.LayoutManager;
import com.iscobol.screenpainter.beans.types.LayoutType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Vector;

public abstract class BaseWindow
implements Serializable,
ScreenElement,
ResourcesProvider,
ComponentsContainer {
    private static final long serialVersionUID = 1L;
    private boolean lock;
    private String name;
    protected Vector<AbstractBeanControl> components = new Vector();
    protected ColorPalette palette;
    private String customData;
    private String customDataVar;
    protected boolean cell = true;
    protected int cellHeight = 10;
    protected int cellWidth;
    protected int origCellWidth = this.cellWidth = 10;
    protected int origCellHeight = this.cellHeight;
    protected String cellHeightVar;
    protected String cellWidthVar;
    private LayoutManager layoutManager = new LayoutManager();

    public int indexOfComponent(AbstractBeanControl abstractBeanControl) {
        return this.components.indexOf(abstractBeanControl);
    }

    public void setComponentAt(int n, AbstractBeanControl abstractBeanControl) {
        if (n < this.getComponentCount()) {
            AbstractBeanControl abstractBeanControl2 = (AbstractBeanControl)this.components.elementAt(n);
            abstractBeanControl2.setParent(null);
            this.components.setElementAt(abstractBeanControl, n);
            abstractBeanControl.setParent((ScreenElement)this);
        }
    }

    public AbstractBeanControl getComponentAt(int n) {
        if (n < this.getComponentCount()) {
            return (AbstractBeanControl)this.components.elementAt(n);
        }
        return null;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void addComponent(AbstractBeanControl abstractBeanControl) {
        this.addComponent(-1, abstractBeanControl);
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        ComponentsContainer componentsContainer = (ComponentsContainer)abstractBeanControl.getParent();
        if (componentsContainer != null) {
            componentsContainer.removeComponent(abstractBeanControl);
        }
        if (n < 0 || n >= this.components.size()) {
            this.components.addElement(abstractBeanControl);
        } else {
            this.components.add(n, abstractBeanControl);
        }
        abstractBeanControl.setParent((ScreenElement)this);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl) {
        this.removeComponent(abstractBeanControl, true);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl, boolean bl) {
        this.components.removeElement(abstractBeanControl);
        abstractBeanControl.setParent(null);
        if (bl) {
            this.removeTabOrder(abstractBeanControl.getTabOrder());
        }
    }

    public void removeAllComponents() {
        while (this.components.size() > 0) {
            this.removeComponent((AbstractBeanControl)this.components.elementAt(0), false);
        }
    }

    public AbstractBeanControl[] getComponents() {
        AbstractBeanControl[] abstractBeanControlArray = new AbstractBeanControl[this.getComponentCount()];
        this.components.toArray(abstractBeanControlArray);
        return abstractBeanControlArray;
    }

    public void setComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.removeAllComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.addComponent(abstractBeanControlArray[i]);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setColor(ColorType var1);

    public abstract ColorType getColor();

    public abstract void setFont(FontType var1);

    public abstract FontType getFont();

    public void updateTabOrders(AbstractBeanControl abstractBeanControl, int n) {
        IscobolBeanConstants.updateTabOrders((AbstractBeanControl[])this.getComponents(), (TabOrderable)abstractBeanControl, (int)n);
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getName());
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlNames());
        }
        return vector;
    }

    public Color getDefaultAwtBackgroundColor() {
        return ColorType.STANDARD_COLOR.getBackgroundColor(this.palette);
    }

    public Color getDefaultAwtForegroundColor() {
        return ColorType.STANDARD_COLOR.getForegroundColor(this.palette);
    }

    public Vector<Integer> getControlIds() {
        Vector<Integer> vector = new Vector<Integer>();
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlIds());
        }
        return vector;
    }

    public void removeTabOrder(int n) {
        IscobolBeanConstants.removeTabOrder((AbstractBeanControl[])this.getComponents(), (int)n);
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    public Color getAwtBackgroundColor() {
        return this.getAwtBackgroundColor(this.getDefaultAwtBackgroundColor());
    }

    public Color getAwtForegroundColor() {
        return this.getAwtForegroundColor(this.getDefaultAwtForegroundColor());
    }

    public abstract Color getAwtForegroundColor(Color var1);

    public abstract Color getAwtBackgroundColor(Color var1);

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }

    public String getCustomData() {
        return this.customData;
    }

    public void setCustomData(String string) {
        this.customData = string;
    }

    public String getCustomDataVariable() {
        return this.customDataVar;
    }

    public void setCustomDataVariable(String string) {
        this.customDataVar = string;
    }

    public final boolean isCell() {
        return this.cell;
    }

    public final int getCellHeight() {
        return this.origCellHeight;
    }

    public final int getRealCellHeight() {
        return this.cellHeight;
    }

    public final int getCellWidth() {
        return this.origCellWidth;
    }

    public final int getRealCellWidth() {
        return this.cellWidth;
    }

    public String getCellHeightVariable() {
        return this.cellHeightVar;
    }

    public String getCellWidthVariable() {
        return this.cellWidthVar;
    }

    public void setCell(boolean bl) {
        this.cell = bl;
    }

    public void setCellHeight(int n) {
        this.cellHeight = n;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public void setCellHeightVariable(String string) {
        this.cellHeightVar = string;
    }

    public void setCellWidthVariable(String string) {
        this.cellWidthVar = string;
    }

    public abstract void updateCellSize();

    protected abstract Component getMeasuringComponent();

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(LayoutType layoutType) {
        this.layoutManager = new LayoutManager(layoutType.getValue(), null);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }
}

