/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans;

import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.BaseWindow;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.util.ColorPalette;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class TabPage
implements Serializable,
ScreenElement,
ResourcesProvider,
ComponentsContainer,
TabOrderable {
    private static final long serialVersionUID = 2243L;
    private String title;
    private String titleVar;
    private String visibleVar;
    private String name;
    private int bitmapNumber;
    private boolean enabled;
    private int cellWidth;
    private int cellHeight;
    private int tabOrder;
    private ScreenElement parent;
    private Vector<AbstractBeanControl> components = new Vector();
    private ColorPalette palette;
    private PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);

    public TabPage() {
        this("");
    }

    public TabPage(String string) {
        this(string, null, 0, true, null);
    }

    public TabPage(String string, String string2, int n, boolean bl, String string3) {
        this.title = string;
        this.bitmapNumber = n;
        this.enabled = bl;
        this.visibleVar = string3;
    }

    public void setComponentAt(int n, AbstractBeanControl abstractBeanControl) {
        if (n < this.getComponentCount()) {
            AbstractBeanControl abstractBeanControl2 = (AbstractBeanControl)this.components.elementAt(n);
            abstractBeanControl2.setParent(null);
            this.components.setElementAt(abstractBeanControl, n);
            abstractBeanControl.setParent((ScreenElement)this);
        }
    }

    public int indexOfComponent(AbstractBeanControl abstractBeanControl) {
        return this.components.indexOf(abstractBeanControl);
    }

    public AbstractBeanControl getComponentAt(int n) {
        if (n < this.getComponentCount()) {
            return (AbstractBeanControl)this.components.elementAt(n);
        }
        return null;
    }

    public void setCellSize(int n, int n2) {
        this.cellWidth = n;
        this.cellHeight = n2;
        for (int i = 0; i < this.components.size(); ++i) {
            ((AbstractBeanControl)this.components.elementAt(i)).setCellSize(n, n2);
        }
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void addComponent(AbstractBeanControl abstractBeanControl) {
        this.addComponent(-1, abstractBeanControl);
    }

    public void addComponent(int n, AbstractBeanControl abstractBeanControl) {
        ComponentsContainer componentsContainer = (ComponentsContainer)abstractBeanControl.getParent();
        if (componentsContainer != null) {
            componentsContainer.removeComponent(abstractBeanControl);
        }
        if (n < 0 || n >= this.components.size()) {
            this.components.addElement(abstractBeanControl);
        } else {
            this.components.add(n, abstractBeanControl);
        }
        abstractBeanControl.setParent((ScreenElement)this);
        abstractBeanControl.setCellSize(this.cellWidth, this.cellHeight);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl) {
        this.removeComponent(abstractBeanControl, true);
    }

    public void removeComponent(AbstractBeanControl abstractBeanControl, boolean bl) {
        this.components.removeElement(abstractBeanControl);
        abstractBeanControl.setParent(null);
        if (bl) {
            this.removeTabOrder(abstractBeanControl.getTabOrder());
        }
    }

    public void removeAllComponents() {
        while (this.components.size() > 0) {
            this.removeComponent((AbstractBeanControl)this.components.elementAt(0), false);
        }
    }

    public AbstractBeanControl[] getComponents() {
        AbstractBeanControl[] abstractBeanControlArray = new AbstractBeanControl[this.getComponentCount()];
        this.components.toArray(abstractBeanControlArray);
        return abstractBeanControlArray;
    }

    public void setComponents(AbstractBeanControl[] abstractBeanControlArray) {
        this.removeAllComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.addComponent(abstractBeanControlArray[i]);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.firePropertyChange("title", null, (Object)this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setVisibleVariable(String string) {
        this.visibleVar = string;
    }

    public String getTitleVariable() {
        return this.titleVar;
    }

    public void setTitleVariable(String string) {
        this.titleVar = string;
    }

    public String getVisibleVariable() {
        return this.visibleVar;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.firePropertyChange("enabled", null, (Object)new Boolean(bl));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
        this.firePropertyChange("bitmapNumber", null, (Object)new Integer(n));
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setTabOrder(int n) {
        this.setTabOrder(n, true);
    }

    public void setTabOrder(int n, boolean bl) {
        int n2 = this.tabOrder;
        this.tabOrder = n;
        if (this.parent != null && bl) {
            ((AbstractTabbedPane)this.parent).updateTabOrders(this, n2);
        }
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcsDelegate.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException();
        }
        this.pcsDelegate.addPropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.pcsDelegate.hasListeners(string)) {
            this.pcsDelegate.firePropertyChange(string, object, object2);
        }
    }

    public ScreenElement getParent() {
        return this.parent;
    }

    public AbstractBeanWindow getParentWindow() {
        if (this.parent != null) {
            return this.parent.getParentWindow();
        }
        return null;
    }

    public BaseWindow getBaseParentWindow() {
        if (this.parent != null) {
            return this.parent.getBaseParentWindow();
        }
        return null;
    }

    public void setParent(ScreenElement screenElement) {
        this.parent = screenElement;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Vector<String> getControlNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        for (int i = 0; i < this.components.size(); ++i) {
            vector.addAll(((AbstractBeanControl)this.components.elementAt(i)).getControlNames());
        }
        return vector;
    }

    public Vector<Integer> getControlIds() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.components.size(); ++i) {
            vector.addAll(((AbstractBeanControl)this.components.elementAt(i)).getControlIds());
        }
        return vector;
    }

    public void updateTabOrders(AbstractBeanControl abstractBeanControl, int n) {
        IscobolBeanConstants.updateTabOrders((AbstractBeanControl[])this.getComponents(), (TabOrderable)abstractBeanControl, (int)n);
    }

    public void removeTabOrder(int n) {
        IscobolBeanConstants.removeTabOrder((AbstractBeanControl[])this.getComponents(), (int)n);
    }

    public int getType() {
        return 302;
    }

    public int getLevel() {
        AbstractTabbedPane abstractTabbedPane = (AbstractTabbedPane)this.getParent();
        return abstractTabbedPane != null ? abstractTabbedPane.getLevel() : 0;
    }

    public void setLevel(int n) {
    }

    public Vector<Integer> getControlExceptionValues() {
        Vector<Integer> vector = new Vector<Integer>();
        AbstractBeanControl[] abstractBeanControlArray = this.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            vector.addAll(abstractBeanControlArray[i].getControlExceptionValues());
        }
        return vector;
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }
}

