/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractAccordion;
import com.iscobol.screenpainter.beans.AccordionPage;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.swing.SwingAccordion;
import com.iscobol.screenpainter.beans.types.HAlignment;
import com.iscobol.screenpainter.beans.types.ImageType;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;

public class SwingAccordion
extends AbstractAccordion
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Accordion accordion;

    public SwingAccordion() {
        super((Component)new Accordion());
    }

    protected void initializeComponent() {
        this.accordion = (Accordion)this.getComponent();
        super.initializeComponent();
    }

    protected void intAddPage(int n, TabPage tabPage) {
        tabPage.addPropertyChangeListener((PropertyChangeListener)this);
        ImageIcon imageIcon = null;
        if (this.getBitmap() != null) {
            imageIcon = IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1);
        }
        this.accordion.addPage(tabPage.getTitle(), imageIcon, tabPage.isEnabled(), this.getAlign(((AccordionPage)tabPage).getAlignment()), n);
    }

    protected void intSetPageAt(int n, TabPage tabPage) {
        this.accordion.setPageTitle(tabPage.getTitle(), n);
        this.accordion.setPageEnabled(tabPage.isEnabled(), n);
        this.accordion.setPageAlign(this.getAlign(((AccordionPage)tabPage).getAlignment()), n);
        if (this.getBitmap() != null) {
            this.accordion.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1), n);
        }
    }

    protected void intRemovePage(int n, TabPage tabPage) {
        if (n >= 0) {
            this.accordion.removePage(n);
        }
        tabPage.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public int indexAtLocation(int n, int n2) {
        return this.accordion.indexAtLocation(n, n2);
    }

    public boolean leftScrollAtLocation(int n, int n2) {
        return false;
    }

    public boolean rightScrollAtLocation(int n, int n2) {
        return false;
    }

    public void selectPage(int n) {
        this.accordion.selectPage(n);
    }

    public void scrollRight() {
    }

    public void scrollLeft() {
    }

    public int getButtonsHeight() {
        return 25;
    }

    public int getSelectedIndex() {
        return this.accordion.getSelectedIndex();
    }

    public int getType() {
        return 14;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        if (propertyChangeEvent.getPropertyName().equals("title")) {
            int n2 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n2 >= 0) {
                this.accordion.setPageTitle((String)propertyChangeEvent.getNewValue(), n2);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            int n3 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n3 >= 0) {
                this.accordion.setPageEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue(), n3);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("bitmapNumber")) {
            int n4 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n4 >= 0 && this.getBitmap() != null) {
                this.accordion.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)((Integer)propertyChangeEvent.getNewValue()), (int)this.getBitmapWidth(), (int)-1), n4);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("alignment") && (n = this.pages.indexOf(propertyChangeEvent.getSource())) >= 0) {
            this.accordion.setPageAlign(this.getAlign((HAlignment)propertyChangeEvent.getNewValue()), n);
        }
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.refreshBitmaps(imageType);
    }

    void refreshBitmaps(ImageType imageType) {
        if (this.pages == null) {
            return;
        }
        int n = this.getPageCount();
        for (int i = 0; i < n; ++i) {
            TabPage tabPage = (TabPage)this.pages.elementAt(i);
            ImageIcon imageIcon = imageType != null && imageType.getImage() != null && tabPage.getBitmapNumber() > 0 ? IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1) : null;
            this.accordion.setPageIcon(imageIcon, i);
        }
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.refreshBitmaps(this.getBitmap());
    }

    private int getAlign(HAlignment hAlignment) {
        switch (hAlignment.getValue()) {
            default: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 3: 
        }
        return 4;
    }
}

