/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractBitmap;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingBitmap;
import com.iscobol.screenpainter.beans.types.BitmapScale;
import com.iscobol.screenpainter.beans.types.ImageType;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SwingBitmap
extends AbstractBitmap {
    private static final long serialVersionUID = 1L;
    private MyBitmap bitmap;

    public SwingBitmap() {
        super((Component)new MyBitmap());
    }

    protected void setComponent(Component component) {
        super.setComponent(component);
        this.bitmap = (MyBitmap)component;
    }

    protected void initializeComponent() {
        super.initializeComponent();
        this.setBitmapNumber(1);
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.intSetBitmap(imageType);
    }

    private void intSetBitmap(ImageType imageType) {
        if (imageType != null && imageType.getImage() != null) {
            Image image = imageType.getImage();
            int n = this.getBitmapScale().getValue();
            if (n > 0 && image != null) {
                image = IscobolBeanConstants.getFitImage((double)this.getSizePixels(), (double)this.getLinesPixels(), (n == 2 ? 1 : 0) != 0, (Image)image);
            }
            this.setImage(image, (int)this.getSizePixels(), (int)this.getLinesPixels(), this.getBitmapNumber(), this.getTransparentColor());
        } else {
            this.setImage(null, -1, -1, 0, -1);
        }
    }

    private void setImage(Image image, int n, int n2, int n3, int n4) {
        this.bitmap.setText(null);
        if (n4 >= 0) {
            image = IscobolBeanConstants.makeColorTransparent((Image)image, (int)n4);
        }
        this.bitmap.setIcon(this.getIcon(image, n, n2, n3));
    }

    private Icon getIcon(Image image, int n, int n2, int n3) {
        if (n3 > 0) {
            Image image2 = IscobolBeanConstants.getImage((int)n, (int)n2, (Image)image, (int)n3);
            if (image2 != null) {
                return new ImageIcon(image2);
            }
            return null;
        }
        return null;
    }

    public void setBitmapNumber(int n) {
        super.setBitmapNumber(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setBitmapScale(BitmapScale bitmapScale) {
        super.setBitmapScale(bitmapScale);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setTransparentColor(int n) {
        super.setTransparentColor(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setLines(float f) {
        super.setLines(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setLinesPixels(int n) {
        super.setLinesPixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setSize(float f) {
        super.setSize(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }

    public void setSizePixels(int n) {
        super.setSizePixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap());
        }
    }
}

