/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractCheckBox;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingCheckBox;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.LeftTextAlignment;
import com.iscobol.screenpainter.beans.types.Position;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;

public class SwingCheckBox
extends AbstractCheckBox {
    private static final long serialVersionUID = 1L;
    private MyCheckBox checkbox;

    public SwingCheckBox() {
        super((Component)new MyCheckBox());
    }

    protected void initializeComponent() {
        this.checkbox = (MyCheckBox)this.getComponent();
        this.checkbox.setText("");
        this.checkbox.setMargin(new Insets(0, 0, 0, 0));
        super.initializeComponent();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.intSetTitle(string);
    }

    public void setHint(String string) {
        super.setHint(string);
        this.checkbox.setToolTipText(string);
    }

    public void setMultiline(boolean bl) {
        super.setMultiline(bl);
        this.intSetMultiline(bl);
    }

    public void setTitlePosition(Position position) {
        super.setTitlePosition(position);
        this.intSetTitlePosition(position.getValue());
        this.intSetTitle(this.getTitle());
    }

    public void setBitmapSelected(int n) {
        super.setBitmapSelected(n);
        this.checkbox.setBitmapSelected(n);
    }

    public void setFlat(boolean bl) {
        super.setFlat(bl);
        this.intSetFlat(bl);
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.intSetBitmap(imageType != null ? imageType.getImage() : null);
    }

    public void setBitmapNumber(int n) {
        super.setBitmapNumber(n);
        this.intSetBitmap(this.getBitmap() != null ? this.getBitmap().getImage() : null);
        this.intSetBitmapNumber(n);
    }

    public void setBitmapDisabled(int n) {
        super.setBitmapDisabled(n);
        this.intSetBitmapDisabled(n);
    }

    public void setBitmapDisabledSelected(int n) {
        super.setBitmapDisabledSelected(n);
        this.intSetBitmapDisabledSelected(n);
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.intSetBitmapWidth(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLeftText(boolean bl) {
        super.setLeftText(bl);
        this.checkbox.setLeftText(bl);
    }

    public void setVTop(boolean bl) {
        super.setVTop(bl);
        this.checkbox.setVTop(bl);
    }

    public void setTransparent(boolean bl) {
        super.setTransparent(bl);
        this.checkbox.setOpaque(!bl);
    }

    void intSetBitmap(Image image) {
        if (this.isAutoFit() && image != null) {
            image = IscobolBeanConstants.getFitImage((double)this.getSizePixels(), (double)this.getLinesPixels(), (Image)image);
        }
        int n = (int)this.getLinesPixels();
        if (!this.isLinesUnitPixel()) {
            n += 8;
        }
        this.checkbox.setImage(image, (int)this.getSizePixels(), n);
        this.checkbox.setTitlePosition(this.getTitlePosition().getValue());
        this.checkbox.setFlat(this.isFlat());
    }

    public void setAutoFit(boolean bl) {
        super.setAutoFit(bl);
        this.checkbox.setAutoFit(bl);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    void intSetBitmapDisabled(int n) {
        this.checkbox.setBitmapDisabled(n);
    }

    void intSetBitmapDisabledSelected(int n) {
        this.checkbox.setBitmapDisabledSelected(n);
    }

    void intSetBitmapNumber(int n) {
        this.checkbox.setBitmapNumber(n);
    }

    void intSetBitmapWidth(int n) {
        this.checkbox.setBitmapWidth(n);
    }

    void intSetFlat(boolean bl) {
        this.checkbox.setFlat(bl);
    }

    void intSetMultiline(boolean bl) {
        this.checkbox.setMultiline(bl);
    }

    void intSetTitle(String string) {
        this.checkbox.setTitle(string);
    }

    void intSetTitlePosition(int n) {
        this.checkbox.setTitlePosition(n);
    }

    public void setValue(int n) {
        super.setValue(n);
        this.checkbox.setSelected(n != 0);
    }

    public int getType() {
        return 104;
    }

    public void setLines(float f) {
        super.setLines(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLinesPixels(int n) {
        super.setLinesPixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSize(float f) {
        super.setSize(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSizePixels(int n) {
        super.setSizePixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLeftTextAlignment(LeftTextAlignment leftTextAlignment) {
        super.setLeftTextAlignment(leftTextAlignment);
        this.checkbox.setLeftTextAlignment(leftTextAlignment.getValue());
    }
}

