/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractCheckListBox;
import com.iscobol.screenpainter.beans.swing.SwingCheckListBox;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.CheckListSelectionMode;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ItemToAddSetting;
import com.iscobol.screenpainter.beans.types.ItemToAddSettingList;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;

public class SwingCheckListBox
extends AbstractCheckListBox {
    private MyCheckList checkList;
    private static final long serialVersionUID = 1L;

    public SwingCheckListBox() {
        super((Component)new MyCheckList());
    }

    protected void initializeComponent() {
        this.checkList = (MyCheckList)this.getComponent();
        super.initializeComponent();
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setItemToAdd(this.getItemToAdd());
    }

    public int getType() {
        return 120;
    }

    public void setItemToAdd(ItemToAddSettingList itemToAddSettingList) {
        super.setItemToAdd(itemToAddSettingList);
        String[] stringArray = new String[itemToAddSettingList.getSettingCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((ItemToAddSetting)itemToAddSettingList.getSettingAt(i)).getData();
        }
        this.checkList.setItems(stringArray);
    }

    public void setSelectionMode(CheckListSelectionMode checkListSelectionMode) {
        super.setSelectionMode(checkListSelectionMode);
        this.checkList.setMultiSelection(checkListSelectionMode.getValue() != 0);
    }

    public void setSelectionIndex(int n) {
        super.setSelectionIndex(n);
        this.checkList.setSelectionIndex(n - 1);
    }

    public void setBorder(BorderStyle borderStyle) {
        super.setBorder(borderStyle);
        switch (borderStyle.getValue()) {
            default: {
                this.setLineBorder();
                break;
            }
            case 0: {
                this.checkList.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 2: {
                this.checkList.setBorder(null);
            }
        }
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        super.setBorderColor(foregroundColorType);
        int n = this.getBorder().getValue();
        if (n == 1 || n == 3) {
            this.setLineBorder();
        }
    }

    private void setLineBorder() {
        Color color = null;
        if (this.getBorderColor() != null) {
            color = this.getBorderColor().getForegroundColor(this.getPalette());
        }
        this.checkList.setBorder(BorderFactory.createLineBorder(color != null ? color : Color.black));
    }
}

