/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractEntryField;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingEntryField;
import com.iscobol.screenpainter.beans.types.BooleanChoice;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.EntryFieldStyle;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.HAlignment;
import com.iscobol.screenpainter.beans.types.ImageType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.Icon;

public class SwingEntryField
extends AbstractEntryField {
    private static final long serialVersionUID = 1L;
    private MyJTextField entryField;

    public SwingEntryField() {
        super((Component)new MyJTextField());
    }

    public int getType() {
        return 101;
    }

    protected void initializeComponent() {
        this.entryField = (MyJTextField)this.getComponent();
        super.initializeComponent();
    }

    public void setValue(String string) {
        super.setValue(string);
        this.entryField.setText(string != null ? string : "");
    }

    public void setStyle(EntryFieldStyle entryFieldStyle) {
        super.setStyle(entryFieldStyle);
        if (entryFieldStyle.getValue() == 4 || entryFieldStyle.getValue() == 5) {
            this.entryField.setSpinner(true);
        } else {
            this.entryField.setSpinner(false);
            this.entryField.setVScrollbar(entryFieldStyle.getValue() == 3);
        }
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        if (this.getBitmap() != null) {
            this.entryField.setIcon((Icon)IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)this.getBitmapNumber(), (int)this.getBitmapWidth(), (int)((int)this.getLinesPixels())));
        } else {
            this.entryField.setIcon(null);
        }
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.setIcons();
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setIcons();
    }

    private void setIcons() {
        if (this.getBitmap() != null) {
            int n = this.getBitmapWidth();
            int n2 = (int)this.getLinesPixels();
            Image image = this.getBitmap().getImage();
            this.entryField.setIcon((Icon)IscobolBeanConstants.getIcon((Image)image, (int)this.getBitmapNumber(), (int)n, (int)n2));
            this.entryField.setIconDisabled((Icon)IscobolBeanConstants.getIcon((Image)image, (int)this.getBitmapDisabled(), (int)n, (int)n2));
            this.entryField.setIconTrailing((Icon)IscobolBeanConstants.getIcon((Image)image, (int)this.getBitmapTrailingNumber(), (int)n, (int)n2));
            this.entryField.setIconTrailingDisabled((Icon)IscobolBeanConstants.getIcon((Image)image, (int)this.getBitmapTrailingDisabled(), (int)n, (int)n2));
        } else {
            this.entryField.setIcon(null);
            this.entryField.setIconDisabled(null);
            this.entryField.setIconTrailing(null);
            this.entryField.setIconTrailingDisabled(null);
        }
    }

    public void setBitmapNumber(int n) {
        super.setBitmapNumber(n);
        if (this.getBitmap() != null) {
            this.setIcons();
        }
    }

    public void setBitmapTrailingNumber(int n) {
        super.setBitmapTrailingNumber(n);
        if (this.getBitmap() != null) {
            this.entryField.setIconTrailing((Icon)IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)this.getBitmapTrailingNumber(), (int)this.getBitmapWidth(), (int)((int)this.getLinesPixels())));
        }
    }

    public void setBitmapDisabled(int n) {
        super.setBitmapDisabled(n);
        if (this.getBitmap() != null) {
            this.entryField.setIconDisabled((Icon)IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)this.getBitmapDisabled(), (int)this.getBitmapWidth(), (int)((int)this.getLinesPixels())));
        }
    }

    public void setBitmapTrailingDisabled(int n) {
        super.setBitmapTrailingDisabled(n);
        if (this.getBitmap() != null) {
            this.entryField.setIconTrailingDisabled((Icon)IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)this.getBitmapTrailingDisabled(), (int)this.getBitmapWidth(), (int)((int)this.getLinesPixels())));
        }
    }

    public void setBorder(BorderStyle borderStyle) {
        super.setBorder(borderStyle);
        switch (borderStyle.getValue()) {
            default: {
                this.setLineBorder();
                break;
            }
            case 0: {
                this.entryField.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 2: {
                this.entryField.setBorder(null);
            }
        }
    }

    public void setEnabled(BooleanChoice booleanChoice) {
        super.setEnabled(booleanChoice);
        this.entryField.redrawIcon();
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        super.setBorderColor(foregroundColorType);
        int n = this.getBorder().getValue();
        if (n == 1 || n == 3) {
            this.setLineBorder();
        }
    }

    private void setLineBorder() {
        Color color = null;
        if (this.getBorderColor() != null) {
            color = this.getBorderColor().getForegroundColor(this.getPalette());
        }
        this.entryField.setBorder(BorderFactory.createLineBorder(color != null ? color : Color.darkGray));
    }

    public void setAlignment(HAlignment hAlignment) {
        super.setAlignment(hAlignment);
        this.entryField.setAlignment(hAlignment.getValue());
    }
}

