/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractGrid;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingGrid;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.GridCellSetting;
import com.iscobol.screenpainter.beans.types.GridCellSettingList;
import com.iscobol.screenpainter.beans.types.GridColumnSetting;
import com.iscobol.screenpainter.beans.types.GridColumnSettingList;
import com.iscobol.screenpainter.beans.types.GridRowSetting;
import com.iscobol.screenpainter.beans.types.GridRowSettingList;
import com.iscobol.screenpainter.beans.types.ItemSetting;
import com.iscobol.screenpainter.beans.types.ItemSettingList;
import com.iscobol.screenpainter.beans.types.RowColorPatternSetting;
import com.iscobol.screenpainter.beans.types.RowColorPatternSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class SwingGrid
extends AbstractGrid {
    private static final long serialVersionUID = 1L;
    private MyJTable grid;
    private int myfontWidth;
    private int myfontHeight;

    public SwingGrid() {
        super((Component)new MyJTable());
    }

    protected void initializeComponent() {
        this.grid = (MyJTable)this.getComponent();
        super.initializeComponent();
    }

    public void setBorder(BorderStyle borderStyle) {
        super.setBorder(borderStyle);
        switch (borderStyle.getValue()) {
            default: {
                this.setLineBorder();
                break;
            }
            case 0: {
                this.grid.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 0, 0, Color.black));
                break;
            }
            case 2: 
            case 3: {
                this.grid.setBorder(null);
            }
        }
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        super.setBorderColor(foregroundColorType);
        if (this.getBorder().getValue() == 1) {
            this.setLineBorder();
        }
    }

    private void setLineBorder() {
        Color color = null;
        if (this.getBorderColor() != null) {
            color = this.getBorderColor().getForegroundColor(this.getPalette());
        }
        this.grid.setBorder(BorderFactory.createLineBorder(color != null ? color : Color.black));
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.intSetCellSettings(this.getCellSettings());
        this.intSetColumnSettings(this.getColumnSettings());
        this.intSetRowSettings(this.getRowSettings(), this.getNumRows() >= 0 ? this.getNumRows() : 1);
        this.updateColumnHeadingsRowHeight();
    }

    private void updateColumnHeadingsRowHeight() {
        this.grid.updateColumnHeadingsRowHeight(this.myfontHeight);
    }

    public void setVScroll(boolean bl) {
        super.setVScroll(bl);
        this.grid.setVScroll(bl);
    }

    public void setCenteredHeadings(boolean bl) {
        super.setCenteredHeadings(bl);
        this.grid.setCenterHeadings(bl);
    }

    public void setVPadding(int n) {
        super.setVPadding(n);
        this.computeFontSize();
        this.grid.setRowHeight(this.myfontHeight + this.getRowDividers());
    }

    public void setVirtualWidth(int n) {
        super.setVirtualWidth(n);
        this.intSetColumnSettings(this.getColumnSettings());
    }

    public void setColumnHeadings(boolean bl) {
        super.setColumnHeadings(bl);
        this.grid.setColumnHeader(bl);
        this.updateColumnHeadingsRowHeight();
    }

    public void setHScroll(boolean bl) {
        super.setHScroll(bl);
        this.grid.setHScroll(bl);
        this.intSetColumnSettings(this.getColumnSettings());
    }

    public void setPaged(boolean bl) {
        super.setPaged(bl);
        this.grid.setPaged(bl);
    }

    public void setRowHeadings(boolean bl) {
        super.setRowHeadings(bl);
        this.grid.setRowHeader(bl);
    }

    public void setTiledHeadings(boolean bl) {
        super.setTiledHeadings(bl);
    }

    public void setDividerColor(ForegroundColorType foregroundColorType) {
        super.setDividerColor(foregroundColorType);
        this.grid.setDividerColor(foregroundColorType.getForegroundColor(this.palette));
    }

    public void setEndColor(BackgroundColorType backgroundColorType) {
        super.setEndColor(backgroundColorType);
        this.grid.setEndColor(backgroundColorType.getBackgroundColor(this.palette));
    }

    public void setRowDividers(int n) {
        super.setRowDividers(n);
        this.grid.setRowDividers(n);
        this.computeFontSize();
        this.grid.setRowHeight(this.myfontHeight + this.getRowDividers());
        this.updateColumnHeadingsRowHeight();
    }

    public void setRowColorPatterns(RowColorPatternSettingList rowColorPatternSettingList) {
        super.setRowColorPatterns(rowColorPatternSettingList);
        Color[] colorArray = new Color[rowColorPatternSettingList.getSettingCount()];
        Color[] colorArray2 = new Color[rowColorPatternSettingList.getSettingCount()];
        for (int i = 0; i < colorArray.length; ++i) {
            RowColorPatternSetting rowColorPatternSetting = (RowColorPatternSetting)rowColorPatternSettingList.getSettingAt(i);
            ColorType colorType = rowColorPatternSetting.getColor();
            colorArray[i] = colorType.getBackgroundColor(this.palette);
            colorArray2[i] = colorType.getForegroundColor(this.palette);
        }
        this.grid.setRowColorPatterns(colorArray, colorArray2);
    }

    public void setRecordToAdd(ItemSettingList itemSettingList) {
        super.setRecordToAdd(itemSettingList);
        String[] stringArray = new String[itemSettingList.getSettingCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((ItemSetting)itemSettingList.getSettingAt(i)).getData();
        }
        this.grid.setItems(stringArray);
    }

    public void setHeadingColor(ColorType colorType) {
        super.setHeadingColor(colorType);
        this.grid.setHeadingColor(colorType.getForegroundColor(this.palette), colorType.getBackgroundColor(this.palette));
    }

    public void setHeadingBackgroundColor(BackgroundColorType backgroundColorType) {
        super.setHeadingBackgroundColor(backgroundColorType);
        this.grid.setHeadingBackColor(backgroundColorType.getBackgroundColor(this.palette));
    }

    public void setHeadingForegroundColor(ForegroundColorType foregroundColorType) {
        super.setHeadingForegroundColor(foregroundColorType);
        this.grid.setHeadingForeColor(foregroundColorType.getForegroundColor(this.palette));
    }

    public void setHeadingDividerColor(ForegroundColorType foregroundColorType) {
        super.setHeadingDividerColor(foregroundColorType);
        this.grid.setHeadingDividerColor(foregroundColorType.getForegroundColor(this.palette));
    }

    public void setHeadingFont(FontType fontType) {
        super.setHeadingFont(fontType);
        this.grid.setHeadingFont(fontType.getFont());
    }

    public void setNumRows(int n) {
        int n2 = this.getNumRows();
        if (n2 < 0) {
            n2 = 1;
        }
        super.setNumRows(n);
        if (n < 0) {
            n = 1;
        }
        GridRowSettingList gridRowSettingList = this.getRowSettings();
        int n3 = n - n2;
        if (n3 != 0) {
            this.intSetRowSettings(gridRowSettingList, n);
        }
    }

    public void setNumColHeadings(int n) {
        super.setNumColHeadings(n);
        this.grid.setNumColHeadings(n);
        this.updateColumnHeadingsRowHeight();
    }

    public void setNumRowHeadings(int n) {
        super.setNumRowHeadings(n);
        this.grid.setNumRowHeadings(n);
    }

    public void setRowHeadingLineHeight(float f) {
        super.setRowHeadingLineHeight(f);
        this.grid.setRowHeadingLineHeight(f);
        this.updateColumnHeadingsRowHeight();
    }

    public void setCellSettings(GridCellSettingList gridCellSettingList) {
        super.setCellSettings(gridCellSettingList);
        this.intSetCellSettings(gridCellSettingList);
    }

    public void setLines(float f) {
        super.setLines(f);
        this.updateColumnHeadingsRowHeight();
    }

    public void setLinesPixels(float f) {
        super.setLinesPixels(f);
        this.updateColumnHeadingsRowHeight();
    }

    public void setSize(float f) {
        super.setSize(f);
        this.intSetColumnSettings(this.getColumnSettings());
        this.updateColumnHeadingsRowHeight();
    }

    public void setSizePixels(int n) {
        super.setSizePixels(n);
        this.intSetColumnSettings(this.getColumnSettings());
        this.updateColumnHeadingsRowHeight();
    }

    public void setFont(FontType fontType) {
        super.setFont(fontType);
        this.computeFontSize();
        this.intSetColumnSettings(this.getColumnSettings());
        this.grid.setRowHeight(this.myfontHeight + this.getRowDividers());
        this.updateColumnHeadingsRowHeight();
    }

    private void computeFontSize() {
        FontMetrics fontMetrics = this.grid.getMetrics();
        this.myfontWidth = fontMetrics.stringWidth("01234567890") / 10;
        float f = fontMetrics.getHeight() * this.getVPadding() / 100;
        this.myfontHeight = (int)((float)fontMetrics.getHeight() + f);
    }

    public void setColumnSettings(GridColumnSettingList gridColumnSettingList) {
        super.setColumnSettings(gridColumnSettingList);
        this.intSetColumnSettings(gridColumnSettingList);
    }

    protected void intSetColumnSettings(GridColumnSettingList gridColumnSettingList) {
        Object object;
        GridColumnSetting gridColumnSetting;
        int n;
        if (gridColumnSettingList == null) {
            return;
        }
        int n2 = gridColumnSettingList.getSettingCount();
        MyColumn[] myColumnArray = new MyColumn[n2];
        if (this.myfontWidth == 0) {
            this.computeFontSize();
        }
        int n3 = 0;
        int n4 = this.getVirtualWidth();
        for (n = 0; n < n2 && (n4 == 0 || n4 - n3 >= 0); ++n) {
            gridColumnSetting = (GridColumnSetting)gridColumnSettingList.getSettingAt(n);
            n3 += gridColumnSetting.getDisplayColumn();
            Color color = null;
            object = null;
            if (gridColumnSetting.getBackgroundColor() != null && !gridColumnSetting.getBackgroundColor().isDisabled()) {
                color = gridColumnSetting.getBackgroundColor().getBackgroundColor(this.palette);
            } else if (gridColumnSetting.getColor() != null && !gridColumnSetting.getColor().isDisabled()) {
                color = gridColumnSetting.getColor().getBackgroundColor(this.palette);
            }
            if (gridColumnSetting.getForegroundColor() != null && !gridColumnSetting.getForegroundColor().isDisabled()) {
                object = gridColumnSetting.getForegroundColor().getForegroundColor(this.palette);
            } else if (gridColumnSetting.getColor() != null && !gridColumnSetting.getColor().isDisabled()) {
                object = gridColumnSetting.getColor().getForegroundColor(this.palette);
            }
            myColumnArray[n] = new MyColumn(n + 1, gridColumnSetting.getDisplayColumn() * this.myfontWidth, gridColumnSetting.getDivider(), (Color)object, color, gridColumnSetting.getFont() != null ? gridColumnSetting.getFont().getFont() : null, gridColumnSetting.getDataColumn(), gridColumnSetting.getAlignmentExt().getValue(), gridColumnSetting.getHeadingLayout());
        }
        if (n > 0) {
            int n5 = n - 1;
            gridColumnSetting = (GridColumnSetting)gridColumnSettingList.getSettingAt(n5);
            object = myColumnArray[n5];
            object.len = 10000;
            boolean bl = this.isHScroll();
            int n6 = n4 - (n3 -= gridColumnSetting.getDisplayColumn());
            int n7 = object.width;
            if (n6 > 0) {
                n7 = n6 * this.myfontWidth;
            } else if (n4 == 0) {
                if (bl) {
                    n7 = 10 * this.myfontWidth;
                } else {
                    int n8 = (int)this.getSizePixels();
                    n7 = n8 - n3 * this.myfontWidth - gridColumnSetting.getDivider();
                }
            }
            object.width = n7;
            if (n < n2) {
                MyColumn[] myColumnArray2 = myColumnArray;
                myColumnArray = new MyColumn[n];
                System.arraycopy(myColumnArray2, 0, myColumnArray, 0, n);
            }
        }
        this.grid.setColumns(myColumnArray);
        this.updateColumnHeadingsRowHeight();
    }

    public void setRowSettings(GridRowSettingList gridRowSettingList) {
        super.setRowSettings(gridRowSettingList);
        this.intSetRowSettings(gridRowSettingList, this.getNumRows() >= 0 ? this.getNumRows() : 1);
    }

    protected void intSetRowSettings(GridRowSettingList gridRowSettingList, int n) {
        int n2 = gridRowSettingList.getSettingCount();
        MyRow[] myRowArray = new MyRow[n2];
        GridRowSetting[] gridRowSettingArray = new GridRowSetting[n2];
        gridRowSettingList.toArray((SettingItem[])gridRowSettingArray);
        for (int i = 0; i < n2; ++i) {
            Color color = null;
            Color color2 = null;
            if (gridRowSettingArray[i].getBackgroundColor() != null && !gridRowSettingArray[i].getBackgroundColor().isDisabled()) {
                color = gridRowSettingArray[i].getBackgroundColor().getBackgroundColor(this.palette);
            } else if (gridRowSettingArray[i].getColor() != null && !gridRowSettingArray[i].getColor().isDisabled()) {
                color = gridRowSettingArray[i].getColor().getBackgroundColor(this.palette);
            }
            if (gridRowSettingArray[i].getForegroundColor() != null && !gridRowSettingArray[i].getForegroundColor().isDisabled()) {
                color2 = gridRowSettingArray[i].getForegroundColor().getForegroundColor(this.palette);
            } else if (gridRowSettingArray[i].getColor() != null && !gridRowSettingArray[i].getColor().isDisabled()) {
                color2 = gridRowSettingArray[i].getColor().getForegroundColor(this.palette);
            }
            myRowArray[i] = new MyRow(gridRowSettingArray[i].getRowIndex(), color2, color, gridRowSettingArray[i].getFont() != null ? gridRowSettingArray[i].getFont().getFont() : null);
        }
        this.grid.setRows(myRowArray, n);
    }

    protected void intSetCellSettings(GridCellSettingList gridCellSettingList) {
        if (this.myfontHeight == 0) {
            this.computeFontSize();
        }
        int n = gridCellSettingList.getSettingCount();
        MyCell[] myCellArray = new MyCell[n];
        GridCellSetting[] gridCellSettingArray = new GridCellSetting[n];
        gridCellSettingList.toArray((SettingItem[])gridCellSettingArray);
        for (int i = 0; i < n; ++i) {
            ImageIcon imageIcon;
            if (gridCellSettingArray[i].getBitmap() != null) {
                int n2 = gridCellSettingArray[i].getBitmapNumber();
                if (n2 < 1) {
                    n2 = 1;
                }
                imageIcon = IscobolBeanConstants.getIcon((Image)gridCellSettingArray[i].getBitmap().getImage(), (int)n2, (int)gridCellSettingArray[i].getBitmapWidth(), (int)this.myfontHeight);
            } else {
                imageIcon = null;
            }
            Color color = null;
            Color color2 = null;
            if (gridCellSettingArray[i].getBackgroundColor() != null && !gridCellSettingArray[i].getBackgroundColor().isDisabled()) {
                color = gridCellSettingArray[i].getBackgroundColor().getBackgroundColor(this.palette);
            } else if (gridCellSettingArray[i].getColor() != null && !gridCellSettingArray[i].getColor().isDisabled()) {
                color = gridCellSettingArray[i].getColor().getBackgroundColor(this.palette);
            }
            if (gridCellSettingArray[i].getForegroundColor() != null && !gridCellSettingArray[i].getForegroundColor().isDisabled()) {
                color2 = gridCellSettingArray[i].getForegroundColor().getForegroundColor(this.palette);
            } else if (gridCellSettingArray[i].getColor() != null && !gridCellSettingArray[i].getColor().isDisabled()) {
                color2 = gridCellSettingArray[i].getColor().getForegroundColor(this.palette);
            }
            myCellArray[i] = new MyCell(gridCellSettingArray[i].getY(), gridCellSettingArray[i].getX(), color2, color, gridCellSettingArray[i].getFont() != null ? gridCellSettingArray[i].getFont().getFont() : null, imageIcon, gridCellSettingArray[i].getBitmapTrailing() != 0, gridCellSettingArray[i].getData());
        }
        this.grid.setCells(myCellArray);
    }
}

