/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractListBox;
import com.iscobol.screenpainter.beans.swing.SwingListBox;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ListColumnSetting;
import com.iscobol.screenpainter.beans.types.ListColumnSettingList;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;

public class SwingListBox
extends AbstractListBox {
    private static final long serialVersionUID = 1L;
    private MyJListBox listBox;
    private int fontWidth;

    public SwingListBox() {
        super((Component)new MyJListBox());
    }

    protected void initializeComponent() {
        this.listBox = (MyJListBox)this.getComponent();
        super.initializeComponent();
    }

    public int getType() {
        return 107;
    }

    public void setFont(FontType fontType) {
        super.setFont(fontType);
        this.computeFontSize();
        this.setColumnSettings(this.getColumnSettings());
    }

    private void computeFontSize() {
        FontMetrics fontMetrics = this.listBox.getMetrics();
        this.fontWidth = fontMetrics.stringWidth("01234567890") / 10;
    }

    public void setColumnSettings(ListColumnSettingList listColumnSettingList) {
        super.setColumnSettings(listColumnSettingList);
        int n = listColumnSettingList.getSettingCount();
        if (n > 0) {
            MyColumn[] myColumnArray = new MyColumn[n - 1];
            if (this.fontWidth == 0) {
                this.computeFontSize();
            }
            for (int i = 0; i < n - 1; ++i) {
                ListColumnSetting listColumnSetting = (ListColumnSetting)listColumnSettingList.getSettingAt(i);
                myColumnArray[i] = new MyColumn(listColumnSetting.getDisplayColumn() * this.fontWidth, listColumnSetting.getDivider());
            }
            this.listBox.setColumns(myColumnArray);
        } else {
            this.listBox.setColumns(null);
        }
    }

    public void setPaged(boolean bl) {
        super.setPaged(bl);
        this.listBox.setPaged(bl);
    }

    public void setBorder(BorderStyle borderStyle) {
        super.setBorder(borderStyle);
        switch (borderStyle.getValue()) {
            default: {
                this.setLineBorder();
                break;
            }
            case 0: {
                this.listBox.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 2: {
                this.listBox.setBorder(null);
            }
        }
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        super.setBorderColor(foregroundColorType);
        int n = this.getBorder().getValue();
        if (n == 1 || n == 3) {
            this.setLineBorder();
        }
    }

    private void setLineBorder() {
        Color color = null;
        if (this.getBorderColor() != null) {
            color = this.getBorderColor().getForegroundColor(this.getPalette());
        }
        this.listBox.setBorder(BorderFactory.createLineBorder(color != null ? color : Color.black));
    }
}

