/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractPushButton;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingPushButton;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.PositionExt;
import com.iscobol.screenpainter.beans.types.PushButtonAlignment;
import com.iscobol.screenpainter.beans.types.PushButtonStyle;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;

public class SwingPushButton
extends AbstractPushButton {
    private static final long serialVersionUID = 1L;
    private MyButton button;

    public SwingPushButton() {
        super((Component)new MyButton(null));
    }

    protected void initializeComponent() {
        this.button = (MyButton)this.getComponent();
        this.button.setText("");
        this.button.setMargin(new Insets(0, 0, 0, 0));
        super.initializeComponent();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.intSetTitle(string);
    }

    public void setHint(String string) {
        super.setHint(string);
        this.button.setToolTipText(string);
    }

    public void setMultiline(boolean bl) {
        super.setMultiline(bl);
        this.intSetMultiline(bl);
    }

    public void setTitlePosition(PositionExt positionExt) {
        super.setTitlePosition(positionExt);
        this.intSetTitlePosition(positionExt.getValue());
        this.intSetTitle(this.getTitle());
    }

    public void setLines(float f) {
        super.setLines(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLinesPixels(int n) {
        super.setLinesPixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSize(float f) {
        super.setSize(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSizePixels(int n) {
        super.setSizePixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setStyle(PushButtonStyle pushButtonStyle) {
        super.setStyle(pushButtonStyle);
        switch (this.getStyle().getValue()) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.setOkButton();
                break;
            }
            case 2: {
                this.setCancelButton();
            }
            case 0: {
                this.intSetTitle(this.getTitle());
            }
        }
    }

    private void setOkButton() {
        this.button.setText("OK");
    }

    private void setCancelButton() {
        this.button.setText("CANCEL");
    }

    void intSetTitle(String string) {
        this.button.setTitle(string);
    }

    void intSetFlat(boolean bl) {
        this.button.setFlat(bl);
    }

    void intSetTitlePosition(int n) {
        this.button.setTitlePosition(n);
    }

    void intSetMultiline(boolean bl) {
        this.button.setMultiline(bl);
    }

    void intSetBitmapNumber(int n) {
        this.button.setBitmapNumber(n);
    }

    void intSetBitmapDisabled(int n) {
        this.button.setBitmapDisabled(n);
    }

    void intSetBitmapWidth(int n) {
        this.button.setBitmapWidth(n);
    }

    void intSetBitmap(Image image) {
        this.setBitmap(image, this.getSizePixels(), this.getLinesPixels(), this.isLinesUnitPixel(), this.isAutoFit(), this.isFlat(), this.getTitlePosition().getValue());
    }

    public void setBitmap(Image image, float f, float f2, boolean bl, boolean bl2, boolean bl3, int n) {
        if (bl2 && image != null) {
            image = IscobolBeanConstants.getFitImage((double)f, (double)f2, (Image)image);
        }
        int n2 = (int)f2;
        if (!bl) {
            n2 += 8;
        }
        this.button.setRedraw(false);
        this.button.setImage(image, (int)f, n2);
        this.button.setTitlePosition(n);
        this.button.setFlat(bl3);
        this.button.setRedraw(true);
    }

    public void setFlat(boolean bl) {
        super.setFlat(bl);
        this.intSetFlat(bl);
    }

    public void setAutoFit(boolean bl) {
        super.setAutoFit(bl);
        this.button.setAutoFit(bl);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.intSetBitmap(imageType != null ? imageType.getImage() : null);
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.intSetBitmapWidth(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setBitmapNumber(int n) {
        super.setBitmapNumber(n);
        this.intSetBitmap(this.getBitmap() != null ? this.getBitmap().getImage() : null);
        this.intSetBitmapNumber(n);
    }

    public void setBitmapDisabled(int n) {
        super.setBitmapDisabled(n);
        this.intSetBitmapDisabled(n);
    }

    public int getType() {
        return 102;
    }

    public void setAlignment(PushButtonAlignment pushButtonAlignment) {
        super.setAlignment(pushButtonAlignment);
        switch (pushButtonAlignment.getValue()) {
            case 0: {
                this.button.setVerticalAlignment(1);
                this.button.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.button.setVerticalAlignment(1);
                this.button.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                this.button.setVerticalAlignment(1);
                this.button.setHorizontalAlignment(4);
                break;
            }
            case 3: {
                this.button.setVerticalAlignment(0);
                this.button.setHorizontalAlignment(2);
                break;
            }
            default: {
                this.button.setVerticalAlignment(0);
                this.button.setHorizontalAlignment(0);
                break;
            }
            case 5: {
                this.button.setVerticalAlignment(0);
                this.button.setHorizontalAlignment(4);
                break;
            }
            case 6: {
                this.button.setVerticalAlignment(3);
                this.button.setHorizontalAlignment(2);
                break;
            }
            case 7: {
                this.button.setVerticalAlignment(3);
                this.button.setHorizontalAlignment(0);
                break;
            }
            case 8: {
                this.button.setVerticalAlignment(3);
                this.button.setHorizontalAlignment(4);
            }
        }
    }
}

