/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractRadioButton;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingRadioButton;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.LeftTextAlignment;
import com.iscobol.screenpainter.beans.types.Position;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;

public class SwingRadioButton
extends AbstractRadioButton {
    private static final long serialVersionUID = 1L;
    private MyRadioButton radio;

    public SwingRadioButton() {
        super((Component)new MyRadioButton());
    }

    protected void initializeComponent() {
        this.radio = (MyRadioButton)this.getComponent();
        this.radio.setMargin(new Insets(0, 0, 0, 0));
        this.radio.setText("");
        super.initializeComponent();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.intSetTitle(string);
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.intSetBitmapWidth(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setHint(String string) {
        super.setHint(string);
        this.radio.setToolTipText(string);
    }

    public void setMultiline(boolean bl) {
        super.setMultiline(bl);
        this.intSetMultiline(bl);
    }

    public void setTitlePosition(Position position) {
        super.setTitlePosition(position);
        this.intSetTitlePosition(position.getValue());
        this.intSetTitle(this.getTitle());
    }

    void intSetBitmap(Image image) {
        if (this.isAutoFit() && image != null) {
            image = IscobolBeanConstants.getFitImage((double)this.getSizePixels(), (double)this.getLinesPixels(), (Image)image);
        }
        int n = (int)this.getLinesPixels();
        if (!this.isLinesUnitPixel()) {
            n += 8;
        }
        this.radio.setImage(image, (int)this.getSizePixels(), n);
        this.radio.setTitlePosition(this.getTitlePosition().getValue());
        this.radio.setFlat(this.isFlat());
    }

    public void setAutoFit(boolean bl) {
        super.setAutoFit(bl);
        this.radio.setAutoFit(bl);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    void intSetBitmapDisabled(int n) {
        this.radio.setBitmapDisabled(n);
    }

    void intSetBitmapNumber(int n) {
        this.radio.setBitmapNumber(n);
    }

    void intSetBitmapWidth(int n) {
        this.radio.setBitmapWidth(n);
    }

    void intSetFlat(boolean bl) {
        this.radio.setFlat(bl);
    }

    void intSetMultiline(boolean bl) {
        this.radio.setMultiline(bl);
    }

    void intSetTitle(String string) {
        this.radio.setTitle(string);
    }

    void intSetTitlePosition(int n) {
        this.radio.setTitlePosition(n);
    }

    public void setBitmapSelected(int n) {
        super.setBitmapSelected(n);
        this.radio.setBitmapSelected(n);
    }

    public void setLeftText(boolean bl) {
        super.setLeftText(bl);
        this.radio.setLeftText(bl);
    }

    public void setValue(int n) {
        super.setValue(n);
        this.radio.setSelected(n != 0);
    }

    public void setVTop(boolean bl) {
        super.setVTop(bl);
        this.radio.setVTop(bl);
    }

    public void setTransparent(boolean bl) {
        super.setTransparent(bl);
        this.radio.setOpaque(!bl);
    }

    public int getType() {
        return 103;
    }

    public void setFlat(boolean bl) {
        super.setFlat(bl);
        this.intSetFlat(bl);
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.intSetBitmap(imageType != null ? imageType.getImage() : null);
    }

    public void setBitmapNumber(int n) {
        super.setBitmapNumber(n);
        this.intSetBitmap(this.getBitmap() != null ? this.getBitmap().getImage() : null);
        this.intSetBitmapNumber(n);
    }

    public void setBitmapDisabled(int n) {
        super.setBitmapDisabled(n);
        this.intSetBitmapDisabled(n);
    }

    void intSetBitmapDisabledSelected(int n) {
        this.radio.setBitmapDisabledSelected(n);
    }

    public void setBitmapDisabledSelected(int n) {
        super.setBitmapDisabledSelected(n);
        this.intSetBitmapDisabledSelected(n);
    }

    public void setLines(float f) {
        super.setLines(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLinesPixels(int n) {
        super.setLinesPixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSize(float f) {
        super.setSize(f);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setSizePixels(int n) {
        super.setSizePixels(n);
        if (this.getBitmap() != null) {
            this.intSetBitmap(this.getBitmap().getImage());
        }
    }

    public void setLeftTextAlignment(LeftTextAlignment leftTextAlignment) {
        super.setLeftTextAlignment(leftTextAlignment);
        this.radio.setLeftTextAlignment(leftTextAlignment.getValue());
    }
}

