/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.swing.SwingRibbon;
import com.iscobol.screenpainter.beans.types.ImageType;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;

public class SwingRibbon
extends AbstractRibbon
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Ribbon ribbon;
    private AbstractButton[] scrollBtn;

    public SwingRibbon() {
        super((Component)new Ribbon());
    }

    protected void initializeComponent() {
        this.ribbon = (Ribbon)this.getComponent();
        this.scrollBtn = new AbstractButton[2];
        Component[] componentArray = this.ribbon.tab.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length && n < 2; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            this.scrollBtn[n++] = (AbstractButton)componentArray[i];
        }
        super.initializeComponent();
    }

    public int getType() {
        return 12;
    }

    protected void intSetPageAt(int n, TabPage tabPage) {
        this.ribbon.tab.setPageTitle(tabPage.getTitle(), n);
        this.ribbon.tab.setPageEnabled(tabPage.isEnabled(), n);
        if (this.getBitmap() != null) {
            this.ribbon.tab.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1), n);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        if (propertyChangeEvent.getPropertyName().equals("title")) {
            int n2 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n2 >= 0) {
                this.ribbon.tab.setPageTitle((String)propertyChangeEvent.getNewValue(), n2);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            int n3 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n3 >= 0) {
                this.ribbon.tab.setPageEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue(), n3);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("bitmapNumber") && (n = this.pages.indexOf(propertyChangeEvent.getSource())) >= 0 && this.getBitmap() != null) {
            this.ribbon.tab.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)((Integer)propertyChangeEvent.getNewValue()), (int)this.getBitmapWidth(), (int)-1), n);
        }
    }

    protected void intAddPage(int n, TabPage tabPage) {
        tabPage.addPropertyChangeListener((PropertyChangeListener)this);
        ImageIcon imageIcon = null;
        if (this.getBitmap() != null) {
            imageIcon = IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1);
        }
        if (this.ribbon.tab.getTabCount() == 0) {
            this.ribbon.mainPanel.remove(this.ribbon.emptyTabPanel);
        }
        this.ribbon.tab.addPage(tabPage.getTitle(), imageIcon, tabPage.isEnabled(), n);
    }

    protected void intRemovePage(int n, TabPage tabPage) {
        if (n >= 0) {
            this.ribbon.tab.removePage(n);
        }
        tabPage.removePropertyChangeListener((PropertyChangeListener)this);
        if (this.ribbon.tab.getTabCount() == 0) {
            this.ribbon.mainPanel.add((Component)this.ribbon.emptyTabPanel, "North");
        }
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.refreshBitmaps(imageType);
        this.ribbon.tab.adjustTabs();
    }

    void refreshBitmaps(ImageType imageType) {
        if (this.pages == null) {
            return;
        }
        int n = this.getPageCount();
        for (int i = 0; i < n; ++i) {
            TabPage tabPage = (TabPage)this.pages.elementAt(i);
            ImageIcon imageIcon = imageType != null && imageType.getImage() != null && tabPage.getBitmapNumber() > 0 ? IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1) : null;
            this.ribbon.tab.setPageIcon(imageIcon, i);
        }
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.refreshBitmaps(this.getBitmap());
        this.ribbon.tab.adjustTabs();
    }

    public int indexAtLocation(int n, int n2) {
        if (this.ribbon.header) {
            n2 -= 28;
        }
        Point point = this.ribbon.tab.getLocation();
        return this.ribbon.tab.indexAtLocation(n - point.x, n2 - point.y);
    }

    public boolean leftScrollAtLocation(int n, int n2) {
        if (this.ribbon.header) {
            n2 -= 28;
        }
        Point point = this.ribbon.tab.getLocation();
        return this.ribbon.tab.getComponentAt(n - point.x, n2 - point.y) == this.scrollBtn[0];
    }

    public boolean rightScrollAtLocation(int n, int n2) {
        if (this.ribbon.header) {
            n2 -= 28;
        }
        Point point = this.ribbon.tab.getLocation();
        return this.ribbon.tab.getComponentAt(n - point.x, n2 - point.y) == this.scrollBtn[1];
    }

    public void selectPage(int n) {
        this.ribbon.tab.setSelectedIndex(n);
    }

    public void scrollRight() {
        if (this.scrollBtn[1] != null) {
            this.scrollBtn[1].doClick();
        }
    }

    public void scrollLeft() {
        if (this.scrollBtn[0] != null) {
            this.scrollBtn[0].doClick();
        }
    }

    public int getButtonsHeight() {
        return this.ribbon.tab.getTabHeight();
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.ribbon.tab.refreshBounds();
    }

    public int getSelectedIndex() {
        return this.ribbon.tab.getSelectedIndex();
    }

    public int getMargin() {
        return this.ribbon.getMargin();
    }

    public void setHeader(boolean bl) {
        this.ribbon.setHeader(bl);
    }

    public void setPopUpMenu(String string) {
        super.setPopUpMenu(string);
        this.ribbon.setPopUpMenu(string);
    }
}

