/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingStatusbar;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.StatusPanelSetting;
import com.iscobol.screenpainter.beans.types.StatusPanelSettingList;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class SwingStatusbar
extends AbstractBeanStatusbar {
    private MyJStatusBar statusBar;
    private int fontWidth;
    private int fontHeight;

    public SwingStatusbar() {
        super((Component)new MyJStatusBar());
    }

    protected void initializeComponent() {
        this.statusBar = (MyJStatusBar)this.getComponent();
        super.initializeComponent();
    }

    private void computeFontSize() {
        FontMetrics fontMetrics = this.statusBar.getMetrics();
        this.fontWidth = fontMetrics.stringWidth("01234567890") / 10;
        this.fontHeight = fontMetrics.getHeight();
    }

    int getFontHeight() {
        if (this.fontHeight == 0) {
            this.computeFontSize();
        }
        return this.fontHeight;
    }

    int getFontWidth() {
        if (this.fontWidth == 0) {
            this.computeFontSize();
        }
        return this.fontWidth;
    }

    public void setCellSize(int n, int n2) {
        if (n != this.cellWidth || n2 != this.cellHeight) {
            super.setCellSize(n, n2);
            this.setPanelSettings(this.getPanelSettings());
        }
    }

    public void setLines(float f) {
        super.setLines(f);
        this.statusBar.setPanelHeight((int)(f * (float)this.getFontHeight()));
        this.setPanelSettings(this.getPanelSettings());
    }

    public void setFont(FontType fontType) {
        super.setFont(fontType);
        this.computeFontSize();
        this.setLines(this.getLines());
        this.setPanelSettings(this.getPanelSettings());
    }

    public void setColor(ColorType colorType) {
        super.setColor(colorType);
        this.setPanelSettings(this.getPanelSettings());
    }

    public void setPanelSettings(StatusPanelSettingList statusPanelSettingList) {
        super.setPanelSettings(statusPanelSettingList);
        int n = statusPanelSettingList.getSettingCount();
        if (n > 0) {
            MyJStatusBar.MyPanel[] myPanelArray = new MyJStatusBar.MyPanel[n];
            for (int i = 0; i < n; ++i) {
                ImageIcon imageIcon;
                StatusPanelSetting statusPanelSetting = (StatusPanelSetting)statusPanelSettingList.getSettingAt(i);
                if (statusPanelSetting.getBitmap() != null) {
                    int n2 = statusPanelSetting.getBitmapNumber();
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    imageIcon = IscobolBeanConstants.getIcon((Image)statusPanelSetting.getBitmap().getImage(), (int)n2, (int)statusPanelSetting.getBitmapWidth(), (int)((int)(this.getLines() * (float)this.getFontHeight())));
                } else {
                    imageIcon = null;
                }
                Color color = null;
                Color color2 = null;
                if (statusPanelSetting.getBackgroundColor() != null && !statusPanelSetting.getBackgroundColor().isDisabled()) {
                    color = statusPanelSetting.getBackgroundColor().getBackgroundColor(this.palette);
                } else if (statusPanelSetting.getColor() != null && !statusPanelSetting.getColor().isDisabled()) {
                    color = statusPanelSetting.getColor().getBackgroundColor(this.palette);
                }
                if (statusPanelSetting.getForegroundColor() != null && !statusPanelSetting.getForegroundColor().isDisabled()) {
                    color2 = statusPanelSetting.getForegroundColor().getForegroundColor(this.palette);
                } else if (statusPanelSetting.getColor() != null && !statusPanelSetting.getColor().isDisabled()) {
                    color2 = statusPanelSetting.getColor().getForegroundColor(this.palette);
                }
                myPanelArray[i] = new MyJStatusBar.MyPanel(statusPanelSetting.getWidth() * this.cellWidth, statusPanelSetting.getStyle().getValue(), statusPanelSetting.getAlignment().getValue(), statusPanelSetting.getBitmapAlignment().getValue(), statusPanelSetting.getText(), imageIcon, color, color2);
            }
            this.statusBar.setPanels(myPanelArray);
        } else {
            this.statusBar.setPanels(null);
        }
    }

    public int getType() {
        return 111;
    }

    public void setGrip(boolean bl) {
        super.setGrip(bl);
        this.statusBar.setGrip(bl);
        this.setPanelSettings(this.getPanelSettings());
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setPanelSettings(this.getPanelSettings());
    }
}

