/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractTab;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.swing.TabbedPane;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;

public class SwingTab
extends AbstractTab
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private TabbedPane tab;
    private AbstractButton[] scrollBtn;

    public SwingTab() {
        super((Component)new TabbedPane());
    }

    protected void initializeComponent() {
        this.tab = (TabbedPane)this.getComponent();
        this.setMultiline(false);
        this.setTabOrientation(new TabOrientation(0));
        super.initializeComponent();
    }

    public int getType() {
        return 109;
    }

    protected void intSetPageAt(int n, TabPage tabPage) {
        this.tab.setPageTitle(tabPage.getTitle(), n);
        this.tab.setPageEnabled(tabPage.isEnabled(), n);
        if (this.getBitmap() != null) {
            this.tab.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1), n);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        if (propertyChangeEvent.getPropertyName().equals("title")) {
            int n2 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n2 >= 0) {
                this.tab.setPageTitle((String)propertyChangeEvent.getNewValue(), n2);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            int n3 = this.pages.indexOf(propertyChangeEvent.getSource());
            if (n3 >= 0) {
                this.tab.setPageEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue(), n3);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("bitmapNumber") && (n = this.pages.indexOf(propertyChangeEvent.getSource())) >= 0 && this.getBitmap() != null) {
            this.tab.setPageIcon(IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)((Integer)propertyChangeEvent.getNewValue()), (int)this.getBitmapWidth(), (int)-1), n);
        }
    }

    protected void intAddPage(int n, TabPage tabPage) {
        tabPage.addPropertyChangeListener((PropertyChangeListener)this);
        ImageIcon imageIcon = null;
        if (this.getBitmap() != null) {
            imageIcon = IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1);
        }
        this.tab.addPage(tabPage.getTitle(), imageIcon, tabPage.isEnabled(), n);
    }

    protected void intRemovePage(int n, TabPage tabPage) {
        if (n >= 0) {
            this.tab.removePage(n);
        }
        tabPage.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void setMultiline(boolean bl) {
        super.setMultiline(bl);
        this.tab.setMultiline(bl);
    }

    public void setTabOrientation(TabOrientation tabOrientation) {
        super.setTabOrientation(tabOrientation);
        switch (tabOrientation.getValue()) {
            case 0: {
                this.tab.setTabOrientation(1);
                break;
            }
            case 3: {
                this.tab.setTabOrientation(3);
                break;
            }
            case 1: {
                this.tab.setTabOrientation(2);
                break;
            }
            case 2: {
                this.tab.setTabOrientation(4);
            }
        }
        Component[] componentArray = this.tab.getComponents();
        this.scrollBtn = new AbstractButton[2];
        int n = 0;
        for (int i = 0; i < componentArray.length && n < 2; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            this.scrollBtn[n++] = (AbstractButton)componentArray[i];
        }
        this.refreshBitmaps(this.getBitmap());
    }

    public void setTextNoRotate(boolean bl) {
        super.setTextNoRotate(bl);
        this.tab.setTextNoRotate(bl);
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        this.refreshBitmaps(imageType);
        this.tab.adjustTabs();
    }

    void refreshBitmaps(ImageType imageType) {
        if (this.pages == null) {
            return;
        }
        int n = this.getPageCount();
        for (int i = 0; i < n; ++i) {
            TabPage tabPage = (TabPage)this.pages.elementAt(i);
            ImageIcon imageIcon = imageType != null && imageType.getImage() != null && tabPage.getBitmapNumber() > 0 ? IscobolBeanConstants.getIcon((Image)this.getBitmap().getImage(), (int)tabPage.getBitmapNumber(), (int)this.getBitmapWidth(), (int)-1) : null;
            this.tab.setPageIcon(imageIcon, i);
        }
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.refreshBitmaps(this.getBitmap());
        this.tab.adjustTabs();
    }

    public int indexAtLocation(int n, int n2) {
        Point point = this.tab.getLocation();
        return this.tab.indexAtLocation(n - point.x, n2 - point.y);
    }

    public boolean leftScrollAtLocation(int n, int n2) {
        Point point = this.tab.getLocation();
        return !this.isMultiline() && this.tab.getComponentAt(n - point.x, n2 - point.y) == this.scrollBtn[0];
    }

    public boolean rightScrollAtLocation(int n, int n2) {
        Point point = this.tab.getLocation();
        return !this.isMultiline() && this.tab.getComponentAt(n - point.x, n2 - point.y) == this.scrollBtn[1];
    }

    public void selectPage(int n) {
        this.tab.setSelectedIndex(n);
    }

    public void scrollRight() {
        if (!this.isMultiline() && this.scrollBtn[1] != null) {
            this.scrollBtn[1].doClick();
        }
    }

    public void scrollLeft() {
        if (!this.isMultiline() && this.scrollBtn[0] != null) {
            this.scrollBtn[0].doClick();
        }
    }

    public int getButtonsHeight() {
        if (this.isVertical()) {
            return this.tab.getTabWidth();
        }
        return this.tab.getTabHeight();
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.setMultiline(this.isMultiline());
        this.setTabOrientation(this.getTabOrientation());
        this.tab.refreshBounds();
    }

    public int getSelectedIndex() {
        return this.tab.getSelectedIndex();
    }
}

