/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.AbstractTreeView;
import com.iscobol.screenpainter.beans.swing.SwingTreeView;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.TreeViewItemSettingList;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;

public class SwingTreeView
extends AbstractTreeView {
    private static final long serialVersionUID = 1L;
    private MyJTree treeView;

    public SwingTreeView() {
        super((Component)new MyJTree());
    }

    protected void initializeComponent() {
        this.treeView = (MyJTree)this.getComponent();
        super.initializeComponent();
    }

    public int getType() {
        return 115;
    }

    public void setBorder(BorderStyle borderStyle) {
        super.setBorder(borderStyle);
        switch (borderStyle.getValue()) {
            default: {
                this.setLineBorder();
                break;
            }
            case 0: {
                this.treeView.setBorder(BorderFactory.createLoweredBevelBorder());
                break;
            }
            case 2: {
                this.treeView.setBorder(null);
            }
        }
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        super.setBorderColor(foregroundColorType);
        int n = this.getBorder().getValue();
        if (n == 1 || n == 3) {
            this.setLineBorder();
        }
    }

    private void setLineBorder() {
        Color color = null;
        if (this.getBorderColor() != null) {
            color = this.getBorderColor().getForegroundColor(this.getPalette());
        }
        this.treeView.setBorder(BorderFactory.createLineBorder(color != null ? color : Color.black));
    }

    public void setLinesAtRoot(boolean bl) {
        super.setLinesAtRoot(bl);
        this.treeView.setShowLinesAtRoot(bl);
    }

    public void setShowLines(boolean bl) {
        super.setShowLines(bl);
        this.treeView.setShowLines(bl);
    }

    public void refreshComponent() {
        super.refreshComponent();
        this.treeView.setTreeContent(this.getTreeItemSettings());
    }

    public void setTreeItemSettings(TreeViewItemSettingList treeViewItemSettingList) {
        super.setTreeItemSettings(treeViewItemSettingList);
        this.treeView.setTreeContent(treeViewItemSettingList);
    }

    public void setBitmap(ImageType imageType) {
        super.setBitmap(imageType);
        if (this.getBitmap() != null) {
            this.treeView.setImage(this.getBitmap().getImage());
            this.treeView.setTreeContent(this.getTreeItemSettings());
        }
    }

    public void setBitmapWidth(int n) {
        super.setBitmapWidth(n);
        this.treeView.setBitmapWidth(n);
        if (this.getBitmap() != null) {
            this.treeView.setTreeContent(this.getTreeItemSettings());
        }
    }
}

